﻿local options = { 
    type='group',
    args = {
        master = {
            type = 'text',
            order = 10,
            name = 'master',
            desc = 'Set the name of your master',
            usage = "<Player name>",
            get = "GetMaster",
            set = "SetMaster",
            
        },
        relaychannel = {
            type = 'text',
            order = 20,
            name = 'Relay Channel',
            desc = 'Set the name of the channel you wish to relay all msg from Bot. Leave empty for whisper relay',
            usage = "<Channel Name>",
            get = "GetChannel",
            set = "SetChannel",
            
        },
        relay = {
            type = 'toggle',
            order = 30,
            name = 'Whispers Relay',
            desc = 'All Whispers send to this char will be relay to the master. Set a master for this to work.',
            get = "isRelay",
            set = "toggleRelay",
            
        },
        relayguild = {
            type = 'toggle',
            order = 40,
            name = 'Guild Relay',
            desc = 'Relay Guild chat.',
            get = "isGuildRelay",
            set = "toggleGuildRelay",
            
        },
        relayofficer = {
            type = 'toggle',
            order = 41,
            name = 'Officer Channel Relay',
            desc = 'Relay Officer chat.',
            get = "isOfficerRelay",
            set = "toggleOfficerRelay",
            
        },
        relayparty = {
            type = 'toggle',
            order = 50,
            name = 'Party Relay',
            desc = 'Relay Party chat.',
            get = "isPartyRelay",
            set = "togglePartyRelay",
            
        },
        relayraid = {
            type = 'toggle',
            order = 60,
            name = 'Raid Relay',
            desc = 'Relay Raid chat.',
            get = "isRaidRelay",
            set = "toggleRaidRelay",
            
        },
        sticky = {
            type = 'toggle',
            order = 70,
            name = 'Sticky Follow',
            desc = 'Toggle Sticky Follow after combat',
            get = "isSticky",
            set = "toggleSticky",
            
        },
        followwarning = {
            type = 'toggle',
            order = 80,
            name = 'Follow Warning',
            desc = 'Warn when follow drops',
            get = "isFollowWarning",
            set = "toggleFollowWarning",
            
        },
        passLoot = {
            type = 'toggle',
            order = 90,
            name = 'Pass on Loot',
            desc = 'Will automaticaly pass on loot roll window',
            get = "isAutoPass",
            set = "toggleAutopass",
            
        },
        autoQuest = {
            type = 'toggle',
            order = 91,
            name = 'Auto Accept Quest',
            desc = 'Will automaticaly accept quest shared and escort',
            get = "isAutoQuest",
            set = "toggleAutoQuest",
        },
        autoInvite = {
            type = 'toggle',
            order = 92,
            name = 'Auto Accept Group Invite',
            desc = 'Will automaticaly accept group invite from people in your friend list. (master invite will always be accepted)',
            get = "isAutoInvite",
            set = "toggleAutoInvite",
        },
        buffFade = {
            type = 'toggle',
            order = 100,
            name = 'Buff fade warning',
            desc = 'Warn the master a buff fade',
            get = "isBuffFade",
            set = "toggleBuffFade",
        },
        bufftime = {
            type = 'range',
            order = 110,
            name = 'Buff Timeout Treshold',
            desc = 'Set how many minutes a boff need to be on the bot for him to warn about loosing it',
            usage = "<# Minute>",
            min = 0,
            max = 30,
            step = 1,
            get = "getTreshold",
            set = "setTreshold",
            
        },
        hpwarning = {
            type = 'range',
            order = 120,
            name = 'Health Warning',
            desc = 'Set the Low Health Warning %. 0 = Disabled',
            usage = "<Health %>",
            min = 0,
            max = 100,
            step = 1,
            get = "getHPTrigger",
            set = "setHPTrigger"
            
        },
        mpwarning = {
            type = 'range',
            order = 130,
            name = 'Mana Warning',
            desc = 'Set the Low Mana Warning %. 0 = Disabled',
            usage = "<Mana %>",
            min = 0,
            max = 100,
            step = 1,
            get = "getMPTrigger",
            set = "setMPTrigger",
            
        },    
        masterHist = {
			type = "group",
			name = "Masters History",
			desc = "Masters history List.",
			pass = true,
			func = function(key)
				dewdrop:Close()
				twoboxtoolkit:selectHistory(key)
			end,
			args = {},
			order = 11,
			
		},
    }
}
dewdrop = AceLibrary("Dewdrop-2.0")
twoboxtoolkit = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0" ,"AceDB-2.0","FuBarPlugin-2.0")
twoboxtoolkit:RegisterChatCommand({"/tb", "/twoboxtoolkit"}, options)
twoboxtoolkit:RegisterDB("twoboxtoolkitDB", "twoboxtoolkitDBPC")
twoboxtoolkit:RegisterDefaults("profile", {
    sticky = false,
    passLoot = false,
    relay = true,
    buffFade = false,
    hpwarning = 0,
    mpwarning = 0,
    bufftime = 10,
    relayguild = false,
    relayofficer = false,
    relayparty = false,
    relayraid = false,
    followwarning = true,
    autoQuest = true,
    autoInvite = true
} )



twoboxtoolkit.defaultPosition = "LEFT"
twoboxtoolkit.hasIcon = true
twoboxtoolkit.defaultMinimapPosition = 250 
twoboxtoolkit.overrideMenu = true
twoboxtoolkit.title = "TwoBox Toolkit"


--function twoboxtoolkit:createMenu()
--    dewdrop:Open(Minimap,
 --   'children', function()
 --       dewdrop:FeedAceOptionsTable(options)    
 --   end)
--end

--function twoboxtoolkit:OnMenuRequest()
--	dewdrop:FeedAceOptionsTable(options)   
--end

local lastFollow = nil
local isBroken = false
local isFollowing = false
local currentHP = nil
local maxHP = nil
local currentMana = nil
local maxMana = nil
local lowHPTrigger = false
local lowMPTrigger = false
local currentBuffList = {}
local currentBuffTime = {}
local currentBuffCount = 0
local chatRelayed = 0
local lastHappyness = 3

function twoboxtoolkit:OnInitialize()
    -- Called when the addon is loaded
    self.options = options 
    self.OnMenuRequest = self.options
    
    if (self.db.profile.masterNbr == nil) then
        self.db.profile.masterNbr = 0
    end
    twoboxtoolkit:updateMasterHistory()
end

function twoboxtoolkit:updateMasterHistory()
    local opt = self.OnMenuRequest.args
    opt.masterHist.args = {}
    for i = 1, self.db.profile.masterNbr do
    
        opt.masterHist.args[i] = {
				type = "execute",
				name = self.db.profile.masterList[i],
				desc = "click to set as master",
			}
    end
 
end

function twoboxtoolkit:OnEnable()
    -- Called when the addon is enabled
    self:RegisterEvent("CHAT_MSG_WHISPER")
    self:RegisterEvent("CHAT_MSG_TEXT_EMOTE")
    self:RegisterEvent("AUTOFOLLOW_BEGIN")
    self:RegisterEvent("AUTOFOLLOW_END")
    self:RegisterEvent("PLAYER_REGEN_ENABLED")
    self:RegisterEvent("START_LOOT_ROLL")
    self:RegisterEvent("UNIT_AURA")
    self:RegisterEvent("UNIT_HEALTH")
    self:RegisterEvent("UNIT_MANA")
    self:RegisterEvent("PLAYER_LOGIN")
    self:RegisterEvent("CHAT_MSG_GUILD")
    self:RegisterEvent("CHAT_MSG_PARTY")
    self:RegisterEvent("CHAT_MSG_RAID")
    self:RegisterEvent("CHAT_MSG_RAID_LEADER")
    self:RegisterEvent("RAID_ROSTER_UPDATE")
    self:RegisterEvent("PARTY_INVITE_REQUEST")
    self:RegisterEvent("RESURRECT_REQUEST")
    self:RegisterEvent("UNIT_HAPPINESS")
    self:RegisterEvent("QUEST_ACCEPT_CONFIRM")
    self:RegisterEvent("QUEST_DETAIL")
    self:RegisterEvent("CHAT_MSG_OFFICER")
    self:RegisterEvent("CHAT_MSG_CHANNEL")
    self:RegisterEvent("TRADE_SHOW")
end

function twoboxtoolkit:OnDisable()
    -- Called when the addon is disabled
end

function twoboxtoolkit:GetMaster()
    return self.db.profile.master
end

function twoboxtoolkit:SetMaster(newValue)
    self.db.profile.master = string.lower(newValue)
    SendChatMessage("You are now my master", "WHISPER", nil, self.db.profile.master);   
    if not self.db.profile.masterList then self.db.profile.masterList = {} end
    if (twoboxtoolkit:checkMasterList(string.lower(newValue)) == false) then
        self.db.profile.masterNbr = self.db.profile.masterNbr + 1
        self.db.profile.masterList[self.db.profile.masterNbr] = string.lower(newValue)
        twoboxtoolkit:updateMasterHistory()
    end
    
end


function twoboxtoolkit:selectHistory(key)
    self.db.profile.master = self.db.profile.masterList[key]
    SendChatMessage("You are now my master", "WHISPER", nil, self.db.profile.master);
end

function twoboxtoolkit:SetChannel(newValue)
    self.db.profile.relaychannel = string.lower(newValue)
end

function twoboxtoolkit:GetChannel()
    return self.db.profile.relaychannel
end


function twoboxtoolkit:isSticky()
    return self.db.profile.sticky
end

function twoboxtoolkit:toggleSticky()
    self.db.profile.sticky = not self.db.profile.sticky
end

function twoboxtoolkit:isFollowWarning()
    return self.db.profile.followwarning
end

function twoboxtoolkit:toggleFollowWarning()
    self.db.profile.followwarning = not self.db.profile.followwarning
end

function twoboxtoolkit:isAutoPass()
    return self.db.profile.passLoot
end

function twoboxtoolkit:toggleAutopass()
    self.db.profile.passLoot = not self.db.profile.passLoot
end

function twoboxtoolkit:isAutoQuest()
    return self.db.profile.autoQuest
end

function twoboxtoolkit:toggleAutoQuest()
    self.db.profile.autoQuest = not self.db.profile.autoQuest
end

function twoboxtoolkit:isRelay()
    return self.db.profile.relay
end

function twoboxtoolkit:toggleRelay()
    self.db.profile.relay = not self.db.profile.relay
end

function twoboxtoolkit:isGuildRelay()
    return self.db.profile.relayguild
end

function twoboxtoolkit:toggleGuildRelay()
    self.db.profile.relayguild = not self.db.profile.relayguild
end

function twoboxtoolkit:isOfficerRelay()
    return self.db.profile.relayofficer
end

function twoboxtoolkit:toggleOfficerRelay()
    self.db.profile.relayofficer = not self.db.profile.relayofficer
end

function twoboxtoolkit:isPartyRelay()
    return self.db.profile.relayparty
end

function twoboxtoolkit:togglePartyRelay()
    self.db.profile.relayparty = not self.db.profile.relayparty
end

function twoboxtoolkit:isRaidRelay()
    return self.db.profile.relayraid
end

function twoboxtoolkit:toggleRaidRelay()
    self.db.profile.relayraid = not self.db.profile.relayraid
end

function twoboxtoolkit:setHPTrigger(newValue)
    self.db.profile.hpwarning = newValue
end

function twoboxtoolkit:getHPTrigger()
    return self.db.profile.hpwarning
end

function twoboxtoolkit:setMPTrigger(newValue)
    self.db.profile.mpwarning = newValue
end

function twoboxtoolkit:getMPTrigger()
    return self.db.profile.mpwarning
end

function twoboxtoolkit:isBuffFade()
    return self.db.profile.buffFade
end

function twoboxtoolkit:getTreshold()
    return self.db.profile.bufftime    
end

function twoboxtoolkit:setTreshold(newValue)
    self.db.profile.bufftime = newValue  
end


function twoboxtoolkit:toggleBuffFade()
    self.db.profile.buffFade = not self.db.profile.buffFade
end

function twoboxtoolkit:isAutoInvite()
    return self.db.profile.autoInvite
end

function twoboxtoolkit:toggleAutoInvite()
    self.db.profile.autoInvite = not self.db.profile.autoInvite
end

function twoboxtoolkit:CHAT_MSG_WHISPER()
    wascommand = false
    if (twoboxtoolkit:checkMasterList(string.lower(arg2))) then
        if (arg1 == "followme") then
            if (self.db.profile.sticky) then
                --SendChatMessage("Sticky Following", "WHISPER", nil, arg2);
                twoboxtoolkit:relayMessage("Sticky Following "..arg2)
            else
                --SendChatMessage("Following", "WHISPER", nil, arg2);
                twoboxtoolkit:relayMessage("Following "..arg2)
            end 
            wascommand = true
            isBroken = false
            FollowUnit(arg2);
            lastFollow = arg2      
        elseif (arg1 == "shoo") then
            wascommand = true
            LeaveParty()
        end
    end
    if (wascommand == false and self.db.profile.relay) then
        --SendChatMessage(arg2.." whispers : "..arg1, "WHISPER", nil, self.db.profile.master);
        twoboxtoolkit:relayMessage(arg2.." whispers : "..arg1)
        chatRelayed = chatRelayed + 1
    end
end

function twoboxtoolkit:CHAT_MSG_CHANNEL()
    if (self.db.profile.relaychannel ~= nil) then
        if (string.lower(arg9) == string.lower(self.db.profile.relaychannel)) then
            if (string.lower(UnitName("Player")) ~= string.lower(arg2)) then
                if (arg1 == "followme") then
                    if (self.db.profile.sticky) then
                        --SendChatMessage("Sticky Following", "WHISPER", nil, arg2);
                        twoboxtoolkit:relayMessage("Sticky Following "..arg2)
                    else
                        --SendChatMessage("Following", "WHISPER", nil, arg2);
                        twoboxtoolkit:relayMessage("Following "..arg2)
                    end 
                    isBroken = false
                    FollowUnit(arg2);
                    lastFollow = arg2      
                elseif (arg1 == "shoo") then
                    LeaveParty()
                end    
            end
        end
    end
end

function twoboxtoolkit:CHAT_MSG_GUILD()
    if (self.db.profile.relayguild) then
        --SendChatMessage(arg2.." Guild : "..arg1, "WHISPER", nil, self.db.profile.master);
        twoboxtoolkit:relayMessage(arg2.." Guild : "..arg1)
        chatRelayed = chatRelayed + 1
    end
end

function twoboxtoolkit:CHAT_MSG_OFFICER()
    if (self.db.profile.relayofficer) then
        twoboxtoolkit:relayMessage(arg2.." Officer : "..arg1)
        chatRelayed = chatRelayed + 1    
    end
end

function twoboxtoolkit:CHAT_MSG_PARTY()
    if (self.db.profile.relayparty) then
        --SendChatMessage(arg2.." Party : "..arg1, "WHISPER", nil, self.db.profile.master);
        twoboxtoolkit:relayMessage(arg2.." Party : "..arg1)
        chatRelayed = chatRelayed + 1
    end    
end

function twoboxtoolkit:CHAT_MSG_RAID()
    if (self.db.profile.relayraid) then
        --SendChatMessage(arg2.." Raid : "..arg1, "WHISPER", nil, self.db.profile.master);
        twoboxtoolkit:relayMessage(arg2.." Raid : "..arg1)
        chatRelayed = chatRelayed + 1
    end     
end

function twoboxtoolkit:CHAT_MSG_RAID_LEADER()
    if (self.db.profile.relayraid) then
        --SendChatMessage(arg2.." Raid Leader : "..arg1, "WHISPER", nil, self.db.profile.master);
        twoboxtoolkit:relayMessage(arg2.." Raid Leader : "..arg1)
        chatRelayed = chatRelayed + 1
    end 
end

function twoboxtoolkit:CHAT_MSG_TEXT_EMOTE()
  --if (string.lower(arg2) == self.db.profile.master) then
  if (twoboxtoolkit:checkMasterList(string.lower(arg2))) then
    if ( string.lower(string.sub(arg1,string.len(arg1)-13,string.len(arg1))) == "you to follow.") then
            if (self.db.profile.sticky) then
                --SendChatMessage("Sticky Following", "WHISPER", nil, arg2);
                twoboxtoolkit:relayMessage("Sticky Following "..arg2)
            else
                --SendChatMessage("Following", "WHISPER", nil, arg2);
                twoboxtoolkit:relayMessage("Following "..arg2)
            end 
            isBroken = false
            FollowUnit(arg2);
            lastFollow = arg2     
    end
  end
end

local tablet = AceLibrary("Tablet-2.0")
function twoboxtoolkit:OnTooltipUpdate()
   local cat = tablet:AddCategory(
        'text', "Info",
        'columns', 2,
        'child_textR', 1,
        'child_textG', 1,
        'child_textB', 0,
        'child_textR2', 1,
        'child_textG2', 1,
        'child_textB2', 1
    )
    
    cat:AddLine(
        'text', "Master",
        'text2', self.db.profile.master
    )
    
    cat:AddLine(
        'text', "Messages Relayed",
        'text2', chatRelayed
    )
    
end

function twoboxtoolkit:AUTOFOLLOW_BEGIN()
    isFollowing = true
end

function twoboxtoolkit:AUTOFOLLOW_END()
    isBroken = true
    if (isFollowing) then
        --SendChatMessage("Follow is broken", "WHISPER", nil, self.db.profile.master);
        if (self.db.profile.followwarning) then
            twoboxtoolkit:relayMessage("Follow is broken")
        end
        isFollowing = false
    end
end

function twoboxtoolkit:PLAYER_REGEN_ENABLED()
    if (self.db.profile.sticky and lastFollow ~= nil and isBroken) then
        FollowUnit(lastFollow);
        isBroken = false
    end
end

function twoboxtoolkit:START_LOOT_ROLL()
    if (self.db.profile.passLoot) then
        RollOnLoot(arg1,0)
    end
end


function twoboxtoolkit:UNIT_AURA()
    if (self.db.profile.buffFade and arg1 == "player") then
        for j=1, currentBuffCount do  
            local foundSpell = false
                for i=1, 24 do
                    if UnitBuff("player", i) == currentBuffList[j] then
                        foundSpell = true
                        break
                    end
                end 
                if not foundSpell then
                    if (time() - currentBuffTime[j] > (self.db.profile.bufftime * 60)) then
                        --SendChatMessage("Buff Gone : "..currentBuffList[j],"WHISPER", nil, self.db.profile.master);
                        twoboxtoolkit:relayMessage("Buff Gone : "..currentBuffList[j])
                    end
                    table.remove(currentBuffList,j)
                    table.remove(currentBuffTime,j)
                    
                end
        end
        fillBuffList()
    end
end

function twoboxtoolkit:UNIT_HEALTH()
    if (self.db.profile.hpwarning ~= 0 and arg1 == "player") then 
        if (lowHPTrigger) then
            if ((UnitHealth("player") / UnitHealthMax("player") * 100) > self.db.profile.hpwarning) then
                lowHPTrigger = false
            end
        else
            if ((UnitHealth("player") / UnitHealthMax("player") * 100) < self.db.profile.hpwarning) then
                lowHPTrigger = true;
                --SendChatMessage("I Need Healing!","WHISPER", nil, self.db.profile.master);
                twoboxtoolkit:relayMessage("I Need Healing!")
            end
        end
    end
end

function twoboxtoolkit:UNIT_MANA()
    if (self.db.profile.mpwarning ~= 0 and arg1 == "player") then
        if (lowMPTrigger) then
            if ((UnitMana("player") / UnitManaMax("player") * 100) > self.db.profile.mpwarning) then
                lowMPTrigger = false
            end
        else
            if ((UnitMana("player") / UnitManaMax("player") * 100) < self.db.profile.mpwarning) then
                lowMPTrigger = true
                --SendChatMessage("My Mana is Low!","WHISPER", nil, self.db.profile.master); 
                twoboxtoolkit:relayMessage("My Mana is Low!")
            end
        end
    end
end

function twoboxtoolkit:PLAYER_LOGIN()
    fillBuffList()    
end

function fillBuffList()
    for i=1, 24 do
	    
		if UnitBuff("player", i) == nil then
            break
        else 
            local buffName = UnitBuff("player",i)
            local foundBuff = false
            for j=1,currentBuffCount do
                if (buffName == currentBuffList[j]) then
                    foundBuff = true
                end
            end
            if not foundBuff then
                table.insert(currentBuffList,buffName)
                table.insert(currentBuffTime,time())
                currentBuffCount = currentBuffCount + 1
            end
        end
    end
end

function twoboxtoolkit:relayMessage(msg)
    if (self.db.profile.relaychannel == nil or string.len(self.db.profile.relaychannel) == 0) then
        if (self.db.profile.master ~= nil and string.len(self.db.profile.master) ~= 0) then
            SendChatMessage(msg, "WHISPER", nil, self.db.profile.master);    
        end
    else
        local index = GetChannelName(self.db.profile.relaychannel) 
        if (index~=nil) then 
            SendChatMessage(msg , "CHANNEL", nil, index); 
        end
    end
end

function twoboxtoolkit:RAID_ROSTER_UPDATE()
    if (self.db.profile.relayraid) then
        twoboxtoolkit:relayMessage(GetNumRaidMembers().." Players in the raid")
    end
end

function twoboxtoolkit:PARTY_INVITE_REQUEST()
    
    valid = false
    if (string.lower(arg1) == self.db.profile.master) then
        valid = true
    end    
    if (valid == false and self.db.profile.autoInvite == true) then
        for j=1, GetNumFriends()  do
            local name, level, class, loc, connected, status = GetFriendInfo(j);
            if (string.lower(name) == string.lower(arg1)) then
                valid = true
            end
        end
    end
    if (valid) then
        AcceptGroup()
        StaticPopup_Hide("PARTY_INVITE")
    end
end

function twoboxtoolkit:RESURRECT_REQUEST()
    valid = false
    if (string.lower(arg1) == self.db.profile.master) then
        valid = true
    end
    if (valid == false) then
        for j=1, GetNumFriends()  do
            local name, level, class, loc, connected, status = GetFriendInfo(j);
            if (string.lower(name) == string.lower(arg1)) then
                valid = true
            end
        end
    end
    if (valid) then
        AcceptResurrect()
    end
end

function twoboxtoolkit:UNIT_HAPPINESS()
    local happiness, damagePercentage, loyaltyRate = GetPetHappiness()
    if (happiness ~= nil and lastHappyness ~= happiness) then
        lastHappyness = happiness
        if (happiness < 3) then
            twoboxtoolkit:relayMessage("My pet needs food")    
        end
    end
end

function twoboxtoolkit:QUEST_ACCEPT_CONFIRM()
    if (self.db.profile.autoQuest) then
        twoboxtoolkit:relayMessage("Escort Quest Accepted")
        ConfirmAcceptQuest();
    end
end

function twoboxtoolkit:QUEST_DETAIL()
    if (self.db.profile.autoQuest) then
        twoboxtoolkit:relayMessage("Quest Accepted")
        AcceptQuest()    
    end
end

function twoboxtoolkit:checkMasterList(name)
    for i = 1 , self.db.profile.masterNbr do
        if (self.db.profile.masterList[i] == name) then
            return true
        end
    end
    return false
end

function twoboxtoolkit:TRADE_SHOW()
    tradePlayer = TradeFrameRecipientNameText:GetText()
    twoboxtoolkit:relayMessage(tradePlayer.." is trading with me")
end

