function ThankGod_OnLoad()

	Player = UnitName("player")

	TG_HC_Sound = true
	TG_HC_Texture = true
	TG_HS_Sound = true
	TG_HS_Texture = true
	TG_CT_Sound = true
	TG_BD_Texture = true
		
	ThankGod_MainFrameFlash1:SetAlpha(0);
	ThankGod_MainFrameFlash1Texture:SetVertexColor(0, 1, 0.8);
	TG_C1_Red, TG_C1_Green, TG_C1_Blue, TG_C1_Alpha = ThankGod_MainFrameFlash1Texture:GetVertexColor();
	ThankGod_MainFrameFlash2:SetAlpha(0);
	ThankGod_MainFrameFlash2Texture:SetVertexColor(1, 0.95, 0);
	TG_C2_Red, TG_C2_Green, TG_C2_Blue, TG_C2_Alpha= ThankGod_MainFrameFlash2Texture:GetVertexColor();
	ThankGod_MainFrameFlash3:SetAlpha(0);
	ThankGod_MainFrameFlash3Texture:SetVertexColor(0, 0.75, 1);
	TG_C3_Red, TG_C3_Green, TG_C3_Blue, TG_C3_Alpha= ThankGod_MainFrameFlash3Texture:GetVertexColor();

	ThankGodOptionsTitle:SetText(ThankGod_String_Version)
	ThankGodOptionsCheckButton1Text:SetText(ThankGod_String_CB1);
	ThankGodOptionsCheckButton2Text:SetText(ThankGod_String_CB2);
	ThankGodOptionsCheckButton3Text:SetText(ThankGod_String_CB3);
	ThankGodOptionsCheckButton4Text:SetText(ThankGod_String_CB4);
	ThankGodOptionsCheckButton5Text:SetText(ThankGod_String_CB5);
	ThankGodOptionsCheckButton6Text:SetText(ThankGod_String_CB6);
	ThankGodOptionsButton1:SetText(ThankGod_String_B1);

	SlashCmdList["ThankGodCommand"] = ThankGod_SlashHandler;
	SLASH_ThankGodCommand1 = "/tg";	
	
	DEFAULT_CHAT_FRAME:AddMessage(ThankGod_String_Version..": Loaded");
end

function ThankGod_OnShow()
	ThankGodOptionsCheckButton1:SetChecked(TG_HC_Sound);
	ThankGodOptionsCheckButton2:SetChecked(TG_HC_Texture);
	ThankGodOptionsCheckButton3:SetChecked(TG_HS_Sound);
	ThankGodOptionsCheckButton4:SetChecked(TG_HS_Texture);
	ThankGodOptionsCheckButton5:SetChecked(TG_CT_Sound);
	ThankGodOptionsCheckButton6:SetChecked(TG_BD_Texture);
	ThankGodOptionsSwatch1NormalTexture:SetVertexColor(TG_C1_Red, TG_C1_Green, TG_C1_Blue, TG_C1_Alpha);
	ThankGodOptionsSwatch2NormalTexture:SetVertexColor(TG_C2_Red, TG_C2_Green, TG_C2_Blue, TG_C2_Alpha);
	ThankGodOptionsSwatch3NormalTexture:SetVertexColor(TG_C3_Red, TG_C3_Green, TG_C3_Blue, TG_C3_Alpha);
end

function ThankGodOptions_Events()
	TG_HC_Sound = ThankGodOptionsCheckButton1:GetChecked() or false;
	TG_HC_Texture = ThankGodOptionsCheckButton2:GetChecked()  or false;
	TG_HS_Sound = ThankGodOptionsCheckButton3:GetChecked()  or false;
	TG_HS_Texture = ThankGodOptionsCheckButton4:GetChecked()  or false;
	TG_CT_Sound = ThankGodOptionsCheckButton5:GetChecked()  or false;
	TG_BD_Texture = ThankGodOptionsCheckButton6:GetChecked()  or false;

	ThankGod_Events()
end

function ThankGod_Events()
	frame = getglobal("ThankGod_MainFrame");
	frame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	
	ThankGod_MainFrameFlash1Texture:SetVertexColor(TG_C1_Red, TG_C1_Green, TG_C1_Blue, TG_C1_Alpha); 
	ThankGod_MainFrameFlash2Texture:SetVertexColor(TG_C2_Red, TG_C2_Green, TG_C2_Blue, TG_C2_Alpha);
	ThankGod_MainFrameFlash3Texture:SetVertexColor(TG_C3_Red, TG_C3_Green, TG_C3_Blue, TG_C3_Alpha);
end


function ThankGod_OnEvent(event)
if (event == "COMBAT_LOG_EVENT_UNFILTERED") then
	if (arg2 == "SPELL_AURA_APPLIED") and (arg7 == Player) then
		if arg9 == 34754 then
      			if(TG_HC_Texture) then			
      				UIFrameFlash(ThankGod_MainFrameFlash1, 0.2, 0.8, 15, nil, 0.2, 0);
			end
			if(TG_HC_Sound) then
				PlaySoundFile("Interface\\AddOns\\ThankGod\\Sounds\\HolyConcentration.mp3");
			end
		elseif arg9 == 33151 then
			if(TG_HS_Texture) then
      				UIFrameFlash(ThankGod_MainFrameFlash2, 0.2, 0.8, 10, nil, 0.2, 0);
			end
			if(TG_HS_Sound) then
				PlaySoundFile("Interface\\AddOns\\ThankGod\\Sounds\\HolySurge.mp3");
			end
		elseif arg9 == 19288 then
			if(TG_BD_Texture) then
      				UIFrameFlash(ThankGod_MainFrameFlash3, 0.2, 0.8, 15, nil, 0.2, 0);
			end
		end
	elseif (arg2 == "SPELL_AURA_REMOVED") and (arg7 == Player) then
		if arg9 == 34754 then
			UIFrameFlashRemoveFrame(ThankGod_MainFrameFlash1);
			UIFrameFadeRemoveFrame(ThankGod_MainFrameFlash1);
			UIFrameFadeOut(ThankGod_MainFrameFlash1, 0.8, ThankGod_MainFrameFlash1:GetAlpha(), 0);
		elseif arg9 == 33151 then
			UIFrameFlashRemoveFrame(ThankGod_MainFrameFlash2);
			UIFrameFadeRemoveFrame(ThankGod_MainFrameFlash2);
			UIFrameFadeOut(ThankGod_MainFrameFlash2, 0.8, ThankGod_MainFrameFlash2:GetAlpha(), 0);
		elseif arg9 == 19288 then
			UIFrameFlashRemoveFrame(ThankGod_MainFrameFlash3);
			UIFrameFadeRemoveFrame(ThankGod_MainFrameFlash3);
			UIFrameFadeOut(ThankGod_MainFrameFlash3, 0.8, ThankGod_MainFrameFlash3:GetAlpha(), 0);
		end
		elseif string.find(arg2, "_DAMAGE") and (arg4 == Player) and (arg17 == 1) and TG_CT_Sound then

			PlaySoundFile("Interface\\AddOns\\ThankGod\\Sounds\\CriticalDamage.mp3");
		end	
	end
end

function ThankGod_SlashHandler(arg1)
	ThankGodOptions:Show();
end

function ThankGod_ColorPicker(swatch)
	CloseMenus();
	ColorPickerFrame.func = function() ThankGod_ChangeColor(swatch); end;
	Red,Green,Blue,Alpha = getglobal(swatch.."NormalTexture"):GetVertexColor()
	ColorPickerFrame:SetColorRGB(Red,Green,Blue,Alpha);
	ColorPickerFrame.cancelFunc = function() ThankGod_CancelColor(swatch,Red,Green,Blue,Alpha); end;
	ColorPickerFrame:Show();
end

function ThankGod_ChangeColor(swatch)
	getglobal(swatch.."NormalTexture"):SetVertexColor(ColorPickerFrame:GetColorRGB());
	if (swatch == "ThankGodOptionsSwatch1") then
		TG_C1_Red, TG_C1_Green, TG_C1_Blue, TG_C1_Alpha  = ColorPickerFrame:GetColorRGB()
		ThankGod_MainFrameFlash1Texture:SetVertexColor(TG_C1_Red, TG_C1_Green, TG_C1_Blue, TG_C1_Alpha); 
	elseif (swatch == "ThankGodOptionsSwatch2") then
		TG_C2_Red, TG_C2_Green, TG_C2_Blue, TG_C2_Alpha  = ColorPickerFrame:GetColorRGB()
		ThankGod_MainFrameFlash2Texture:SetVertexColor(TG_C2_Red, TG_C2_Green, TG_C2_Blue, TG_C2_Alpha);
	elseif (swatch == "ThankGodOptionsSwatch3") then
		TG_C3_Red, TG_C3_Green, TG_C3_Blue, TG_C3_Alpha  = ColorPickerFrame:GetColorRGB()
		ThankGod_MainFrameFlash3Texture:SetVertexColor(TG_C3_Red, TG_C3_Green, TG_C3_Blue, TG_C3_Alpha);
	end
end

function ThankGod_CancelColor(swatch,Red,Green,Blue,Alpha)
	getglobal(swatch.."NormalTexture"):SetVertexColor(Red,Green,Blue,Alpha);
	if (swatch == "ThankGodOptionsSwatch1") then
		ThankGod_MainFrameFlash1Texture:SetVertexColor(Red,Green,Blue,Alpha); 
	elseif (swatch == "ThankGodOptionsSwatch2") then
		ThankGod_MainFrameFlash2Texture:SetVertexColor(Red,Green,Blue,Alpha);
	elseif (swatch == "ThankGodOptionsSwatch3") then
		ThankGod_MainFrameFlash3Texture:SetVertexColor(Red,Green,Blue,Alpha);
	end
end