-- Scorchio!
-- A multi-mob fire vulnerability manager
-- Ennui@Bloodhoof-EU
-- Email: ennuilg@gmail.com
-- Based on: ScorchWatch by Liccee

local SM = LibStub:GetLibrary("LibSharedMedia-3.0", true)
local PC = AceLibrary("PaintChips-2.0")
local L = AceLibrary("AceLocale-2.2"):new("Scorchio")

local SB = "Scorch_Bars"

-- ScorchTable Fields
local MOBNAME = 1
local REFRESHTIME = 2
local SCORCHSTACK = 3
local CASTS = 4

local SCORCHIDS = {[27074]=true, [27903]=true, [10207]=true, [10206]=true, [10205]=true, [8446]=true, [8445]=true, [8444]=true, [2948]=true}

local playerName = UnitName("player")
local testBars = false
local mageList = { }
local impScorch = nil
local lastTargetedBarname = nil

local options = { 
	handler = Scorchio,
	type = 'group',
	args = {
		baroptions = {
			type = 'group',
			name = L["Bar Options"],
			desc = L["Bar Options"],
			args = {
				anchor = {
					type = 'group',
					name = L["Anchor"],
					desc = L["Manage anchor and test bars"],
					order = 10,
					args = {
						anchortoggle = {
							type = 'execute',
							name = L["Toggle"],
							desc = L["Shows/hides the dragable anchor and test bars"],
							func = "ToggleAnchor",
							order = 101
						},
						anchorreset = {
							type = 'execute',
							name = L["Reset Position"],
							desc = L["Reset anchor position to center of screen"],
							func = "ResetAnchor",
							order = 102,
						},
					},
				},
				growup = {
					type = 'toggle',
					name = L["Grow Up"],
					desc = L["If checked, bar will stack above the anchor, not below"],
					get = function()
						return Scorchio.db.profile.growUp
					end,
					set = function(v)
						Scorchio.db.profile.growUp = not Scorchio.db.profile.growUp
						Scorchio:SetGrowUp()
					end
				},
				barwidth = {
					type = 'range',
					name = L["Width"],
					desc = L["Change the width of the bars"],
					order = 120,
					get = function()
						return Scorchio.db.profile.baroptions.width
					end,
					set = function(v)
						Scorchio.db.profile.baroptions.width = v
						if testBars then Scorchio:ShowTestBars() end                        
					end,
					min = 24,
					max = 512,
					step = 8,
				},
				barheight = {
					type = 'range',
					name = L["Height"],
					desc = L["Change the height of the bars"],
					order = 121,
					get = function()
						return Scorchio.db.profile.baroptions.height
					end,
					set = function(v)
						Scorchio.db.profile.baroptions.height = v
						if testBars then Scorchio:ShowTestBars() end
					end,
					min = 6,
					max = 64,
					step = 2,
				},
				scale = {
					type = 'range',
					name = L["Scale"],
					desc = L["Change the scale of the bars"],
					order = 122,
					min = 0.5,
					max = 2,
					get = function()
						return Scorchio.db.profile.baroptions.scale
					end,
					set = function(v)
						Scorchio.db.profile.baroptions.scale = v
						if testBars then Scorchio:ShowTestBars() end
					end
				},
                fontsize = {
                    type = 'range',
                    name = L["Font Size"],
                    desc = L["Change the font size"],
                    order = 123,
                    min = 7,
                    max = 24,
                    step = 1,
                    get = function()
                        return Scorchio.db.profile.baroptions.fontsize
                    end,
                    set = function(v)
                        Scorchio.db.profile.baroptions.fontsize = v
                        if testBars then Scorchio:ShowTestBars() end
                    end
                },
				barcolour = {
					type = 'color',
					name = L["Bar Colour"],
					desc = L["Change bar colour"],
					order = 110,
					get = function()
						return unpack(Scorchio.db.profile.baroptions.fgcolours)
					end,
					set = function(r, g, b, a)
						Scorchio.db.profile.baroptions.fgcolours = {r, g, b, a}
						if testBars then Scorchio:ShowTestBars() end
					end,
					hasAlpha = true
				},
				backgroundcolour= {
					type = 'color',
					name = L["Background Colour"],
					desc = L["Change background colour"],
					order = 111,
					get = function()
						return unpack(Scorchio.db.profile.baroptions.bgcolours)
					end,
					set = function(r, g, b, a)
						Scorchio.db.profile.baroptions.bgcolours = {r, g, b, a}
						if testBars then Scorchio:ShowTestBars() end
					end,
					hasAlpha = true
				},
				targetbarcolour = {
					type = 'color',
					name = L["Target Bar Colour"],
					desc = L["Change bar colour for your target"],
					order = 112,
					get = function()
						return unpack(Scorchio.db.profile.baroptions.fgcolourstarget)
					end,
					set = function(r, g, b, a)
						Scorchio.db.profile.baroptions.fgcolourstarget = {r, g, b, a}
						if testBars then Scorchio:ShowTestBars() end
					end,
					hasAlpha = true
				},
				targetbackgroundcolour= {
					type = 'color',
					name = L["Target Background Colour"],
					desc = L["Change background colour for your target"],
					order = 113,
					get = function()
						return unpack(Scorchio.db.profile.baroptions.bgcolourstarget)
					end,
					set = function(r, g, b, a)
						Scorchio.db.profile.baroptions.bgcolourstarget = {r, g, b, a}
						if testBars then Scorchio:ShowTestBars() end
					end,
					hasAlpha = true
				},
				texture = {
					type = 'text',
					name = L["Texture"],
					desc = L["Change the texture of the bars"],
					order = 115,
					get = function() 
						return Scorchio.db.profile.baroptions.texture 
					end,
					set = function(v)
						Scorchio.db.profile.baroptions.texture = v
						if testBars then Scorchio:ShowTestBars() end
					end,
					validate = SM:List("statusbar")
				},                
				fadetime = {
					type = 'range',
					name = L["Fade Time"],
					desc = L["Change how long the bars remain after a vulnerability has faded. (-1 will stop them disappearing until you leave combat or the mob is rescorched)"],
					min = -1,
					max = 30,
					step = 1,
					get = function()
						return Scorchio.db.profile.baroptions.fadetime
					end,
					set = function(v)
						Scorchio.db.profile.baroptions.fadetime = v
					end
				},
				icon = {
					type = 'group',
					name = L["Icon"],
					desc = L["Show Scorchio! icon beside bars"],
					args = {
						iconshow = {
							type = 'toggle',
							name = L["Show"],
							desc = L["Show Scorchio! icon beside bars"],
							order = 100,
							get = function()
								return Scorchio.db.profile.baroptions.iconshow
							end,
							set = function(v)
								Scorchio.db.profile.baroptions.iconshow = not Scorchio.db.profile.baroptions.iconshow
								if testBars then Scorchio:ShowTestBars() end
							end
						},
						iconside = {
							type = 'text',
							name = L["Side"],
							disabled = function()
								return not Scorchio.db.profile.baroptions.iconshow
							end,
							desc = L["Show Scorchio! icon on left or right of bars"],
							order = 101,
							get = function() 
								return Scorchio.db.profile.baroptions.iconside 
							end,
							set = function(v)
								Scorchio.db.profile.baroptions.iconside = v
								if testBars then Scorchio:ShowTestBars() end
							end,
							validate = { ["LEFT"] = L["Left"], ["RIGHT"] = L["Right"] }
						},
					},
				},
                raidicon = {
                    type = 'group',
                    name = L["Raid Icon"],
                    desc = L["Show Raid Icons"],
                    args = {
                        raidiconshow = {
                            type = 'toggle',
                            name = L["Show"],
                            desc = L["Show Raid Target Icons on Bars"],
                            order = 100,
                            get = function()
                                return Scorchio.db.profile.baroptions.raidiconshow
                            end,
                            set = function(v)
                                Scorchio.db.profile.baroptions.raidiconshow = not Scorchio.db.profile.baroptions.raidiconshow
                                if Scorchio.db.profile.baroptions.raidiconshow then
                                    Scorchio:RegisterEvent("RAID_TARGET_UPDATE")
                                else
                                    Scorchio:UnregisterEvent("RAID_TARGET_UPDATE")
                                end
                                if testBars then Scorchio:ShowTestBars() end
                            end
                        },
                        raidiconpos = {
                            type = 'range',
                            name = L["Icon Position"],
                            desc = L["Change the position of the Raid Target Icons"],
                            order = 101,
                            get = function()
                                return Scorchio.db.profile.baroptions.raidiconpos
                            end,
                            set = function(v)
                                Scorchio.db.profile.baroptions.raidiconpos = v
                                if testBars then Scorchio:ShowTestBars() end
                            end,
                            min = -200,
                            max = 200,
                            step = 1
                        },
                    },
                },
			},
		},
		syncreceive = {
			type = 'group',
			name = L["Receive Data"],
			desc = L["Change sync data sources to listen to"],
			args = {
				grouped = {
					type = 'toggle',
					name = L["Grouped Only"],
					desc = L["Ignore Data from Mages outside of your group/raid"],
					get = function()
						return Scorchio.db.profile.syncreceive.grouped
					end,
					set = function()
						Scorchio.db.profile.syncreceive.grouped = not Scorchio.db.profile.syncreceive.grouped
					end
				},
			},
		},
		warningtime = {
			type = 'range',
			name = L["Warning Time"],
			desc = L["Length of time to be warned before Fire Vulnerability expires. (Set to 0 to disable)"],
			min = 0,
			max = 30,
			step = 1,
			get = function ()
				return Scorchio.db.profile.warningtime
			end,
			set = function(v)
				Scorchio.db.profile.warningtime = v
			end
		},
		sounds = {
			type = 'group',
			name = L["Sounds"],
			desc = L["Notification Sounds"],
			args = {
				on = {
					type = 'toggle',
					name = L["Toggle Sounds"],
					desc = L["Enable/Disable all sounds"],
					order = 110,
					get = function()
						return Scorchio.db.profile.sounds.on
					end,
					set = function()
						Scorchio.db.profile.sounds.on = not Scorchio.db.profile.sounds.on
					end
				},
				warningsound = {
					type = 'text',
					name = L["Warning Sound"],
					disabled = function()
						return not Scorchio.db.profile.sounds.on
					end,
					desc = L["Change the sound played when warning time is reached"],
					order = 111,
					get = function() 
						return Scorchio.db.profile.sounds.warningsound 
					end,
					set = function(v)
						Scorchio.db.profile.sounds.warningsound = v
						PlaySoundFile(SM:Fetch("sound",v))
					end,
					validate = SM:List("sound")
				},
				expiredsound = {
					type = 'text',
					name = L["Expired Sound"],
					disabled = function()
						return not Scorchio.db.profile.sounds.on
					end,
					desc = L["Change the sound played when Fire Vulnerability expires"],
					order = 112,
					get = function() 
						return Scorchio.db.profile.sounds.expiredsound 
					end,
					set = function(v)
						Scorchio.db.profile.sounds.expiredsound = v
						PlaySoundFile(SM:Fetch("sound",v))
					end,
					validate = SM:List("sound")
				},
			},
		},
		blacklist = {
			type = 'group',
			name = L["Blacklist"],
			desc = L["Blacklist mages who aren't 3/3 Imp Scorch"],
			args = {
				magelist = {
					type = 'text',
					name = L["Blacklist"],
					order = 100,
					desc = L["Blacklist mages who aren't 3/3 Imp Scorch. (Check mages to ignore their data)"],
					get = function(key)
						return Scorchio.db.profile.blacklist[key]
					end,
					set = function(key,value)
						Scorchio.db.profile.blacklist[key] = value
					end,
					multiToggle = true,
					validate = mageList
				},
				autoblacklist = {
					type = 'toggle',
					name = L["Automatic"],
					desc = L["Check to automatically blacklist mages in your party without 3/3 Imp Scorch"],
					order = 105,
					get = function()
						return Scorchio.db.profile.autoBlackList
					end,
					set = function()
						Scorchio.db.profile.autoBlackList = not Scorchio.db.profile.autoBlackList
						Scorchio:RebuildMageList()
					end
				},
				rebuild = {
					type = 'execute',
					name = L["Rebuild"],
					desc = L["Rebuild Mage List"],
					order = 110,
					func = "RebuildMageList"
				},
			},
		},
		debug = {
			type = 'group',
			name = "Debug",
			desc = "Debug Options",
			guiHidden = true,
			args = {
				duplicates = {
					type = 'toggle',
					name = "Duplicates",
					desc = "Notify of duplicate supression.",
					get = function()
						return Scorchio.db.profile.debug.duplicates
					end,
					set = function()
						Scorchio.db.profile.debug.duplicates = not Scorchio.db.profile.debug.duplicates
					end
				},
				sync = {
					type = 'toggle',
					name = "Sync Info",
					desc = "Display synchronisation debug information",
					get = function()
						return Scorchio.db.profile.debug.sync
					end,
					set = function()
						Scorchio.db.profile.debug.sync = not Scorchio.db.profile.debug.sync
					end                   
				},
				mob = {
					type = 'toggle',
					name = "Mob Info",
					desc = "Display mob debug information",
					get = function()
						return Scorchio.db.profile.debug.mob
					end,
					set = function()
						Scorchio.db.profile.debug.mob = not Scorchio.db.profile.debug.mob
					end
				},
				code = {
					type = 'toggle',
					name = "Code Info",
					desc = "Display code debug information",
					get = function()
						return Scorchio.db.profile.debug.code
					end,
					set = function()
						Scorchio.db.profile.debug.code = not Scorchio.db.profile.debug.code
					end
				},
				timers = {
					type = 'toggle',
					name = "Timers Info",
					desc = "Display timers debug information",
					get = function()
						return Scorchio.db.profile.debug.timers
					end,
					set = function()
						Scorchio.db.profile.debug.timers = not Scorchio.db.profile.debug.timers
					end
                },
                log = {
					type = 'toggle',
					name = "Combat Log Info",
					desc = "Display combat log information",
					get = function()
						return Scorchio.db.profile.debug.log
					end,
					set = function()
						Scorchio.db.profile.debug.log = not Scorchio.db.profile.debug.log
					end
				},                  
			},
		},
	},
}

Scorchio = AceLibrary("AceAddon-2.0"):new("AceComm-2.0", "AceConsole-2.0", "AceDB-2.0", "AceEvent-2.0", "EnniBar-2.0", "FuBarPlugin-2.0", "Sink-1.0")

Scorchio:RegisterChatCommand("/scorchio", options)
Scorchio.OnMenuRequest = options

Scorchio:RegisterDB("ScorchioDB", "ScorchioDBPC")
Scorchio:RegisterDefaults("profile", {
	sink10OutputSink = "ChatFrame",
	baroptions = {
		barposition = {0, 50},
		p = "CENTER",
		rP = "CENTER",
		scale = 1.0,
		fadetime = -1,
		iconshow = true,
		iconside = "LEFT",
        raidiconshow = false,
        raidiconpos = -10,
		fgcolours = { 0, 1, 0, 0.7 },
		bgcolours = { 1, 0, 0, 0.7 },
		fgcolourstarget = { 1, 0, 0, 0.7 },
		bgcolourstarget = { 1, 0, 0, 0.7 },
		texture = "Blizzard",
		width = 192,
		height = 16,
        fontsize = 11
	},
	syncreceive = {
		grouped = true
	},
	warningtime = 6,
	debug = {
		duplicates = false,
		sync = false,
		mob = false,
		code = false,
		timers = false,
        log = false
	},
	sounds = {
		on = true,
		warningsound = "Bell",
		expiredsound = "Info"
	},
	blacklist = { },
	autoBlackList = false
}
)



Scorchio:SetCommPrefix("Scorchio")
Scorchio.commPrefix = "Scorchio"

Scorchio.hasIcon = "Interface\\AddOns\\Scorchio\\icons\\scorch"
Scorchio.defaultMinimapPosition = 285
Scorchio.clickableTooltip       = false
Scorchio.cannotDetachTooltip    = true
Scorchio.hideMenuTitle          = true
Scorchio.hideWithoutStandby     = true

local function Debug(class, msg)
	local text = "DEBUG: " .. msg
	if Scorchio.db.profile.debug[class] then
		Scorchio:Print(text)
	end
end
Scorchio.Debug = Debug
local function hasImpScorch()
    local _, englishClass = UnitClass("Player")
    if englishClass ~= "MAGE" then return false end
    
	local _,_,_,_,currRank,_ = GetTalentInfo(2,10)
    Debug("code", "TALENT: Improved Scorch Rank: " .. tostring(currRank))
	if currRank == 3 then
		return true
	else
		return false
	end
end

Scorchio.hasImpScorch = hasImpScorch
local function isValidGrp(flags)
    local isValid = bit.band(flags, COMBATLOG_OBJECT_AFFILIATION_MINE + COMBATLOG_OBJECT_AFFILIATION_PARTY + COMBATLOG_OBJECT_AFFILIATION_RAID) ~= 0
    if Scorchio.db.profile.syncreceive.grouped == false then isValid = true end
    return isValid
end
Scorchio.isGrouped = isGroup
local function isValidSrc(caster)
    local isValid = true
    if Scorchio.db.profile.blacklist[caster] == true then isValid = false end
    return isValid
end
Scorchio.isValidSrc = isValidSrc

function Scorchio:OnClick()
	self:ToggleAnchor()
end

function Scorchio:InitializeTables()
	scorchTable = { }
	casterTable = { }
    raidIconTable = { }
    
	lastTargetedBarname = "0"
end

function Scorchio:OnInitialize()
end

function Scorchio:OnEnable()
	self:RegisterComm(self.commPrefix, "GROUP", "ReceiveMessage")
	self:RegisterComm(self.commPrefix, "WHISPER", "ReceiveMessage")
	self:SetDefaultCommPriority("ALERT")
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("PLAYER_TARGET_CHANGED")
	self:RegisterEvent("PARTY_MEMBERS_CHANGED")
    self:RegisterEvent("RAID_TARGET_UPDATE")
	self:RegisterEvent("TIMER_COMPLETE", "TimerComplete")
	self.anchor = self:CreateAnchor()
	self:RegisterEnniBarGroup(SB)
	self:SetGrowUp()
    
	self:InitializeTables()

--[[ 	if Scorchio.db.profile.blacklist[playerName] == nil or Scorchio.db.profile.blacklist[playerName] == true then 
  -- 		Scorchio.db.profile.blacklist[playerName] = not hasImpScorch() 
  -- 		Debug("code", "Adding " .. tostring(playerName) .. " to the Blacklist as " .. tostring(Scorchio.db.profile.blacklist[playerName]))
  -- 	end
--]]

    Scorchio.db.profile.blacklist[playerName] = false

	self:RebuildMageList()
    
    Scorchio.db.profile.syncreceive.scorchio = true
	castingScorch = false
end

function Scorchio:OnDisable()
end



function Scorchio:ShowTestBars()
		self:CreateBar({"Test Mob_1", GetTime(), 3, 0})
        raidIconTable["2"] = 5
        self:CreateBar({"Another Mob_2", GetTime()-10, 5, 0})
		testBars = true
end

function Scorchio:HideTestBars()
    self:UnregisterEnniBarWithGroup("Test Mob_1",SB)
    self:UnregisterEnniBar("Test Mob_1")
    raidIconTable["2"] = nil
    self:UnregisterEnniBarWithGroup("Another Mob_2",SB)
    self:UnregisterEnniBar("Another Mob_2")
	testBars = false
end

function Scorchio:ToggleAnchor()
	if self.anchor:IsVisible() then
		self.anchor:Hide()
		self:HideTestBars()
	else
		self.anchor:Show()
		self:ShowTestBars()
	end
	Debug("code","Anchor position: " .. tostring(Scorchio.db.profile.baroptions.barposition.x) .. ", " .. tostring(Scorchio.db.profile.baroptions.barposition.y))
end

function Scorchio:CreateAnchor()
	local f = CreateFrame("Button", nil, UIParent)
	f:SetWidth(160)
	f:SetHeight(25)

	f.owner = self

	if Scorchio.db.profile.baroptions.barposition.x and Scorchio.db.profile.baroptions.barposition.y and Scorchio.db.profile.baroptions.barposition.p and Scorchio.db.profile.baroptions.barposition.rP then
		f:ClearAllPoints()
		f:SetPoint(Scorchio.db.profile.baroptions.barposition.p, UIParent, Scorchio.db.profile.baroptions.barposition.rP, Scorchio.db.profile.baroptions.barposition.x, Scorchio.db.profile.baroptions.barposition.y)
	else
		f:SetPoint("CENTER", UIParent, "CENTER", 0, 50)
	end

	f:SetScript("OnDragStart", function() this:StartMoving() end )
	f:SetScript("OnDragStop",
	function()
		this:StopMovingOrSizing()
		local p, _, rP, x, y = this:GetPoint()
		Scorchio.db.profile.baroptions.barposition.x = math.floor(x)
		Scorchio.db.profile.baroptions.barposition.y = math.floor(y)
		Scorchio.db.profile.baroptions.barposition.p = p
		Scorchio.db.profile.baroptions.barposition.rP = rP
	end)

	f:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background",
	edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
	tile = false, tileSize = 16, edgeSize = 16,
	insets = { left = 5, right =5, top = 5, bottom = 5 }})
	f:SetBackdropColor(1,0,0,.6)
	f:SetMovable(true)
	f:RegisterForDrag("LeftButton")

	f.Text = f:CreateFontString(nil, "OVERLAY")
	f.Text:SetFontObject(GameFontNormalSmall)
	f.Text:ClearAllPoints()
	f.Text:SetTextColor(1, 1, 1, 1)
	f.Text:SetWidth(160)
	f.Text:SetHeight(25)
	f.Text:SetPoint("TOPLEFT", f, "TOPLEFT")
	f.Text:SetJustifyH("CENTER")
	f.Text:SetJustifyV("MIDDLE")
	f.Text:SetText("Scorchio! v" .. Scorchio.version)
	f:Hide()
	return f
end

function Scorchio:ResetAnchor()
	self.db.profile.baroptions.barposition.x = 0
	self.db.profile.baroptions.barposition.y = 50
	Scorchio.db.profile.baroptions.barposition.p = "CENTER"
	Scorchio.db.profile.baroptions.barposition.rP = "CENTER"
	self.anchor:ClearAllPoints()
	self.anchor:SetPoint("CENTER", UIParent, "CENTER", 0, 50)
	self.anchor:Show()
	self:ShowTestBars()
end

function Scorchio:SetGrowUp()
	if Scorchio.db.profile.growUp then
		self:SetEnniBarGroupPoint(SB, "BOTTOM", self.anchor, "TOP", -7, 0)
		self:SetEnniBarGroupGrowth(SB, true)
		if testBars then self:ShowTestBars() end
	else
		self:SetEnniBarGroupPoint(SB, "TOP", self.anchor, "BOTTOM", -7, 0)
		self:SetEnniBarGroupGrowth(SB, false)
		if testBars then self:ShowTestBars() end
	end
end



function Scorchio:COMBAT_LOG_EVENT_UNFILTERED(_, event, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, ...)
    
	local _, _, prefix, suffix = string.find(event, "(.-)_(.+)")
	local fullMobName 
    
	if dstName ~= nil then 
		fullMobName = dstName .. "_" .. tostring(dstGUID)
	else
        fullMobName = UnitName("target")
    end
    
    local timestamp = GetTime()
    
    Debug("code", tostring(prefix) .. tostring(suffix) .. " : " .. tostring(srcName) .. " : " .. tostring(srcFlags))
    
    Debug("log", "LOG: Time: " .. tostring(timestamp) .. ", Event: " .. tostring(event) .. ", dstName: " .. tostring(dstName) .. ", dstFlags: " .. tostring(dstFlags))
	if (prefix == "SPELL") then
		local spellID, spellName, spellSchool, spellAuraType, spellCount, fvApplied
		spellCount = -1
		spellID = arg9
		if (suffix == "DAMAGE") then
			if (SCORCHIDS[tonumber(spellID)]) then
                if isValidSrc(srcName) and isValidGrp(srcFlags) then
                    self:SendCommMessage("GROUP", srcName, fullMobName, "SSYN") 
                    Debug("sync",">SSYN: " .. tostring(srcName) .. ", " .. tostring(fullMobName))
                    casterTable[srcName] = timestamp
                    self:UpdateTableScorch(fullMobName, timestamp)
                end
			end
		elseif scorchTable[fullMobName] ~= nil then
            if(suffix == "AURA_APPLIED") then
                spellCount = 1
                self:CheckFireVuln(arg9, spellCount, fullMobName)
            elseif (suffix == "AURA_APPLIED_DOSE") then
                self:CheckFireVuln(arg9, arg13, fullMobName)
            elseif (suffix == "AURA_REMOVED") then		
                spellCount = -1
                self:CheckFireVuln(arg9, spellCount, fullMobName)
            elseif (suffix == "AURA_REMOVED_DOSE") then						
                self:CheckFireVuln(arg9, arg13, fullMobName)			
            end
        end
	elseif (prefix == "UNIT") then
		if dstName ~= nil and scorchTable[fullMobName] ~= nil then
            self:MobDies(fullMobName)
            Debug("sync", ">RDEA: " .. tostring(fullMobName))
			self:SendCommMessage("GROUP", fullMobName, fullMobName, "RDEA")
		end
	end
end
function Scorchio:PLAYER_REGEN_ENABLED()
	for k,v in pairs(scorchTable) do
		self:UnregisterEnniBarWithGroup(k,SB)
		self:UnregisterEnniBar(k)
	end
	self:InitializeTables()
end

function Scorchio:PLAYER_TARGET_CHANGED()
	if self:IsEnniBarRegistered(lastTargetedBarname) then
		self:SetEnniBarColor(lastTargetedBarname, unpack(Scorchio.db.profile.baroptions.fgcolours))
        self:SetEnniBarBackgroundColor(lastTargetedBarname, unpack(Scorchio.db.profile.baroptions.bgcolours))
	end

	if UnitExists("target") then
		lastTargetedBarname = UnitName("target") .. "_" .. tostring(UnitGUID("target"))

		if self:IsEnniBarRegistered(lastTargetedBarname) then
			self:SetEnniBarColor(lastTargetedBarname, unpack(Scorchio.db.profile.baroptions.fgcolourstarget))
            self:SetEnniBarBackgroundColor(lastTargetedBarname, unpack(Scorchio.db.profile.baroptions.bgcolourstarget))
		end
	else
		lastTargetedBarname = "0"
	end
end

function Scorchio:PARTY_MEMBERS_CHANGED()
	Scorchio:RebuildMageList()
end

function Scorchio:RAID_TARGET_UPDATE()
    if not Scorchio.db.profile.baroptions.raidiconshow then return end
    local ceiling = GetNumRaidMembers()
    local rop = "raid"
    if ceiling == 0 then 
        ceiling = GetNumPartyMembers() 
        rop = "party"
    end
    local unit = "target"
    local icon = GetRaidTargetIndex(unit)
    if icon then
        raidIconTable[UnitGUID(unit)] = icon
        local fullMobName = UnitName(unit) .. "_" .. UnitGUID(unit)
        if self:IsEnniBarRegistered(fullMobName) then
            local scorchStack = scorchTable[fullMobName][SCORCHSTACK]
            self:SetEnniBarText(fullMobName, self:RaidIcon(self:GetGUID(fullMobName)) .. " (x" .. scorchStack .. ")  " .. self:GetName(fullMobName))
        end
        Debug("code", "raidIconTable[" .. tostring(UnitGUID(unit)) .. " = " .. tostring(icon) .. "]")
    end
    for i = 1, ceiling do
        unit = rop..i.."target"
        icon = GetRaidTargetIndex(unit)
        if icon then
			raidIconTable[UnitGUID(unit)] = icon
            local fullMobName = UnitName(unit) .. "_" .. UnitGUID(unit)
            if self:IsEnniBarRegistered(fullMobName) then
                local scorchStack = scorchTable[fullMobName][SCORCHSTACK]
                self:SetEnniBarText(fullMobName, self:RaidIcon(self:GetGUID(fullMobName)) .. " (x" .. scorchStack .. ")  " .. self:GetName(fullMobName))
            end
            Debug("code", "raidIconTable[" .. tostring(UnitGUID(unit)) .. " = " .. tostring(icon) .. "]")
        end
    end
end

function Scorchio:ReceiveMessage(prefix, sender, distribution, arg1, arg2, arg3)
	if arg3 == nil or arg3 == "SSYN" then
		local castTime = GetTime()
		local srcName = arg1
		local fullMobName = arg2
		Debug("sync", "<: " .. tostring(srcName) .. ", " .. tostring(fullMobName))
		Debug("code", tostring(srcName) .. ": " .. tostring(casterTable[srcName]) .. ", " .. tostring(castTime) .. " SYNC")
		if casterTable[srcName] == nil or (castTime - 0.8) > casterTable[srcName] then
			if not Scorchio.db.profile.blacklist[srcName] then
				casterTable[srcName] = castTime
				self:UpdateTableScorch(fullMobName, GetTime())
			else
				Debug("sync", tostring(srcName) .. " blacklisted. Ignoring event.")
			end
		else
			Debug("duplicates", "Duplicate event ignored (" .. tostring(srcName) ..") SYNC")
		end
	elseif arg3 == "STAC" then
		local stacks = arg1
		local fullMobName = arg2
        self:UpdateTableScorch(fullMobName, GetTime(), stacks)
	elseif arg3 == "RDEA" then
        self:MobDies(arg1)

	elseif arg3 == "RTAL" then 
		Debug("sync", "<RTAL: " .. tostring(sender))
		self:SendCommMessage("WHISPER", sender, playerName, hasImpScorch(), "STAL")
	elseif arg3 == "STAL" then
		local caster = arg1
		local remImpScorch = arg2
		Debug("sync", "<STAL: " .. tostring(sender))
		Scorchio.db.profile.blacklist[caster] = not remImpScorch
		Debug("code", "Adding " .. tostring(caster) .. " to the Blacklist as " .. tostring(Scorchio.db.profile.blacklist[caster]))
	end
end

function Scorchio:MobDies(fullMobName)
    Debug("mob", tostring(fullMobName) .. " dies.")
    scorchTable[fullMobName] = nil
    raidIconTable[self:GetGUID(fullMobName)] = nil
    self:UnregisterEnniBarWithGroup(fullMobName,SB)
    self:UnregisterEnniBar(fullMobName)
end

function Scorchio:CheckFireVuln(spellID, spellCount, fullMobName)
    Debug("log", "LOG:" .. tostring(GetTime()) .. ": CheckFireVuln: " .. tostring(spellID) .. ", " .. tostring(fullMobName))
	if (spellID == 22959) then
        if spellCount >= 0 then
            self:UpdateTableScorch(fullMobName, GetTime(), spellCount)
            Debug("mob", tostring(fullMobName) .. " gained scorch " .. tostring(spellCount))
            self:SendCommMessage("GROUP", spellCount, fullMobName, "STAC") 
            Debug("sync", ">STAC: " .. tostring(spellCount) .. ", " .. tostring(fullMobName))
        end
    end 
end
function Scorchio:LostVuln(fullMobName)
	if Scorchio.db.profile.sounds.on then
		PlaySoundFile(SM:Fetch("sound", Scorchio.db.profile.sounds.expiredsound))
	end
	self:Pour(L["Fire Vulnerability Expired on "] .. tostring(self:GetName(fullMobName)), 1, 0, 0)
    if self:IsEnniBarRegistered(fullMobName) then
        self:UnregisterEnniBarWithGroup(fullMobName,SB)
        self:UnregisterEnniBar(fullMobName)
    end 
end
function Scorchio:TimerComplete(fullMobName)
	local timerTime = GetTime()
	if scorchTable[fullMobName] then
		Debug("timers", "TIMER: " ..tostring(fullMobName) .. ", " .. tostring(scorchTable[fullMobName][REFRESHTIME]) .. ", " .. tostring(timerTime) .. ", " .. tostring(scorchTable[fullMobName][REFRESHTIME] - timerTime))
		if scorchTable[fullMobName][REFRESHTIME] - timerTime <= (-30 + Scorchio.db.profile.warningtime) then
			if Scorchio.db.profile.sounds.on then
				PlaySoundFile(SM:Fetch("sound", Scorchio.db.profile.sounds.warningsound))
			end
			self:Pour(L["Rescorch "] .. self:GetName(fullMobName) .. "!", 1, 0.647, 0)
		end
	end
end

function Scorchio:UpdateTableScorch(fullMobName, time, stacks)
	if scorchTable[fullMobName] == nil then
        Debug("mob", "New mob: " .. tostring(fullMobName))
        scorchTable[fullMobName] = {fullMobName, time, 0, 0 } 
	end
    if stacks == nil then stacks = scorchTable[fullMobName][SCORCHSTACK] + 1 end
    if stacks > 5 then stacks = 5 end
    if stacks <= 0 then
        self:LostVuln(fullMobName)
    else
        scorchTable[fullMobName][SCORCHSTACK] = stacks
        scorchTable[fullMobName][REFRESHTIME] = time       	
        if Scorchio.db.profile.warningtime > 0 and scorchTable[fullMobName][SCORCHSTACK] > 0 then Scorchio:ScheduleEvent("TIMER_COMPLETE",(30 - Scorchio.db.profile.warningtime), fullMobName) end
    end
    self:CreateBar(scorchTable[fullMobName])
end
function Scorchio:RebuildMageList()
	local tmp = { }
	local count = 0
	local ceiling = GetNumRaidMembers()
	local rop = "raid"
	if ceiling == 0 then 
		ceiling = GetNumPartyMembers()
		rop = "party"
		tmp = { playerName }
		count = count + 1
	end
	if ceiling == 0 then
		mageList = { playerName }
		options.args.blacklist.args.magelist.validate = mageList
		return
	end
	for i = 1, ceiling do
		local unit = rop..tostring(i)
		local _, unitclass = UnitClass(unit)
		local unitname, unitrealm
		if unitclass == "MAGE" then
			unitname, unitrealm = UnitName(unit)
			if unitrealm ~= nil then
				Debug("code",":"..unitname..":-:"..unitrealm..":")
				unitrealm = "-" .. unitrealm
				if unitrealm ~= "-" then unitname = unitname .. unitrealm end
			end
			table.insert(tmp, unitname)
			count = count + 1
		end
	end
	mageList = tmp
	for k,v in pairs(mageList) do
		if Scorchio.db.profile.blacklist[v] == nil then
			Scorchio.db.profile.blacklist[v] = false
			Debug("code", "New mage: " .. tostring(v))
			if Scorchio.db.profile.autoBlackList then
				self:SendCommMessage("WHISPER", v, playerName, hasImpScorch(), "RTAL")
				Debug("sync",">RTAL: " .. tostring(v))
			end
		end
	end
	Debug("code", tostring(count) .. " mages added.")
	options.args.blacklist.args.magelist.validate = mageList
end

function Scorchio:CreateBar(scorchTarget)
    Debug("log", "LOG:" .. tostring(GetTime()) .. ": CreateBarStart: " .. ", " .. tostring(fullMobName))
	if scorchTarget == nil then return end
	local fullMobName = scorchTarget[MOBNAME]
	local elapsedTime = GetTime() - scorchTarget[REFRESHTIME]
	local remainingTime = math.floor (30 - elapsedTime)
    local scorchStack = tostring(scorchTarget[SCORCHSTACK])
	local text = self:RaidIcon(self:GetGUID(fullMobName)) .. " (x" .. scorchStack .. ")  " .. self:GetName(fullMobName)
	local barName = (fullMobName)
	local ExpFun = function (fullMobName)
		local test = fullMobName
		self:LostVuln(test)
	end
    
    if not self:IsEnniBarRegistered(barName) then
        self:RegisterEnniBar(barName, 30, text)
        self:RegisterEnniBarWithGroup(barName, SB)
    else
        self:SetEnniBarText(barName, text)
    end
    
    self:SetEnniBarTimeLeft(barName, remainingTime)

	if UnitExists("target") and UnitName("target").."_"..UnitGUID("target") == barName then
		self:SetEnniBarColor(barName, unpack(Scorchio.db.profile.baroptions.fgcolourstarget))
        self:SetEnniBarBackgroundColor(barName, unpack(Scorchio.db.profile.baroptions.bgcolourstarget))
	else
		self:SetEnniBarColor(barName, unpack(Scorchio.db.profile.baroptions.fgcolours))
        self:SetEnniBarBackgroundColor(barName, unpack(Scorchio.db.profile.baroptions.bgcolours))
	end

	self:SetEnniBarFade(barName, Scorchio.db.profile.baroptions.fadetime)

	if Scorchio.db.profile.baroptions.iconshow then
		self:SetEnniBarIcon(barName, "Interface\\AddOns\\scorchio\\icons\\scorchr" .. scorchStack)
		self:SetEnniBarIconPosition(barName, Scorchio.db.profile.baroptions.iconside)
	else
		self:SetEnniBarIcon(barName, nil)
	end

	self:SetEnniBarWidth(barName, Scorchio.db.profile.baroptions.width)
	self:SetEnniBarHeight(barName, Scorchio.db.profile.baroptions.height)
	self:SetEnniBarScale(barName, Scorchio.db.profile.baroptions.scale)
    self:SetEnniBarFontSize(barName, Scorchio.db.profile.baroptions.fontsize)
    self:SetEnniBarTexture(barName, SM:Fetch("statusbar", Scorchio.db.profile.baroptions.texture))
	
    self:SetEnniBarCompletion(barName, ExpFun, fullMobName)

    self:StartEnniBar(barName)
    Debug("log", "LOG:" .. tostring(GetTime()) .. ": CreateBarEnd: " .. ", " .. tostring(fullMobName))
end

function Scorchio:RaidIcon(mobGUID)
    local text = ""
    if raidIconTable[mobGUID] == nil or not Scorchio.db.profile.baroptions.raidiconshow then
        text = "|TInterface\\AddOns\\Scorchio\\icons\\blank"
    else
        text = "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_" .. tostring(raidIconTable[mobGUID])
    end
    text = text .. ":" .. tostring(Scorchio.db.profile.baroptions.height-2) .. ":" .. tostring(Scorchio.db.profile.baroptions.height-2) .. ":" .. tostring(Scorchio.db.profile.baroptions.raidiconpos) .. "|t"
    return text
end

function Scorchio:GetName(fullMobName)
	local _, _, mobName, mobGUID = string.find(fullMobName, "(.-)_(.+)")
    if mobName == nil then
        return fullMobName
    else
        return tostring(mobName)
    end
end

function Scorchio:GetGUID(fullMobName)
	local _, _, mobName, mobGUID = string.find(fullMobName, "(.-)_(.+)")
	return tostring(mobGUID)
end
