local L = AceLibrary("AceLocale-2.2"):new("sRaidFrames")
local Media = LibStub("LibSharedMedia-3.0")
local sRaidFrames = sRaidFrames

BINDING_HEADER_sRaidFrames = "sRaidFrames"
BINDING_NAME_ShowHideRaidWindows = L["Show/Hide Raid Windows"]
BINDING_NAME_ToggleBuffDebuffview = L["Toggle Buff/Debuff view"]
BINDING_NAME_Toggledisplayofonlydispellabledebuffs = L["Toggle display of only dispellable debuffs"]


local function SetVar(var, val)
	sRaidFrames.db.profile[var] = val
end

local function GetVar(var)
	return sRaidFrames.db.profile[var]
end


sRaidFrames.options = {
	type = 'group',
	handler = sRaidFrames,
	args = {
		spacer = {
			type = "header",
			order = 100,
		},
		
		spacer2 = {
			type = "header",
			order = 600,
		},

		behaviour = {
			name = L["Frame Behaviour"],
			type = "header",
			order = 200,
		},

		informational = {
			name = L["Informational"],
			type = "header",
			order = 300,

		},

		appearance = {
			name = L["Appearance"],
			type = "header",
			order = 400,
		},

		buffsdebuffs = {
			name = L["Buffs & Debuffs"],
			type = "header",
			order = 500,
		},

		lock = {
			name = L["Lock"],
			type = "toggle",
			desc = L["Lock/Unlock the raid frames"],
			get = function()
				return sRaidFrames.opt.Locked
			end,
			set = function(value)
				sRaidFrames.opt.Locked = value
				if not value then
					sRaidFrames.opt.ShowGroupTitles = true
					for _,f in pairs(sRaidFrames.groupframes) do
						sRaidFrames:UpdateTitleVisibility(f.header)
					end
				end
			end,
			disabled = InCombatLockdown,
			order = 2,
		},

		show = {
			name = L["Show"],
			type = "toggle",
			desc = L["Show the raid frames"],
			get = function()
				return sRaidFrames.master:IsVisible()
			end,
			set = function(value)
				if value then
					sRaidFrames.master:Show()
				else
					sRaidFrames.master:Hide()
				end
			end,
			hidden = function() return not sRaidFrames.enabled end,
			disabled = InCombatLockdown,
			order = 3,
		},
		
		hidearena = {
			name = L["Hide in arena"],
			type = "toggle",
			desc = L["Hide the raid frames when you are in an arena"],
			get = function()
				return sRaidFrames.opt.HideInArena
			end,
			set = function(value)
				sRaidFrames.opt.HideInArena = value
				sRaidFrames:UpdateRoster()
			end,
			disabled = InCombatLockdown,
			order = 4,
		},

		health = {
			name = L["Health text"],
			type = "text",
			desc = L["Set health display type"],
			get = function()
				return sRaidFrames.opt.HealthFormat
			end,
			set = function(value)
				sRaidFrames.opt.HealthFormat = value
			end,
			validate = {["curmax"] = L["Current and max health"], ["deficit"] = L["Health deficit"], ["percent"] = L["Health percentage"], ["current"] = L["Current health"], ["curdeficit"] = L["Current health with deficit"], ["none"] = L["Hide health text"]},
			order = 301,
		},

		debuffs = {
			name = L["Debuffs"],
			type = "group",
			desc = L["Debuff settings"],
			args = {
				blacklist = {
					name = L["Debuff blacklist"],
					type = "group",
					desc = L["Set a list of debuffs to never be displayed"],
					args = {
						add = {
							name = L["Add debuff"],
							type = "text",
							desc = L["Add a debuff"],
							get = false,
							set = function(value)
								if value and value ~= "" and not sRaidFrames.opt.DebuffFilter[value] and not sRaidFrames.opt.DebuffWhitelist[value] then
									sRaidFrames.opt.DebuffFilter[value] = true
									sRaidFrames:chatUpdateDebuffMenu()
									for unit in pairs(sRaidFrames:GetAllUnits()) do
										sRaidFrames:UpdateAuras(unit)
									end
								end
							end,
							usage = L["<name of debuff>"],
						},
					},
					disabled = function() return (sRaidFrames.opt.BuffType == "buffs") end,
				},
				whitelist = {
					name = L["Debuff whitelist"],
					type = "group",
					desc = L["Set a list of debuffs to always be displayed"],
					args = {
						add = {
							name = L["Add debuff"],
							type = "text",
							desc = L["Add a debuff"],
							get = false,
							set = function(value)
								if value and value ~= "" and not sRaidFrames.opt.DebuffWhitelist[value] and not sRaidFrames.opt.DebuffFilter[value] then
									sRaidFrames.opt.DebuffWhitelist[value] = true
									sRaidFrames:chatUpdateDebuffMenu()
									for unit in pairs(sRaidFrames:GetAllUnits()) do
										sRaidFrames:UpdateAuras(unit)
									end
								end
							end,
							usage = L["<name of debuff>"],
						},
					},
					disabled = function() return not (sRaidFrames.opt.BuffType ~= "buffs" and sRaidFrames.opt.ShowOnlyDispellable) end,
				},

				curable = {
					name = L["Show only curable debuffs"],
					type = "toggle",
					desc = L["Show only debuffs that are curable by me"],
					get = function()
						return sRaidFrames.opt.ShowOnlyDispellable
					end,
					set = function(value)
						sRaidFrames.opt.ShowOnlyDispellable = value
						sRaidFrames:UpdateAllUnits()
					end,
					disabled = function() return (sRaidFrames.opt.BuffType == "buffs") end,
				},

				highlight = {
					name = L["Highlight debuffed units"],
					type = "text",
					desc = L["Highlight units afflicted by a certain debuff type"],
					get = function()
						return sRaidFrames.opt.HighlightDebuffs
					end,
					set = function(value)
						sRaidFrames.opt.HighlightDebuffs = value
						sRaidFrames:UpdateAllUnits()
					end,
					validate = {["never"] = L["Never"], ["all"] = L["All dispellable debuffs"], ["onlyself"] = L["Debuffs dispellable by me"]},
				},
			},
			order = 501,
		},

		buffs = {
			name = L["Buffs"],
			type = "group",
			desc = L["Buff settings"],
			disabled = function() return sRaidFrames.opt.BuffType == "debuffs" end,
			args = {
				display = {
					name = L["Buff Display"],
					type = "text",
					desc = L["Set which buffs are displayed"],
					get = function()
						return sRaidFrames.opt.BuffDisplay
					end,
					set = function(value)
						sRaidFrames.opt.BuffDisplay = value
						for unit in pairs(sRaidFrames:GetAllUnits()) do
							sRaidFrames:UpdateAuras(unit)
						end
					end,
					validate = {["own"] = L["Show buffs cast by me"], ["class"] = L["Show buffs cast by anyone from my class"], ["all"] = L["Show all buffs"]},
					
				},
				filter = {
					name = L["Buff Filter"],
					type = "group",
					desc = L["Set a list of buffs to be exclusively displayed"],
					args = {
						add = {
							name = L["Add buff"],
							type = "text",
							desc = L["Add a buff"],
							get = false,
							set = function(value)
								if value and value ~= "" and not sRaidFrames.opt.BuffFilter[value] then
									sRaidFrames.opt.BuffFilter[value] = true
									sRaidFrames:chatUpdateBuffMenu()
									for unit in pairs(sRaidFrames:GetAllUnits()) do
										sRaidFrames:UpdateAuras(unit)
									end
								end
							end,
							usage = L["<name of buff>"],
						},
					},
					disabled = function() return sRaidFrames.opt.BuffDisplay == "own" end,
				},
				blacklist = {
					name = L["Buff Blacklist"],
					type = "group",
					desc = L["Set a list of buffs to not be displayed"],
					args = {
						add = {
							name = L["Add buff"],
							type = "text",
							desc = L["Add a buff"],
							get = false,
							set = function(value)
								if value and value ~= "" and not sRaidFrames.opt.BuffBlacklist[value] then
									sRaidFrames.opt.BuffBlacklist[value] = true
									sRaidFrames:chatUpdateBuffMenu()
									for unit in pairs(sRaidFrames:GetAllUnits()) do
										sRaidFrames:UpdateAuras(unit)
									end
								end
							end,
							usage = L["<name of buff>"],
						},
					},
					disabled = function() return sRaidFrames.opt.BuffDisplay == "own" end,
				},
			},
			order = 501,
		},

		titles = {
			name = L["Show group titles"],
			type = "toggle",
			desc = L["Toggle display of titles above each group frame"],
			get = function()
				return sRaidFrames.opt.ShowGroupTitles
			end,
			set = function(value)
				sRaidFrames.opt.ShowGroupTitles = value
				for _,f in pairs(sRaidFrames.groupframes) do
					sRaidFrames:UpdateTitleVisibility(f.header)
				end
			end,
			disabled = function() return not sRaidFrames.opt.Locked or InCombatLockdown() end,
			order = 401,
		},

		bufftype = {
			name = L["Buff/Debuff visibility"],
			type = "text",
			desc = L["Show buffs or debuffs on the raid frames"],
			get = function()
				return sRaidFrames.opt.BuffType
			end,
			set = function(value)
				sRaidFrames.opt.BuffType = value
				sRaidFrames:UpdateAllUnits()
			end,
			validate = {["buffs"] = L["Only buffs"], ["debuffs"] = L["Only debuffs"], ["buffsifnotdebuffed"] = L["Buffs if not debuffed"]},
			order = 501,
		},

		powerfilter = {
			name = L["Power type visiblity"],
			type = "text",
			desc = L["Toggle the display of certain power types (Mana, Rage, Energy)"],
			multiToggle = true,
			get = function(key)
				return sRaidFrames.opt.PowerFilter[tonumber(key)]
			end,
			set = function(key, value)
				sRaidFrames.opt.PowerFilter[tonumber(key)] = value
				sRaidFrames:UpdateAllUnits()
			end,
			validate = {
				[tostring(SPELL_POWER_MANA)] = L["Mana"],
				[tostring(SPELL_POWER_RAGE)] = L["Rage"],
				[tostring(SPELL_POWER_ENERGY)] = "Energy",
				--[SPELL_POWER_RUNIC_POWER] = "Runic Power",
			},
			order = 301,
		},

		invert = {
			name = L["Invert health bars"],
			type = "toggle",
			desc = L["Invert the growth of the health bars"],
			get = function()
				return sRaidFrames.opt.Invert
			end,
			set = function(value)
				sRaidFrames.opt.Invert = value
				sRaidFrames:UpdateAllUnits()
			end,
			order = 201,
		},

		texture = {
			name = L["Bar textures"],
			type = "text",
			desc = L["Set the texture used on health and mana bars"],
			get = function()
				return sRaidFrames.opt.Texture
			end,
			set = function(value)
				sRaidFrames.opt.Texture = value
			
				local tex = Media:Fetch("statusbar", self.opt.Texture)
				for _, f in pairs(sRaidFrames.frames) do
					f.hpbar:SetStatusBarTexture(tex)
					f.mpbar:SetStatusBarTexture(tex)
				end
			end,
			validate = Media:List("statusbar"),
			order = 401,
		},

		scale = {
			name = L["Scale"],
			type = "range",
			desc = L["Set the scale of the raid frames"],
			min = 0.1,
			max = 3.0,
			step = 0.05,
			get = function()
				return sRaidFrames.opt.Scale
			end,
			set = function(value)
				sRaidFrames.opt.Scale = value
				sRaidFrames.master:SetScale(value)
			end,
			disabled = InCombatLockdown,
			order = 401,
		},

		positioning = {
			name = L["Positioning"],
			type = "group",
			desc = L["Set the positioning of the raid frames"],
			args = {
				reset = {
					name = L["Reset position"],
					type = "execute",
					desc = L["Reset the position of sRaidFrames"],
					func = "ResetPosition"
				},
				predefined = {
					name = L["Predefined position"],
					type = "text",
					desc = L["Set a predefined position for the raid frames"],
					get = function() return nil end,
					set = function(layout)
						sRaidFrames:PositionLayout(layout, sRaidFrames.groupframes[1]:GetLeft(), sRaidFrames.groupframes[1]:GetTop()-UIParent:GetEffectiveScale()/sRaidFrames.master:GetEffectiveScale()*UIParent:GetTop())
					end,
					validate = {["ctra"] = L["CT_RaidAssist"], ["horizontal"] = L["Horizontal"], ["vertical"] = L["Vertical"]},
				},
			},
			disabled = InCombatLockdown,
			order = 201,
		},

		layout = {
			name = L["Layout"],
			type = "text",
			desc = L["Set the layout of the frames based on presets"],
			get = function()
				return sRaidFrames.opt.Layout
			end,
			set = function(value)
				sRaidFrames.opt.Layout = value
				sRaidFrames:SetLayout(value)
				sRaidFrames:ApplyLayout()
			end,
			validate = {},
			order = 201,
		},

		colors = {
			name = L["Colors"],
			type = "group",
			desc = L["Set the diffirent colors of the raid frames"],
			args = {
				background = {
					type = "color",
					name = L["Background color"],
					desc = L["Change the background color"],
					get = function()
						local s = sRaidFrames.opt.BackgroundColor
						return s.r, s.g, s.b, s.a
					end,
					set = function(r, g, b, a)
						sRaidFrames.opt.BackgroundColor = {r = r, g = g, b = b, a = a}
						sRaidFrames:UpdateAllUnits()
					end,
					hasAlpha = true,
					order = 100,
				},
				border = {
					type = "color",
					name = L["Border color"],
					desc = L["Change the border color"],
					get = function()
						local s = sRaidFrames.opt.BorderColor
						return s.r, s.g, s.b, s.a
					end,
					set = function(r, g, b, a)
						sRaidFrames.opt.BorderColor = {r = r, g = g, b = b, a = a}

						for _, frame in pairs(sRaidFrames.frames) do
							frame:SetBackdropBorderColor(r, g, b, a)
						end
					end,
					hasAlpha = true,
					disabled = function() return not sRaidFrames.opt.Border end,
					order = 100,
				},

				healthtext = {
					type = "color",
					name = L["Health text color"],
					desc = L["Change the color of the health text"],
					get = function()
						local s = sRaidFrames.opt.HealthTextColor
						return s.r, s.g, s.b, s.a
					end,
					set = function(r, g, b, a)
						sRaidFrames.opt.HealthTextColor = {r = r, g = g, b = b, a = a}

						for _, frame in pairs(sRaidFrames.frames) do
							frame.hpbar.text:SetTextColor(r, g, b, a)
						end
					end,
					hasAlpha = false,
					order = 100,
				},
			},
			order = 401,
		},

		tooltips = {
			name = L["Tooltip display"],
			type = "group",
			desc = L["Determine when a tooltip is displayed"],
			args = {
				units = {
					name = L["Unit tooltips"],
					type = "text",
					desc = L["Determine when a tooltip is displayed"],
					get = GetVar,
					set = SetVar,
					passValue = "UnitTooltipMethod",
					validate = {["never"] = L["Never"], ["notincombat"] = L["Only when not in combat"], ["always"] = L["Always"]},
				},
				unittype = {
					name = "Unit tooltip type",
					type = "text",
					desc = "Determine the look of unit tooltips",
					get = GetVar,
					set = SetVar,
					passValue = "UnitTooltipType",
					validate = {["blizz"] = "Blizzard", ["ctra"] = "CT_RaidAssist"},
				},
				buffs = {
					name = L["Buff tooltips"],
					type = "text",
					desc = L["Determine when a tooltip is displayed"],
					get = GetVar,
					set = SetVar,
					passValue = "BuffTooltipMethod",
					validate = {["never"] = L["Never"], ["notincombat"] = L["Only when not in combat"], ["always"] = L["Always"]},
				},
				debuffs = {
					name = L["Debuff tooltips"],
					type = "text",
					desc = L["Determine when a tooltip is displayed"],
					get = GetVar,
					set = SetVar,
					passValue = "DebuffTooltipMethod",
					validate = {["never"] = L["Never"], ["notincombat"] = L["Only when not in combat"], ["always"] = L["Always"]},
				},
			},
			order = 401,
		},

		aggro = {
				name = L["Highlight units with aggro"],
				type = "toggle",
				desc = L["Turn the border of units who have aggro red"],
				get = GetVar,
				set = SetVar,
				passValue = "AggroCheck",
				order = 301,
				disabled = function() return not LibStub("LibBanzai-2.0", true) end,
		},

		highlight = {
				name = L["Highlight targetted unit"],
				type = "toggle",
				desc = L["Turn the border of unit you are targetting orange"],
				get = GetVar,
				set = SetVar,
				passValue = "HighlightTarget",
				order = 301,
		},

		heals = {
			name = L["Heal tracking"],
			type = "group",
			desc = L["Options for heal tracking"],
			disabled = function() return not LibStub:GetLibrary("LibHealComm-3.0", true) end,
			args = {
				enable = {
						name = L["Enable heal tracking"],
						type = "toggle",
						desc = L["Turn the border of units getting heals green"],
						get = GetVar,
						set = SetVar,
						passValue = "HighlightHeals",
				},
				self = {
						name = L["Show self heals"],
						type = "toggle",
						desc = L["Show heals originating from yourself"],
						get = GetVar,
						set = SetVar,
						passValue = "HighlightHealsSelf",
						disabled = function() return not sRaidFrames.opt.HighlightHeals end,

				},
				users = {
						name = L["Show users and versions"],
						type = "execute",
						desc = L["Show a list of users whom are broadcasting heal data"],
						func = function() sRaidFrames:ShowHealCommVersions() end,
						order = 200,
				},
			},
			order = 301,
		},

		range = {
			name = L["Range"],
			type = "group",
			desc = L["Options for range checks"],
			args = {
				enable = {
					name = L["Enable range check"],
					type = "toggle",
					desc = L["Enable range checking"],
					get = function() return sRaidFrames.opt.RangeCheck end,
					set = function(value)
						sRaidFrames.opt.RangeCheck = value
						if not value then
							for unit in pairs(sRaidFrames.frames) do
								sRaidFrames.frames[unit]:SetAlpha(1)
							end
						end
					end,
					order = 1,
				},
				alpha = {
					name = L["Alpha"],
					type = "range",
					desc = L["The alpha level for units who are out of range"],
					get = GetVar,
					set = SetVar,
					passValue = "RangeAlpha",
					min  = 0,
					max  = 1,
					step = 0.1,
					disabled = function() return not sRaidFrames.opt.RangeCheck end,
				},
				frequency = {
					name = L["Frequency"],
					type = "range",
					desc = L["The interval between which range checks are performed"],
					get = function() return sRaidFrames.opt.RangeFrequency end,
					set = function(value)
						sRaidFrames.opt.RangeFrequency = value
						sRaidFrames:UpdateRangeFrequency()
					end,
					min  = 0.2,
					max  = 2.0,
					step = 0.1,
					disabled = function() return not sRaidFrames.opt.RangeCheck end,
				},
				limit = {
					name = L["Range"],
					type = "text",
					desc = L["The range at which a unit is considered out of range"],
					get = function() return tostring(sRaidFrames.opt.RangeLimit) end,
					set = function(value)
						sRaidFrames.opt.RangeLimit = tonumber(value)
					end,
					validate = {},
					disabled = function() return not sRaidFrames.opt.RangeCheck end,
				}
			},
			order = 301,
		},
		
		readycheck = {
			name = L["Display ready check"],
			type = "toggle",
			desc = L["Display readiness status for the raid"],
			get = GetVar,
			set = SetVar,
			passValue = "ReadyCheck",
			order = 301,
		},

		sets = {
			name = L["Filter/Sort sets"],
			type = "group",
			desc = L["Toggle the display of certain Groups/Classes"],
			args = {},
			disabled = InCombatLockdown,
			order = 201,
		},

		growth = {
			name = L["Growth"],
			type = "text",
			desc = L["Set the growth of the raid frames"],
			get = function()
				return sRaidFrames.opt.Growth
			end,
			set = function(value)
				sRaidFrames.opt.Growth = value
				sRaidFrames:SetGrowth()
			end,
			validate = {["up"] = L["Up"], ["down"] = L["Down"], ["left"] = L["Left"], ["right"] = L["Right"]},
			disabled = InCombatLockdown,
			order = 201,
		},

		spacing = {
			name = L["Frame Spacing"],
			type = "range",
			desc = L["Set the spacing between each of the raid frames"],
			min = -5,
			max = 5,
			step = 1,
			get = function()
				return sRaidFrames.opt.Spacing
			end,
			set = function(s)
				sRaidFrames.opt.Spacing = s
				sRaidFrames:SetSpacing()
			end,
			disabled = InCombatLockdown,
			order = 201,
		},
		
		advanced = {
			name = L["Advanced"],
			type = "group",
			desc = L["Advanced options"],
			args = {
				elements = {
					name = L["Status elements"],
					type = "group",
					desc = L["Manage status elements"],
					args = {
						reset = {
							name = L["|cffff0000Delete all statuses|r"],
							desc = L["Resets all status maps, requires a RELOAD UI to initate the default maps"],
							type = "execute",
							func = function() 
								for key in pairs(sRaidFrames.opt.StatusMaps) do
									sRaidFrames.options.args.advanced.args.elements.args[key] = nil
									sRaidFrames.opt.StatusMaps[key] = nil
								end
							end,
							confirm = true,
							order = 500,
						},
					},
				},	
			},
			order = 601,
		},
	},
}

function sRaidFrames:chatUpdateStatusElements()
	local i = 1
	for key, data in pairs(self.opt.StatusMaps) do
		if not self.options.args.advanced.args.elements.args[key] then
			self.options.args.advanced.args.elements.args[key] = {
				type = 'group',
				name = key,
				desc = ("Change settings for the status %s"):format(key),
				args = {
					priority = {
						name = L["Priority"],
						desc = L["Set the priority"],
						type = "range",
						min = 1,
						max = 200,
						step = 1,
						set = function(value) self.opt.StatusMaps[key].priority = value end,
						get = function() return self.opt.StatusMaps[key].priority end,
					},
					enabled = {
						name = L["Enabled"],
						desc = L["Enable the status indicator"],
						type = "toggle",
						set = function(value) self.opt.StatusMaps[key].enabled = value end,
						get = function() return self.opt.StatusMaps[key].enabled ~= false end,
					},
					elements = {
						name = L["GUI Elements"],
						desc = L["Set which elements this status will use"],
						type = "text",
						multiToggle = true,
						validate = sRaidFrames.validateStatusElements,
						set = function(element, value) self.opt.StatusMaps[key].elements[element] = value end,
						get = function(value) return self.opt.StatusMaps[key].elements[value] end,
					},
					color = {
						name = L["Color"],
						desc = L["Set which color this status will use"],
						type = "color",
						set = function(r, g, b, a)
							self.opt.StatusMaps[key].color = {r = r, g = g, b = b, a = a}
						 end,
						get = function() 
							local color = self.opt.StatusMaps[key].color
							return color.r, color.g, color.b, color.a 
						end,
					},
					text = {
						name = L["Text"],
						desc = L["Set which text this status will show"],
						type = "text",
						usage = "<name>",
						set = function(value) self.opt.StatusMaps[key].text = value end,
						get = function() return self.opt.StatusMaps[key].text end,
					},
				},
				order = 200-self.opt.StatusMaps[key].priority,
			}
		end
	end
end

function sRaidFrames:chatUpdateBuffMenu()
	self.options.args.buffs.args.filter.args.remove = {
		type = 'group',
		name = L["Remove buff"],
		desc = L["Remove buffs from the filter"],
		args = {},
	}

	table.sort(self.opt.BuffFilter)

	local i = 1
	for buff in pairs(self.opt.BuffFilter) do
		local buffName = buff -- Odd hack, don't know
		self.options.args.buffs.args.filter.args.remove.args["buff" .. i] = {
			type = 'execute',
			name = buffName,
			desc = L["Remove %s from the buff filter"]:format(buffName),
			func = function()
				self.opt.BuffFilter[buffName] = nil
				self:chatUpdateBuffMenu()
			end,
			confirm = true,
		}
		i = i + 1
	end
	
	self.options.args.buffs.args.blacklist.args.remove = {
		type = 'group',
		name = L["Remove buff"],
		desc = L["Remove buffs from the filter"],
		args = {},
	}

	table.sort(self.opt.BuffBlacklist)

	local i = 1
	for buff in pairs(self.opt.BuffBlacklist) do
		local buffName = buff -- Odd hack, don't know
		self.options.args.buffs.args.blacklist.args.remove.args["buff" .. i] = {
			type = 'execute',
			name = buffName,
			desc = L["Remove %s from the buff filter"]:format(buffName),
			func = function()
				self.opt.BuffBlacklist[buffName] = nil
				self:chatUpdateBuffMenu()
			end,
			confirm = true,
		}
		i = i + 1
	end
end

function sRaidFrames:chatUpdateDebuffMenu()
	self.options.args.debuffs.args.blacklist.args.remove = {
		type = 'group',
		name = L["Remove debuff"],
		desc = L["Remove debuffs from the filter"],
		args = {},
	}

	table.sort(self.opt.DebuffFilter)

	local i = 1
	for debuff in pairs(self.opt.DebuffFilter) do
		local debuffName = debuff -- Odd hack, don't know
		self.options.args.debuffs.args.blacklist.args.remove.args["debuff" .. i] = {
			type = 'execute',
			name = debuffName,
			desc = L["Remove %s from the filter"]:format(debuffName),
			func = function()
				self.opt.DebuffFilter[debuffName] = nil
				self:chatUpdateDebuffMenu()
			end,
			confirm = true,
		}
		i = i + 1
	end


	self.options.args.debuffs.args.whitelist.args.remove = {
		type = 'group',
		name = L["Remove debuff"],
		desc = L["Remove debuffs from the filter"],
		args = {},
	}

	table.sort(self.opt.DebuffWhitelist)

	local i = 1
	for debuff in pairs(self.opt.DebuffWhitelist) do
		local debuffName = debuff -- Odd hack, don't know
		self.options.args.debuffs.args.whitelist.args.remove.args["debuff" .. i] = {
			type = 'execute',
			name = debuffName,
			desc = L["Remove %s from the filter"]:format(debuffName),
			func = function()
				self.opt.DebuffWhitelist[debuffName] = nil
				self:chatUpdateDebuffMenu()
			end,
			confirm = true,
		}
		i = i + 1
	end
end

function sRaidFrames:UpdateRangeLimitOptions()
	self.options.args.range.args.limit.validate = {}
	for r, _ in pairs(self.RangeChecks) do
		self.options.args.range.args.limit.validate[tostring(r)] = L["%d yards"]:format(r)
	end
end