local HealComm = LibStub:GetLibrary("LibHealComm-3.0", true)
if not HealComm then return end
local RL = AceLibrary("Roster-2.1")

local sRaidFrames = sRaidFrames
local playerHeals = {}

local function StripRealm(name)
	return name:match("(.+)%-") or name
end

function sRaidFrames:UpdateHealsOnUnit(unit)
	local incomingHeals = (select(2, HealComm:UnitIncomingHealGet(unit, GetTime())) or 0) + (playerHeals[unit] or 0)

	if incomingHeals > 0 then
		incomingHeals = incomingHeals * HealComm:UnitHealModifierGet(unit)
		self:SetStatus(unit, "Heal", ("+%d"):format(incomingHeals), nil, true)
	else
		self:UnsetStatus(unit, "Heal")
	end
end

function sRaidFrames:HealComm_DirectHealStart(event, healerFullName, healSize, endTime, ...)
	if not self.opt.HighlightHeals then return end

	local HealerUnit = RL:GetUnitIDFromName(StripRealm(healerFullName))
	local isOwnHeal = HealerUnit and UnitIsUnit(HealerUnit, "player") or false
	if not self.opt.HighlightHealsSelf and isOwnHeal then
		return
	end

	for i=1,select('#', ...) do
		local targetUnit = RL:GetUnitIDFromName(StripRealm(select(i, ...)))
		if targetUnit then
			if isOwnHeal then
				playerHeals[targetUnit] = healSize
			end
			self:UpdateHealsOnUnit(targetUnit)
		end
	end
end

function sRaidFrames:HealComm_DirectHealStop(event, healerFullName, healSize, succeeded, ...)
	if not self.opt.HighlightHeals then return end

	local HealerUnit = RL:GetUnitIDFromName(StripRealm(healerFullName))
	local isOwnHeal = HealerUnit and UnitIsUnit(HealerUnit, "player") or false

	for i=1,select('#', ...) do
		local targetUnit = RL:GetUnitIDFromName(StripRealm(select(i, ...)))
		if targetUnit then
			if isOwnHeal then
				playerHeals[targetUnit] = nil
			end
			self:UpdateHealsOnUnit(targetUnit)
		end
	end
end

function sRaidFrames:HealComm_DirectHealDelayed(event, healerFullName, healSize, endTime, ...)

end

function sRaidFrames:HealComm_HealModifierUpdate(event, unit, targetName, healMod)
	local targetUnit = RL:GetUnitIDFromName(StripRealm(targetName))
	if targetUnit then
		self:UpdateHealsOnUnit(targetUnit)
	end
end

function sRaidFrames:ShowHealCommVersions()
	local versions = HealComm:GetRaidOrPartyVersions()
	local your_version = versions[(UnitName("player"))]

	self:Print(("HealComm users (your version: %d):"):format(your_version))
	for user, version in pairs(versions) do
		if version then
			if version < your_version then
				version = ("|cffff0000%d|r"):format(version)
			elseif version > your_version then
				version = ("|cff00ff00%d|r"):format(version)
			end
			self:Print((" %s: %s"):format(user, version))
		end
	end
end
