---------------------------------------------------------
-- Options Menu

RUPTURE_TOURNEY_SAVED = RUPTURE_TOURNEY_SAVED or {
		aura = 1,
		cursor = 1,
		playerscale = 1,
		targetscale = 1,
		petscale = 1,
		partyscale = 1,
		focusscale = 1,
		comboscale = 1,
		alertoffset = 95,
		alertsize = 23,
	}

local options = CreateFrame("Frame", "Rupture_Options", UIParent)
options:SetWidth(370)
options:SetHeight(250)
options:SetPoint("CENTER")
options:SetBackdrop({
	bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
	edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
	tile = true,
	tileSize = 16,
	edgeSize = 16,
	insets = { left = 5, right = 5, top = 5, bottom = 5 },
})
options:SetBackdropColor(0, 0, 0, 0.75)
options:Hide()
table.insert(UISpecialFrames, "Rupture_Options")

options:RegisterEvent("VARIABLES_LOADED")
options:SetScript("OnEvent", function()
		Rupture_player:SetScale(RUPTURE_TOURNEY_SAVED.playerscale)
		Rupture_target:SetScale(RUPTURE_TOURNEY_SAVED.targetscale)
		Rupture_pet:SetScale(RUPTURE_TOURNEY_SAVED.petscale)
		Rupture_focus:SetScale(RUPTURE_TOURNEY_SAVED.focusscale)
		Rupture_party1:SetScale(RUPTURE_TOURNEY_SAVED.partyscale)
		Rupture_party2:SetScale(RUPTURE_TOURNEY_SAVED.partyscale)
		Rupture_party3:SetScale(RUPTURE_TOURNEY_SAVED.partyscale)
		Rupture_party4:SetScale(RUPTURE_TOURNEY_SAVED.partyscale)

		if RUPTURE_TOURNEY_SAVED.combonum then
			for i = 1, 5 do
				Rupture_Combo["combo"..i]:Hide()
			end
			Rupture_Combo.bg:Hide()
			Rupture_Combo.text:Show()
		else	
			Rupture_Combo.bg:Show()
			Rupture_Combo.text:Hide()
		end

		Rupture_Combo:SetScale(RUPTURE_TOURNEY_SAVED.comboscale)
		
		Rupture_SpellAlert:SetPoint("CENTER", 0, RUPTURE_TOURNEY_SAVED.alertoffset)
		Rupture_SpellAlert:SetHeight(RUPTURE_TOURNEY_SAVED.alertsize + 2)
		Rupture_SpellAlert:SetFont("Fonts\\FRIZQT__.TTF", RUPTURE_TOURNEY_SAVED.alertsize, "OUTLINE")
		Rupture_BuffAlert:SetHeight(RUPTURE_TOURNEY_SAVED.alertsize + 2)
		Rupture_BuffAlert:SetFont("Fonts\\FRIZQT__.TTF", RUPTURE_TOURNEY_SAVED.alertsize, "OUTLINE")
	end)
	
local font = options:CreateFontString(nil, "ARTWORK")
font:SetWidth(200)
font:SetHeight(15)
font:SetPoint("TOP", 0, -5)
font:SetFontObject("NumberFontNormal")
font:SetText("|cffff0000Rupture|r Tourney Menu")

local check = CreateFrame("CheckButton", "Rupture_AuraOpt", options, "UICheckButtonTemplate")
check:SetWidth(20)
check:SetHeight(20)
check:SetPoint("TOPLEFT", 5, -20)
check:SetScript("OnShow", function(self)
		self:SetChecked(RUPTURE_TOURNEY_SAVED.aura)
	end)
check:SetScript("OnClick", function(self)
		RUPTURE_TOURNEY_SAVED.aura = self:GetChecked()
	end)
Rupture_AuraOptText:SetText("Aura Cooldowns")

check = CreateFrame("CheckButton", "Rupture_CursorOpt", options, "UICheckButtonTemplate")
check:SetWidth(20)
check:SetHeight(20)
check:SetPoint("TOPLEFT", "Rupture_AuraOpt", "BOTTOMLEFT", 0, -5)
check:SetScript("OnShow", function(self)
		self:SetChecked(RUPTURE_TOURNEY_SAVED.cursor)
	end)
check:SetScript("OnClick", function(self)
		RUPTURE_TOURNEY_SAVED.cursor = self:GetChecked()
	end)
Rupture_CursorOptText:SetText("Tooltip at Cursor")

check = CreateFrame("CheckButton", "Rupture_ComboOpt", options, "UICheckButtonTemplate")
check:SetWidth(20)
check:SetHeight(20)
check:SetPoint("TOPLEFT", "Rupture_CursorOpt", "BOTTOMLEFT", 0, -5)
check:SetScript("OnShow", function(self)
		self:SetChecked(RUPTURE_TOURNEY_SAVED.combonum)
	end)
check:SetScript("OnClick", function(self)
		RUPTURE_TOURNEY_SAVED.combonum = self:GetChecked()
		if RUPTURE_TOURNEY_SAVED.combonum then
			for i = 1, 5 do
				Rupture_Combo["combo"..i]:Hide()
			end
			Rupture_Combo.bg:Hide()
			Rupture_Combo.text:Show()
		else	
			Rupture_Combo.bg:Show()
			Rupture_Combo.text:Hide()
		end
	end)
Rupture_ComboOptText:SetText("Combos as Number")

local slider = CreateFrame("Slider", "Rupture_PlayerScale", options, "OptionsSliderTemplate")
slider:SetPoint("TOPRIGHT", -5, -33)
slider:SetMinMaxValues(0.25, 3)
slider:SetValueStep(0.01)
slider:SetScript("OnShow", function(self)
		self:SetValue(RUPTURE_TOURNEY_SAVED.playerscale)
	end)
slider:SetScript("OnValueChanged", function(self)
		local value = self:GetValue()
		RUPTURE_TOURNEY_SAVED.playerscale = value
		Rupture_player:SetScale(value)
	end)
Rupture_PlayerScaleText:SetText("Player Frame Scale")

slider = CreateFrame("Slider", "Rupture_TargetScale", options, "OptionsSliderTemplate")
slider:SetPoint("TOPRIGHT", "Rupture_PlayerScale", "BOTTOMRIGHT", 0, -23)
slider:SetMinMaxValues(0.25, 3)
slider:SetValueStep(0.01)
slider:SetScript("OnShow", function(self)
		self:SetValue(RUPTURE_TOURNEY_SAVED.targetscale)
	end)
slider:SetScript("OnValueChanged", function(self)
		local value = self:GetValue()
		RUPTURE_TOURNEY_SAVED.targetscale = value
		Rupture_target:SetScale(value)
	end)
Rupture_TargetScaleText:SetText("Target Frame Scale")

slider = CreateFrame("Slider", "Rupture_FocusScale", options, "OptionsSliderTemplate")
slider:SetPoint("TOPRIGHT", "Rupture_TargetScale", "BOTTOMRIGHT", 0, -23)
slider:SetMinMaxValues(0.25, 3)
slider:SetValueStep(0.01)
slider:SetScript("OnShow", function(self)
		self:SetValue(RUPTURE_TOURNEY_SAVED.focusscale)
	end)
slider:SetScript("OnValueChanged", function(self)
		local value = self:GetValue()
		RUPTURE_TOURNEY_SAVED.focusscale = value
		Rupture_focus:SetScale(value)
	end)
Rupture_FocusScaleText:SetText("Focus Frame Scale")

slider = CreateFrame("Slider", "Rupture_PetScale", options, "OptionsSliderTemplate")
slider:SetPoint("TOPRIGHT", "Rupture_FocusScale", "BOTTOMRIGHT", 0, -23)
slider:SetMinMaxValues(0.25, 3)
slider:SetValueStep(0.01)
slider:SetScript("OnShow", function(self)
		self:SetValue(RUPTURE_TOURNEY_SAVED.petscale)
	end)
slider:SetScript("OnValueChanged", function(self)
		local value = self:GetValue()
		RUPTURE_TOURNEY_SAVED.petscale = value
		Rupture_pet:SetScale(value)
	end)
Rupture_PetScaleText:SetText("Pet Frame Scale")

slider = CreateFrame("Slider", "Rupture_PartyScale", options, "OptionsSliderTemplate")
slider:SetPoint("TOPRIGHT", "Rupture_PetScale", "BOTTOMRIGHT", 0, -23)
slider:SetMinMaxValues(0.25, 3)
slider:SetValueStep(0.01)
slider:SetScript("OnShow", function(self)
		self:SetValue(RUPTURE_TOURNEY_SAVED.partyscale)
	end)
slider:SetScript("OnValueChanged", function(self)
		local value = self:GetValue()
		RUPTURE_TOURNEY_SAVED.partyscale = value
		Rupture_party1:SetScale(value)
		Rupture_party2:SetScale(value)
		Rupture_party3:SetScale(value)
		Rupture_party4:SetScale(value)
	end)
Rupture_PartyScaleText:SetText("Party Frame Scale")

slider = CreateFrame("Slider", "Rupture_AlertOffset", options, "OptionsSliderTemplate")
slider:SetPoint("TOPLEFT", "Rupture_ComboOpt", "BOTTOMLEFT", 0, -18)
slider:SetMinMaxValues(-400, 400)
slider:SetValueStep(1)
slider:SetScript("OnShow", function(self)
		self:SetValue(RUPTURE_TOURNEY_SAVED.alertoffset)
	end)
slider:SetScript("OnValueChanged", function(self)
		local value = self:GetValue()
		RUPTURE_TOURNEY_SAVED.alertoffset = value
		Rupture_SpellAlert:SetPoint("CENTER", 0, value)
		Rupture_SpellAlert:AddMessage("Alert Position Changed")
		Rupture_BuffAlert:AddMessage("Alert Position Changed")
	end)
Rupture_AlertOffsetText:SetText("Spell Alert Offset")

slider = CreateFrame("Slider", "Rupture_AlertSize", options, "OptionsSliderTemplate")
slider:SetPoint("TOPLEFT", "Rupture_AlertOffset", "BOTTOMLEFT", 0, -23)
slider:SetMinMaxValues(5, 33)
slider:SetValueStep(1)
slider:SetScript("OnShow", function(self)
		self:SetValue(RUPTURE_TOURNEY_SAVED.alertsize)
	end)
slider:SetScript("OnValueChanged", function(self)
		local value = self:GetValue()
		RUPTURE_TOURNEY_SAVED.alertsize = value
		Rupture_SpellAlert:SetHeight(value + 2)
		Rupture_SpellAlert:SetFont("Fonts\\FRIZQT__.TTF", value, "OUTLINE")
		Rupture_BuffAlert:SetHeight(value + 2)
		Rupture_BuffAlert:SetFont("Fonts\\FRIZQT__.TTF", value, "OUTLINE")
		Rupture_SpellAlert:AddMessage("Alert Size Changed")
		Rupture_BuffAlert:AddMessage("Alert Size Changed")
	end)
Rupture_AlertSizeText:SetText("Spell Alert Size")

slider = CreateFrame("Slider", "Rupture_ComboScale", options, "OptionsSliderTemplate")
slider:SetPoint("TOPLEFT", "Rupture_AlertSize", "BOTTOMLEFT", 0, -23)
slider:SetMinMaxValues(0.25, 3)
slider:SetValueStep(0.01)
slider:SetScript("OnShow", function(self)
		self:SetValue(RUPTURE_TOURNEY_SAVED.comboscale)
	end)
slider:SetScript("OnValueChanged", function(self)
		local value = self:GetValue()
		RUPTURE_TOURNEY_SAVED.comboscale = value
		Rupture_Combo:SetScale(value)
	end)
Rupture_ComboScaleText:SetText("Combo Scale")