---------------------------------------------------------
-- Bindings Menu

local spells, macros, items, listing

local updatelist = function()
	spells = {}
	local offset, numSpells, spell, spellname, spellrank
	for tab = 1, GetNumSpellTabs() do
		_, _, offset, numSpells = GetSpellTabInfo(tab)
		spells[tab] = {}
		for i = 1, numSpells do
			spell = offset + i
			if not IsPassiveSpell(spell, BOOKTYPE_SPELL) then
				spellname, spellrank = GetSpellName(spell, BOOKTYPE_SPELL)
				if not spells[tab][spellname] then
					spells[tab][spellname] = {}
					table.insert(spells[tab], spellname)
				end
				table.insert(spells[tab][spellname], spell)
			end
		end
	end
	
	macros = { {}, {} }
	local all, char, name, texture
	all, char = GetNumMacros()
	for i = 1, all do
		name, texture = GetMacroInfo(i)
		table.insert(macros[1], {name, texture})
	end
	
	for i = 19, char + 18 do
		name, texture = GetMacroInfo(i)
		table.insert(macros[2], {name, texture})
	end
	
	items = {}
	for i = 0, 19 do
		local link = GetInventoryItemLink("player", i)
		if link then
			local _, _, itemid = string.find(link, "item:(%d+):")
			local add = true
			for _, v in ipairs(items) do
				if v == itemid then
					add = nil
					break
				end
			end
			if add and (IsConsumableItem(itemid) or GetItemSpell(itemid)) then
				table.insert(items, itemid)
			end
		end
	end
	
	for bag = 0, NUM_BAG_FRAMES do
		local baglink
		if bag == 0 then
			baglink = true
		else
			baglink = GetInventoryItemLink("player",(ContainerIDToInventoryID(bag)))
		end
		if baglink then
			local slots = GetContainerNumSlots(bag)
			for i = 1, slots do
				local link = GetContainerItemLink(bag, i)
				if link then
					local _, _, itemid = string.find(link, "item:(%d+):")
					local add = true
					for _, v in ipairs(items) do
						if v == itemid then
							add = nil
							break
						end
					end
					if add and (IsConsumableItem(itemid) or GetItemSpell(itemid)) then
						table.insert(items, itemid)
					end
				end
			end
		end
	end
	
	listing = nil
end

local selected, bind

function Rupture_ScrollBinds()
	if not spells then
		updatelist()
	end
	
	if not listing then
		listing = {}
		for i = 1, #spells do
			local name = GetSpellTabInfo(i)
			table.insert(listing, { name, "|cff0099ff" })
			for k, v in ipairs(spells[i]) do
				table.insert(listing, { v, spells[i][v], "SPELL" })
			end
		end

		table.insert(listing, { " ", "|cff00ff00" })

		for i = 1, #macros do
			if i == 1 then
				table.insert(listing, { GENERAL_MACROS, "|cff00ff00" })
			else
				local text = string.format(CHARACTER_SPECIFIC_MACROS, UnitName("player"))
				table.insert(listing, { text, "|cff00ff00" })
			end
			for k, v in ipairs(macros[i]) do
				table.insert(listing, { v[1], v[2], "MACRO" })
			end
		end

		table.insert(listing, { " ", "|cffffff00" })
		table.insert(listing, { ITEMS, "|cffffff00" })

		for _, v in ipairs(items) do
			table.insert(listing, { v, true, "ITEM" })
		end
	end

	local format_row = function(row, num)
		if listing[num][3] then
			local spell = listing[num][1]
			row.ranks = nil
			row.spell = spell
			row.icon:Show()
			row.text:SetPoint("LEFT", row.icon, "RIGHT", 3, 0)
			if selected == spell then
				row:LockHighlight()
				row:EnableKeyboard(true)
				row.hl:SetVertexColor(1, 0, 0)
				bind = listing[num][3]
			else
				row:UnlockHighlight()
				row:EnableKeyboard(nil)
				row.hl:SetVertexColor(1, 1, 0)
			end
			if listing[num][3] == "SPELL" then
				row.icon:SetTexture(GetSpellTexture(listing[num][2][1], BOOKTYPE_SPELL))
				if #listing[num][2] > 1 then
					row.ranks = #listing[num][2]
					if row.rank then
						spell = spell.."("..RANK.." "..row.rank..")"
					end
				end
			elseif listing[num][3] == "MACRO" then
				row.icon:SetTexture(listing[num][2])
			elseif listing[num][3] == "ITEM" then
				local itemid = listing[num][1]
				spell = GetItemInfo(itemid)
				row.icon:SetTexture(select(10, GetItemInfo(itemid)))
			end
			row.text:SetText(spell)
			row.bind:SetText(GetBindingKey(listing[num][3].." "..spell))
		else
			row.icon:Hide()
			row.bind:SetText(nil)
			row.text:SetPoint("LEFT")
			row.text:SetText(listing[num][2]..listing[num][1].."|r")
		end
	end

	local frame = Rupture_ScrollBind
	FauxScrollFrame_Update(frame, #listing, 13, 15)
	for line = 1, 13 do
		local offset = line + FauxScrollFrame_GetOffset(frame)
		local row = getglobal("Rupture_Bind"..line)
		if offset <= #listing then
			format_row(row, offset)
			row:Show()
		else
			row:Hide()
		end
	end
end

function Rupture_Binding_Save(key, spell, type)
	SetBinding(key)
	if spell then
		type = capitalize(type)
		local func = _G["SetBinding"..type]
		func(key, spell)
		if type == "Click" then
			local btn = _G[spell]
			local id = btn:GetID()
			spell = spell..":LeftButton"
		end
		local old = { GetBindingKey(type.." "..spell) }
		for _, v in ipairs(old) do
			if v ~= key then
				SetBinding(v)
			end
		end
	end
	SaveBindings(GetCurrentBindingSet())
	selected = nil
	Rupture_ScrollBinds()
end

local onkeydown = function(self, arg1)
	local keyPressed = arg1
	local screenshotKey = GetBindingKey("SCREENSHOT")
	if screenshotKey and keyPressed == screenshotKey then
		Screenshot()
		return
	end
	if keyPressed == "ESCAPE" then
		HideUIPanel(self:GetParent())
		return
	end

	if selected then
		if keyPressed == "UNKNOWN" or keyPressed == "SHIFT" or keyPressed == "CTRL" or keyPressed == "ALT" then
			return
		end
		if keyPressed == "MiddleButton" then
			keyPressed = "BUTTON3"
		elseif keyPressed == "Button4" then
			keyPressed = "BUTTON4"
		elseif keyPressed == "Button5" then
			keyPressed = "BUTTON5"
		end
		
		if IsShiftKeyDown() then keyPressed = "SHIFT-"..keyPressed end
		if IsControlKeyDown() then keyPressed = "CTRL-"..keyPressed end
		if IsAltKeyDown() then keyPressed = "ALT-"..keyPressed end
		
		local spell = selected
		if self.rank then
			spell = spell.."("..RANK.." "..self.rank..")"
		end
		if bind == "ITEM" then
			spell = GetItemInfo(spell)
		end
		
		local key
		if bind == "CLICK" then
			key = GetBindingKey(bind.." "..spell..":LeftButton")
		else
			key = GetBindingKey(bind.." "..spell)
		end

		local text, data
		if key == keyPressed then
			text = "Unbind |cff00ff00"..spell.."|r?"
			Rupture_Bindings.data = { keyPressed }
		else
			text = "Bind |cff00ff00"..spell.."|r to |cffff0000"..keyPressed.."|r?"
			local oldkey = GetBindingAction(keyPressed)
			if getglobal("BINDING_NAME_"..oldkey) then
				oldkey = getglobal("BINDING_NAME_"..oldkey)
			end
			if oldkey ~= "" then
				text = "Current: |cff00ff00"..oldkey.."|r\n"..text
			end

			if string.find(spell, " %(") then
				spell = spell.."()"
			end
			Rupture_Bindings.data = { keyPressed, spell, bind }
		end
		StaticPopupDialogs["RUPTURE_BINDKEY"].text = text
		StaticPopup_Show("RUPTURE_BINDKEY")
	end
end

local clickbind = function(self, arg1)
	if self.icon:IsShown() then
		if arg1 == "LeftButton" then
			if selected == self.spell then
				selected = nil
			else
				selected = self.spell
			end
		elseif arg1 == "RightButton" then
			if self.ranks then
				local info = {}
				local spell = self.spell
				local drop = self.drop
				drop.displayMode = "MENU"
				drop.initialize = function ()
					info.text = spell
					info.isTitle = 1
					info.notCheckable = 1
					UIDropDownMenu_AddButton(info)

					info = {}
					info.text = "Max "..RANK
					info.func = function() self.rank = nil Rupture_ScrollBinds() end
					info.isTitle = nil
					info.notCheckable = 1
					UIDropDownMenu_AddButton(info)

					for i = 1, this.ranks do
						info.text = "("..RANK.." "..i..")"
						info.func = function() self.rank = i Rupture_ScrollBinds() end
						info.isTitle = nil
						info.notCheckable = 1
						UIDropDownMenu_AddButton(info)
					end
				end
				ToggleDropDownMenu(1, nil, drop, "cursor")
			end
		else
			onkeydown(self, arg1)
		end
		Rupture_ScrollBinds()
	end
end

local mousewheel = function(self, arg1)
	if selected then
		local btn
		for i = 1, 13 do
			btn = _G["Rupture_Bind"..i]
			if btn.spell == selected then
				break
			end
		end
		if arg1 > 0 then
			onkeydown(btn, "MOUSEWHEELUP")
		else
			onkeydown(btn, "MOUSEWHEELDOWN")
		end
	else
		ScrollFrameTemplate_OnMouseWheel(arg1)
	end
end

StaticPopupDialogs["RUPTURE_BINDKEY"] = {
	button1 = TEXT(ACCEPT),
	button2 = TEXT(CANCEL),
	OnAccept = function()
		local info = Rupture_Bindings.data
		Rupture_Binding_Save(unpack(info))
		Rupture_Bindings.data = nil
	end,
	timeout = 10,
	whileDead = 1,
	hideOnEscape = 1,
}

local menu = CreateFrame("Frame", "Rupture_Bindings", UIParent)
menu:SetWidth(370)
menu:SetHeight(250)
menu:SetPoint("CENTER")
menu:Hide()
menu:RegisterEvent("BAG_UPDATE")
menu:RegisterEvent("UPDATE_MACROS")
menu:RegisterEvent("LEARNED_SPELL_IN_TAB")
menu:SetScript("OnEvent", function() spells = nil end)
menu:SetBackdrop({
	bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
	edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
	tile = true,
	tileSize = 16,
	edgeSize = 16,
	insets = { left = 5, right = 5, top = 5, bottom = 5 },
})
menu:SetBackdropColor(0, 0, 0, 0.75)
table.insert(UISpecialFrames, "Rupture_Bindings")

local font = menu:CreateFontString(nil, "ARTWORK")
font:SetWidth(200)
font:SetHeight(15)
font:SetPoint("TOP", 0, -5)
font:SetFontObject("NumberFontNormal")
font:SetText("|cffff0000Rupture|r Bindings Menu")

local scroll = CreateFrame("ScrollFrame", "Rupture_ScrollBind", menu, "FauxScrollFrameTemplate")
scroll:SetWidth(335)
scroll:SetHeight(220)
scroll:SetPoint("BOTTOMLEFT", 6, 5)
scroll:SetScript("OnShow", function(self)
		Rupture_ScrollBinds()
	end)
scroll:SetScript("OnVerticalScroll", function(self)
		FauxScrollFrame_OnVerticalScroll(14, Rupture_ScrollBinds)
	end)
scroll:SetScript("OnMouseWheel", function(self, arg)
		mousewheel(self, arg1)
	end)
	
for i = 1, 13 do
	local btn = CreateFrame("Button", "Rupture_Bind"..i, menu)
	btn:SetWidth(340)
	btn:SetHeight(17)
	btn:RegisterForClicks("AnyUp")
	btn:SetScript("OnClick", function(self, arg1) clickbind(self, arg1) end)
	btn:SetScript("OnKeyDown", function(self, arg1) onkeydown(self, arg1) end)
	
	btn.hl = btn:CreateTexture(nil, "ARTWORK")
	btn.hl:SetAllPoints(btn)
	btn.hl:SetTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	btn.hl:SetBlendMode("ADD")
	btn:SetHighlightTexture(btn.hl)
	btn.drop = CreateFrame("Frame")
	
	if i == 1 then
		btn:SetPoint("TOPLEFT", scroll, "TOPLEFT")
	else
		btn:SetPoint("TOP", "Rupture_Bind"..(i - 1), "BOTTOM")
	end

	btn.icon = btn:CreateTexture(nil, "ARTWORK")
	btn.icon:SetWidth(15)
	btn.icon:SetHeight(15)
	btn.icon:SetPoint("LEFT", 10, 0)

	btn.text = btn:CreateFontString(nil, "ARTWORK")
	btn.text:SetJustifyH("LEFT")
	btn.text:SetFontObject("GameFontWhite")
	btn.text:SetPoint("LEFT", btn.icon, "RIGHT", 3, 0)

	btn.bind = btn:CreateFontString(nil, "ARTWORK")
	btn.bind:SetJustifyH("RIGHT")
	btn.bind:SetFontObject("GameFontNormal")
	btn.bind:SetPoint("RIGHT", -3, 0)
end