local opts = {
	type = 'group',
	args = {
		debug = {
			type = 'toggle',
			name = 'debug',
			desc = 'Enables/Disables the Debug-Mode',
			get = 'IsDebugging',
			set = function(v)
				rSelfCast:SetDebugging(v)
				rSelfCast.db.profile.debug = v
			end,
		},
--		reset = {
--			type = 'execute',
--			name = 'reset',
--			desc = 'Deletes all collected Data',
--			func = 'ResetDB',
--			disabled = 'IsNotDebugging',
--		},
	},
}

local defaults = {
--	version = 300,
	debug = false,
	spells = {},
}

local fail_messages = {
	-- deDE	
	"Ihr scheitert beim Wirken von (.+): Ung\195\188ltiges Ziel.",
	"Ihr scheitert beim Wirken von (.+): Eure Waffenhand ist leer..",
	-- enGB
	"You fail to cast (.+): No target.",
	"You fail to cast (.+): Your weapon hand is empty.",
	-- frFR
	"Vous n'avez pas r\195\169ussi \195\160 lancer (.+) : Cible incorrecte.",
	"Vous n'avez pas r\195\169ussi \195\160 lancer (.+) : Vous n'avez pas d'arme en main..",
		-- koKR
	"(.+) 시전이 실패했습니다: 대상이 없습니다.",
	"(.+) 시전이 실패했습니다: 주장비를 착용하지 않았습니다.",
}


rSelfCast = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0","AceDB-2.0","AceDebug-2.0")

rSelfCast:RegisterChatCommand({"/rsc"}, opts)
rSelfCast:RegisterDB("rSelfCast_Vars")
rSelfCast:RegisterDefaults("profile",defaults)

function rSelfCast:OnEnable()
	self:SetDebugging(self.db.profile.debug)

	MainMenuBarArtFrame:SetAttribute("unit2", "player");
	MultiBarBottomLeft:SetAttribute("unit2", "player");
	MultiBarBottomRight:SetAttribute("unit2", "player");
	MultiBarRight:SetAttribute("unit2", "player");
	MultiBarLeft:SetAttribute("unit2", "player");
end

function rSelfCast:OnDisable()
	self:SetDebugging(self.db.profile.debug)

	MainMenuBarArtFrame:SetAttribute("unit2", "");
	MultiBarBottomLeft:SetAttribute("unit2", "");
	MultiBarBottomRight:SetAttribute("unit2", "");
	MultiBarRight:SetAttribute("unit2", "");
	MultiBarLeft:SetAttribute("unit2", "");
end


-- Libary Functions

function rSelfCast:IsNotDebugging()
	return not self:IsDebugging()
end