--******************************************************************************************************
--[[
	Deathwing!Quel
	qwarlock@gmail.com
	v4.0 3/23/08

	Detects when targets become immune to spell effects and displays a count down timer estimating
	the Immunity time remaining based on the target's class, level, and when the message was 
	captured.
--]]

--******************************************************************************************************
-- 

ICtimer=0; 	
ICimmunity=0;
IConesec=0;
ICicon=0;

ICcooldown=0;
ICduration=0;

ICMAXINDEX=5;	-- max number of targets to track
ICindex=0;	-- zero indicates no targets are being tracked
ICtarget= { {name="no target1", type="none", race="none", level=0, immune=0, timer=0, duration=0, cooldown=0, display="none"},
	    {name="no target2", type="none", race="none", level=0, immune=0, timer=0, duration=0, cooldown=0, display="none"},
	    {name="no target3", type="none", race="none", level=0, immune=0, timer=0, duration=0, cooldown=0, display="none"},
	    {name="no target4", type="none", race="none", level=0, immune=0, timer=0, duration=0, cooldown=0, display="none"},
	    {name="no target5", type="none", race="none", level=0, immune=0, timer=0, duration=0, cooldown=0, display="none"}  };

-- we're only interested in messages regarding hostile players
IC_ENEMY_MASK=bit.bor(COMBATLOG_OBJECT_REACTION_HOSTILE, 
				 COMBATLOG_OBJECT_CONTROL_PLAYER,
				 COMBATLOG_OBJECT_TYPE_PLAYER);

--IC_ENEMY_MASK=COMBATLOG_FILTER_HOSTILE_PLAYERS;
--CombatLog_Object_IsA(destFlags, COMBATLOG_FILTER_HOSTILE_PLAYERS)

ICdebug=0;
ICverbose=0;

--****************************************************************************************************
-- Dragging code
-- Virtually no other add-on does this, but my window wouldn't drag until I added all this.

local lBeingDragged;

function ImmunityClockWindowFrame_OnDragStart()
	ImmunityClockWindowFrame:StartMoving()
	lBeingDragged = 1;
end

function ImmunityClockWindowFrame_OnDragStop()
	ImmunityClockWindowFrame:StopMovingOrSizing()
	lBeingDragged = nil;
end

function ImmunityClockTargetFrame_OnDragStart()
	ImmunityClockTargetFrame:StartMoving()
	lBeingDragged = 1;
end

function ImmunityClockTargetFrame_OnDragStop()
	ImmunityClockTargetFrame:StopMovingOrSizing()
	lBeingDragged = nil;
end
--****************************************************************************************************
--Window Buttons
function ImmunityClockCloseButton_OnClick()
	ImmunityClockWindowFrame:Hide();
end

--*****************************************************************************************************
-- Debugging text messages
function ICmsg(msg)
	if (ICdebug == 1 or ICverbose == 1) then
		ChatFrame4:AddMessage(msg);
--		ImmunityClockTargetText:SetText(msg);
	end
end
--******************************************************************************************************
-- Looks up player stats
function pc_lookup(name, origname)
-- In 2.0, calls to TargetByName won't work
ICmsg("pc lookup");

	local race;
	local class;
	local level;

--	if (name ~= origname) then
--		ICmsg(format("IC pc_lookup(): calling TargetByName("..name..")"));
--		TargetByName(name);
--	end

	race = UnitRace("target");
	class = UnitClass("target");
	level = UnitLevel("target");

--	if (origname ~= name) then
--		if (origname == nil) then
--			ICmsg("IC pc_lookup(): calling ClearTarget()");
--			ClearTarget();
--		else
--			ICmsg(format("IC pc_lookup(): calling TargetByName("..origname..")"));
--			TargetByName(origname);
--		end
--	end
end

--******************************************************************************************************
-- adds a new name to the tracking list
function add_clock (name, type, duration, cooldown, buff)
ICmsg("add clock");

	local k;
	local n;
	local indx;
	local disp_ptr;
	local ac_name;

	-- Is there already a clock running for it? If this is a buff, then overwrite that entry.
	-- if this is an fear-in-progress detection, then don't start a new clock.

	-- in battlegrounds, names have hyphens in them in the new patch 2.4 combat log, but not
	-- via UnitName(target). So, if there's a hyphen, we have to truncate.
	local hyphen = string.find(name, "-");
	if (hyphen ) then
		name = string.sub(name, 1, hyphen - 1);
	end

	indx = 0;
	k=1;
	while (k <= ICMAXINDEX) do
		if (ICtarget[k].name == name and ICtarget[k].immune ~= 0) then
			if( buff == 0) then
				-- we're already tracking this event
				return;
			else
				-- this guy became immune again before we expected it. Reset clock
				indx = k;
			end
		end
		k=k+1;
	end

	-- which slot are we editing?rwh
	if (indx == 0) then
		-- this is a new clock, find the next open slot
		ICindex=ICindex + 1;
		if (ICindex > ICMAXINDEX) then
			ICindex = 1;
		end
		indx = ICindex;
	end

	ICtarget[indx].name=name;
	ICtarget[indx].type=type;
	ICtarget[indx].cooldown=cooldown;
	ICtarget[indx].duration=duration;
	ICtarget[indx].immune=1;
	ICtarget[indx].timer=0;

	-- Display the counter. Buffs are detected for all characters, so make sure we're operating on the right
	-- person.
	if (buff == 1) then
		ac_name = UnitName("target");
		if (ac_name == name) then
			ImmunityClockTargetText:SetText(format("IMMUNE "..ICtarget[indx].duration.."/"..ICtarget[indx].duration));
			ImmunityClockTargetFrame:Show();
		end
	end

	-- add the name to the separate window
	n = 1;
	while (n <= ICMAXINDEX ) do
		disp_ptr = getglobal("ImmunityClockWindowText"..n);

		if (disp_ptr:GetText() == " ") then
			ICmsg(format("IC add_clock(): found first open slot at: "..n));
			ICtarget[indx].display=disp_ptr;
			ICtarget[indx].display:SetText(format("|cffff0000 "..ICtarget[indx].name.." ("..ICtarget[indx].type.."): Immune "..ICtarget[indx].duration.."/"..ICtarget[indx].duration));
			ImmunityClockWindowFrame:SetHeight(30 + (13 * n) ); 
			n = ICMAXINDEX + 1;
		end
		n = n + 1;
	end
	ImmunityClockWindowFrame:Show();
--	ImmunityClockWindowFrame:Hide();
	PlaySound("AuctionWindowOpen");
end

--******************************************************************************************************
-- Initialization
function ImmunityClockFrame_OnLoad()
ICmsg("on load");
	-- Register for events
--	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterForDrag("LeftButton");

	-- UI Commands

	SLASH_ImmunityClock1 = "/Immunityclock";
	SLASH_ImmunityClock2 = "/ic";
	SlashCmdList["ImmunityClock"] = ImmunityClock_SlashHandler;

	ImmunityClockFrame:RegisterEvent("PLAYER_TARGET_CHANGED");
	ImmunityClockFrame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");

	ICicon=1;
	ICindex=0;

--	ChatFrame1:AddMessage("|cffffff00 Immunity Clock Loaded.");
--  UIErrorsFrame:AddMessage("Quel's Immunity Clock Loaded.", 1.0, 1.0, 1.0, 1.0, UIERRORS_HOLD_TIME);

--	message(format(ICtarget[1].name.." "..ICtarget[2].name));
--	message("Immunity Clock is activated");

end

function ImmunityClockWindowFrame_OnLoad()

	this:SetBackdropBorderColor(TOOLTIP_DEFAULT_COLOR.r, TOOLTIP_DEFAULT_COLOR.g, TOOLTIP_DEFAULT_COLOR.b);
	this:SetBackdropColor(TOOLTIP_DEFAULT_BACKGROUND_COLOR.r, TOOLTIP_DEFAULT_BACKGROUND_COLOR.g, TOOLTIP_DEFAULT_BACKGROUND_COLOR.b, 0);

	ImmunityClockWindowText1:SetText(" ");
	ImmunityClockWindowText2:SetText(" ");
	ImmunityClockWindowText3:SetText(" ");
	ImmunityClockWindowText4:SetText(" ");
	ImmunityClockWindowText5:SetText(" ");
	
	ImmunityClockWindowFrame:SetHeight("30");
end
--******************************************************************************************************
-- Handles UI  commands
function ImmunityClock_SlashHandler(arg1)
	local str;
	local opt;

ICmsg("Slash handler");

	if(arg1 == "") then
		ChatFrame1:AddMessage("--ImmunityClock Help--");
		ChatFrame1:AddMessage("/ImmunityClock <on|off>");
		ChatFrame1:AddMessage("/ic <on|off>");
		if (ICicon == 0) then
			ChatFrame1:AddMessage("Immunity Clock is currently OFF");
		else
			ChatFrame1:AddMessage("Immunity Clock is currently ON");
		end

		return;
	end

	opt=string.find(arg1,"debug");
	if (opt ~= nil) then
		if (ICdebug == 0) then
			ICdebug = 1;
			ChatFrame1:AddMessage("Immunity Clock debug messages enabled");
		else
			ICdebug = 0;
			ChatFrame1:AddMessage("Immunity Clock debug messages disabled");
		end
		return;
	end

	opt=string.find(arg1,"verbose");
	if (opt ~= nil) then
		if (ICverbose == 0) then
			ICverbose = 1;
			ChatFrame1:AddMessage("Immunity Clock verbose messages enabled");
		else
			ICverbose = 0;
			ChatFrame1:AddMessage("Immunity Clock verbose messages disabled");
		end
		return;
	end

	opt=string.find(arg1,"off");
	if (opt ~= nil) then
		ImmunityClockFrame:UnregisterEvent("PLAYER_TARGET_CHANGED");
		ImmunityClockFrame:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");


		ImmunityClockTargetFrame:Hide();
		ChatFrame1:AddMessage("Immunity Clock Deactivated");

		ImmunityClockWindowFrame:Hide();
		ImmunityClockWindowText1:SetText(" ");
		ImmunityClockWindowText2:SetText(" ");
		ImmunityClockWindowText3:SetText(" ");
		ImmunityClockWindowText4:SetText(" ");
		ImmunityClockWindowText5:SetText(" ");

		ICindex=0;
		ICimmunity=0;

		ICicon=0;
		return;
	end

	opt=string.find(arg1,"on");
	if (opt ~= nil) then
		ImmunityClockFrame:RegisterEvent("PLAYER_TARGET_CHANGED");
		ImmunityClockFrame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");

		ChatFrame1:AddMessage("Immunity Clock Activated");

		if (ICdebug == 1) then
			ImmunityClockTargetText:SetText(format("ImmunityClock On"));
			ImmunityClockTargetFrame:Show();
		end

		UIErrorsFrame:AddMessage("Immunity Clock Enabled.", 1.0, 1.0, 1.0, 1.0, UIERRORS_HOLD_TIME);

		ImmunityClockTitleText:SetText("Immunity Clock");
		ImmunityClockWindowFrame:SetHeight("30");	-- 30 + (15 * x)

		ICicon=1;
		ICindex=0;
		return;
	end
end

--******************************************************************************************************
-- Event handler 
-- variables: event = the event code, arg1= message shown to player upon that event, 
--	arg2= so far always blank

function ImmunityClockFrame_OnEvent(event,...)

	local sub1;
	local sub2;
	local sub3;

	local name;
	local type;
	local duration;
	local cooldown;

	local immunity=0;
	local k;
	local n;

	if (ICicon == 0) then
		return;
	end

	flag = 0;

	-- store the target we already have, if we have one.
	origname=UnitName("target");
	
	if (event == "PLAYER_TARGET_CHANGED") then
		-- If we've switched targets, we may need to turn the window on or off
		k = 1;
		while (k <= ICMAXINDEX ) do
			if (origname == ICtarget[k].name and ICtarget[k].immune == 1) then
				ImmunityClockTargetFrame:Show();
				return;
			end
			k=k+1;
		end
		ImmunityClockTargetFrame:Hide();
		return;

	elseif (event == "COMBAT_LOG_EVENT_UNFILTERED") then
		-- new combat log for patch 2.4
		-- primary attributes should always be available when this event fires
		local timestamp, ttype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags = select(1, ...);

		-- we're only interested in messages regarding hostile players. AURA events will utilize the dstFlags,
		-- while other events utilize the srcFlags. So, just check both to make sure a hostile player is involved,
		-- then refine the search below, per event.

		if (bit.band(dstFlags, IC_ENEMY_MASK) ~= IC_ENEMY_MASK and
		    bit.band(srcFlags, IC_ENEMY_MASK) ~= IC_ENEMY_MASK) then
			return;
		end

--[[		ChatFrame4:AddMessage(format("%s hostile player",dstName));
		ChatFrame4:AddMessage(format("bit mask: 0x%x",IC_ENEMY_MASK));
		ChatFrame4:AddMessage(format("dstFlags: 0x%x",dstFlags));
		ChatFrame4:AddMessage(format("result = 0x%x",bit.band(dstFlags, IC_ENEMY_MASK)));
--]]
		-- secondary attributes vary in quantity and values depending on the type of spell
		local spellid, spellname, spellschool, b_or_d = select(9, ...);

		-- Now we know there's an enemy in the vicinity. Send an alert.
--[[
		ChatFrame4:AddMessage("----------------------");
		ChatFrame4:AddMessage(format("%s: %s",timestamp, ttype));
		ChatFrame4:AddMessage(format("     by: %s (%s)", srcName or "na",srcGUID or "na"));
		ChatFrame4:AddMessage(format("          srcflags: 0x%x",srcFlags));
		ChatFrame4:AddMessage(format("     to: %s (%s)", dstName or "na",dstGUID or "na"));
		ChatFrame4:AddMessage(format("          dstflags: 0x%x",dstFlags));
		ChatFrame4:AddMessage(format("     spell: %s %s (ID: %s)",b_or_d or "na", spellname or "na",spellid or "na"));
		ChatFrame4:AddMessage(" ");
--]]	
		if (string.find(ttype,"SPELL_CAST_SUCCESS") ~= nil ) then

			-- totem processing is better as of patch 2.4, but still not perfect. If shaman puts down both totems,
			-- I can only track the last one. And I can't yet detect when a party member benefits from the totem.
			-- But, at least I can determine who owns the totem now.

			if (string.find(spellname,"Grounding Totem") ~= nil) then	-- ID 8177
				--ChatFrame4:AddMessage(" IC OnEvent: grounding totem detected " ..spellid);
				cooldown=.05
				duration=45;
				type="grnd totem";

				add_clock(srcName, type, duration, cooldown, 1);
				return;

			elseif (string.find(spellname,"Tremor Totem") ~= nil) then	-- ID 8143
				-- ChatFrame4:AddMessage(" IC OnEvent: Tremor totem detected " ..spellid);
				cooldown=.05
				duration=120;
				type="trem totem";			
				
				add_clock(srcName, type, duration, cooldown, 1);
				return;
			end		
			return;

		elseif (string.find(ttype,"SPELL_AURA_APPLIED") ~= nil) then
		
			if ( string.find(spellname,"Will of the Forsaken") ~= nil) then		-- ID 7744
				--ChatFrame4:AddMessage("	IC OnEvent: Will of the Forsaken detected " ..spellid);
				cooldown=115;
				duration=5;
				type="undead";

			elseif (string.find(spellname,"Fearless") ~= nil) then
				ChatFrame4:AddMessage("	IC OnEvent: trinket use detected " ..spellid);
				cooldown=570; 
				duration=30;
				type="trinket";

			elseif (string.find(spellname,"Ice Block") ~= nil) then		-- ID 45438
				--ChatFrame4:AddMessage( "IC OnEvent: Mage Ice Block detected " ..spellid);
				cooldown=290;
				duration=10;
				type="mage";

			elseif (string.find(spellname,"Sacrifice") ~= nil) then	-- ID 27148
				--ChatFrame4:AddMessage("	IC OnEvent: Voidwalker Sacrifice detected " ..spellid);
				cooldown=.05; 
				duration=30;
				type="warlock";

			elseif (string.find(spellname,"Divine Protection") ~= nil) then		-- ID 1020 (70)
				--ChatFrame4:AddMessage("	IC OnEvent: Divine Protection detected " ..spellid);

				if (spellid ~= "1020" ) then
					-- low level pally
					cooldown=292;
					duration=8;
				else
					-- high level pally
					cooldown=294;
					duration=6;
				end
				type="paladin";

			elseif (string.find(spellname,"Divine Shield") ~= nil) then	-- ID 642 (70)
				--ChatFrame4:AddMessage(" IC OnEvent: Divine Shield detected " ..spellid);
			
				if (spellid == "642" ) then
					-- high level pally
					cooldown=288;
					duration=12;
				else
					-- low level pally
					cooldown=290;
					duration=10;
				end
				type="paladin";

			elseif (string.find(spellname,"Berserker Rage") ~= nil) then	-- ID 18499
				--ChatFrame4:AddMessage(" IC OnEvent: Warrior Berserker Rage detected" ..spellid);
				cooldown=30;
				duration=10;
				type="warrior";

			elseif (string.find(spellname,"Beast Within") ~= nil) then	-- ID34471
				--ChatFrame4:AddMessage(" IC OnEvent: Hunter Bestial Wrath detected " ..spellid);
				cooldown=120;
				duration=18;
				type="hunter";

			elseif (string.find(spellname,"Death Wish") ~= nil) then	-- ID 12292
				--ChatFrame4:AddMessage(" IC OnEvent: Warrior Death Wish detected " ..spellid);
				cooldown=180;
				duration=30;
				type="warrior";

			elseif (string.find(spellname,"Cloak of Shadows") ~= nil) then	--ID 31224
				--ChatFrame4:AddMessage(" IC OnEvent: Rogue Cloak of Shadows detected " ..spellid);
				cooldown=60;
				duration=5;
				type="Cloak";

			else
				-- no immunity buff detected. 
				ICmsg("	IC OnEvent: Not an immunity buff.");
				return;
			end

			--ChatFrame4:AddMessage("ttype= " .. ttype );
			add_clock(dstName, type, duration, cooldown, 1);
			return;

		elseif (string.find(ttype,"SPELL_AURA_REMOVED") ~= nil) then
			-- Need to find out if they just removed fear
			
			if (string.find(spellname,"Fear")		~= nil or
			    string.find(spellname,"Howl of Terror")	~= nil or
			    string.find(spellname,"Seduction")	~= nil or
			    string.find(spellname,"Psychic Scream") ~= nil )then

				ChatFrame4:AddMessage(" ***** Fear removed from " .. dstName);
				
				-- If we land here, we can't be certain how they got out of fear, but we can make some
				-- guesses based on their details. We can only look up details on our current target, though.
				if (origname == dstName) then
					local race,class,level = pc_lookup(name, origname);

					if (race == "Undead") then
						cooldown=100;
						duration=20;
						type="undead?";
			
					elseif (class == "Mage") then
						cooldown=290;
						duration=10;
						type="mage?";

					elseif (class == "Paladin") then
					-- we can only guess which spell the pally may have cast
					-- as of 2.4, each spell has an unique ID. Maybe different ranks can be detected?
						if (level >= 50) then
							cooldown=288;
							duration=30;
						elseif(level >= 34) then
							cooldown=290;
							duration=10;
						elseif(level >= 18) then
							cooldown=292;
							duration=8;
						else --(level >= 6) then
							cooldown=294;
							duration=6;
						end
						type="paladin?";

					elseif (class == "Hunter") then
					-- must be Bestial Wrath
						cooldown=120;
						duration=18;
						type="hunter";

					elseif (class == "Shaman") then
						cooldown=.05;
						duration=45;
						type="totem?";

					else
						cooldown=.01; 
						duration=30;
						type="Dim returns?";
					end

					add_clock(dstName, type, duration, cooldown, 0);
					return;

				else -- if (orginame ~= dstName)
					-- we don't know anything about this user since it's not our target. Start a
					-- clock with a generic trinket timer just to be safe.
					-- assume it's a trinket
					cooldown=.01; 
					duration=30;
					type="Dim returns?";
					add_clock(dstName, type, duration, cooldown, 0);
					return;

				end -- if (origname == dstName)
			
			else -- if (spellname is a known fear name)
				ICmsg("Not an Immunity Event");
			end -- if (spellname is a known fear name)

		end	-- if (string.find(ttype))	
		return;

	else
		-- unknown entry
		return;
	end

	-- Display the counter. 
end

--******************************************************************************************************
-- OnUpdate is called apparently everytime a new Frame is drawn, according to 
--	the sources on the web. arg1 = number of seconds since last time OnUpdate was called.

-- This function is responsible for updating the clock window and shutting it off when the
--	cooldown expires.

function ImmunityClockFrame_OnUpdate(arg1)
	local icou_name;
	local level;
	local m;
	local o;
	local p;

	if (ICicon == 0) then
		return;
	end

	IConesec=IConesec+arg1;	-- allow screen writes no more than 1 per second.
	icou_name=UnitName("target");

	m=1;
	while (m <= ICMAXINDEX) do
		-- Immunity values: 0=none detected; 1=Immunity detected; 2=ICcooldown period
		if (ICtarget[m].immune == 0) then
			-- this target does not have active immunity. If this is the currently selected target, the
			-- sure the TargetFrame got turned off.
			if (ICtarget[m].name == icou_name) then
				ImmunityClockTargetFrame:Hide();
			end

		elseif (ICtarget[m].immune == 1) then
			--Immunity has been detected on this unit.
			if (arg1 + ICtarget[m].timer < ICtarget[m].duration) then	
				-- The length of time since we detected Immunity is less than expected duration. Update the
				-- the counter and display the new value 
				if (IConesec >= .1) then
					ICtarget[m].display:SetText(format("|cffff0000 "..ICtarget[m].name.." ("..ICtarget[m].type..") Immune %.1f / %d", ICtarget[m].duration-ICtarget[m].timer-arg1, ICtarget[m].duration));

					if (ICtarget[m].name == icou_name ) then
						-- The target frame should already be shown. But, just in case...
						ImmunityClockTargetFrame:Show();
						ImmunityClockTargetText:SetText(format("IMMUNITY %.1f / %d", ICtarget[m].duration-ICtarget[m].timer-arg1, ICtarget[m].duration));
					end
				end

				ICtarget[m].timer=ICtarget[m].timer + arg1;
			else
				-- the Immunity has now lasted longer than the expected duration. Transistion to ICcooldown.
				ICtarget[m].timer=0;
				ICtarget[m].immune=2;
			end

		elseif (ICtarget[m].immune == 2) then
			--ICcooldown period has been detected
			if (arg1 + ICtarget[m].timer < ICtarget[m].cooldown) then
				-- The length of time since we detected Immunity stopped is less than the ICcooldown. Update the
				-- the counter and display the new value 
				if (IConesec >= .1) then
					ICtarget[m].display:SetText(format("|c0000ff00 "..ICtarget[m].name.." ("..ICtarget[m].type..") Cooling %.1f / %d",ICtarget[m].cooldown-ICtarget[m].timer-arg1, ICtarget[m].cooldown ));
					if (ICtarget[m].name == icou_name ) then
						-- the target frame should already be shown. But, just in case...
						ImmunityClockTargetFrame:Show();
						ImmunityClockTargetText:SetText(format("Cooldown %.1f / %d", ICtarget[m].cooldown-ICtarget[m].timer-arg1, ICtarget[m].cooldown));
					end
				end
				ICtarget[m].timer=ICtarget[m].timer + arg1;
			else
				-- the ICcooldown has now loasted longer than the expected duration. Clear everything.
				ICmsg(format("hiding slot "..m));
				if (ICtarget[m].name == icou_name ) then
					ImmunityClockTargetFrame:Hide();
				end
				ImmunityClockWindowFrame:SetHeight(ImmunityClockWindowFrame:GetHeight() - 13);
				ICtarget[m].display:SetText(" ");

				ICtarget[m].display="none";
				ICtarget[m].timer=0;
				ICtarget[m].immune=0;
				ICtarget[m].duration=0;
				ICtarget[m].cooldown=0;
				ICtarget[m].level=0;
				ICtarget[m].name="none";
				ICtarget[m].type="none";
				ICtarget[m].race="none";
			end
		else
			--unknown/bad ICimmunity value
			ICmsg(format("IC OnUpdate(): "..ICtarget[m].name.."has bad immunity value"));
		end

		m=m+1;

	end -- while (m <= ICMAXINDEX)

	-- condense the display as names fall off so there aren't holes.
	o=1;
	p=1
	while (o <= ICMAXINDEX) do
		if (ICtarget[o].display ~= "none") then
			ICtarget[p].display=ICtarget[o].display;
			ICtarget[p].timer=ICtarget[o].timer;
			ICtarget[p].immune=ICtarget[o].immune;
			ICtarget[p].duration=ICtarget[o].duration;
			ICtarget[p].cooldown=ICtarget[o].cooldown;
			ICtarget[p].level=ICtarget[o].level;
			ICtarget[p].name=ICtarget[o].name;
			ICtarget[p].type=ICtarget[o].type;
			ICtarget[p].race=ICtarget[o].race;
			
			if (o ~= p) then
				ICtarget[o].display ="none";
				ICtarget[o].timer=0;
				ICtarget[o].immune=0;
				ICtarget[o].duration=0;
				ICtarget[o].cooldown=0;
				ICtarget[o].level=0;
				ICtarget[o].name="none";
				ICtarget[o].type="none";
				ICtarget[o].race="none";
			end
			p=p+1
		end
		o = o + 1;
	end
	ICindex=p-1; -- ICindex always points to the last used slot.
	o = 1;
	p = 1;
	while (o <= ICMAXINDEX) do
		if (ICtarget[o].display ~= "none") then
			disp_ptr = getglobal("ImmunityClockWindowText"..p);
			text = ICtarget[o].display:GetText();
			ICtarget[o].display:SetText(" ");
			ICtarget[o].display=disp_ptr;
			ICtarget[o].display:SetText(text);
			p = p + 1;
		end
		o = o + 1;
	end

	-- if there's nobody being tracked, hide the window
	if (p == 1) then
		ImmunityClockWindowFrame:Hide()
	end

	-- allow screen writes no more than 1 per second
	if (IConesec >= .1) then
		IConesec=0;
	end
end