--[[
	qAHImproved by Quel
	12/8/06 v1.0
--]]
AHIMP_STRING_PRICEEACH="Price Each";
AHImpData = {};
AHDuration = nil;

--**********************************************************
function AHImpFrame_OnLoad()
	this:RegisterEvent("AUCTION_HOUSE_SHOW");
	this:RegisterEvent("AUCTION_HOUSE_CLOSED");
ChatFrame1:AddMessage("I'm Loaded");
end

function AHImpFrame_OnEvent(event_name, arg01, arg02)
	if (event_name == "AUCTION_HOUSE_SHOW") then
		AHImpFrame_SetupFrames();
	elseif (event_name == "AUCTION_HOUSE_CLOSED") then
		AHImpFrame_Exit();
	end
end

-- called when the orig Auc start button OnEvent handler fires.
function AHImpFrame_EventOverride()
	AHImpFrame_OrigOnEvent();
	if (event ~= "NEW_AUCTION_UPDATE") then
		return;
	end
	-- put up our previously stored price
	local name, texture, count, quality, canUse, price = GetAuctionSellItemInfo();
	if (AHImpData[name] ~= nil) then
		MoneyInputFrame_SetCopper(StartPrice, floor(AHImpData[name].bid * count));
		MoneyInputFrame_SetCopper(BuyoutPrice, floor(AHImpData[name].buyout * count));
	end
end

-- override StartAuction so I can intercept the price info before the auction goes up
function AHImpFrame_StartAuction(bid_price, buyout_price, duration)
	local name, texture, count, quality, canUse, price = GetAuctionSellItemInfo();
	if (AHImpData[name] == nil) then
		AHImpData[name] = {};
	end
	AHImpData[name].bid = bid_price / count;
	AHImpData[name].buyout = buyout_price / count;
	AHImpFrame_OrigStartAuction(bid_price, buyout_price, duration);
end

-- On exit, save the last duration the user entered and cleanup the overrides
function AHImpFrame_Exit()
	-- save the duration they specified as the new default and put back the StartAuction function
	AHDuration = AuctionFrameAuctions.duration;
	StartAuction = AHImpFrame_OrigStartAuction;
	AuctionSellItemButton_OnEvent = AHImpFrame_OrigOnEvent;
end

-- Called by OnEvent(), configures the default duration, function overrides, and AH frame overrides
function AHImpFrame_SetupFrames()
	local i;
	-- configure the override we need to capture pricing info
	AHImpFrame_OrigStartAuction = StartAuction;
	StartAuction = AHImpFrame_StartAuction;

	AHImpFrame_OrigOnEvent = AuctionSellItemButton_OnEvent;
	AuctionSellItemButton_OnEvent = AHImpFrame_EventOverride;

	-- set the default auction time
	if (AHDuration) then
		AuctionFrameAuctions.duration = AHDuration;
		if (AHDuration == 1440) then
			AuctionsLongAuctionButton:SetChecked(1);
			AuctionsMediumAuctionButton:SetChecked(0);
			AuctionsShortAuctionButton:SetChecked(0);
		elseif (AHDuration == 480) then
			AuctionsLongAuctionButton:SetChecked(0);
			AuctionsMediumAuctionButton:SetChecked(1);
			AuctionsShortAuctionButton:SetChecked(0);
		else
			AuctionsLongAuctionButton:SetChecked(0);
			AuctionsMediumAuctionButton:SetChecked(0);
			AuctionsShortAuctionButton:SetChecked(1);
		end
	end
	-- the default UI hard codes the AH elements. Resize the AH frame, redefine the anchor points so the elements move accordingly.
	-- the main overall AH frame
	AuctionFrame:SetWidth(970);	
	AuctionFrame:EnableMouse(true);
	AuctionFrame:SetMovable(true);
	AuctionFrame:SetScript("OnMouseDown",function() this:StartMoving() end);
	AuctionFrame:SetScript("OnMouseUp",function()this:StopMovingOrSizing() end);

	-- the artwork that covers the frame comes in 6 parts: topleft, top, topright, botleft, bot, and botright
	AuctionFrameTopRight:ClearAllPoints();
	AuctionFrameTopRight:SetPoint("TopRight","AuctionFrame","TopRight");
	AuctionFrameTop:ClearAllPoints();
	AuctionFrameTop:SetPoint("TopLeft","AuctionFrameTopLeft","TopRight");
	AuctionFrameTop:SetPoint("TopRight","AuctionFrameTopRight","TopLeft");
		
	AuctionFrameBotRight:ClearAllPoints();
	AuctionFrameBotRight:SetPoint("Top","AuctionFrameTopRight","Bottom");
	AuctionFrameBot:ClearAllPoints();
	AuctionFrameBot:SetPoint("BottomLeft","AuctionFrameBotLeft","BottomRight");
	AuctionFrameBot:SetPoint("BottomRight","AuctionFrameBotRight","BottomLeft");

	-- sub frame, many items anchored to it
	AuctionFrameBrowse:SetPoint("BottomRight","AuctionFrame","BottomRight", -39, 0);
	BrowseScrollFrame:ClearAllPoints();
	BrowseScrollFrame:SetPoint("TopRight","AuctionFrameBrowse","TopRight",0,-105);

	-- The buttons on each page are anchored to each other, just need to move the close button for each tab
	BrowseCloseButton:ClearAllPoints();
	BrowseCloseButton:SetPoint("BottomRight","AuctionFrameBrowse","BottomRight",30,14);
	BidCloseButton:ClearAllPoints();
	BidCloseButton:SetPoint("BottomRight","AuctionFrameBrowse","BottomRight",30,14);
	AuctionsCloseButton:ClearAllPoints();
	AuctionsCloseButton:SetPoint("BottomRight","AuctionFrameBrowse","BottomRight",30,14);

	-- Add buttons to sort by buyout price or per item price. Shrink the existing "bid sort" button to make room.
	BrowseCurrentBidSort:SetPoint("BottomLeft","BrowseHighBidderSort","TopRight",-2,-6);
	BrowseCurrentBidSort:SetHeight(14);
	BrowseCurrentBidSortLeft:SetHeight(14);
	BrowseCurrentBidSortRight:SetHeight(14);
	BrowseCurrentBidSortMiddle:SetHeight(14);

	-- add our new BuyoutSort button below the BidSort button
	local button = CreateFrame("Button","BrowseBuyoutSort",AuctionFrameBrowse,"AuctionSortButtonTemplate");
	button:SetText(BUYOUT_PRICE);
	button:SetPoint("TopLeft","BrowseCurrentBidSort","BottomLeft",0,1);
	button:SetPoint("TopRight","BrowseCurrentBidSort","BottomRight",0,1);
	button:SetHeight(14);
	getglobal(button:GetName().."Left"):SetHeight(14);
	getglobal(button:GetName().."Right"):SetHeight(14);
	getglobal(button:GetName().."Middle"):SetHeight(14);

	button:SetScript("OnClick",
		function()
			SortAuctionItems("list", "buyout");
	          SortButton_UpdateArrow(BrowseBuyoutSort, "list", "buyout")
		end);
	button:Show();

	-- and a new column for showing the Price per each Item.
	local button = CreateFrame("Button","BrowsePriceEachBidSort",AuctionFrameBrowse,"AuctionSortButtonTemplate");
	button:SetText(AHIMP_STRING_PRICEEACH);
	button:SetPoint("BottomLeft","BrowseBuyoutSort","BottomRight",-2,0);
	button:SetWidth(90);
	button:SetHeight(19);
	button:SetScript("OnUpdate",AHImpFrame_PriceEach);
	button:Show();

	for i=1,8,1 do
		frame=CreateFrame("Frame","EachBidMoneyFrame"..i,AuctionFrameBrowse,"SmallMoneyFrameTemplate");
		frame2=CreateFrame("Frame","EachBuyoutMoneyFrame"..i,AuctionFrameBrowse,"SmallMoneyFrameTemplate");
		frame:SetPoint("TopRight",getglobal("BrowseButton"..i):GetName(),"TopRight",130,0);
		frame2:SetPoint("TopRight",frame:GetName(),"BottomRight",0,0);
		frame:SetID(i);
		frame2:SetID(i);
		MoneyFrame_Update(frame:GetName(),0);
		MoneyFrame_Update(frame2:GetName(),0);
		frame.info.fixedWidth = true;
		frame2.info.fixedWidth = true;
		frame:Hide();
		frame2:Hide();
	end

	-- do they use Auctioneer?
	if (AuctionFrameSearchCloseButton) then
		AuctionFrameSearchCloseButton:ClearAllPoints();
		AuctionFrameSearchCloseButton:SetPoint("BottomRight","AuctionFrameBrowse","BottomRight",30,14);
		AuctionFramePostCloseButton:ClearAllPoints();
		AuctionFramePostCloseButton:SetPoint("BottomRight","AuctionFrameBrowse","BottomRight",30,14);

		AuctionFrameSearch:SetPoint("BottomRight","AuctionFrameBrowse","BottomRight",0,38);
		AuctionFrameSearchList:SetPoint("BottomRight","AuctionFrameSearch","BottomRight");
		AuctionFramePost:SetPoint("BottomRight","AuctionFrameBrowse","BottomRight",0,38);
		AuctionFramePostList:SetPoint("BottomRight","AuctionFramePost","BottomRight");

		AuctionFramePostCreateAuctionButton:ClearAllPoints();
		AuctionFramePostCreateAuctionButton:SetPoint("BottomLeft","AuctionFramePost","BottomLeft",40,6);

		AuctionFramePostScanButton:ClearAllPoints();
		AuctionFramePostScanButton:SetPoint("BottomLeft","AuctionFramePost","BottomLeft",187,-24);
	end
end

-- Caclulates the price per item and displays the info
function AHImpFrame_PriceEach()
	local name, count, bid, minBid, buyoutPrice, bidAmount, i;
	local offset = FauxScrollFrame_GetOffset(BrowseScrollFrame);

	-- Trap for, and prevent, filters from doing anything while KCI is scanning.
	if (KC_ItemsAuction and KC_ItemsAuction.scanning) then
		return;
	end

	for i=1,8,1 do
		name, _, count, _, _, _, minBid, _, buyoutPrice, bidAmount, _, _ = GetAuctionItemInfo("list", offset + i);
		if (bidAmount ~= 0) then
			bid = bidAmount;
		else
			bid = minBid;
		end

		if (count > 1) then
			if (buyoutPrice ~= 0) then
				if (getglobal("BrowseButton"..i):IsVisible()) then
					getglobal("EachBuyoutMoneyFrame"..i):Show();
				end
				MoneyFrame_Update( getglobal("EachBuyoutMoneyFrame"..i):GetName(), floor(buyoutPrice / count));
			end
			MoneyFrame_Update( getglobal("EachBidMoneyFrame"..i):GetName(), floor(bid / count));
			if (getglobal("BrowseButton"..i):IsVisible()) then
				getglobal("EachBidMoneyFrame"..i):Show();
			end
		else
			getglobal("EachBuyoutMoneyFrame"..i):Hide();
			getglobal("EachBidMoneyFrame"..i):Hide();
		end
	end
end

--[[
Some reference code from earlier AH mods.

qg, qs, qc = AHImpFrame_ConvertMoney(buyoutPrice/count);
qg = NORMAL_FONT_COLOR_CODE .. qg .. "g " .. FONT_COLOR_CODE_CLOSE;
qs = AHImpFrame_GetHex(0.8,0.8,0.8) .. qs .. "s " .. FONT_COLOR_CODE_CLOSE;
qc = AHImpFrame_GetHex(0.8,0.5,0.4) .. qc .. "c " .. FONT_COLOR_CODE_CLOSE;
ChatFrame1:AddMessage("name: " .. name .. ", BO priceEach: " .. qg .. qs .. qc);

--courtesy EnhTooltip:
function AHImpFrame_ConvertMoney(copper)
	if (copper == nil) then copper = 0; end
	local g = math.floor(copper / 10000);
	local s = math.floor((copper - (g*10000)) / 100);
	local c = math.floor(copper - (g*10000) - (s*100));
	return g,s,c;
end

--courtesy watchdog:
function AHImpFrame_GetHex(r,g,b)
	return string.format("|cFF%02X%02X%02X", (255*r), (255*g), (255*b))
end
--]]
