
-- local upvalues
local select = select
local UnitClass = UnitClass
local UnitIsDead = UnitIsDead
local UnitIsGhost = UnitIsGhost
local UnitIsPlayer = UnitIsPlayer
local UnitReaction = UnitReaction
local UnitIsConnected = UnitIsConnected

local print = function(a) ChatFrame1:AddMessage("|cff33ff99oUF:|r "..tostring(a)) end

local wotlk = select(4, GetBuildInfo()) >= 3e4

local playerClass = select(2, UnitClass("player")) -- combopoints for druid/rogue

local font, fontHeight = "Interface\\AddOns\\oUF_sb\\media\\barframes.ttf", 11
--local font, fontHeight = "Interface\\AddOns\\oUF_sb\\media\\Russel Square LT.ttf", 9

local backdrop = {
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 16,
		insets = {left = -1.5, right = -1.5, top = -1.5, bottom = -1.5},
	}
local statusbartexture = "Interface\\AddOns\\oUF_sb\\media\\statusbar"
local bordertexture = "Interface\\AddOns\\oUF_sb\\media\\border"
local druidmanabartexture = "Interface\\AddOns\\oUF_sb\\media\\statusbar"

local LibMobHealth, LibDruidMana
if LibStub then LibMobHealth = LibStub("LibMobHealth-4.0", true) end
if LibStub then LibDruidMana = LibStub("LibDruidMana-1.0", true) end	
	

-- local colors = setmetatable({
	-- power = setmetatable({
		-- [0] = oUF.colors.power["MANA"],
		-- [1] = oUF.colors.power["RAGE"],
		-- [3] = oUF.colors.power["ENERGY"],
		-- [6] = oUF.colors.power["RUNIC_POWER"]
	-- }, {__index = oUF.colors.power}),},
-- {__index = oUF.colors})

-- colors.power[0] = colors.power.MANA
-- colors.power[1] = colors.power.RAGE
-- colors.power[3] = colors.power.ENERGY
-- colors.power[6] = colors.power.RUNIC_POWER

-- colors.power[0] = colors.power.MANA
-- colors.power[1] = colors.power.RAGE
-- colors.power[3] = colors.power.ENERGY
-- colors.power[6] = colors.power.RUNIC_POWER


local sbColors = {
	green = { r = 0, g = 1, b = 0 },
	gray = { r = 0.5, g = 0.5, b = 0.5 },
	white = { r = 1, g = 1, b = 1},
	unknown = { r = .41, g = .95, b = .2 },
}

local barFormatMinMax = "%d/%d"
local barFormatPerc = "%d%%"
local barFormatPercMinMax = barFormatPerc.." "..barFormatMinMax
local barFormatDeficit = "|cffff8080%d|r"
local barFormatMinMaxDef = "%d/%d |cffff8080%d|r"

local function fmt_standard(txt, min, max)
	txt:SetFormattedText(barFormatMinMax, min, max)
end

local function fmt_perc(txt, min, max)
	local perc = floor(min/max*100)
	txt:SetFormattedText(barFormatPerc,perc)
end

local function fmt_full(txt, min, max)
	local deficit = min - max
	if deficit == 0 then
		txt:SetFormattedText(barFormatMinMax, min, max )
	else
		txt:SetFormattedText(barFormatMinMaxDef, min, max, deficit)
	end
end

local function fmt_deficit(txt, min, max)
	local deficit = min - max
	if deficit < 0 then
		txt:SetFormattedText(barFormatDeficit, deficit)
	else
		txt:SetText(max)
	end
end

local function fmt_percminmax(txt, min, max)
	local perc = floor(min/max*100)
	txt:SetFormattedText(barFormatPercMinMax, perc, min, max)
end

local fmtmeta = { __index = 
	function(self, key)
		if type(key) == "nil" then return nil end
		if not rawget(self, key) then
			rawset(self, key, fmt_standard)
			return self[key]
		end
	end
}

local formats = setmetatable({}, { __index = 
	function(self, key)
		if type(key) == "nil" then return nil end
		if not rawget(self, key) then
			if key:find("raidpet%d") then self[key] = self.raidpet
			elseif key:find("raidtarget%d") then self[key] = self.raidtarget
			elseif key:find("raid%d") then self[key] = self.raid
			elseif key:find("party6%d") then self[key] = self.partypet
			elseif key:find("party%dtarget") then self[key] = self.partytarget
			elseif key:find("party%d") then self[key] = self.party
			else
				self[key] = {}
			end
		end
		return self[key]
	end,
	__newindex = function(self, key, value)
		rawset(self, key, setmetatable(value, fmtmeta))
	end,
})

--[[ 
	Formatting for the hp and mana texts go here!
	Anything non-existant is handled through metatable magic
	and will default to min/max
	
	the format is:
	
	formats.[unit].[health or power] = formattingfunction
	
	group units like party raid partypet raidpet partytarget raidtarget 
	are done like:
	formats.raidpet.health = fmt_deficit
	
	To call the format from your updateHealth:
	formats[unit]["health"](bar.value, min, max)
	
]]--

formats.player.health = fmt_full
formats.pet.health = fmt_full
formats.party.health = fmt_full

formats.target.health = fmt_percminmax
formats.target.power = fmt_percminmax

formats.focus.health = fmt_percminmax
formats.focus.power = fmt_percminmax

formats.partypet.health = fmt_deficit
formats.partytarget.health = fmt_perc

formats.targettarget.health = fmt_percminmax
--formats.targettarget.health = fmt_deficit
formats.targettarget.power = fmt_perc

formats.focustarget.health = fmt_deficit
formats.focustarget.power = fmt_perc

local classificationFormats = {
	worldboss = '|cffD7BEA5Boss|r',
	rareelite = '|cffD7BEA5%s+ Rare|r',
	elite = '|cffD7BEA5%s+|r',
	rare = '|cffD7BEA5%s Rare|r',
	normal = '|cffD7BEA5%s|r',
	trivial = '|cffD7BEA5%s|r',
}

local getDifficultyColor = function(level)
	if tonumber(level) ~= nil then
		local levelDiff = level - UnitLevel("player")
		if levelDiff >= 5 then
			return 1.00, 0.10, 0.10
		elseif levelDiff >= 3 then
			return 1.00, 0.50,0.25
		elseif levelDiff >= -2 then
			return 1.00, 1.00, 1.00
		elseif -levelDiff <= GetQuestGreenRange() then
			return 0.25, 0.75, 0.25
		end
		return 0.50, 0.50, 0.50
	end
end

-- This is the core of RightClick menus on diffrent frames
local menu = function(self)
	local unit = self.unit:sub(1, -2)
	local cunit = self.unit:gsub("(.)", string.upper, 1)

	if(unit == "party" or unit == "partypet") then
		ToggleDropDownMenu(1, nil, _G["PartyMemberFrame"..self.id.."DropDown"], "cursor", 0, 0)
	elseif(_G[cunit.."FrameDropDown"]) then
		ToggleDropDownMenu(1, nil, _G[cunit.."FrameDropDown"], "cursor", 0, 0)
	end
end

local function OverrideUpdateName(self, event, unit)
	if(self.unit == unit) then
		self.Name:SetTextColor(sbColors.white.r, sbColors.white.g, sbColors.white.b)

		local uName = UnitName(unit)
				
		-- name unknow pets just "pet"
		if (unit == 'pet' and uName == 'Unknown') then 
			uName = 'Pet'
		end
		if self.Class then
			if UnitIsPlayer(unit)  then	
				self.Class:SetText(UnitClass(unit))
			else
				self.Class:SetText(UnitCreatureFamily(unit) or UnitCreatureType(unit))
			end		
		end
		if string.len(uName) > 20 then
			self.Name:SetFormattedText('%s...', uName:sub(1, 20))
		else
			self.Name:SetText(uName)
		end
		
		if(self.Lvl) then	
			local lvl = self.Lvl
			local level = UnitLevel(unit)
			local classification = UnitClassification(unit)

			if (level == -1) then
				level = "??"
			end
			
			if classificationFormats[classification] then
				lvl:SetFormattedText(classificationFormats[classification], level)
			else			
				lvl:SetText(level)
			end
			if UnitCanAttack("player", unit) then
				lvl:SetTextColor(getDifficultyColor(level))
			else
				lvl:SetTextColor(1, 1, 1)
			end
		end
	
		if self.Race then
			self.Race:SetText(UnitRace(unit))
		end	
	
	end
end

local function PostUpdateHealth(self, event, unit, bar, min, max)

	local LibMobHealth
	if LibStub then LibMobHealth = LibStub('LibMobHealth-4.0', true) end
	local cur, maxhp
		if LibMobHealth then
			cur, maxhp = LibMobHealth:GetUnitHealth(unit)
			maxhp, hpknown = LibMobHealth:GetUnitMaxHP(unit)
		else
			cur, maxhp = min, max
		end
	if(max ~= 0) then
		r, g, b = self.ColorGradient(min/max, .69,.31,.31, .65,.63,.35, .33,.59,.33)
	end
	
	--local color = colors.class[UnitPowerType(unit)]

	if UnitIsDead(unit) then
		bar:SetValue(0)
		bar.value:SetText("Dead")
	elseif UnitIsGhost(unit) then
		bar:SetValue(0)
		bar.value:SetText("Ghost")	
	elseif not UnitIsConnected(unit) then
		bar:SetValue(0)
		bar.value:SetText("Offline")
	else
		formats[unit].health(bar.value, cur, maxhp)
	end
	
	local color
	
	if unit == "pet" then
		--local num, str = UnitPowerType(unit)
		color = self.colors.happiness[GetPetHappiness()] or self.colors.health --self.colors.power[UnitPowerType(unit)]
		--print(unit.." - "..UnitPowerType(unit))
	elseif UnitIsPlayer(unit) then
		color = self.colors.class[select(2, UnitClass(unit))]		
		--print(unit.." - "..color[1])
		--color[1], color[2], color[2] = self.ColorGradient(min/max, color[1], color[2], color[3], 0, 0, 0)
	elseif UnitIsTapped(unit) and not UnitIsTappedByPlayer(unit) and not UnitIsPlayer(unit) then
		color = sbColors.gray
		
		--@TODO: unpack needed?
		color = unpack(self.colors.tapped)
	else
		color = self.colors.reaction[UnitReaction(unit, 'player')] or self.colors.health
	end	
	
	if not color then 
		color = sbColors.unknown
	end	
	
	if(UnitIsDead(unit) or UnitIsGhost(unit) or not UnitIsConnected(unit)) then
		--@TODO: unpack needed?
		color = unpack(self.colors.disconnected)
		bar:SetStatusBarColor(.31*.25, .45*.25, .63*.25)
		bar.bg:SetVertexColor(.31*.25, .45*.25, .63*.25)
	else
		bar:SetStatusBarColor(color[1], color[2], color[3])
		bar.bg:SetTexture(color[1], color[2], color[3], .25)		
	end
	
	self:UNIT_NAME_UPDATE(event, unit)
end

local function PostUpdatePower(self, event, unit, bar, min, max)

	if max == 0 or UnitIsDead(unit) or UnitIsGhost(unit) or not UnitIsConnected(unit) then
		bar:SetValue(0)
		if bar.value then
			bar.value:SetText()
		end
	elseif bar.value then
		formats[unit].power(bar.value, min, max)
	end

	--fix coloring issues TODO: CHECK RESULTS
	local num, str = UnitPowerType(unit)
	local color = self.colors.power[select(4, GetBuildInfo()) >= 3e4 and str or num]	
	--local color = colors.power[UnitPowerType(unit)]
	
	if not color then 
		color = sbColors.white
	end	

	bar:SetStatusBarColor(color[1], color[2], color[3])
	bar.bg:SetTexture(color[1], color[2], color[3], .25)
	
	if not color then 
		color = sbColors.white
	end	
	
	--print(UnitPowerType(unit))
	
	
	if color then
		bar:SetStatusBarColor(color[1], color[2], color[3])
		bar.bg:SetTexture(color[1], color[2], color[3], .25)
	end
	
	self:UNIT_NAME_UPDATE(event, unit)
end

local function PostUpdateExperience(self, event, unit, bar, min, max)
	if(GetXPExhaustion()) then
		bar:SetStatusBarColor(.65,.33,.73) -- rested color
	else
		bar:SetStatusBarColor(.33,.59,.33) -- normal color
	end
end

local auraIcon = function(self, button)
	button.icon:SetTexCoord(.07, .93, .07, .93)

	local tex = button:CreateTexture(nil, "OVERLAY")
	tex:SetTexture(bordertexture)
	tex:SetAllPoints(button)

	if button.overlay then -- hide debuff overlay from oUF and set our own
		button.overlay:Hide()
		button.overlay = tex
	else
		tex:SetVertexColor(.25,.25,.35)
	end
end

local function PostCreateAuraIcon(self, button, icons, index, debuff)
	icons.showDebuffType = true
	button.cd:SetReverse()
	button.icon:SetTexCoord(.07, .93, .07, .93)
	button.count:SetPoint('BOTTOMRIGHT', button, 1, 0)
	button.count:SetTextColor(.84,.75,.65)
	button:SetScript('OnMouseUp', function(self, mouseButton)
		if mouseButton == 'RightButton' then
			local name, rank = UnitBuff('player', index)
			CancelPlayerBuff(name, rank)
		end
	end)

	local tex = button:CreateTexture(nil, "OVERLAY")
	tex:SetTexture(bordertexture)
	tex:SetAllPoints(button)	
end



local OnEnter = function(self)
	if not InCombatLockdown() then
		UnitFrame_OnEnter(self)
	end
end

local OnLeave = function(self)
	if not InCombatLockdown() then
		UnitFrame_OnLeave()
	end
end

local func = function(settings, self, unit)

	self.menu = menu -- Enable the menus

	self:SetScript("OnEnter", OnEnter)
	self:SetScript("OnLeave", OnLeave)

	self:RegisterForClicks"anyup"
	self:SetAttribute("*type2", "menu")

	local tiny = settings["sb-tiny"]
	local micro = settings["sb-micro"]
	local hidebuffs = settings["sb-hidebuffs"]
	
	-- Backgrounds
	self:SetBackdrop(backdrop)
	self:SetBackdropColor(0,0,0,1)

	-- Healthbar
	local hp = CreateFrame("StatusBar", nil, self)
	hp:SetHeight(tiny and 16 or 22) -- 16 height if we're dealing with tiny or micro frames
	hp:SetStatusBarTexture(statusbartexture)
	hp:SetPoint("TOPLEFT")
	hp:SetPoint("TOPRIGHT")

	-- Healthbar background
	local hpbg = hp:CreateTexture(nil, "BORDER")
	hpbg:SetAllPoints(hp)
	hpbg:SetTexture(.25,.25,.25)

	-- Healthbar text
	local hpp = hp:CreateFontString(nil, "OVERLAY")
	hpp:SetPoint("RIGHT", -2, -1)
	hpp:SetFont(font, fontHeight)
	hpp:SetShadowColor(0, 0, 0)
	hpp:SetShadowOffset(0.8, -0.8)
	hpp:SetTextColor(1,1,1)

	-- Call the functions
	hp.bg = hpbg
	hp.value = hpp
	self.Health = hp
	--self.OverrideUpdateHealth = updateHealth

	local icon = hp:CreateTexture(nil, "OVERLAY")
	icon:SetHeight(16)
	icon:SetWidth(16)
	icon:SetPoint("TOP", self, 0, 8)
	icon:SetTexture("Interface\\TargetingFrame\\UI-RaidTargetingIcons")
	self.RaidIcon = icon

	local name = hp:CreateFontString(nil, "OVERLAY")
	name:SetPoint("LEFT", 2, -1)
	--name:SetPoint("RIGHT", hpp, "LEFT")
	name:SetJustifyH("LEFT")
	name:SetFont(font, fontHeight)
	name:SetShadowColor(0, 0, 0)
	name:SetShadowOffset(0.8, -0.8)
	name:SetTextColor(1,1,1)
	self.Name = name
	--self.UNIT_NAME_UPDATE = updateName	
	
	local pp, ppbg, ppp
	if not micro then -- micro units don't have a powerbar at all
		-- Power Bar 
		pp = CreateFrame("StatusBar", nil, self)
		pp:SetHeight(tiny and 4 or 16)
		pp:SetStatusBarTexture(statusbartexture)
	
		-- pp:SetParent(self)
		pp:SetPoint("LEFT")
		pp:SetPoint("RIGHT")
		pp:SetPoint("TOP", hp, "BOTTOM", 0, -1.35)

		ppbg = pp:CreateTexture(nil, "BORDER")
		ppbg:SetAllPoints(pp)
		ppbg:SetTexture(.25,.25,.25)

		if not tiny then
			ppp = pp:CreateFontString(nil, "OVERLAY")
			ppp:SetPoint("RIGHT", -2, -1)
			ppp:SetFont(font, fontHeight)
			ppp:SetShadowColor(0, 0, 0)
			ppp:SetShadowOffset(0.8, -0.8)	
			ppp:SetTextColor(1,1,1)
			pp.value = ppp
		end
		pp.bg = ppbg
		self.Power = pp
		--self.OverrideUpdatePower = updatePower
	end

	if not tiny then -- anything larger than tiny has text on the powerbar
		local lvl, class, race
		lvl = pp:CreateFontString(nil, "OVERLAY")
		lvl:SetPoint("LEFT", pp, "LEFT", 2, 0)
		lvl:SetFont(font, fontHeight)
		lvl:SetShadowColor(0, 0, 0)
		lvl:SetShadowOffset(0.8, -0.8)	
		self.Lvl = lvl

		class = pp:CreateFontString(nil, "OVERLAY")
		class:SetPoint("LEFT", lvl, "RIGHT",  1, 0)
		class:SetFont(font, fontHeight)
		class:SetShadowColor(0, 0, 0)
		class:SetShadowOffset(0.8, -0.8)
		self.Class = class
	
		race = pp:CreateFontString(nil, "OVERLAY")
		race:SetPoint("LEFT", class, "RIGHT",  1, 0)
		race:SetFont(font, fontHeight)
		race:SetTextColor(1,1,1)
		race:SetShadowColor(0, 0, 0)
		race:SetShadowOffset(0.8, -0.8)	
		self.Race = race	
	end
	
	if unit == "player" then
		if LibDruidMana then
			local druid = hp:CreateFontString(nil, "OVERLAY")
			druid:SetFontObject(GameFontNormalSmall)
			druid:SetTextColor(1,1,1)
			druid:SetPoint("CENTER", pp)
			druidmanabartexture = druid
		end
	end
	
	
	local buffs
	
	local buffheight = 12 -- which happens to be the oUF default
	local buffwidth = settings["initial-width"]
	buffwidth = buffwidth - (buffwidth%16)
	
	if not hidebuffs then
		buffs = CreateFrame("Frame", nil, self)
		buffs.size = buffheight
		buffs:SetHeight(buffheight)
		buffs:SetWidth(buffwidth)
	end
		
	if not unit or unit == "player" then -- party or player gets a leader icon
		local leader = hp:CreateTexture(nil, "OVERLAY")
		leader:SetHeight(16)
		leader:SetWidth(16)
		leader:SetPoint("TOPLEFT", self, 0, 8)
		leader:SetTexture("Interface\\GroupFrame\\UI-Group-LeaderIcon")
		self.Leader = leader	
	end
	
	if not tiny then
		local state = hp:CreateTexture(nil, "OVERLAY")
		state:SetHeight(16)
		state:SetWidth(16)
		state:SetPoint("TOPLEFT", self, -13, -30)
		state:SetTexture("Interface\\CharacterFrame\\UI-StateIcon")
		state:SetTexCoord(0.57, 0.90, 0.08, 0.41)
		self.Combat = state
	end
	
	-- player, pet party and partypets get debuff highlighting
	if not unit or unit == "player" or unit == "pet" or unit:find("partypet%d") then
		self.DebuffHighlightBackdrop = true -- oUF_DebuffHighlight Support, using the backdrop
		self.DebuffHighlightFilter = true -- only show debuffs I can cure
	end
	
	--if not unit or not unit:find("party%dtarget") then -- party and anything but partytargets get cbft
		local cbft = hp:CreateFontString(nil, "OVERLAY")
		cbft:SetPoint("CENTER", self, "CENTER")
		cbft:SetFont(font, 16, "OUTLINE")
		self.CombatFeedbackText = cbft		
	--end
	
	
	if not hidebuffs and unit and not unit:find("party%dtarget") and not unit:find("partypet%d") then		
		local debuffs = CreateFrame("Frame", nil, self)
		debuffs.size = buffheight
		debuffs:SetHeight(buffheight)
		debuffs:SetWidth(buffwidth)
	
		debuffs:SetPoint("BOTTOMRIGHT", self, "TOPRIGHT",1.5,3)
		debuffs.initialAnchor = "BOTTOMRIGHT"
		debuffs["growth-y"] = "UP"
		debuffs["growth-x"] = "LEFT"
		debuffs.num = 40
		self.Debuffs = debuffs
			
		buffs:SetPoint("TOPLEFT", self, "BOTTOMLEFT",-1.5, -3)
		buffs.initialAnchor = "TOPLEFT"
		buffs["growth-y"] = "DOWN"
		buffs.num = 40
		self.Buffs = buffs	
	elseif not hidebuffs and not unit then -- this the party
		local debuffs = CreateFrame("Frame", nil, self)
		debuffs.size = buffheight
		debuffs:SetHeight(buffheight)
		debuffs:SetWidth(buffwidth)
	
		debuffs:SetPoint("BOTTOMRIGHT", self, "TOPRIGHT",1.5,3)
		debuffs.initialAnchor = "BOTTOMRIGHT"
		debuffs["growth-y"] = "UP"
		debuffs["growth-x"] = "LEFT"
		debuffs.num = 40
		self.Debuffs = debuffs	
	
	
		-- no debuffs on my party frames
		buffs:SetPoint("TOPLEFT", self, "BOTTOMLEFT",-1.5, -3)
		buffs.initialAnchor = "TOPLEFT"
		buffs["growth-y"] = "DOWN"
		buffs.num = floor(buffwidth/buffheight) -- one row of buffs
		buffs.filter = true
		self.Buffs = buffs			
	end
	
	if not unit or unit:find("partypet%d") then -- range on party and party pets
		self.Range = true 
		self.inRangeAlpha = 1.0
		self.outsideRangeAlpha = 0.6		
	end
	
	if unit=="target" and playerClass == "ROGUE" or playerClass == "DRUID" then
		local cpoints = self:CreateFontString(nil, "OVERLAY")
		cpoints:SetPoint("RIGHT", self, "LEFT", -9, 3)
		cpoints:SetFont(font, 38, "OUTLINE")
		cpoints:SetTextColor(1,1,1)
		cpoints:SetJustifyH("RIGHT")
		self.CPoints = cpoints
	end
	
	--self.PostCreateAuraIcon = auraIcon

	self.UNIT_NAME_UPDATE = OverrideUpdateName
	self.UNIT_HAPPINESS = OverrideUpdateName
	self.PostUpdateHealth = PostUpdateHealth
	self.PostUpdatePower = PostUpdatePower
	self.PostUpdateExperience = PostUpdateExperience
	self.PostCreateAuraIcon = PostCreateAuraIcon
	
	return self
end

oUF:RegisterStyle("sb", setmetatable({
	["initial-width"] = 200,
	["initial-height"] = 39,
}, {__call = func}))

oUF:RegisterStyle("sb_Small", setmetatable({
	["initial-width"] = 150,
	["initial-height"] = 39,
	["sb-small"] = true,
}, {__call = func}))

oUF:RegisterStyle("sb_Tiny", setmetatable({
	["initial-width"] = 125,
	["initial-height"] = 20,
	["sb-tiny"] = true,
}, {__call = func}))

oUF:RegisterStyle("sb_Micro", setmetatable({
	["initial-width"] = 125,
	["initial-height"] = 16,
	["sb-tiny"] = true,
	["sb-micro"] = true,
}, {__call=func}))

oUF:RegisterStyle("sb_OneLine", setmetatable({
	["initial-width"] = 175,
	["initial-height"] = 16,
	["sb-tiny"] = true,
	["sb-micro"] = true,
	["sb-hidebuffs"] = true,
}, {__call=func}))




oUF:SetActiveStyle("sb")
local player = oUF:Spawn("player", "oUF_Player")
player:SetPoint("TOPLEFT", UIParent, "TOPLEFT", 20, -70)

local target = oUF:Spawn("target", "oUF_Target")
target:SetPoint("LEFT", player, "RIGHT", 40, 0)

local focus = oUF:Spawn("focus", "oUF_Focus")
focus:SetPoint("TOPLEFT", UIParent, "TOPLEFT", 20, -600)

local party	= oUF:Spawn("header", "oUF_Party")
party:SetPoint("TOPLEFT", UIParent, "TOPLEFT", 20, -150)
party:SetAttribute("yOffset", -31)
party:SetAttribute("showParty", true)
party:Show()



oUF:SetActiveStyle("sb_Small")

local pet = oUF:Spawn("pet", "oUF_Pet")
pet:SetPoint("TOPLEFT", UIParent, "TOPLEFT", 20, -700)

local targetofpet = oUF:Spawn("pettarget", "oUF_Pettarget")
targetofpet:SetPoint("LEFT", pet, "RIGHT", 25, 0)

local tof = oUF:Spawn("focustarget", "oUF_Focustarget")
tof:SetPoint("LEFT", focus, "RIGHT", 25, 0)

oUF:SetActiveStyle("sb_OneLine")

local tot = oUF:Spawn("targettarget", "oUF_TargetTarget")
tot:SetPoint("TOPLEFT", target, "TOPRIGHT", 40, 0)

local totot = oUF:Spawn("targettargettarget", "oUF_TargetTargetTarget")
totot:SetPoint("TOP", tot, "BOTTOM", 0, -10)



oUF:SetActiveStyle("sb_Tiny")

-- The pet header is being a cunt, this is  better solution

local pets = {}
-- pets[1] = oUF:Spawn("partypet1", "oUF_PartyPet1")
-- pets[1]:SetPoint("TOPRIGHT", party, "TOPRIGHT", 0, -44)
-- for i =2, 4 do
	-- pets[i] = oUF:Spawn("partypet"..i, "oUF_PartyPet"..i)
	-- pets[i]:SetPoint("TOP", pets[i-1], "BOTTOM", 0, -50)
-- end

local pts = {}
-- pts[1] = oUF:Spawn("party1target", "oUF_Party1Target")
-- pts[1]:SetPoint("TOPLEFT", party, "TOPRIGHT", 5, 0)
-- for i =2, 4 do
	-- pts[i] = oUF:Spawn("party"..i.."target", "oUF_Party"..i.."Target")
	-- pts[i]:SetPoint("TOP", pts[i-1], "BOTTOM", 0, -50)
-- end

if LibDruidMana then
	LibDruidMana:AddListener(function(currMana, maxMana)
		if currMana ~= maxMana then
			local perc = floor(currMana/maxMana*100)
			druidmanabartexture:SetFormattedText("%d|cff0090ff%%|r", perc)
		else
			druidmanabartexture:SetText()
		end
	end)
end

local toggleParty = CreateFrame("Frame")
toggleParty:SetScript("OnEvent", function()
	if GetNumRaidMembers() > 0 then		
		party:SetAttribute("showParty", false)
		party:Hide()
		for i =1, 4 do
			--pets[i]:Hide()
			--pts[i]:Hide()
		end
	elseif GetNumPartyMembers() > 0 then
		party:SetAttribute("showParty", true)
		party:Show()
		for i =1, 4 do
			--pets[i]:Show()
			--pts[i]:Show()
		end
	end
end)
toggleParty:RegisterEvent("PARTY_MEMBERS_CHANGED")
toggleParty:RegisterEvent("PARTY_LEADER_CHANGED")
toggleParty:RegisterEvent("RAID_ROSTER_UPDATE")
toggleParty:RegisterEvent("PLAYER_LOGIN")