local tostring = tostring
local UnitName = UnitName
local pairs = pairs

local addon = CreateFrame("Frame")
local total = 0
local function onUpdate(self, elapsed)
	total = total + elapsed
	if total >= 1.5 then
		for _, f in pairs(oUF.objects) do
			if type(f) == "table" and f.ReadyCheck then
				f.ReadyCheck:Hide()
			end
		end
		total = 0
		self:SetScript("OnUpdate", nil)
	else
		local alpha = (1.5 - total) / 1.5
		for _, f in pairs(oUF.objects) do
			if type(f) == "table" and f.ReadyCheck then
				f.ReadyCheck:SetAlpha(alpha)
			end
		end
	end
end

addon:SetScript("OnEvent", function(self)
	self:SetScript("OnUpdate", onUpdate)
end)
addon:RegisterEvent("READY_CHECK_FINISHED")

function oUF:READY_CHECK(event, name)
	if not (IsRaidLeader() or IsRaidOfficer() or IsPartyLeader()) then return end
	if UnitName(self.unit) == name then
		self.ReadyCheck:SetTexture("Interface\\RAIDFRAME\\ReadyCheck-Ready")
	else
		self.ReadyCheck:SetTexture("Interface\\RAIDFRAME\\ReadyCheck-Waiting")
	end
	self.ReadyCheck:SetAlpha(1)
	self.ReadyCheck:Show()
end

function oUF:READY_CHECK_CONFIRM(event, index, status)
	if self.id ~= tostring(index) then return end
	if status and status == 1 then
		self.ReadyCheck:SetTexture("Interface\\RAIDFRAME\\ReadyCheck-Ready")
	else
		self.ReadyCheck:SetTexture("Interface\\RAIDFRAME\\ReadyCheck-NotReady")
	end
end

local function func(object)
	if not object.ReadyCheck then return end
	object:RegisterEvent("READY_CHECK")
	object:RegisterEvent("READY_CHECK_CONFIRM")
end

for _, object in pairs(oUF.objects) do func(object) end
oUF:RegisterInitCallback(func)

