do return end

local UnitName = UnitName
local GetTime = GetTime
local UnitCastingInfo = UnitCastingInfo
local UnitChannelInfo = UnitChannelInfo

function oUF:UNIT_SPELLCAST_START(event, unit, spell, spellrank)
	if self.unit ~= unit then return end
	if not self.SpellcastStart then 
		local name, rank, text, texture, startTime, endTime = UnitCastingInfo(unit)
		if not name then return end
			
		self.startTime = startTime / 1000
		self.maxValue = endTime / 1000
		self.delay = 0
		
		self.Castbar:SetMinMaxValues(1, 100)
		self.Castbar:SetValue(1)
		self.Castbar.text:SetText(text)
		self.Castbar:SetAlpha(1)
		self.Castbar.icon:SetTexture(texture)
		self.Castbar.icon:Show()
		if self.Castbar.safezone then
			self.Castbar.safezone:Show() 
		end
		if self.Castbar.casttime then
			self.Castbar.casttime:Show()
			self.Castbar.casttime:SetText()
		end
		self.Castbar:Show()
		self.casting = true
		if unit == "target" or unit:sub(1,4) == "raid" then self.unitName = UnitName(unit) end	
	else
		self:SpellcastStart(event, unit, spell, spellrank) 
	end
end

function oUF:UNIT_SPELLCAST_FAILED(event, unit, spellname, spellrank)
	if self.unit ~= unit then return end
	if not self.SpellcastFailed then 
		self.Castbar:SetValue(1)
		self.Castbar.text:SetText()
		self.Castbar.icon:Hide()
		if self.Castbar.safezone then self.Castbar.safezone:Hide() end
		if self.Castbar.casttime then self.Castbar.casttime:Hide() end
		self.Castbar:Hide()
		self.casting = nil
	else
		self:SpellcastFailed(event, unit, spellname, spellrank) 
	end
end

function oUF:UNIT_SPELLCAST_INTERRUPTED(event, unit, spellname, spellrank)
	if self.unit ~= unit then return end
	if not self.SpellcastInterrupted then 
		self.Castbar:SetValue(1)
		self.Castbar.text:SetText()
		self.Castbar.icon:Hide()
		if self.Castbar.safezone then self.Castbar.safezone:Hide() end
		if self.Castbar.casttime then self.Castbar.casttime:Hide() end
		self.Castbar:Hide()
		self.casting = nil
		self.channeling = nil
	else
		self:SpellcastInterrupted(event, unit, spellname, spellrank) 
	end
end
	
function oUF:UNIT_SPELLCAST_DELAYED(event, unit, spellname, spellrank)
	if self.unit ~= unit then return end
	if not self.SpellcastDelayed then 
		local name, rank, text, texture, startTime, endTime = UnitCastingInfo(unit)
		if not startTime then return end
		
		local oldStart = self.startTime
		self.startTime = startTime / 1000
		self.maxValue = endTime / 1000
		self.delay = self.delay + (self.startTime - oldStart)
	else
		self:SpellcastDelayed(event, unit, spellname, spellrank) 
	end
end

function oUF:UNIT_SPELLCAST_STOP(event, unit, spellname, spellrank)
	if self.unit ~= unit then return end
	if not self.Castbar.casting then return end
	if not self.SpellcastStop then
		self.Castbar:SetValue(1)
		self.Castbar.text:SetText()
		self.Castbar.icon:Hide()
		self.Castbar:Hide()
		if self.Castbar.safezone then self.Castbar.safezone:Hide() end
		if self.Castbar.casttime then self.Castbar.casttime:Hide() end
		self.casting = nil		
	else
		self:SpellcastStop(event, unit, spellname, spellrank)
	end
end

function oUF:UNIT_SPELLCAST_CHANNEL_START(event, unit, spellname, spellrank)
	if self.unit ~= unit then return end
	if not self.SpellcastChannelStart then 
		local name, rank, text, texture, startTime, endTime = UnitChannelInfo(unit)
		self.startTime = startTime / 1000
		self.endTime = endTime / 1000
		self.duration = self.endTime - self.startTime
		self.maxValue = self.startTime
		self.delay = 0
		self.Castbar:SetMinMaxValues(self.startTime, self.endTime)
		self.Castbar:SetValue(self.endTime)
		self.Castbar.text:SetText(name)
		self.Castbar.icon:SetTexture(texture)
		self.Castbar.icon:Show()
		if self.Castbar.casttime then 
			self.Castbar.casttime:SetText() 
			self.Castbar.casttime:Show() 
		end
		self.Castbar:Show()
		self.channeling = true
		if unit == "target" or unit:sub(1,4) == "raid" then self.unitName = UnitName(unit) end
	else
		self:SpellcastChannelStart(event, unit, spellname, spellrank) 
	end
end

function oUF:UNIT_SPELLCAST_CHANNEL_UPDATE(event, unit, spellname, spellrank)
	if self.unit ~= unit then return end
	if not self.SpellcastChannelUpdate then 
		local spell, _, _, _, startTime, endTime, oldStart = UnitChannelInfo(unit);
		local oldStart = self.startTime
		self.startTime = startTime / 1000
		self.endTime = endTime / 1000
		self.maxValue = self.startTime
		self.delay = self.delay + (oldStart - self.startTime)
	else
		self:SpellcastChannelUpdate(event, unit, spellname, spellrank) 
	end
end

function oUF:UNIT_SPELLCAST_CHANNEL_STOP(event, unit, spellname, spellrank)
	if self.unit ~= unit then return end
	if not self.SpellcastChannelStop then 
		self.Castbar:SetValue(1)
		self.Castbar.text:SetText()
		self.Castbar.icon:Hide()
		self.Castbar:Hide()
		if self.Castbar.casttime then self.Castbar.casttime:Hide() end
		self.channeling = nil
	else
		self:SpellcastChannelStop(event, unit, spellname, spellrank) 
	end
end

oUF.UNIT_SPELLCAST_CHANNEL_INTERRUPTED = oUF.UNIT_SPELLCAST_INTERRUPTED

local onUpdate = function(self, elapsed)
	self = self:GetParent()
	self.timeSinceLastUpdate = self.timeSinceLastUpdate + elapsed 	
	if self.timeSinceLastUpdate > (self.castbarRefreshRate or 0.05) then
		if not self.Update then 
			if self.unitName and self.unitName ~= UnitName(self.unit) then
				self.unitName = nil
				self.casting = nil
				self.channeling = nil
				self.Castbar:SetValue(1)
				self.Castbar.icon:Hide()
				self.Castbar:Hide()
				self.Castbar.text:SetText()
			end
			if self.casting then
				local status = GetTime()
				if (status >= self.maxValue) then
					self.casting = nil
					self.Castbar.icon:Hide()
					self.Castbar:Hide()
					self.Castbar.text:SetText()
					if self.Castbar.safezone then
						self.Castbar.safezone:Hide()
					end
					return
				end
				if self.Castbar.safezone then 
					local castTime = (self.maxValue - self.startTime) * 1000
					local safeZonePercent = ( (self:GetWidth() / castTime ) * select(3,GetNetStats()) );
					if safeZonePercent > 100 then safeZonePercent = 100 end
					self.Castbar.safezone:SetWidth((self:GetWidth() / 100) * safeZonePercent);
				end
				if self.Castbar.casttime then
					if self.delay ~= 0 then
						self.Castbar.casttime:SetText(("|cffff0000%.1f|r - %.1f/%.1f"):format(self.delay, self.maxValue - status, self.maxValue - self.startTime))
					else
						self.Castbar.casttime:SetText(("%.1f/%.1f"):format(self.maxValue - status, self.maxValue - self.startTime))
					end
				end
				self.Castbar:SetValue( ((status - self.startTime) / (self.maxValue - self.startTime)) * 100 )		
			elseif self.channeling then
				local status = GetTime()
				if ( status >= self.endTime ) then
					self.channeling = nil
					self.Castbar.icon:Hide()
					self.Castbar:Hide()
					self.Castbar.text:SetText()
					return
				end
				if self.Castbar.casttime then
					if self.delay ~= 0 then
						self.Castbar.casttime:SetText(("|cffff0000%.1f|r - %.1f/%.1f"):format(self.delay, self.endTime - status, self.endTime - self.startTime))
					else
						self.Castbar.casttime:SetText(("%.1f/%.1f"):format(self.endTime - status, self.endTime - self.startTime))
					end
				end
				self.Castbar:SetValue( self.startTime + (self.endTime - status) )
			end
		else
			self:Update(elapsed) 
		end
		self.timeSinceLastUpdate = 0;
	end
end

local PLAYER_TARGET_CHANGED = function(self)
	self = self:GetParent()
	self.Castbar:Hide()
	self.Castbar.icon:Hide()
	self.Castbar.text:SetText()

	local spell

	spell = UnitCastingInfo("target")

	if spell then
		self:UNIT_SPELLCAST_START(nil, "target")
		return
	end 
	
	spell = UnitChannelInfo("target")

	if spell then
		self:UNIT_SPELLCAST_CHANNEL_START(nil, "target")
	end
end

local onEvent = function(self, event, ...)
	if event == "PLAYER_TARGET_CHANGED" then
		PLAYER_TARGET_CHANGED(self) 
	end
end

local func = function(object)
	if not object.Castbar or not object.Castbar.text or not object.Castbar.icon or (object.unit and object.unit:match"%wtarget$") then return end	
	object:RegisterEvent"UNIT_SPELLCAST_START"
	object:RegisterEvent"UNIT_SPELLCAST_FAILED"
	object:RegisterEvent"UNIT_SPELLCAST_STOP"
	object:RegisterEvent"UNIT_SPELLCAST_INTERRUPTED"
	object:RegisterEvent"UNIT_SPELLCAST_DELAYED"
	object:RegisterEvent"UNIT_SPELLCAST_CHANNEL_START"
	object:RegisterEvent"UNIT_SPELLCAST_CHANNEL_UPDATE"
	object:RegisterEvent"UNIT_SPELLCAST_CHANNEL_INTERRUPTED"
	object:RegisterEvent"UNIT_SPELLCAST_CHANNEL_STOP"
	object.timeSinceLastUpdate = 0

	local frame = CreateFrame("Frame", nil, object)
	frame:SetScript("OnUpdate", onUpdate)
	frame:SetScript("OnEvent", onEvent)
	
	if object.unit == "target" then frame:RegisterEvent("PLAYER_TARGET_CHANGED") end

	if object.unit == "player" then
		CastingBarFrame:UnregisterAllEvents()
		CastingBarFrame.Show = function() end
		CastingBarFrame:Hide()
	end
end

for _, object in pairs(oUF.objects) do func(object) end
oUF:RegisterInitCallback(func)