--[[-------------------------------------------------------------------------
	Hello source reader! oUF_Amnith is based upon oUF_Lily by haste.
---------------------------------------------------------------------------]]

local select = select
local UnitIsPlayer = UnitIsPlayer
local UnitIsDead = UnitIsDead
local UnitIsGhost = UnitIsGhost
local UnitIsConnected = UnitIsConnected
local RAID_CLASS_COLORS = RAID_CLASS_COLORS
local UnitClass = UnitClass
local UnitReactionColor = UnitReactionColor
local UnitReaction = UnitReaction
local FONT = STANDARD_TEXT_FONT
local FONT_SIZE = 11
local strlen = string.len
local substr = string.sub
local ceil = math.ceil 
local menu = function(self)
	local unit = self.unit:sub(1, -2)
	local cunit = self.unit:gsub("(.)", string.upper, 1)

	if(unit == "party" or unit == "partypet") then
		ToggleDropDownMenu(1, nil, _G["PartyMemberFrame"..self.id.."DropDown"], "cursor", 0, 0)
	elseif(_G[cunit.."FrameDropDown"]) then
		ToggleDropDownMenu(1, nil, _G[cunit.."FrameDropDown"], "cursor", 0, 0)
	end
end

local siValue = function(val)
	if(val >= 1e5) then
		return ("%.1f"):format(val / 1e4):gsub('%.', 'm')
	elseif(val >= 1e4) then
		return ("%.1f"):format(val / 1e3):gsub('%.', 'k')
	else
		return val
	end
end

local updateName = function(self, event, unit)
	if(self.unit ~= unit) then return end
	self.Name:SetTextColor(1, 1, 1)
	self.Name:SetText(substr(UnitName(unit), 0, 4)) 
end

local updateHealth = function(self, event, unit, bar, min, max)
	if(self.unit ~= unit) then return end
	if(UnitIsDead(unit)) then
		bar:SetValue(0)
		bar.value:SetText"Dead"
	elseif(UnitIsGhost(unit)) then
		bar:SetValue(0)
		bar.value:SetText"Ghst"
	elseif(not UnitIsConnected(unit)) then
		bar.value:SetText"Offl"
	else
		bar.value:SetFormattedText("%d%%", min/max*100)
	end

	if(not UnitIsConnected(unit)) then
		bar:SetStatusBarColor(.6, .6, .6)
	else
		local color = self.colors.class[select(2, UnitClass(unit))]
		bar:SetStatusBarColor(color[1], color[2], color[3])
	end
end

local func = function(settings, self, unit)
	self.menu = menu

	self:EnableMouse(true)
	self:SetMovable(true)
	self:SetScript("OnEnter", function(self) UnitFrame_OnEnter(self) end)
	self:SetScript("OnLeave", function(self) UnitFrame_OnLeave(self) end)

	self:RegisterForClicks"anyup"
	self:SetAttribute("*type2", "menu")

	self:SetHeight(20)

	local hp = CreateFrame"StatusBar"
	hp:SetHeight(20)
	hp:SetStatusBarTexture"Interface\\AddOns\\oUF_AmnithRaid\\textures\\statusbar"
	hp:SetStatusBarColor(.25, .25, .35)

	hp:SetParent(self)
	hp:SetPoint"TOP"
	hp:SetPoint"LEFT"
	hp:SetPoint"RIGHT"

	local hpbg = hp:CreateTexture(nil, "BORDER")
	hpbg:SetAllPoints(hp)
	hpbg:SetTexture(0, 0, 0, .5)

	local hpp = hp:CreateFontString(nil, "OVERLAY")
	hpp:SetPoint("RIGHT", -2, 0)
	hpp:SetFont(FONT, FONT_SIZE)--, "OUTLINE")
	hpp:SetShadowOffset(1, -1)
	hpp:SetTextColor(1, 1, 1)
		
	hp.bg = hpbg
	hp.value = hpp
	self.Health = hp
	self.OverrideUpdateHealth = updateHealth

	local leader = hp:CreateTexture(nil, "OVERLAY")
	leader:SetHeight(16)
	leader:SetWidth(16)
	leader:SetPoint("CENTER", hp, "CENTER", 0, 10)
	leader:SetTexture"Interface\\GroupFrame\\UI-Group-LeaderIcon"
	self.Leader = leader

	local ricon = hp:CreateTexture(nil, "OVERLAY")
	ricon:SetHeight(16)
	ricon:SetWidth(16)
	ricon:SetPoint("LEFT", hp, "LEFT", -5, 10)
	ricon:SetTexture"Interface\\TargetingFrame\\UI-RaidTargetingIcons"
	self.RaidIcon = ricon

	local name = hp:CreateFontString(nil, "OVERLAY")
	name:SetPoint("LEFT", 2, 0)
	name:SetJustifyH"LEFT"
	name:SetFont(FONT, FONT_SIZE) --, "OUTLINE")
	name:SetShadowOffset(1, -1)
	name:SetTextColor(1, 1, 1)
	self.Name = name
	self.UNIT_NAME_UPDATE = updateName

	if(not unit) then
		self.Range = true 
		self.inRangeAlpha = 1.0
		self.outsideRangeAlpha = 0.5
	end

	return self
end

oUF:RegisterStyle("oUF_AmnithRaid", setmetatable({
	["initial-width"] = 80,
	["initial-height"] = 21,
}, {__call = func}))

oUF:SetActiveStyle"oUF_AmnithRaid"

local raid = {}
for i = 1, 8 do
	table.insert(raid, oUF:Spawn("header", "oUF_Raid"..i))
	if i == 1 then
		raid[i]:SetPoint("LEFT", UIParent, "LEFT", 30, 100)
	elseif i == 6 then
		raid[i]:SetPoint("LEFT", UIParent, "LEFT", 30, -20)
	else
		raid[i]:SetPoint("LEFT", raid[i-1], "RIGHT", 5, 0)		
	end
	raid[i]:SetManyAttributes("showRaid", true, "yOffset", 0, "groupFilter", i)
	raid[i]:Show()
end
