--[[-------------------------------------------------------------------------
	Hello source reader! oUF_Amnith is based upon oUF_Lily by haste.
---------------------------------------------------------------------------]]

local select = select
local UnitIsPlayer = UnitIsPlayer
local UnitIsDead = UnitIsDead
local UnitIsGhost = UnitIsGhost
local UnitIsConnected = UnitIsConnected
local RAID_CLASS_COLORS = RAID_CLASS_COLORS
local UnitClass = UnitClass
local UnitReactionColor = UnitReactionColor
local UnitReaction = UnitReaction
local FONT = STANDARD_TEXT_FONT
local FONT_SIZE = 11
local strlen = string.len
local substr = string.sub
local ceil = math.ceil 
local menu = function(self)
	local unit = self.unit:sub(1, -2)
	local cunit = self.unit:gsub("(.)", string.upper, 1)

	if(unit == "party" or unit == "partypet") then
		ToggleDropDownMenu(1, nil, _G["PartyMemberFrame"..self.id.."DropDown"], "cursor", 0, 0)
	elseif(_G[cunit.."FrameDropDown"]) then
		ToggleDropDownMenu(1, nil, _G[cunit.."FrameDropDown"], "cursor", 0, 0)
	end
end

local siValue = function(val)
	if(val >= 1e6) then	
		return ("%.2f"):format(val / 1e6):gsub('%.', 'm')
	elseif(val >= 1e4) then
		return ("%.1f"):format(val / 1e3):gsub('%.', 'k')
	else
		return val
	end
end

local updateName = function(self, event, unit)
	if(self.unit ~= unit) then return end
	local name = UnitName(unit)
	self.Name:SetTextColor(1, 1, 1)
	if strlen(name) > 15 then 
		name = substr(name, 0, 12) .. "..."
	end
	self.Name:SetText(name) 
end

local updateHealth = function(self, event, unit, bar, min, max)
	if(UnitIsDead(unit)) then
		bar:SetValue(0)
		bar.value:SetText"Dead"
	elseif(UnitIsGhost(unit)) then
		bar:SetValue(0)
		bar.value:SetText"Ghost"
	elseif(not UnitIsConnected(unit)) then
		bar.value:SetText"Offline"
	else
		if not UnitIsPlayer(unit) and UnitIsFriend("player", unit) then
			bar.value:SetFormattedText("%s", siValue(min))
		else
			bar.value:SetFormattedText("%s/%s", siValue(min), siValue(max))
		end
	end

	if(UnitIsTapped(unit) and not UnitIsTappedByPlayer(unit) or not UnitIsConnected(unit)) then
		bar:SetStatusBarColor(.6, .6, .6)
	else
		local t, r, g, b
		t = UnitIsPlayer(unit) and self.colors.class[select(2, UnitClass(unit))]
		if not t then
			if UnitPlayerControlled(unit) then 
				r, g, b = 0, 1, 0
			else
				r, g, b = UnitSelectionColor(unit)
			end
		else
			r, g, b = t[1], t[2], t[3]
		end
		bar:SetStatusBarColor(r, g, b) 
	end
end

local updatePower = function(self, event, unit, bar, min, max)
	if(max == 0) then
		bar.value:SetText()
	elseif(UnitIsDead(unit) or UnitIsGhost(unit)) then
		bar:SetValue(0)
	elseif(not UnitIsConnected(unit)) then
		bar.value:SetText()
	else
		bar.value:SetFormattedText("%d/%d ", min, max)
	end
	bar:SetStatusBarColor(.85, .85, .85)
end

local auraIcon = function(self, button)
	button.icon:SetTexCoord(.07, .93, .07, .93)
end

function PvPCheck(unit)
	local isfaction = false   
	isfaction = UnitFactionGroup(unit)   
	if isfaction and (UnitIsPVP(unit)) then   
		isfaction = faction   
	end 
end

local func = function(settings, self, unit)
	self.menu = menu


	self:EnableMouse(true)
	self:SetMovable(true)
	self:SetScript("OnEnter", function(self) UnitFrame_OnEnter(self) end)
	self:SetScript("OnLeave", function(self) UnitFrame_OnLeave(self) end)

	self:RegisterForClicks"anyup"
	self:SetAttribute("*type2", "menu")
	
	local hp = CreateFrame"StatusBar"
	if unit == "targettarget" or unit == "pet" then
		hp:SetHeight(20)
		self:SetHeight(20)
	else
		hp:SetHeight(25)
		self:SetHeight(40)
	end
	
	local pw = 0
	if unit ~= "targettarget" and unit ~= "pet" then 
		local portrait = CreateFrame("PlayerModel")
		portrait:SetParent(self)
		portrait:SetPoint("LEFT", self, "LEFT")
		portrait:SetBackdrop( { 
		  bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
		  edgeFile = "", tile = true, tileSize = 0, edgeSize = 0, 
		  insets = { left = 0, right = 0, top = 0, bottom = 0 }
		});
		portrait:SetBackdropColor(0, 0, 0, .5)
		portrait:SetHeight(40)
		portrait:SetWidth(40)
		pw = portrait:GetWidth()
		self.Portrait = portrait
	end

	hp:SetStatusBarTexture"Interface\\AddOns\\oUF_Amnith\\textures\\statusbar"
	hp:SetStatusBarColor(.25, .25, .35)

	hp:SetParent(self)
	hp:SetPoint"TOP"
	hp:SetPoint("LEFT", self, "LEFT", pw, 0)
	hp:SetPoint"RIGHT"
	
	local hpbg = hp:CreateTexture(nil, "BORDER")
	hpbg:SetAllPoints(hp)
	hpbg:SetTexture(0, 0, 0, .5)

	local hpp = hp:CreateFontString(nil, "OVERLAY")
	hpp:SetPoint("RIGHT", -2, 0)
	hpp:SetFont(FONT, FONT_SIZE)
	hpp:SetTextColor(1, 1, 1)
	hpp:SetShadowOffset(1, -1)		
	hp.bg = hpbg
	hp.value = hpp
	self.Health = hp
	self.OverrideUpdateHealth = updateHealth

	if unit ~= "pet" and unit ~= "targettarget" then 
		local pp = CreateFrame"StatusBar"
		pp:SetHeight(15)
		pp:SetStatusBarTexture"Interface\\AddOns\\oUF_Amnith\\textures\\statusbar"
		pp:SetStatusBarColor(.25, .25, .35)

		pp:SetParent(self)
		pp:SetPoint("LEFT", self, "LEFT", pw, 0)
		pp:SetPoint"RIGHT"
		pp:SetPoint("TOP", hp, "BOTTOM")

		local ppbg = pp:CreateTexture(nil, "BORDER")
		ppbg:SetAllPoints(pp)
		ppbg:SetTexture(0, 0, 0, .5)

		local ppp = pp:CreateFontString(nil, "OVERLAY")
		ppp:SetPoint("RIGHT", 1, 2) -- "LEFT", 0, 0)
		ppp:SetFont(FONT, FONT_SIZE)
		ppp:SetTextColor(1, 1, 1)
		ppp:SetShadowOffset(1, -1)
	
		pp.frequentUpdates = true
		pp.value = ppp
		pp.bg = ppbg
		self.Power = pp
		self.OverrideUpdatePower = updatePower

		local info = pp:CreateFontString(nil, "OVERLAY")
		info:SetPoint("LEFT", 2, 2)
		info:SetFont(FONT, FONT_SIZE)
		info:SetShadowOffset(1, -1)
		info:SetTextColor(1, 1, 1)
		info:SetJustifyH("LEFT")
		local inf = CreateFrame"Frame"
		inf:RegisterEvent"PLAYER_TARGET_CHANGED"
		inf:RegisterEvent"UNIT_LEVEL"
		inf:RegisterEvent"PARTY_MEMBERS_CHANGED"
		inf:RegisterEvent"RAID_ROSTER_UPDATE"
		inf:RegisterEvent"PLAYER_ENTERING_WORLD"
		inf:RegisterEvent"PLAYER_FOCUS_CHANGED"
		inf:RegisterEvent"UNIT_TARGET"
		inf:SetScript("OnEvent", function()
			local classification, level = "", ""
			if self.unit then 
				local c = UnitClassification(self.unit)
				if c == "worldboss" then 
					classification = "b"
				elseif c == "rareelite" then
					classification = "r+"
				elseif c == "rare" then
					classification = "r"
				elseif c == "elite" then 
					classification = "+"
				else
					classification = ""
				end
				
				level = UnitLevel(self.unit) or "??"
				if level == -1 then 
					level = "??"
				end
			end
			info:SetFormattedText("L%s%s", level, classification)
		end)
	end
	if unit ~= "targettarget" and unit ~= "player" then 
		local cb = CreateFrame"StatusBar"
		cb:SetStatusBarTexture"Interface\\AddOns\\oUF_Amnith\\textures\\statusbar"
		cb:SetStatusBarColor(.7, .05, .15, .5)
		cb:SetParent(self)
		cb:SetAllPoints(hp)
		--cb:SetToplevel(true)
		self.Castbar = cb
	end
	
	local leader = hp:CreateTexture(nil, "OVERLAY")
	leader:SetHeight(16)
	leader:SetWidth(16)
	leader:SetPoint("CENTER", hp, "CENTER", 0, 10)
	leader:SetTexture"Interface\\GroupFrame\\UI-Group-LeaderIcon"
	self.Leader = leader

	local ricon = hp:CreateTexture(nil, "OVERLAY")
	ricon:SetHeight(16)
	ricon:SetWidth(16)
	ricon:SetPoint("LEFT", hp, "LEFT", -5, 10)
	ricon:SetTexture"Interface\\TargetingFrame\\UI-RaidTargetingIcons"
	self.RaidIcon = ricon

	local name = hp:CreateFontString(nil, "OVERLAY")
	name:SetPoint("LEFT", 2, 0)
	name:SetJustifyH"LEFT"
	name:SetFont(FONT, FONT_SIZE)
	name:SetTextColor(1, 1, 1)
	name:SetShadowOffset(1, -1)
	self.Name = name
	self.UNIT_NAME_UPDATE = updateName
	
	-- Enable pvp icon   
	self.PvP = hp:CreateTexture(nil, 'OVERLAY')   
	if isfaction == 'Horde' then   
		self.PvP:SetTexCoord(0.08, 0.58, 0.045, 0.545)   
     	elseif isfaction == 'Alliance' then   
        	self.PvP:SetTexCoord(0.07, 0.58, 0.06, 0.57)   
     	else   
        	self.PvP:SetTexCoord(0.05, 0.605, 0.015, 0.57)   
     	end   

     	if(unit == 'targettarget') then   
        	self.PvP:SetHeight(15)   
        	self.PvP:SetWidth(15)   
        	self.PvP:SetPoint('TOPRIGHT', 10, 10)   
     	else   
	        self.PvP:SetHeight(22)   
         	self.PvP:SetWidth(22)   
         	self.PvP:SetPoint('TOPRIGHT', 15, 10)   
     	end   
     	self.PvPCheck = PvPCheck
	
	if unit == "pet" then
		name:Hide()
		local happy = hp:CreateFontString(nil, "OVERLAY")
		local happiness = ({":<", ":|", ":D"})
		local smile = CreateFrame"Frame"
		happy:SetFont(FONT, FONT_SIZE)	
		happy:SetShadowOffset(1, -1)
		happy:SetPoint("LEFT", 2, 0)
		smile:RegisterEvent"UNIT_HAPPINESS"
		smile:SetScript("OnEvent", function()
			local h, _, _ = GetPetHappiness()
			if h then 
				happy:SetText(string.format("%s", happiness[h]))
			end
		end)
	end
	
	if(unit == "target" or unit == "focus" or self:GetParent():GetName() == "oUF_Party") then
		local buffs = CreateFrame("Frame", nil, self)
		buffs:SetHeight(17) --hp:GetHeight() + pp:GetHeight())
		buffs:SetWidth(200) --0) --0*self:GetHeight())
		buffs.initialAnchor = "BOTTOMLEFT"
		buffs.num = 12
		buffs["growth-x"] = "RIGHT"
		buffs:SetPoint("BOTTOMLEFT", self, "TOPLEFT") --BOTTOMLEFT")--, "LEFT")
		buffs.size = math.floor(buffs:GetHeight() + .5)
		buffs.filter = false
		self.Buffs = buffs

		local debuffs = CreateFrame("Frame", nil, self)
		debuffs:SetHeight(15) --hp:GetHeight() + pp:GetHeight())
		debuffs:SetWidth(200) --*self:GetHeight())
		if self:GetParent():GetName() == "oUF_Party" then
			debuffs:SetPoint("BOTTOMRIGHT", 200, 0)
			debuffs.num = 6
		else
			debuffs:SetPoint("TOPLEFT", self, "BOTTOMLEFT")
			debuffs.num = 12
		end
		debuffs.size = math.floor(debuffs:GetHeight() + .5)
		debuffs.initialAnchor = "BOTTOMLEFT"
		
		debuffs.filter = false
		self.Debuffs = debuffs
	end

	if(unit == "target") then
		local cpoints = self:CreateFontString(nil, "OVERLAY")
		cpoints:SetPoint("LEFT", self, "RIGHT", 10, 0)
		cpoints:SetFont(FONT, 30)
		cpoints:SetTextColor(1, 1, 1) 
		cpoints:SetShadowOffset(1, -1)
		self.CPoints = cpoints
	end
	
	if(not unit) then
		self.Range = true 
		self.inRangeAlpha = 1.0
		self.outsideRangeAlpha = 0.5
	end

	self.PostCreateAuraIcon = auraIcon
	return self
end

oUF:RegisterStyle("oUF_Amnith", setmetatable({
	["initial-width"] = 220,
	["initial-height"] = 40,
}, {__call = func}))

oUF:RegisterStyle("oUF_AmnithPet", setmetatable({
	["initial-width"] = 100,
	["initial-height"] = 22, 
}, {__call = func}))

oUF:SetActiveStyle"oUF_Amnith"

local player = oUF:Spawn"player"
player:SetPoint("TOPLEFT", 20, -75)
local target = oUF:Spawn"target"
target:SetPoint("LEFT", player, "RIGHT", 15, 0)
local tt = oUF:Spawn"targettarget"
tt:SetPoint("BOTTOM", target, "TOP", 0, 0)
local party = oUF:Spawn("header", "oUF_Party")
party:SetPoint("TOP", player, "BOTTOM", 0, -50)
party:SetManyAttributes("showParty", true, "yOffset", -25)
party:Show()
local focus = oUF:Spawn"focus"
focus:SetPoint("LEFT", target, "RIGHT", 15, 0)
oUF:SetActiveStyle"oUF_AmnithPet"
local pet = oUF:Spawn"pet"
pet:SetPoint("BOTTOMLEFT", player, 0, -25)


