do return end

local function print( txt )
	ChatFrame1:AddMessage("|cffff00bbRPM|r: "..tostring(txt))
end

-- spawn func predefs
local spawn_10man, spawn_25man, spawn_40man, spawn_always
local analyze_raid

-- objects
-- will be filled with headers/units by name tag 
-- headers["10man"] = {header, header, header, header}
-- :Show and :Hide will be called on them
local objects = {}

-- spawn functions, should return wether or not they've spawned
-- all spawned unit or header objects should be added to the correct headers[] entry
function spawn_10man()
	print("spawning 10man")

	-- set style
	oUF:SetActiveStyle("Ammo_Tiny")
	return false
end

function spawn_25man()
	print("spawning 25man")

	return false
end

function spawn_40man()
	print("spawning 40man")
	return false
end

function spawn_always( cond )
	print("spawning always")
	oUF:SetActiveStyle("Ammo_Micro")
	local raid = oUF:Spawn("header", "oUF_Raid")
	raid:SetPoint("TOPLEFT", 13, -13)
	raid:SetManyAttributes(
		"point", "TOP",
		"sortDir", "ASC",
		"xOffset", 0,
		"yOffset", -2,
		"groupingOrder",  "1,2,3,4,5,6,7,8",
		"groupBy", "GROUP",
		--"unitsPerColumn", 5,
		--"columnAnchorPoint", "TOP",
		--"columnSpacing", 4.9,
		--"maxColumns", 8,
		"showRaid", true
	)
	-- raid:Show() -- show is handled by the manager
	table.insert(objects[cond.name], raid)
	return true
end



-- list of condition, any condition that fits results in its frames being shown.
-- this means you can have multiple raid frame styles active. Just the way I like it.
-- a spawned member will be set on the conditions. If no spawned member is set the spawn function is called.
-- a shown member will be set onthe conditions. If set, the show will not be called
local conditions = {
	{
		name = "always",
		min = 1,
		max = 40,
		spawn = spawn_always,
	},
	{	
		name = "10man",
		min = 1,
		max = 15,
		spawn = spawn_10man,
	},
	{
		name = "25man",
		min = 16,
		max = 35,
		spawn = spawn_25man,
	},
	{
		name = "40man",
		min = 35,
		max = 40,
		spawn = spawn_40man,
	},
}

-- setup
for k, v in pairs(conditions) do
	objects[v.name] = {}
end

local checkAfterUpdate = nil
local checkAfterCombat = nil

local pm = CreateFrame("Frame", nil, UIParent)
pm:Hide()

local function OnEvent(self, event, ...)
	if self[event] then
		self[event](self, event, ...)
	end
end
local function OnUpdate(self, elapsed)
	if InCombatLockdown() then
		checkAfterCombat = true
		checkAfterUpdate = nil
		pm:Hide()
		return
	end
	checkAfterUpdate = checkAfterUpdate + elapsed
	if checkAfterUpdate > 4 then
		checkAfterUpdate = nil
		pm:Hide()
		analyze_raid()
	end
end

pm:RegisterEvent("RAID_ROSTER_UPDATE")
pm:RegisterEvent("PLAYER_REGEN_ENABLED")
pm:RegisterEvent("PLAYER_LOGIN")

pm:SetScript("OnEvent", OnEvent)
pm:SetScript("OnUpdate", OnUpdate)

function pm:RAID_ROSTER_UPDATE()
	if InCombatLockdown() then
		pm:Hide()
		checkAfterUpdate = nil
		checkAfterCombat = true
		return
	end
	if not checkAfterUpdate then
		checkAfterUpdate = 0
	end
	pm:Show()
end


function pm:PLAYER_REGEN_ENABLED()
	if checkAfterCombat then
		checkAfterCombat = nil
		analyze_raid()
	end
end

pm.PLAYER_LOGIN = pm.RAID_ROSTER_UPDATE

function analyze_raid()
	local nr = GetNumRaidMembers()
	for k, v in ipairs(conditions) do
		if nr >= v.min and nr <= v.max then
			print( v.name .." matches!")
			if not v.shown then
				print( v.name .." not shown")
				if not v.spawned then 
					print( v.name .." has type "..type(v.spawn))
					v.spawned = v.spawn(v) 
				end
				if v.spawned then
					print( v.name .." spawned, showing objects")
					for _, object in pairs(objects[v.name]) do
						if object.unit then
							RegisterUnitWatch(object)
							if(UnitExists(object.unit)) then
								object:PLAYER_ENTERING_WORLD()
							end
						else
							object:Show()
						end
					end
					v.shown = true
				end
			end
		elseif v.shown then
			print( v.name .." shown, but no match => hiding")
			for _, object in pairs(objects[v.name]) do
				if object.unit then
					UnregisterUnitWatch(object)
				end
				object:Hide()				
			end
		end
	end
end



