-- the local upvalues bandwagon
local select = select
local UnitClass = UnitClass
local UnitIsDead = UnitIsDead
local UnitIsGhost = UnitIsGhost
local UnitIsPlayer = UnitIsPlayer
local UnitIsConnected = UnitIsConnected
local RAID_CLASS_COLORS = RAID_CLASS_COLORS
local UnitLevel = UnitLevel
local UnitPowerType = UnitPowerType
local UnitClassification = UnitClassification
local UnitCreatureFamily = UnitCreatureFamily
local UnitCreatureType = UnitCreatureType
local UnitCanAttack = UnitCanAttack
local GetQuestGreenRange = GetQuestGreenRange

local playerClass = select(2, UnitClass("player")) -- combopoints for druid/rogue

local unfiltered = (playerClass == "ROGUE" or playerClass == "WARRIOR")

local font, fontHeight = "Interface\\AddOns\\oUF_Ammo\\media\\barframes.ttf", 11
local backdrop = {
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 16,
		insets = {left = -1.5, right = -1.5, top = -1.5, bottom = -1.5},
	}
local statusbartexture = "Interface\\AddOns\\oUF_Ammo\\media\\statusbar"
local bordertexture = "Interface\\AddOns\\oUF_Ammo\\media\\border"
	
local white = { r = 1, g = 1, b = 1}

local barFormatMinMax = "%d/%d"
local barFormatPerc = "%d%%"
local barFormatPercMinMax = "%d%% %d/%d"
local barFormatDeficit = "|cffff8080%d|r"
local barFormatDeficitNoMax = "%d"
local barFormatMinMaxDef = "%d/%d |cffff8080%d|r"

local function fmt_standard(txt, min, max)
	txt:SetFormattedText(barFormatMinMax, min, max)
end

local function fmt_perc(txt, min, max)
	txt:SetFormattedText(barFormatPerc,floor(min/max*100))
end

local function fmt_full(txt, min, max)
	local deficit = min - max
	if deficit == 0 then
		txt:SetFormattedText(barFormatMinMax, min, max )
	else
		txt:SetFormattedText(barFormatMinMaxDef, min, max, deficit)
	end
end

local function fmt_deficit(txt, min, max)
	local deficit = min - max
	if deficit < 0 then
		txt:SetFormattedText(barFormatDeficit, deficit)
	else
		txt:SetText(max)
	end
end

local function fmt_deficitnomax(txt, min, max)
	local deficit = min - max
	if deficit < 0 then
		txt:SetFormattedText(barFormatDeficitNoMax, deficit)
	else
		txt:SetText("")
	end
end

local function fmt_percminmax(txt, min, max)
	txt:SetFormattedText(barFormatPercMinMax, floor(min/max*100), min, max)
end

local fmtmeta = { __index = function(self, key)
	if type(key) == "nil" then return nil end
	if not rawget(self, key) then
		rawset(self, key, fmt_standard)
		return self[key]
	end
end}

local formats = setmetatable({}, { 
	__index = function(self, key)
		if type(key) == "nil" then return nil end
		if not rawget(self, key) then
			if key:find("raidpet%d") then self[key] = self.raidpet
			elseif key:find("raidtarget%d") then self[key] = self.raidtarget
			elseif key:find("raid%d") then self[key] = self.raid
			elseif key:find("partypet%d") then self[key] = self.partypet
			elseif key:find("party%dtarget") then self[key] = self.partytarget
			elseif key:find("party%d") then self[key] = self.party
			else
				self[key] = {}
			end
		end
		return self[key]
	end,
	__newindex = function(self, key, value)
		rawset(self, key, setmetatable(value, fmtmeta))
	end,
})

formats.player.health = fmt_full
formats.pet.health = fmt_full
formats.party.health = fmt_full

formats.target.health = fmt_percminmax
formats.target.power = fmt_percminmax

formats.focus.health = fmt_percminmax
formats.focus.power = fmt_percminmax

formats.partypet.health = fmt_deficit
formats.partytarget.health = fmt_perc

formats.targettarget.health = fmt_deficit
formats.targettarget.power = fmt_perc

formats.focustarget.health = fmt_deficit
formats.focustarget.power = fmt_perc

formats.raid.health = fmt_deficitnomax

local classificationFormats = {
	worldboss = "?? Boss",
	rareelite = "%d+ Rare",
	elite = "%d+",
	rare = "%d Rare",
	normal = "%d",
	trivial = "%d",
}

local function getDifficultyColor(level)
	local levelDiff = level - UnitLevel("player")
	if levelDiff >= 5 then
		return 1.00, 0.10, 0.10
	elseif levelDiff >= 3 then
		return 1.00, 0.50, 0.25
	elseif levelDiff >= -2 then
		return 1.00, 1.00, 1.00
	elseif -levelDiff <= GetQuestGreenRange() then
		return 0.25, 0.75, 0.25
	end
	return 0.50, 0.50, 0.50
end

-- This is the core of RightClick menus on diffrent frames
local function menu(self)
	local unit = self.unit:sub(1, -2)
	local cunit = self.unit:gsub("(.)", string.upper, 1)

	if(unit == "party" or unit == "partypet") then
		ToggleDropDownMenu(1, nil, _G["PartyMemberFrame"..self.id.."DropDown"], "cursor", 0, 0)
	elseif(_G[cunit.."FrameDropDown"]) then
		ToggleDropDownMenu(1, nil, _G[cunit.."FrameDropDown"], "cursor", 0, 0)
	end
end

local function updateLevel(self, event, unit)
	if self.unit ~= unit then return end
	
	local lvl = self.Lvl
	local level = UnitLevel(unit)

	lvl:SetFormattedText(classificationFormats[UnitClassification(unit)] or classificationFormats["normal"], level)

	if UnitCanAttack("player", unit) then
		lvl:SetTextColor(getDifficultyColor(level))
	else
		lvl:SetTextColor(1, 1, 1)
	end
end

local function updateName(self, event, unit)
	if self.unit ~= unit then return end
	
	self.Name:SetText(UnitName(unit))
	if self.Lvl then
		updateLevel(self, event, unit)
	end

	if self.Class then
		local color = white
		if UnitIsPlayer(unit)  then	
			self.Class:SetText(UnitClass(unit))
			color = RAID_CLASS_COLORS[select(2, UnitClass(unit))] or white
		else
			self.Class:SetText(UnitCreatureFamily(unit) or UnitCreatureType(unit))
		end
		self.Class:SetVertexColor(color.r, color.g, color.b)
	end
	if self.Race then
		self.Race:SetText(UnitRace(unit))
	end
end

local function updateHealth(self, event, unit, bar, min, max)
	local cur, maxhp, MHfound
	if MobHealth3 then
		cur,maxhp,MHfound = MobHealth3:GetUnitHealth(unit, min, max)
	end
	if not MHfound then
		cur, maxhp = min, max
	end

	if UnitIsDead(unit) then 
		bar:SetValue(0)
		bar.value:SetText("Dead")
	elseif UnitIsGhost(unit) then
		bar:SetValue(0)
		bar.value:SetText("Ghost")
	elseif not UnitIsConnected(unit) then
		bar:SetValue(0)
		bar.value:SetText("Offline")
	else
		formats[unit].health(bar.value, cur, maxhp)
	end
end


local function updatePower(self, event, unit, bar, min, max)
	if max == 0 or UnitIsDead(unit) or UnitIsGhost(unit) or not UnitIsConnected(unit) then
		bar:SetValue(0)
		if bar.value then
			bar.value:SetText()
		end
	elseif bar.value then
		formats[unit].power(bar.value, min, max)
	end
end

local function noHide(self)
	self:SetVertexColor(.25,.25, .25)
end

local function auraIcon(self, button, icons, index, debuff)
	button.cd:SetReverse()
	button.icon:SetTexCoord(.07, .93, .07, .93) --zoom icon
	button.overlay:SetTexture(bordertexture)
	button.overlay:SetTexCoord(0,1,0,1)
	button.overlay.Hide = noHide
end

local function OnEnter(self)
	self.Name:SetTextColor(1, 0, 1)
	if InCombatLockdown() then return end
	UnitFrame_OnEnter(self)
end

local function OnLeave(self)
	self.Name:SetTextColor(1, 1, 1)
	if InCombatLockdown() then return end
	UnitFrame_OnLeave()
end

local function getFontString(parent)
	local fs = parent:CreateFontString(nil, "OVERLAY")
	fs:SetFont(font, fontHeight)
	fs:SetShadowColor(0,0,0)
	fs:SetShadowOffset(0.8, -0.8)
	fs:SetTextColor(1,1,1)
	fs:SetJustifyH("LEFT")
	return fs
end

local function Banzai(self, unit, aggro)
	if aggro == 1 then
		self.Health.value:SetTextColor(1,0,0)
		if UnitHealth(unit) == UnitHealthMax(unit) then
			self.Health.value:SetText("Aggro")
		end
	else
		self.Health.value:SetTextColor(1,1,1)
	end
end

local function setStyle(settings, self, unit)
	self.menu = menu -- Enable the menus
	self:RegisterForClicks("anyup")
	self:SetAttribute("*type2", "menu")
	self:SetScript("OnEnter", OnEnter)
	self:SetScript("OnLeave", OnLeave)

	local tiny = settings["ammo-tiny"]
	local micro = settings["ammo-micro"]
	
	local hpheight = 22
	if micro then hpheight = 12
	elseif tiny then hpheight = 16
	end

	local ppheight = 16
	if micro then ppheight = 3
	elseif tiny then ppheight = 4
	end
	
	-- Background
	self:SetBackdrop(backdrop)
	self:SetBackdropColor(0,0,0,1)

	-- Healthbar
	local hp = CreateFrame("StatusBar", nil, self)
	hp:SetHeight(hpheight)
	hp:SetStatusBarTexture(statusbartexture)
	hp:SetPoint("TOPLEFT")
	hp:SetPoint("TOPRIGHT")

	-- Healthbar background
	hp.bg = hp:CreateTexture(nil, "BORDER")
	hp.bg:SetAllPoints(hp)
	hp.bg:SetTexture(statusbartexture)
	hp.bg:SetAlpha(.5)
	
	-- healthbar coloring, happy true fest
	hp.colorHappiness = true
	hp.colorClass = true
	hp.colorReaction = true
	hp.colorTapping = true
	
	-- Healthbar text
	hp.value = getFontString(hp)
	hp.value:SetPoint("RIGHT", -2, 0)
	
	self.Health = hp
	self.PostUpdateHealth = updateHealth

	local icon = hp:CreateTexture(nil, "OVERLAY")
	icon:SetHeight(16)
	icon:SetWidth(16)
	icon:SetPoint("TOP", self, 0, not micro and 8 or 0)
	icon:SetTexture("Interface\\TargetingFrame\\UI-RaidTargetingIcons")
	self.RaidIcon = icon
	
	self.Name = getFontString(hp)
	self.Name:SetPoint("LEFT", 2, 0)
	self.UNIT_NAME_UPDATE = updateName
	
	-- hack to update level 
	self:RegisterEvent("UNIT_LEVEL")
	self.UNIT_LEVEL = updateName
	
	-- Power Bar 
	local pp = CreateFrame("StatusBar", nil, self)
	pp:SetHeight(ppheight)
	pp:SetStatusBarTexture(statusbartexture)
	
	pp:SetPoint("LEFT")
	pp:SetPoint("RIGHT")
	pp:SetPoint("TOP", hp, "BOTTOM", 0, not micro and -1.35 or 0)
	
	pp.colorPower = true

	pp.bg = pp:CreateTexture(nil, "BORDER")
	pp.bg:SetAllPoints(pp)
	pp.bg:SetTexture(statusbartexture)
	pp.bg:SetAlpha(.5)
	
	self.Power = pp
	self.PostUpdatePower = updatePower
		
	if not tiny then -- anything larger than tiny has text on the powerbar
		pp.value = getFontString(pp)
		pp.value:SetPoint("RIGHT", -2, 0)
	
		self.Lvl = getFontString(pp)
		self.Lvl:SetPoint("LEFT", pp, "LEFT", 2, 0)

		self.Class = getFontString(pp)
		self.Class:SetPoint("LEFT", self.Lvl, "RIGHT",  1, 0)

		self.Race = getFontString(pp)
		self.Race:SetPoint("LEFT", self.Class, "RIGHT",  1, 0)
	end

	if not unit or unit == "player" then --raid,  party or player gets a leader icon
		local leader = hp:CreateTexture(nil, "OVERLAY")
		leader:SetHeight(16)
		leader:SetWidth(16)
		leader:SetPoint("TOPLEFT", self, -8, 8)
		leader:SetTexture("Interface\\GroupFrame\\UI-Group-LeaderIcon")
		self.Leader = leader		
	end
	
	if unit == "player" then -- player gets resting and combat
		local resting = pp:CreateTexture(nil, "OVERLAY")
		resting:SetHeight(16)
		resting:SetWidth(16)
		resting:SetPoint("BOTTOMLEFT", self, -8, -8)
		resting:SetTexture("Interface\\CharacterFrame\\UI-StateIcon")
		resting:SetTexCoord(0.09, 0.43, 0.08, 0.42)
		self.Resting = resting
		local combat = pp:CreateTexture(nil, "OVERLAY")
		combat:SetHeight(16)
		combat:SetWidth(16)
		combat:SetPoint("BOTTOMRIGHT", self, 8, -8)
		combat:SetTexture("Interface\\CharacterFrame\\UI-StateIcon")
		combat:SetTexCoord(0.57, 0.90, 0.08, 0.41)
		self.Combat = combat
	end
	
	-- player, pet party and partypets get debuff highlighting
	if not unit or unit == "player" or unit == "pet" or unit:find("partypet%d") then
		self.DebuffHighlightBackdrop = true -- oUF_DebuffHighlight Support, using the backdrop
		self.DebuffHighlightFilter = not unfiltered -- only show debuffs I can cure, if I can cure any
	end
	
	if not unit or not unit:find("party%dtarget") then -- party, raid and anything but partytargets get cbft
		self.CombatFeedbackText = getFontString(hp)
		self.CombatFeedbackText:SetFont(font, micro and 14 or 16, "OUTLINE")
		self.CombatFeedbackText:SetPoint("CENTER", self, "CENTER")
	end
	
	if micro then -- micro units (raid) don't color healthbar but the health text
		self.Banzai = Banzai
	end
	if unit == "focustarget" then
		self.ignoreBanzai = true
	end

	local buffheight = settings["buff-height"] or 16
	local buffwidth = settings["initial-width"]
	buffwidth = buffwidth - (buffwidth%buffheight) -- make sure we have exactly enough room for the buffs
	
	if unit and not unit:find("party%dtarget") and not unit:find("partypet%d") then
		local debuffs = CreateFrame("Frame", nil, self)
		debuffs.size = buffheight
		debuffs:SetHeight(buffheight)
		debuffs:SetWidth(buffwidth)
	
		debuffs:SetPoint("BOTTOMRIGHT", self, "TOPRIGHT",1.5,3)
		debuffs.initialAnchor = "BOTTOMRIGHT"
		debuffs["growth-y"] = "UP"
		debuffs["growth-x"] = "LEFT"
		debuffs.num = 40
		self.Debuffs = debuffs

		local buffs = CreateFrame("Frame", nil, self)
		buffs.size = buffheight
		buffs:SetHeight(buffheight)
		buffs:SetWidth(buffwidth)
		buffs:SetPoint("TOPLEFT", self, "BOTTOMLEFT",-1.5, -3)
		buffs.initialAnchor = "TOPLEFT"
		buffs["growth-y"] = "DOWN"
		buffs.num = 40
		self.Buffs = buffs
	elseif not unit and not micro then -- this the party but not the raid
		-- no debuffs on my party frames
		local buffs = CreateFrame("Frame", nil, self)
		buffs.size = buffheight
		buffs:SetHeight(buffheight)
		buffs:SetWidth(buffwidth)
		buffs:SetPoint("TOPLEFT", self, "BOTTOMLEFT",-1.5, -3)
		buffs.initialAnchor = "TOPLEFT"
		buffs["growth-y"] = "DOWN"
		buffs.num = floor(buffwidth/buffheight) -- one row of buffs
		buffs.filter = true
		self.Buffs = buffs
	end
	
	if not unit or unit:find("partypet%d") then -- range on party, raid and party pets
		self.Range = true 
		self.inRangeAlpha = 1.0
		self.outsideRangeAlpha = micro and 0.4 or 0.6		
	end
	
	if unit=="target" and playerClass == "ROGUE" or playerClass == "DRUID" then
		self.CPoints = getFontString(self)
		self.CPoints:SetPoint("RIGHT", self, "LEFT", -9, 3)
		self.CPoints:SetFont(font, 38, "OUTLINE")
		self.CPoints:SetJustifyH("RIGHT")
	end
	self.PostCreateAuraIcon = auraIcon
	
	return self
end

oUF:RegisterStyle("Ammo", setmetatable({
	["initial-width"] = 200,
	["initial-height"] = 39,
	["buff-height"] = 20,
}, {__call = setStyle}))

oUF:RegisterStyle("Ammo_Small", setmetatable({
	["initial-width"] = 150,
	["initial-height"] = 39,
	["ammo-small"] = true,
}, {__call = setStyle}))

oUF:RegisterStyle("Ammo_Tiny", setmetatable({
	["initial-width"] = 125,
	["initial-height"] = 21,
	["ammo-tiny"] = true,
}, {__call = setStyle}))

oUF:RegisterStyle("Ammo_Raid", setmetatable({
	["initial-width"] = 125,
	["initial-height"] = 14,
	["ammo-tiny"] = true,
	["ammo-micro"] = true,
}, {__call = setStyle}))

oUF:SetActiveStyle("Ammo")
local player = oUF:Spawn("player", "oUF_Player")
player:SetPoint("RIGHT", UIParent, "CENTER", -20, -250)

local target = oUF:Spawn("target", "oUF_Target")
target:SetPoint("LEFT", UIParent, "CENTER", 20, -250)

local focus = oUF:Spawn("focus", "oUF_Focus")
focus:SetPoint("BOTTOMLEFT", target, "TOPLEFT", 0, 70)

local party	= oUF:Spawn("header", "oUF_Party")
party:SetPoint("TOPLEFT", UIParent, "CENTER", 400, 0)
party:SetAttribute("yOffset", -31)
party:SetAttribute("showParty", true)
--party:SetAttribute("showRaid", true)
party:Show()

oUF:SetActiveStyle("Ammo_Small")

local pet = oUF:Spawn("pet", "oUF_Pet")
pet:SetPoint("RIGHT", player, "LEFT", -25, 0)

local tot = oUF:Spawn("targettarget", "oUF_TargetTarget")
tot:SetPoint("LEFT", target, "RIGHT", 25, 0)

local tof = oUF:Spawn("focustarget", "oUF_Focustarget")
tof:SetPoint("LEFT", focus, "RIGHT", 25, 0)

oUF:SetActiveStyle("Ammo_Tiny")

-- The pet header is being a cunt, this is  better solution

local pets = {}
pets[1] = oUF:Spawn("partypet1", "oUF_PartyPet1")
pets[1]:SetPoint("TOPRIGHT", party, "TOPRIGHT", 0, -44)
for i =2, 4 do
	pets[i] = oUF:Spawn("partypet"..i, "oUF_PartyPet"..i)
	pets[i]:SetPoint("TOP", pets[i-1], "BOTTOM", 0, -50)
end

local pts = {}
pts[1] = oUF:Spawn("party1target", "oUF_Party1Target")
pts[1]:SetPoint("TOPLEFT", party, "TOPRIGHT", 5, 0)
for i =2, 4 do
	pts[i] = oUF:Spawn("party"..i.."target", "oUF_Party"..i.."Target")
	pts[i]:SetPoint("TOP", pts[i-1], "BOTTOM", 0, -50)
end

oUF:SetActiveStyle("Ammo_Raid")

local raid2 = oUF:Spawn("header", "oUF_Raid2")
raid2:SetPoint("BOTTOMRIGHT", pet, "BOTTOMLEFT", -25, 0)
raid2:SetManyAttributes(
	"point", "BOTTOM",
	"sortDir", "DESC",
	"xOffset", 0,
	"yOffset", 4.9,
	"groupFilter",  "6,7,8",
	"groupingOrder", "6,7,8",
	"groupBy", "GROUP",
	"showRaid", true
)

local raid = oUF:Spawn("header", "oUF_Raid")
raid:SetPoint("BOTTOMRIGHT", raid2, "BOTTOMLEFT", -10, 0)
raid:SetManyAttributes(
	"point", "BOTTOM",
	"sortDir", "DESC",
	"xOffset", 0,
	"yOffset", 4.9,
	"groupFilter", "1,2,3,4,5",
	"groupingOrder", "1,2,3,4,5",
	"groupBy", "GROUP",
	"showRaid", true
)
raid:Show()
raid2:Show()