﻿-- -*- indent-tabs-mode: t; tab-width: 4; lua-indent-level: 4 -*-

assert( oRA, "oRA not found!")

------------------------------
--      Are you flagged?    --
------------------------------

local L = AceLibrary("AceLocale-2.2"):new("oRAOPvp")
local player = UnitName("player")

----------------------------
--      Localization      --
----------------------------

L:RegisterTranslations("enUS", function() return {
	["PvP"] = true,
	["Permanent"] = true, -- as in "PVP Enabled" or "permaflagged"
	["Unflagged"] = true, -- as in "PvP flag down"
	["Options for zone checks."] = true,
	["Refresh"] = true,
	["Close"] = true,
	["Name"] = true,
	["Leader/Pvp"] = true,
	["Perform pvp check"] = true,
	["Check who is flagged for PvP."] = true,
} end )

L:RegisterTranslations("zhCN", function() return {
	["PvP"] = "PVP",
	["Permanent"] = "PVP开启", -- as in "PVP Enabled" or "permaflagged"
	["Unflagged"] = "PVP关闭", -- as in "PvP flag down"
	["Options for zone checks."] = "区域检查选项",
	["Refresh"] = "刷新",
	["Close"] = "关闭",
	["Name"] = "名字",
	["Leader/Pvp"] = "领袖/PVP",
	["Perform pvp check"] = "进行PVP检查",
	["Check who is flagged for PvP."] = "检查谁开启了PVP",
} end )

L:RegisterTranslations("zhTW", function() return {
	["PvP"] = "PVP",
	["Permanent"] = "PVP 開啟", -- as in "PVP Enabled" or "permaflagged"
	["Unflagged"] = "PVP 關閉", -- as in "PvP flag down"
	["Options for zone checks."] = "區域檢查選項",
	["Refresh"] = "更新",
	["Close"] = "關閉",
	["Name"] = "名字",
	["Leader/Pvp"] = "領隊/PVP",
	["Perform pvp check"] = "進行 PVP 檢查",
	["Check who is flagged for PvP."] = "檢查誰開啟了 PVP",
} end )

----------------------------------
--      Module Declaration      --
----------------------------------

local mod = oRA:NewModule("LeaderPvp")
mod.participant = true
mod.name = L["Leader/Pvp"]
mod.consoleCmd = "pvp"
mod.consoleOptions = {
	type = "execute",
	name = L["Perform pvp check"],
	desc = L["Check who is flagged for PvP."],
	handler = mod,
	func = "PerformPvpCheck",
	disabled = function()
		return not oRA:IsModuleActive(mod)
	end,
}

------------------------------
--      Initialization      --
------------------------------

local players = nil
local player_pvp_state = nil

function mod:OnEnable()
	self:RegisterCheck("PVP", "oRA_PVPResponse")
	self:RegisterCheck("PVPC", "oRA_PVPCheck")
	self:RegisterShorthand("rapvp", "PerformPvpCheck")
end

--------------------
-- Event Handlers --
--------------------

function mod:oRA_PVPResponse(msg, author)
	local pvp_flagged_raw, requestby = select(3, msg:find("^PVP (%d) ([^%s]+)$"))
	if pvp_flagged_raw and requestby and requestby == player then
		local pvp_flagged = tonumber(pvp_flagged_raw)
		local status = L["Unflagged"]
		if pvp_flagged == 2 then
			status = L["Permanent"]
		elseif pvp_flagged == 1 then
			status = L["PvP"]
		end
		self:AddPlayer(author, status)
		oRA:UpdateWindow()
	end
end

function mod:oRA_PVPCheck(msg, author)
	local flaglevel = 0
	if GetPVPDesired() == 1 then
		flaglevel = 2
	elseif UnitIsPVP("player") then
		flaglevel = 1
	end
	oRA:SendMessage(string.format("PVP %d %s", flaglevel, author), true)
end

-----------------------
--  Command Handlers --
-----------------------

local function RefreshPvp()
	mod:PerformPvpCheck()
end

local paintchips = nil
function mod:PerformPvpCheck()
	if not oRA:IsPromoted() then return end
	local playerflagged = UnitIsPVP("player")

	players = self:del(players)
	players = self:new()

	if GetPVPDesired() == 1 then
		player_pvp_state = L["Permanent"]
	elseif UnitIsPVP("player") then
		player_pvp_state = L["PvP"]
	else
		player_pvp_state = L["Unflagged"]
	end

	for i = 1, GetNumRaidMembers() do
		local name = GetRaidRosterInfo(i)
		if name ~= player then
			local flagged = UnitIsPVP(name)
			if flagged ~= playerflagged then
				table.insert(players, self:new(self.coloredNames[name], flagged and L["PvP"] or L["Unflagged"]))
			end
		end
	end
	oRA:SendMessage("PVPC", true)
	oRA:OpenWindow(L["PvP"], players, RefreshPvp, L["Name"], 125, L["PvP"], 155)
end

-- The logic here is a bit subtle. Let's say the player is permaflagged, and
-- the raider is as well. All the initial check will reveal is that the raider
-- is "PVP". Only if the raider has oRA2 will you know if he is permaflagged
-- and thus can be removed from the list because he is the same state as you.
--
-- Players should not be discovered by the last if block, but it's included
-- for completeness.
--
-- Someone may eventually prefer that we only care if they're flagged or not,
-- and to ignore the difference between permaflagging and pvp when comparing
-- player and raider.
function mod:AddPlayer(nick, status)
	local colored_name = self.coloredNames[nick]
	for i,p in ipairs(players) do
		if colored_name == p[1] then
			if status == player_pvp_state then
				table.remove(players,i)
			else
				p[2] = status
			end
			return
		end
	end

	-- not found, so add
	if status ~= player_pvp_state then
		table.insert(players, self:new(colored_name, status))
	end
end

