﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

    nUI is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with nUI.  If not, see <http://www.gnu.org/licenses/>.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

nUI_L = {};
nUI_Locale = GetLocale(); 

	nUI_L["font1"] = "Fonts\\ARIALN.TTF";
	nUI_L["font2"] = "Fonts\\FRIZQT__.TTF";
	
	nUI_L["Welcome back to %s, %s..."] = "Welcome back to %s, %s...";
	nUI_L["nUI version %s is loaded!"] = "nUI version %s is loaded!";
	nUI_L["Type '/nui' for a list of available nUI commands."] = "Type '/nui' for a list of available nUI commands.";
	
	-- clock strings
	
	nUI_L["am"] = "am";
	nUI_L["pm"] = "pm";
	nUI_L["(S) <hour>:<minute><suffix> - <hour>:<minute><suffix> (L)"] = "(S) %d:%02d%s - %d:%02d%s (L)";
	nUI_L["(S) <hour>:<minute> - <hour>:<minute> (L)"] = "(S) %02d:%02d - %02d:%02d (L)";
	
	-- state strings
	
	nUI_L["|cFF00FF00ENABLED|r"]  = "|cFF00FF00ENABLED|r";
	nUI_L["|cFFFF0000DISABLED|r"] = "|cFFFF0000DISABLED|r";
	nUI_L["~INTERRUPTED~"]        = "~INTERRUPTED~";
	nUI_L["~FAILED~"]             = "~FAILED~";
	nUI_L["~MISSED~"]             = "~MISSED~";
	nUI_L["OFFLINE"]              = "OFFLINE";
	nUI_L["DND"]                  = "DND";
	nUI_L["AFK"]                  = "AFK";
	nUI_L["DEAD"]                 = "DEAD";
	nUI_L["GHOST"]                = "GHOST";
	nUI_L["FD"]                   = "FD";
	nUI_L["TAXI"]                 = "TAXI";
	nUI_L["OOR"]				  = "OOR"; -- new -- abbreviation for "out of range"
	
	-- time remaining (cooldowns, buffs, etc.)
	
	nUI_L["TimeLeftInHours"]   = "%0.0fh";
	nUI_L["TimeLeftInMinutes"] = "%0.0fm";
	nUI_L["TimeLeftInSeconds"] = "%0.0fs";
	nUI_L["TimeLeftInTenths"]  = "%0.1fs";
	
	-- raid and party role tooltip strings
	
	nUI_L["Party Role: |cFF00FFFF%s|r"] = "Party Role: |cFF00FFFF%s|r";
	nUI_L["Raid Role: |cFF00FFFF%s|r"]  = "Raid Role: |cFF00FFFF%s|r";
	nUI_L["Raid Leader"]                = "Raid Leader";
	nUI_L["Party Leader"]               = "Party Leader";
	nUI_L["Raid Assistant"]             = "Raid Assistant";
	nUI_L["Main Tank"]                  = "Main Tank";
	nUI_L["Off-Tank"]                   = "Off-Tank";
	nUI_L["Master Looter"]              = "Master Looter";
	
	-- hunter pet feeder strings
	
	nUI_L[nUI_FOOD_MEAT]   = "meat";
	nUI_L[nUI_FOOD_FISH]   = "fish";
	nUI_L[nUI_FOOD_BREAD]  = "bread";
	nUI_L[nUI_FOOD_CHEESE] = "cheese";
	nUI_L[nUI_FOOD_FRUIT]  = "fruit";
	nUI_L[nUI_FOOD_FUNGUS] = "fungus";
	
	nUI_L["Click to feed %s"]           = "Click to feed %s";
	nUI_L["Click to cancel feeding"]    = "Click to cancel feeding";
	nUI_L["nUI: %s can eat %s%s%s"]     = "nUI: %s can eat %s%s%s";
	nUI_L[" or "]                       = " or ";
	nUI_L["nUI: You don't have a pet!"] = "nUI: You don't have a pet!";
	
	nUI_L["nUI: You can feed %s the following...\n"] = "nUI: You can feed %s the following...\n";
	nUI_L["nUI: You have nothing you can feed %s in your current inventory"] = "nUI: You have nothing you can feed %s in your current inventory";
	nUI_L["    Click the pet happiness indictor to feed your pet now"] = "    Click the pet happiness indictor to feed your pet now";
	
	-- status bar strings
	
	nUI_L["nUI: Cannot change status bar config while in combat!"] = "nUI: Cannot change status bar config while in combat!";
	nUI_L["nUI: [%s] is not a valid option for orienting a status bar... use LEFT, RIGHT, TOP or BOTTOM"] = "nUI: [%s] is not a valid option for orienting a status bar... use LEFT, RIGHT, TOP or BOTTOM";
	nUI_L["nUI: Can not change status bar overlays while in combat!"] = "nUI: Can not change status bar overlays while in combat!";
	nUI_L["nUI: The maximum value (%d) of a status bar must be greater than the minimum value (%d)"] = "nUI: The maximum value (%d) of a status bar must be greater than the minimum value (%d)";
	
	-- information panel strings
	
	nUI_L["Minimap"] = "Minimap";
	
	nUI_L[nUI_INFOPANEL_MINIMAP]   		   		= "Info Panel: Minimap Display Mode";
	nUI_L[nUI_INFOPANEL_MINIMAP.."Label"]		= "Minimap";
	
	nUI_L[nUI_INFOPANEL_COMBATLOG]      		= "Info Panel: Combat Log Display Mode";
	nUI_L[nUI_INFOPANEL_COMBATLOG.."Label"]		= "Combat";
	
	nUI_L[nUI_INFOPANEL_BMM]		      		= "Info Panel: Battlefield Minimap Mode";
	nUI_L[nUI_INFOPANEL_BMM.."Label"]			= "Map";
	
	nUI_L[nUI_INFOPANEL_RECOUNT]		   		= "Info Panel: Recount Damage Meter Mode";
	nUI_L[nUI_INFOPANEL_RECOUNT.."Label"]		= "Recount";
	
	nUI_L[nUI_INFOPANEL_OMEN2]		      		= "Info Panel: Omen2 Threat Meter Mode";
	nUI_L[nUI_INFOPANEL_OMEN2.."Label"]			= "Omen2";
	
	nUI_L[nUI_INFOPANEL_OMEN2KLH]	      		= "Info Panel: Combined Omen2 + KLH Threat Meter Mode";
	nUI_L[nUI_INFOPANEL_OMEN2KLH.."Label"]		= "Threat";
	
	nUI_L[nUI_INFOPANEL_OMEN2RECOUNT]		   	= "Info Panel: Omen2 Threat + Recount Damage Meter Mode";
	nUI_L[nUI_INFOPANEL_OMEN2RECOUNT.."Label"]	= "Omen2+";
	
	nUI_L[nUI_INFOPANEL_KLH]		      		= "Info Panel: KLH Threat Meter Mode";
	nUI_L[nUI_INFOPANEL_KLH.."Label"]			= "KTM";
	
	nUI_L[nUI_INFOPANEL_KLHRECOUNT]	      		= "Info Panel: KLH Threat + Recount Damage Meter Mode";
	nUI_L[nUI_INFOPANEL_KLHRECOUNT.."Label"]	= "KTM+";
	
	nUI_L["nUI: You need to go to the WoW Interface menu, select the 'Social' option and turn off the 'Simple Chat' menu option to enable integrated combat log support in nUI."] = "nUI: You need to go to the WoW Interface menu, select the 'Social' option and turn off the 'Simple Chat' menu option to enable integrated combat log support in nUI.";
	nUI_L["The %s Info Panel plugin is a core plugin to nUI and cannot be disabled"] = "The %s Info Panel plugin is a core plugin to nUI and cannot be disabled";
	nUI_L["Click to change information panels"] = "Click to change information panels";
	nUI_L["nUI: Cannot initialize the Info Panel plugin [ %s ] -- it does not have an initPanel() interface method"] = "nUI: Cannot initialize the Info Panel plugin [ |cFF00FFFF%s|r ] -- it does not have an initPanel() interface method";
	nUI_L["nUI: Cannot initialize the Info Panel plugin [ %s ] -- No global object by that name exists"] = "nUI: Cannot initialize the Info Panel plugin [ |cFF00FFFF%s|r ] -- No global object by that name exists";	
	nUI_L["nUI: Cannot select the Info Panel plugin [ %s ] -- it does not have a setSelected() interface method"] = "nUI: cannot select the Info Panel plugin [ |cFF00FFFF%s|r ] -- it does not have a setSelected() interface method";
	
	-- HUD layout strings (heads up display)
	
	nUI_L["Click to change HUD layouts"] = "Click to change HUD layouts";
	
	nUI_L[nUI_HUDLAYOUT_PLAYERTARGET]	   		= "HUD Layout: Player Left / Target Right";
	nUI_L[nUI_HUDLAYOUT_PLAYERTARGET.."Label"]	= "Player/Target";
	
	nUI_L[nUI_HUDLAYOUT_HEALTHPOWER]	   		= "HUD Layout: Health Left / Power Right";
	nUI_L[nUI_HUDLAYOUT_HEALTHPOWER.."Label"]	= "Health/Power";
	
	nUI_L[nUI_HUDLAYOUT_SIDEBYSIDE]	   			= "HUD Layout: Side-by-side Horizontal Bars";
	nUI_L[nUI_HUDLAYOUT_SIDEBYSIDE.."Label"]	= "Side by Side";
	
	nUI_L[nUI_HUDLAYOUT_NOBARS]	   				= "HUD Layout: Simple HUD (no bars)";
	nUI_L[nUI_HUDLAYOUT_NOBARS.."Label"]		= "Simple HUD";
	
	nUI_L[nUI_HUDLAYOUT_NOHUD]		   			= "HUD Layout: Disabled (no HUD)";
	nUI_L[nUI_HUDLAYOUT_NOHUD.."Label"]			= "No HUD";
	
	nUI_L[nUI_HUDMODE_PLAYERTARGET]        = "nUI Player/Target HUD Mode";
	nUI_L[nUI_HUDSKIN_PLAYERTARGET_PET]    = nUI_L[nUI_HUDMODE_PLAYERTARGET]..": skin for displaying the Player Pet's unit data";
	nUI_L[nUI_HUDSKIN_PLAYERTARGET_PLAYER] = nUI_L[nUI_HUDMODE_PLAYERTARGET]..": skin for displaying the Player's unit data";
	nUI_L[nUI_HUDSKIN_PLAYERTARGET_TARGET] = nUI_L[nUI_HUDMODE_PLAYERTARGET]..": skin for displaying the Target's unit data";
	nUI_L[nUI_HUDSKIN_PLAYERTARGET_TOT]    = nUI_L[nUI_HUDMODE_PLAYERTARGET]..": skin for displaying the Target of Target's (ToT) unit data";
	
	nUI_L[nUI_HUDMODE_HEALTHPOWER]         = "nUI Health/Power HUD Mode";
	nUI_L[nUI_HUDSKIN_HEALTHPOWER_PET]     = nUI_L[nUI_HUDMODE_HEALTHPOWER]..": skin for displaying the Player Pet's unit data";
	nUI_L[nUI_HUDSKIN_HEALTHPOWER_PLAYER]  = nUI_L[nUI_HUDMODE_HEALTHPOWER]..": skin for displaying the Player's unit data";
	nUI_L[nUI_HUDSKIN_HEALTHPOWER_TARGET]  = nUI_L[nUI_HUDMODE_HEALTHPOWER]..": skin for displaying the Target's unit data";
	nUI_L[nUI_HUDSKIN_HEALTHPOWER_TOT]     = nUI_L[nUI_HUDMODE_HEALTHPOWER]..": skin for displaying the Target of Target's (ToT) unit data";
	
	nUI_L[nUI_HUDMODE_SIDEBYSIDE]          = "nUI Side by Side HUD Mode";
	nUI_L[nUI_HUDSKIN_SIDEBYSIDE_PET]      = nUI_L[nUI_HUDMODE_SIDEBYSIDE]..": skin for displaying the Player Pet's unit data";
	nUI_L[nUI_HUDSKIN_SIDEBYSIDE_PLAYER]   = nUI_L[nUI_HUDMODE_SIDEBYSIDE]..": skin for displaying the Player's unit data";
	nUI_L[nUI_HUDSKIN_SIDEBYSIDE_TARGET]   = nUI_L[nUI_HUDMODE_SIDEBYSIDE]..": skin for displaying the Target's unit data";
	nUI_L[nUI_HUDSKIN_SIDEBYSIDE_TOT]      = nUI_L[nUI_HUDMODE_SIDEBYSIDE]..": skin for displaying the Target of Target's (ToT) unit data";
	
	nUI_L[nUI_HUDMODE_NOBARS]              = "nUI Simple Barless HUD Mode";
	nUI_L[nUI_HUDSKIN_NOBARS_PLAYER]       = nUI_L[nUI_HUDMODE_SIDEBYSIDE]..": skin for displaying the Player's unit data";
	nUI_L[nUI_HUDSKIN_NOBARS_TARGET]       = nUI_L[nUI_HUDMODE_SIDEBYSIDE]..": skin for displaying the Target's unit data";
	
	-- nUI_Unit strings

	nUI_L["Pet"]        = "Pet";
	nUI_L["Target"]     = "Target";
	nUI_L["Range"]      = "Range";
	nUI_L["MELEE"]      = "MELEE";      -- new -- used by the range to target module to indicate target is in melee or physical combat range
	nUI_L["Elite"]      = "Elite";      -- new -- used in unit frames to show the target is an elite mob
	nUI_L["Rare"]       = "Rare";       -- new -- used in unit frames to show the target is non-elite rare mob
	nUI_L["Rare Elite"] = "Rare Elite"; -- new -- used in unit frames to indate the target is both a rare mob and an elite mob
	nUI_L["World Boss"] = "World Boss"; -- new -- used in unit frames to indicate the target mob is a world boss
	
	nUI_L["unit: player"]             = "Player";
	nUI_L["unit: pet"]		          = "Player's Pet";
	nUI_L["unit: pettarget"]          = "Player Pet's Target";
	nUI_L["unit: focus"]              = "Player's Focus";
	nUI_L["unit: focustarget"]        = "Target of Player's Focus";
	nUI_L["unit: target"]             = "Player's Target";
	nUI_L["unit: %s-target"]          = "%s's Target";
	nUI_L["unit: mouseover"]          = "Mouseover Target";
	nUI_L["unit: targettarget"]       = "Target of Target (ToT)";
	nUI_L["unit: targettargettarget"] = "Target of ToT (ToTT)";
	nUI_L["unit: party%d"]            = "Party Member %d";
	nUI_L["unit: party%dpet"]         = "Party Member %d's Pet";
	nUI_L["unit: party%dtarget"]      = "Party Member %d's Target";
	nUI_L["unit: party%dpettarget"]   = "Party Member %d Pet's Target";
	nUI_L["unit: raid%d"]             = "Raid Member %d";
	nUI_L["unit: raid%dpet"]          = "Raid Member %d's Pet";
	nUI_L["unit: raid%dtarget"]       = "Raid Member %d's Target";
	nUI_L["unit: raid%dpettarget"]    = "Raid Member %d Pet's Target";

	nUI_L[nUI_UNITMODE_PLAYER]        = "nUI Solo Player Mode";
	nUI_L[nUI_UNITSKIN_PARTYFOCUS]    = nUI_L[nUI_UNITMODE_PLAYER]..": Player Focus' unit skin";
	nUI_L[nUI_UNITSKIN_PARTYMOUSE]    = nUI_L[nUI_UNITMODE_PLAYER]..": Mouseover target unit skin";
	nUI_L[nUI_UNITSKIN_SOLOPET]       = nUI_L[nUI_UNITMODE_PLAYER]..": Player Pet's unit skin";
	nUI_L[nUI_UNITSKIN_SOLOPETBUTTON] = nUI_L[nUI_UNITMODE_PLAYER]..": Pet targeting button unit skins... i.e. Target's Pet, Player Focus' Pet, etc";
	nUI_L[nUI_UNITSKIN_SOLOPLAYER]    = nUI_L[nUI_UNITMODE_PLAYER]..": Player's unit skin";
	nUI_L[nUI_UNITSKIN_SOLOTARGET]    = nUI_L[nUI_UNITMODE_PLAYER]..": Target's unit skin";
	nUI_L[nUI_UNITSKIN_SOLOTGTBUTTON] = nUI_L[nUI_UNITMODE_PLAYER]..": Target targeting button unit skins... i.e. Player Focus' target, etc.";
	nUI_L[nUI_UNITSKIN_SOLOTOT]       = nUI_L[nUI_UNITMODE_PLAYER]..": Target of Target's (ToT) unit skin";

	nUI_L[nUI_UNITMODE_PARTY]          = "nUI Party/Group Mode";
	nUI_L[nUI_UNITSKIN_PARTYFOCUS]     = nUI_L[nUI_UNITMODE_PARTY]..": Player Focus' unit skin";
	nUI_L[nUI_UNITSKIN_PARTYMOUSE]     = nUI_L[nUI_UNITMODE_PARTY]..": Mouseover target unit skin";
	nUI_L[nUI_UNITSKIN_PARTYPLAYER]    = nUI_L[nUI_UNITMODE_PARTY]..": Player's unit skin";
	nUI_L[nUI_UNITSKIN_PARTYPET]       = nUI_L[nUI_UNITMODE_PARTY]..": Player Pet's unit skin";
	nUI_L[nUI_UNITSKIN_PARTYTARGET]    = nUI_L[nUI_UNITMODE_PARTY]..": Target's unit skin";
	nUI_L[nUI_UNITSKIN_PARTYTOT]       = nUI_L[nUI_UNITMODE_PARTY]..": Target of Target's (ToT) unit skin";
	nUI_L[nUI_UNITSKIN_PARTYFOCUS]     = nUI_L[nUI_UNITMODE_PARTY]..": Player Focus' unit skin";
	nUI_L[nUI_UNITSKIN_PARTYLEFT]      = nUI_L[nUI_UNITMODE_PARTY]..": Left side party member unit skin";
	nUI_L[nUI_UNITSKIN_PARTYRIGHT]     = nUI_L[nUI_UNITMODE_PARTY]..": Right side party member unit skin";
	nUI_L[nUI_UNITSKIN_PARTYPETBUTTON] = nUI_L[nUI_UNITMODE_PARTY]..": Party Member and Focus' pet button unit skin";
	nUI_L[nUI_UNITSKIN_PARTYTGTBUTTON] = nUI_L[nUI_UNITMODE_PARTY]..": Party Member and Focus' target button unit skin";
	nUI_L[nUI_UNITSKIN_PARTYMOUSE]     = nUI_L[nUI_UNITMODE_PARTY]..": Mouseover unit skin";
	
	nUI_L[nUI_UNITMODE_RAID10]          ="nUI 10 Player Raid Mode";
	nUI_L[nUI_UNITSKIN_RAID10FOCUS]     = nUI_L[nUI_UNITMODE_RAID10]..": Player Focus' unit skin";
	nUI_L[nUI_UNITSKIN_RAID10MOUSE]     = nUI_L[nUI_UNITMODE_RAID10]..": Mouseover target unit skin";
	nUI_L[nUI_UNITSKIN_RAID10PLAYER]    = nUI_L[nUI_UNITMODE_RAID10]..": Player's unit skin";
	nUI_L[nUI_UNITSKIN_RAID10PET]       = nUI_L[nUI_UNITMODE_RAID10]..": Player Pet's unit skin";
	nUI_L[nUI_UNITSKIN_RAID10TARGET]    = nUI_L[nUI_UNITMODE_RAID10]..": Target's unit skin";
	nUI_L[nUI_UNITSKIN_RAID10TOT]       = nUI_L[nUI_UNITMODE_RAID10]..": Target of Target's (ToT) unit skin";
	nUI_L[nUI_UNITSKIN_RAID10FOCUS]     = nUI_L[nUI_UNITMODE_RAID10]..": Player Focus' unit skin";
	nUI_L[nUI_UNITSKIN_RAID10LEFT]      = nUI_L[nUI_UNITMODE_RAID10]..": Left side raid member unit skin";
	nUI_L[nUI_UNITSKIN_RAID10RIGHT]     = nUI_L[nUI_UNITMODE_RAID10]..": Right side raid member unit skin";
	nUI_L[nUI_UNITSKIN_RAID10PETBUTTON] = nUI_L[nUI_UNITMODE_RAID10]..": Raid Member and Focus' pet button unit skin";
	nUI_L[nUI_UNITSKIN_RAID10TGTBUTTON] = nUI_L[nUI_UNITMODE_RAID10]..": Raid Member and Focus' target button unit skin";
	nUI_L[nUI_UNITSKIN_RAID10MOUSE]     = nUI_L[nUI_UNITMODE_RAID10]..": Mouseover unit skin";
	
	nUI_L[nUI_UNITPANEL_PLAYER]      		= "Unit Panel: Solo Player Mode";
	nUI_L[nUI_UNITPANEL_PLAYER.."Label"]	= "Player";
	
	nUI_L[nUI_UNITPANEL_PARTY]       		= "Unit Panel: Party/Group Mode";
	nUI_L[nUI_UNITPANEL_PARTY.."Label"] 	= "Party";
	
	nUI_L[nUI_UNITPANEL_RAID10]      		= "Unit Panel: 10 Player Raid Mode";
	nUI_L[nUI_UNITPANEL_RAID10.."Label"]	= "Raid 10";
	
	nUI_L[nUI_UNITPANEL_RAID15]      		= "Unit Panel: 15 Player Raid Mode";
	nUI_L[nUI_UNITPANEL_RAID15.."Label"]	= "Raid 15";
	
	nUI_L[nUI_UNITPANEL_RAID20]      		= "Unit Panel: 20 Player Raid Mode";
	nUI_L[nUI_UNITPANEL_RAID20.."Label"]	= "Raid 20";
	
	nUI_L[nUI_UNITPANEL_RAID25]      		= "Unit Panel: 25 Player Raid Mode";
	nUI_L[nUI_UNITPANEL_RAID25.."Label"]	= "Raid 25";
	
	nUI_L[nUI_UNITPANEL_RAID40]      		= "Unit Panel: 40 Player Raid Mode";
	nUI_L[nUI_UNITPANEL_RAID40.."Label"]	= "Raid 40";
	
	nUI_L["Click to change unit frame panels"] = "Click to change unit frame panels";
	
	nUI_L["<unnamed frame>"]   = "<unnamed frame>";
	nUI_L["casting bar"]       = "casting bar";
	nUI_L["pet happiness"]     = "pet happiness";
	nUI_L["raid group"]        = "raid group";
	nUI_L["raid target"]       = "raid target";
	nUI_L["ready check"]       = "ready check";
	nUI_L["unit aura"]         = "unit aura";
	nUI_L["unit change"]       = "unit change";
	nUI_L["unit class"]        = "unit class";
	nUI_L["unit combat"]       = "unit combat";
	nUI_L["unit combo points"] = "unit combo points"; -- new -- unit frame module that display's rogue/druid combe point icons
	nUI_L["unit feedback"]     = "unit feedback";
	nUI_L["unit health"]       = "unit health";
	nUI_L["unit label"]        = "unit label";
	nUI_L["unit level"]        = "unit level";
	nUI_L["unit portrait"]     = "unit portrait";
	nUI_L["unit power"]        = "unit power";
	nUI_L["unit PvP"]          = "unit PvP";
	nUI_L["unit range"]        = "unit range"; -- new -- unit frame module that calculates the range to target
	nUI_L["unit reaction"]     = "unit reaction";
	nUI_L["unit resting"]      = "unit resting";
	nUI_L["unit role"]         = "unit role";
	nUI_L["unit spec"]         = "unit spec"; -- new -- unit frame module that determines the unit's talent build (or displays elite/rare/world boss tags)
	nUI_L["unit status"]       = "unit status";
	
	nUI_L["Talent Build: <build name> (<talent points>)"] = "Talent Build: |cFF00FFFF%s|r (%s)"; -- new -- used to display the unit's talent tree build in the unit frame mouseover tooltip
	nUI_L["passed unit id is <nil> in callback table for %s"] = "passed unit id is <nil> in callback table for %s";
	nUI_L["nUI: Warning.. anchoring %s to %s -- anchor point has a <nil> value."] = "nUI: Warning.. anchoring %s to %s -- anchor point has a <nil> value.";
	nUI_L["nUI: Cannot register %s for scaling... frame does not have a applyScale() method"] = "nUI: Cannot register %s for scaling... frame does not have a applyScale() method";
	nUI_L["nUI: Cannot register %s for scaling... frame does not have a applyAnchor() method"] = "nUI: Cannot register %s for scaling... frame does not have a applyAnchor() method";
	nUI_L["nUI: %s %s callback %s does not have a newUnitInfo() method."] = "nUI: %s %s callback %s does not have a newUnitInfo() method.";
	nUI_L["nUI_UnitClass.lua: unhandled unit class [%s] for [%s]"] = "nUI_UnitClass.lua: unhandled unit class [%s] for [%s]";
	nUI_L["nUI: click-casting registration is %s"] = "nUI: click-casting registration is %s";
	nUI_L["nUI: must pass a valid parent frame to nUI_Unit:createFrame() for unit id [%s (%s)]"] = "nUI: must pass a valid parent frame to nUI_Unit:createFrame() for unit id [%s (%s)]";
	nUI_L["nUI says: Gratz for reaching level %d %s!"] = "nUI says: Gratz for reaching level %d %s!";
	nUI_L["nUI_Unit: [%s] is not a valid unit frame element type!"] = "nUI_Unit: [%s] is not a valid unit frame element type!";
	nUI_L["nUI_Unit: [%s] is not a known unit skin name!"] = "nUI_Unit: [%s] is not a known unit skin name!";
	
	-- nUI_Unit hunter pet strings
	
	nUI_L["Your pet"] = "Your pet";
	nUI_L["quickly"] = "quickly";
	nUI_L["slowly"] = "slowly";
	nUI_L["nUI: %s is happy."] = "nUI: %s is happy.";
	nUI_L["nUI: %s is unhappy... time to feed!"] = "nUI: %s is unhappy... time to feed!";
	nUI_L["nUI: Warning! %s is |cFFFFFFFFNOT|r happy! Better feed soon."] = "nUI: Warning! %s is |cFFFFFFFFNOT|r happy! Better feed soon.";
	nUI_L["nUI: Warning... %s is %s losing loyalty "] = "nUI: Warning... %s is %s losing loyalty ";
	nUI_L["nUI: %s is %s gaining loyalty"] = "nUI: %s is %s gaining loyalty";
	nUI_L["nUI: %s has stopped gaining loyalty"] = "nUI: %s has stopped gaining loyalty";
	nUI_L["nUI: %s has stopped losing loyalty"] = "nUI: %s has stopped losing loyalty";
	nUI_L["nUI_UnitHappiness.lua: unhandled pet happiness value (%s)"] = "nUI_UnitHappiness.lua: unhandled pet happiness value (%s)";
	nUI_L["Your pet's current damage bonus is %d%%"] = "Your pet's current damage bonus is %+d%%";
	nUI_L["Your pet's current damage penalty is %d%%"] = "Your pet's current damage penalty is %+d%%";
	nUI_L["nUI: It looks to me like you're a little busy... maybe you should try feeding %s AFTER you leave combat?"] = "nUI: It looks to me like you're a little busy... maybe you should try feeding %s AFTER you leave combat?";
	nUI_L["nUI: I looked everywhere, but I couldn't find a pet to feed. Perhaps he's in your backpack?"] = "nUI: I looked everywhere, but I couldn't find a pet to feed. Perhaps he's in your backpack?";
	nUI_L["nUI: You know, I could be wrong, but I don't think feeding %s is a very good idea... it doesn't look to me like what you have in your bags is what %s is thinking about eating."] = "nUI: You know, I could be wrong, but I don't think feeding %s is a very good idea... it doesn't look to me like what you have in your bags is what %s is thinking about eating.";
	
	-- miscelaneous strings

	nUI_L["Version"]             = "nUI Version |cFF00FF00%s|r";
	nUI_L["Copyright"]           = "Copyright (C) 2008 by K. Scott Piel";
	nUI_L["Rights"]              = "All Rights Reserved";
	nUI_L["Off Hand Weapon:"]    = "Off Hand Weapon:";
	nUI_L["Main Hand Weapon:"]   = "Main Hand Weapon:";
	nUI_L["Group %d"]            = "Group %d";
	nUI_L["MS"]                  = "MS";
	nUI_L["FPS"]				 = "FPS";
	nUI_L["Minimap Button Bag"]  = "Minimap Button Bag";
	
	-- faction / reputation bar strings
	
	nUI_L["Unknown"]    = "Unknown"; -- new -- these strings are all used to print the player's reputation with a given faction
	nUI_L["Hated"]      = "Hated"; -- new -- i.e. "You are Hated by the Bucksail Buckaneers"
	nUI_L["Hostile"]    = "Hostile"; -- new
	nUI_L["Unfriendly"] = "Unfriendly"; -- new
	nUI_L["Neutral"]    = "Neutral"; -- new
	nUI_L["Friendly"]   = "Friendly"; -- new
	nUI_L["Honored"]    = "Honored"; -- new
	nUI_L["Revered"]    = "Revered"; -- new
	nUI_L["Exalted"]    = "Exalted"; -- new
	
	nUI_L["Faction: <faction name>"]    = "Faction: |cFF00FFFF%s|r"; -- new -- used to display faction name in reputation bar mouseover tooltip
	nUI_L["Reputation: <rep level>"]    = "Reputation: |cFF00FFFF%s|r"; -- new -- one of "Hated", "Hostile", "Neutral", "Honored", etc.
	nUI_L["Current Rep: <number>"]      = "Current Rep: |cFF00FFFF%d|r"; -- new -- how much reputation has the player earned toward the next level?
	nUI_L["Required Rep: <number>"]     = "Required Rep: |cFF00FFFF%d|r"; -- new -- how reputation does the player need to get to the next level?
	nUI_L["Remaining Rep: <number>"]    = "Remaining Rep: |cFF00FFFF%d|r"; -- new -- how much reputation is left to earn to reach the next level? (required rep - current rep = remaining rep)
	nUI_L["Percent Complete: <number>"] = "Percent Complete: |cFF00FFFF%0.1f%%|r"; -- new -- how much of this level has the player completed as a percent of total? (currently rep / required rep = percent complete)
	nUI_L["<faction name> (<reputation>) <current rep> of <required rep> (<percent complete>)"] = "%s (%s) %d of %d (%0.1f%%)"; -- new -- used to print a reputation bar label showing current faction facts
	
	nUI_L[FACTION_UPDATE_START_STRING]    = "Reputation with "; -- new -- used to mark the beginning of a faction update line in combat log
	nUI_L[FACTION_UPDATE_END_STRING]      = " increased"; -- new -- used to mark the end of the faction name in the update line
	nUI_L[FACTION_UPDATE_INCREASE_STRING] = "increased"; -- new -- used to indicate that the update is an increase in faction
	
	-- player experience bar strings
	
	nUI_L["Current level: <level>"]                         = "Current level: |cFF00FFFF%d|r"; -- new -- used to print the player's current level in tooltip text
	nUI_L["Current XP: <experience points>"]                = "Current XP: |cFF00FFFF%d|r"; -- new -- how much XP has the player earned so far in this level
	nUI_L["Required XP: <XP required to reach next level>"] = "Required XP: |cFF00FFFF%d|r"; -- new -- how much XP has the player got to earn to complete this level
	nUI_L["Remaining XP: <XP remaining to level>"]          = "Remaining XP: |cFF00FFFF%d|r"; -- new -- how much XP is left to earn to complete this level (required XP - current XP = remaining XP)
	nUI_L["Percent complete: <current XP / required XP>"]   = "Percent complete: |cFF00FFFF%0.1f%%|r"; -- new -- how much of this level has the player completed as a percent (current XP / required XP = percent complete)
	nUI_L["Rested XP: <total rested experience> (percent)"] = "Rested XP: |cFF00FFFF%d|r (%0.1f%%)"; -- new -- prints how much total rested XP the player has remaining as both a value and a percent of the total XP required for the current level
	nUI_L["Rested Levels: <levels>"]                        = "Rested Levels: |cFF00FFFF%0.2f|r"; -- new -- the number of levels the player can earn from their current XP + rested XP remaining
	nUI_L["Level <player level>: <experience> of <max experience> (<percent of total>), <rested xp> rested XP"] = "Level %d: %d of %d (%0.1f%%), %d rested XP"; -- new -- used to display player's current experience level
	
	-- health race bar tooltip strings
	
	nUI_L["nUI Health Race Stats..."] = "nUI Health Race Stats...";
	nUI_L["No current advantage to <player> or <target>"] = "No current advantage to %s or %s";
	nUI_L["<unit name>'s Health: <current>/<maximum> (<percent>)"] = "%s's Health: |cFF00FF00%d/%d|r (|cFFFFFFFF%0.1f%%|r)";
	nUI_L["Advantage to <player>: <pct>"] = "Advantage to %s: (|cFF00FF00%+0.1f%%|r)";
	nUI_L["Advantage to <target>: <pct>"] = "Advantage to %s: (|cFFFFC0C0%0.1f%%|r)";
	
	-- skinning system messages
	
	nUI_L["nUI could not load the currently selected skin [ %s ]... perhaps you have it disabled? Switching to the default nUI skin."] = "nUI could not load the currently selected skin [ |cFFFFC0C0%s|r ]... perhaps you have it disabled? Switching to the default nUI skin.";
	nUI_L["nUI: Cannot register %s for skinning... frame does not have a applySkin() method"] = "nUI: Cannot register |cFFFFC0C0%s|r for skinning... frame does not have an applySkin() method";
	
	-- frame mover messages
	
	nUI_L["Left click and drag to move <frame label>"] = "Left click and drag to move |cFF00FFFF%s|r";
	nUI_L["Right click to reset to the default location"] = "Right click to reset to the default location";
	nUI_L["Left-click and drag to move this frame"] = "Left-click and drag to move this frame";
	
	-- names of the various frames that nUI allows the user to move on the screen
	
	nUI_L["Micro-Menu"]                = "Micro-Menu";
	nUI_L["Capture Bar"]               = "Capture Bar";
	nUI_L["Watched Quests"]            = "Watched Quests";
	nUI_L["Quest Timer"]               = "Quest Timer";
	nUI_L["Equipment Durability"]      = "Equipment Durability";
	nUI_L["PvP Objectives"]            = "PvP Objectives";
	nUI_L["In-Game Tooltips"]          = "In-Game Tooltips";
	nUI_L["Bag Bar"]                   = "Bag Bar";
	nUI_L["pg1 / Action Bar]"]         = "pg1 / Action Bar]";
	nUI_L["pg2 / nUI Bonus Bar 1"]     = "pg2 / nUI Bonus Bar 1";
	nUI_L["pg3 / Right 2"]             = "pg3 / Right 2";
	nUI_L["pg4 / Right"]               = "pg4 / Right";
	nUI_L["pg5 / BottomRight"]         = "pg5 / BottomRight";
	nUI_L["pg6 / BottomLeft"]          = "pg6 / BottomLeft";
	nUI_L["nUI Bonus Bar 2"]           = "nUI Bonus Bar 2";
	nUI_L["Pet/Stance/Shapeshift Bar"] = "Pet/Stance/Shapeshift Bar";
	
	-- slash command processing	
	
	nUI_SlashCommands =
	{
		[nUI_SLASHCMD_HELP] =
		{
			command = "help",
			options = "{command}",
			desc    = "Displays the list of all available slash commands if {command} is not given or, if {command} is given, displays information about that specific command",
			message = nil,
		},
		[nUI_SLASHCMD_RELOAD] =
		{
			command = "rl",
			options = nil,
			desc    = "Reloads the user interface and all enabled mods (same as /console reloadui)",
			message = nil,
		},
		[nUI_SLASHCMD_BUTTONBAG] =
		{
			command = "bb",
			options = nil,
			desc    = "This command toggles the display of the Minimap Button Bag on and off.",
			message = nil,
		},
		[nUI_SLASHCMD_MOVERS] =
		{
			command = "movers",
			options = nil,
			desc    = "Enables and disables moving the standard Blizzard UI frames such as tooltips, durability, quest timer, etc.",
			message = "nUI: Blizzard frame movers have been %s",
		},
		[nUI_SLASHCMD_CONSOLE] =
		{
			command = "console",
			options = "{on|off|mouseover}",
			desc    = "Sets the visibility option for the top console where 'on' always show the console, 'off' always hides the console and 'mouseover' shows the console when the mouse is over the console.",
			message = "nUI: Top console visibility has been set to |cFF00FFFF%s|r",
		},
		[nUI_SLASHCMD_TOOLTIPS] =
		{
			command = "tooltips",
			options = "{owner|mouse|fixed|default}",
			desc    = "This option sets the location of the mouseover tooltips where 'owner' displays the tooltip next to the frame that owns it, 'mouse' displays the tooltip at the current mouse location, 'fixed' displays all tooltips at a fixed location on screen or 'default' does not manage tooltips at all",
			message = "nUI: Tooltip display mode changed to |cFF00FFFF%s|r",
		},
		[nUI_SLASHCMD_BAGSCALE] =
		{
			command = "bagscale",
			options = "{n}",
			desc    = "This option increases and decreases the size of your bags where {n} is a number between 0.5 and 1.5 -- 1 is the default",
			message = "nUI: Your bag scale has been changed to |cFF00FFFF%0.2f|r",
		},
		[nUI_SLASHCMD_BAGBAR] =
		{
			command = "bagbar",
			options = nil,
			desc    = "This option toggles display of the bag bar on and off",
			message = "nUI: The bag bar's display has been %s",
		},
		[nUI_SLASHCMD_FRAMERATE] =
		{
			command = "framerate",
			options = "{n}",
			desc    = "This option changes (or throttles) the maximum refresh rate for bar animations and unit frames. Increase {n} for smoothness, decrease {n} for performance. The default is "..nUI_DEFAULT_FRAME_RATE.." frames per second.",
			message = "nUI: Your refresh frame rate has been changed to |cFF00FFFF%0.0fFPS|r",
		},
		[nUI_SLASHCMD_SHOWANIM] =
		{
			command = "anim",
			options = nil,
			desc    = "This option toggles display of animated unit portraits and unit bars on and off",
			message = "nUI: Display of animated unit frames has been %s",
		},
		[nUI_SLASHCMD_HUD] =
		{
			command  = "hud",
			options  = nil,
			desc     = "This command provides access to a set of commands used to control the behavior of the nUI HUD. Use the '/nui hud' command alone for a list of available sub-commands.",
			message  = nil,
			sub_menu =
			{
				[nUI_SLASHCMD_HUD_SCALE] =
				{
					command = "scale",
					options = "{n}",
					desc    = "This option sets the scale of the HUD where 0.25 <= {n} <= 1.75. Smaller values of {n} descrease the HUD size and larger values increase the size. The default is {n} = 1",
					message = "nUI: The HUD scale has been set to |cFF00FFFF%0.2f|r",
				},
				[nUI_SLASHCMD_HUD_SHOWNPC] =
				{
					command = "shownpc",
					options = nil,
					desc    = "This option toggles display of HUD bars for non-attackable NPC targets on and off when out of combat",
					message = "nUI: Non-attackable NPC target HUD bar display has been %s",
				},
				[nUI_SLASHCMD_HUD_HEALTHRACE] =
				{
					command = "healthrace",
					options = nil,
					desc    = "This option toggles display of in-HUD health race bar on and off",
					message = "nUI: The HUD health race bar display has been %s",
				},
				[nUI_SLASHCMD_HUD_HGAP] =
				{
					command = "hgap",
					options = "{n}",
					desc    = "This option sets horizontal gap between the left and right sides of the HUD where {n} is a number greater than 0. Increase {n} to increase the gap between the left and right of the HUD. The default value of {n} is 400",
					message = "nUI: The horizontal HUD gap has been set to |cFF00FFFF%0.0f|r",
				},
				[nUI_SLASHCMD_HUD_IDLEALPHA] =
				{
					command = "idlealpha",
					options = "{n}",
					desc    = "This option sets the transparency of the HUD when you are completely idle where {n} = 0 for an invisible HUD and {n} = 1 for a fully opaque HUD. The default is {n} = 0",
					message = "nUI: The HUD idle alpha has been set to |cFF00FFFF%0.2f|r",
				},
				[nUI_SLASHCMD_HUD_REGENALPHA] =
				{
					command = "regenalpha",
					options = "{n}",
					desc    = "This option sets the transparency of the HUD when you (or your pet) are regenerating health, regenerating power or are debuffed where {n} = 0 for an invisible HUD and {n} = 1 for a fully opaque HUD. The default is {n} = 0.35",
					message = "nUI: The HUD regen alpha has been set to |cFF00FFFF%0.2f|r",
				},
				[nUI_SLASHCMD_HUD_TARGETALPHA] =
				{
					command = "targetalpha",
					options = "{n}",
					desc    = "This option sets the transparency of the HUD when you have selected a valid target where {n} = 0 for an invisible HUD and {n} = 1 for a fully opaque HUD. The default is {n} = 0.75",
					message = "nUI: The HUD targeting alpha has been set to |cFF00FFFF%0.2f|r",
				},
				[nUI_SLASHCMD_HUD_COMBATALPHA] =
				{
					command = "combatalpha",
					options = "{n}",
					desc    = "This option sets the transparency of the HUD when you or your pet are in combat where {n} = 0 for an invisible HUD and {n} = 1 for a fully opaque HUD. The default is {n} = 1",
					message = "nUI: The HUD combat alpha has been set to |cFF00FFFF%0.2f|r",
				},
			},
		},
		[nUI_SLASHCMD_CLOCK] =
		{
			command = "clock",
			options = "{12|24}",
			desc    = "This option sets the display of the dashboard clock to either a 12 hour clock or a 24 hour clock. The default is 12",
			message = "nUI: The dashboard clock has been set to |cFF00FFFF%d|r hour format",
		},
		[nUI_SLASHCMD_ROUNDMAP] = -- new 
		{
			command = "roundmap",
			options = nil,
			desc    = "This option toggles the minimap display between the default square minimap and a round minimap",
			message = "nUI: The minimap shape has been set to |cFF00FFFF%s|r", -- "round" or "square"
		},
		[nUI_SLASHCMD_LASTITEM+1] =
		{
			command = "debug",
			options = "{n}",
			desc    = "This option sets the nUI debugger messaging level. As a rule you should only change debug levels if you are asked to by the mod author. Use {n} = 0 to turn debugging off entirely (the default).",
			message = "nUI: Your debugging level has been set to |cFF00FFFF%d|r",
		},
	};
	
	nUI_L["round"]  = "round"; -- new -- used to display the current minimap shape selection
	nUI_L["square"] = "square"; -- new
	
	nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_CONSOLE, "on" )]        = "on";
	nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_CONSOLE, "off" )]       = "off";
	nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_CONSOLE, "mouseover" )] = "mouseover";
	
	nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_TOOLTIPS, "owner" )]   = "owner";
	nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_TOOLTIPS, "mouse" )]   = "mouse";
	nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_TOOLTIPS, "fixed" )]   = "fixed";
	nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_TOOLTIPS, "default" )] = "default";
	
	nUI_L["The value [ %s ] is not a valid nUI slash command. Try [ /nui help ] for a list of commands"] = "The value [ |cFFFFC000%s|r ] is not a valid nUI slash command. Try [ |cFF00FFFF/nui help|r ] for a list of commands";
	nUI_L["nUI currently supports the following list of slash commands..."]	= "nUI currently supports the following list of slash commands..."; 
	nUI_L["The '/nui %s' slash command currently supports the following list of sub-commands..."] = "The '|cFF00FFFF/nui %s|r' slash command currently supports the following list of sub-commands...";
	nUI_L["nUI: [ %s ] is not a valid tooltip settings option... please choose from %s, %s, %s or %s"] = "nUI: [ |cFFFFC0C0%s|r ] is not a valid tooltip settings option... please choose from |cFF00FFFF%s|r, |cFF00FFFF%s|r, |cFF00FFFF%s|r or |cFF00FFFF%s|r";
	nUI_L["nUI: [ %s ] is not a valid console visibility option... please choose from %s, %s or %s"] = "nUI: [ |cFFFFC0C0%s|r ] is not a valid console visibility option... please choose from |cFF00FFFF%s|r, |cFF00FFFF%s|r or |cFF00FFFF%s|r";
	nUI_L["nUI: [ %s ] is not a valid alpha value... please choose a number between 0 and 1 where 0 is fully transparent and 1 is fully opaque."] = "nUI: [ |cFFFFC0C0%s|r ] is not a valid alpha value... please choose a number between 0 and 1 where 0 is fully transparent and 1 is fully opaque.";
	nUI_L["nUI: [ %s ] is not a valid horizontal gap value... please  choose a number between 1 and 1200 where 1 is very narrow and 1200 is very wide."] = "nUI: [ |cFFFFC0C0%s|r ] is not a valid horizontal gap value... please choose a number between 1 and 1200 where 1 is very narrow and 1200 is very wide.";
	nUI_L["nUI: [ %s ] is not a valid clock option... please choose either '12' for a 12 hour clock or '24' for a 24 hour clock."] = "nUI: [ |cFFFFC0C0%s|r ] is not a valid clock option... please choose either '12' for a 12 hour clock or '24' for a 24 hour clock.";	
		
