﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

    nUI is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with nUI.  If not, see <http://www.gnu.org/licenses/>.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------
	
local function DetectTitanBars()
	
	local	bar1_at_top   = TitanPanelGetVar( "Position" ) == TITAN_PANEL_PLACE_TOP;
	local	bar1_hidden   = TitanPanelBarButton.hide == 1;
	local	bar2_hidden   = TitanPanelAuxBarButton.hide == 1;
	local	both_bars     = TitanPanelGetVar( "BothBars" );
	
	-- bar 1 is located at the top of the screen
nUI:debug( "both_bars = "..(both_bars and "true" or "false")..", bar1_at_top = "..(bar1_at_top and "true" or "false"), 1 );

	nUI_TopBarsLocator:ClearAllPoints();
	nUI_BottomBarsLocator:ClearAllPoints();

	if both_bars or bar1_at_top then
		
		if bar1_hidden then 
			nUI_TopBarsLocator:SetPoint( "BOTTOM", UIParent, "TOP", 0, 0 );
		else
			nUI_TopBarsLocator:SetPoint( "BOTTOMLEFT", TitanPanelBarButtonHider, "BOTTOMLEFT", 0, 0 );
		end

		if both_bars and not bar2_hidden then
			nUI_BottomBarsLocator:SetPoint( "TOPLEFT", TitanPanelAuxBarButton, "TOPLEFT", 0, 0 );
		else
			nUI_BottomBarsLocator:SetPoint( "TOP", UIParent, "BOTTOM", 0, 0 );
		end

	-- bar 1 is located at the bottom of the screen
	
	else
	
		nUI_TopBarsLocator:SetPoint( "BOTTOM", UIParent, "TOP", 0, 0 );

		if both_bars and not bar2_hidden then
			nUI_BottomBarsLocator:SetPoint( "TOPLEFT", TitanPanelAuxBarButton, "TOPLEFT", 0, 0 );
		elseif not bar1_at_top and not bar1_hidden then
			nUI_BottomBarsLocator:SetPoint( "TOPLEFT", TitanPanelBarButtonHider, "TOPLEFT", 0, 0 );
		else
			nUI_BottomBarsLocator:SetPoint( "TOP", UIParent, "BOTTOM", 0, 0 );
		end
	end
end

-------------------------------------------------------------------------------

local frame = CreateFrame( "Frame", "nUI_TitanPanelEvents", WorldFrame );

local function onTitanPanelEvent()
	
	if IsAddOnLoaded( "Titan" ) then
		
		hooksecurefunc( "TitanPanelBarButton_ToggleAutoHide", DetectTitanBars );
		hooksecurefunc( "TitanPanelBarButton_ToggleAuxAutoHide", DetectTitanBars );
		hooksecurefunc( "TitanPanelBarButton_TogglePosition", DetectTitanBars );
		hooksecurefunc( "TitanPanelBarButton_ToggleBarsShown", DetectTitanBars );
		hooksecurefunc( "TitanPanelBarButton_Hide", DetectTitanBars );
		hooksecurefunc( "TitanPanelBarButton_Show", DetectTitanBars );
		
		DetectTitanBars();
		
		frame:UnregisterEvent( "PLAYER_ENTERING_WORLD" );
		
	end
end

frame:SetScript( "OnEvent", onTitanPanelEvent );
frame:RegisterEvent( "PLAYER_ENTERING_WORLD" );
