﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

    nUI is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with nUI.  If not, see <http://www.gnu.org/licenses/>.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if not nUI then nUI = {}; end
if not nUI_DefaultConfig then nUI_DefaultConfig = {}; end
if not nUI_InfoPanelOptions then nUI_InfoPanelOptions = {}; end
if not nUI_InfoPanels then nUI_InfoPanels = {}; end

local CreateFrame = CreateFrame;
local MouseIsOver = MouseIsOver;

-------------------------------------------------------------------------------

-- See nUI\Integration\nUI_CombatLog.lua for information on how to integrate
-- a custom plugin into the InfoPanel system

-------------------------------------------------------------------------------

nUI_DefaultConfig.InfoPanelSelector =
{
	anchor =
	{
		anchor_pt   = "TOPRIGHT",
		relative_to = "nUI_BonusBar2",
		relative_pt = "TOPLEFT",
		xOfs        = -10,
		yOfs        = 0,
	},
	options =
	{
		enabled = true,
		height  = 40,
		width   = 93,
		strata  = nil,
		level   = nil,
			
		label =
		{
			enabled = true,
			fontsize = 12,
			anchor_pt = "CENTER",
		},
		
		background =
		{
			backdrop =
			{
				bgFile   = "Interface\\Tooltips\\UI-Tooltip-Background", 
				edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
				tile     = true, 
				tileSize = 1, 
				edgeSize = 5, 
				insets   = { left = 0, right = 0, top = 0, bottom = 0 },
			},
			
			color =
			{
				border = { r = 1, g = 1, b = 1, a = 1 },
				backdrop = { r = 0.75, g = 0, b = 0, a = 0.75 },
			},
		},		
	},
};

-------------------------------------------------------------------------------
-- default configuration for the actual information frame backdrop

nUI_DefaultConfig.InfoPanel =
{	
	anchor =
	{
		anchor_pt   = "BOTTOMLEFT",
		relative_to = "nUI_Dashboard",
		relative_pt = "CENTER",
		xOfs        = 685,
		yOfs        = -174,
	},	
	
	options = 
	{
		enabled  = true;
		strata   = "BACKGROUND",
		level    = 3,
		scale    = 1,
		height   = 290,
		width    = 585,
		inset    = 6,

		background =
		{
			backdrop =
			{
				bgFile   = "Interface\\AddOns\\nUI\\Art\\nUI_BevelboxBg", 
				edgeFile = "Interface\\AddOns\\nUI\\Art\\nUI_BevelboxBorder", 
				tile     = true, 
				tileSize = 1, 
				edgeSize = 12, 
				insets   = { left = 0, right = 0, top = 0, bottom = 0 },
			},
			
			color =
			{
				border = { r = 1, g = 1, b = 1, a = 1 },
				backdrop = { r = 0, g = 0, b = 0, a = 0.85 },
			},
		},
	},	
};

-------------------------------------------------------------------------------
-- method for sorting the info panel options on the selector button. Panels
-- are ordered ascending first by their rotation number, then by their 
-- description and finally by their panel name.

local function SortPanelList( left, right )

	local result;
	
	if left.rotation > right.rotation then
		result = false;
	elseif left.rotation < right.rotation then
		result = true;
	elseif left.desc > right.desc then
		result = false;
	elseif left.desc < right.desc then
		result = true;
	elseif left.name > right.name then
		result = false;
	else
		result = true;
	end
	
	return result;
	
end

-------------------------------------------------------------------------------

local InfoPanelList  = {};

local background = CreateFrame( "Frame", "nUI_InfoPanelBackground", nUI_Dashboard.Anchor );
local frame      = CreateFrame( "Frame", "nUI_InfoPanelSelector", background, "SecureStateHeaderTemplate" );
frame.button     = CreateFrame( "Button", "$parent_Button", frame, "SecureAnchorButtonTemplate" );
frame.text       = frame:CreateFontString( "$parent_Label", "ARTWORK" );

nUI_InfoPanelSelector        = frame;
nUI_InfoPanelSelector.Labels = {};
nUI_InfoPanelSelector.Panels = {};

background:SetAllPoints( frame );
frame.button:SetAllPoints( frame );
frame:SetAttribute( "addchild", frame.button );

frame.button:SetScript( "OnEnter",

	function()
		GameTooltip:SetOwner( frame.button );
		GameTooltip:SetText( frame.desc or nUI_L["Click to change information panels"] );
		if frame.desc then 
			GameTooltip:AddLine( nUI_L["Click to change information panels"] );
		end
		GameTooltip:Show();
	end
);

frame.button:SetScript( "OnLeave", function() GameTooltip:Hide(); end );

-------------------------------------------------------------------------------

frame.applyScale = function( scale )
	
	local scale    = scale or frame.scale or 1;
	local options  = frame.options;
	local fontsize = (options and options.label and options.label.fontsize or 12) * nUI.scale * 1.75;
	
	frame.scale   = scale;
	
	if options then
		
		local width  = options.width * scale * nUI.scale;
		local height = options.height * scale * nUI.scale;
		
		if frame.width ~= width
		or frame.height ~= height
		then
			
			frame.width  = width;
			frame.height = height;
			
			frame:SetWidth( width );
			frame:SetHeight( height );
			
		end
	end
	
	if frame.text.fontsize ~= fontsize then
		frame.text.fontsize = fontsize;
		frame.text:SetFont( nUI_L["font1"], fontsize, "OUTLINE" );
	end
	
end

-------------------------------------------------------------------------------

frame.applyAnchor = function( anchor )
	
	local anchor      = anchor or frame.anchor or {};
	local anchor_pt   = anchor.anchor_pt or "CENTER";
	local relative_to = anchor.relative_to or "nUI_Dashboard";
	local relative_pt = anchor.relative_pt or "CENTER";
	local xOfs        = (anchor.xOfs or 0) * nUI.scale;
	local yOfs        = (anchor.yOfs or 0) * nUI.scale;
	
	frame.anchor = anchor;
	
	if frame.xOfs ~= xOfs
	or frame.yOfs ~= yOfs
	or frame.anchor_pt ~= anchor_pt
	or frame.relative_to ~= relative_to
	or frame.relative_pt ~= relative_pt
	then
		
		frame.anchor_pt = anchor_pt;
		frame.relative_to = relative_to;
		frame.relative_pt = relative_pt;
		frame.xOfs        = xOfs;
		frame.yOfs        = yOfs;
		
		frame:SetPoint( anchor_pt, relative_to, relative_pt, xOfs, yOfs );
		
	end

	if frame.options then

		local label = frame.options.label;
		
		if label and label.enabled then
			
			anchor_pt   = label.anchor_pt or "CENTER";
			relative_to = label.relative_to or frame:GetName();
			relative_pt = label.relative_pt or anchor_pt;			
			xOfs        = (label.xOfs or 0) * frame.scale * nUI.scale;
			yOfs        = (label.yOfs or 0) * frame.scale * nUI.scale;
			
			if frame.text.xOfs ~= xOfs
			or frame.text.yOfs ~= yOfs
			or frame.text.anchor_pt ~= anchor_pt
			or frame.text.relative_to ~= relative_to
			or frame.text.relative_pt ~= relative_pt
			then
				
				frame.text.anchor_pt   = anchor_pt;
				frame.text.relative_to = relative_to;
				frame.text.relative_pt = relative_pt;
				frame.text.xOfs        = xOfs;
				frame.text.yOfs        = yOfs;
				
				frame.text:SetPoint( anchor_pt, relative_to, relative_pt, xOfs, yOfs );
				
			end			
		end		
	end
end

-------------------------------------------------------------------------------

frame.applyOptions = function( options )
	
	frame.options = options;
	
	if not options or not options.enabled then
		
		frame.enabled = false;
		background:Hide();
		
	else
		
		frame.enabled = true;
		background:Show();
		
		background:SetFrameStrata( options.strata or nUI_Dashboard:GetFrameStrata() );
		background:SetFrameLevel( options.level or nUI_Dashboard:GetFrameLevel()+2 );
		
		if not options.label or not options.label.enabled then
			
			frame.text.enabled = false;
			frame.text.value   = nil;
			frame.text:SetAlpha( 0 );
			frame.text:SetText( "" );
			
		else
			
			frame.text.enabled = true;
			frame.text:SetAlpha( 1 );
			
			local color = options.label.color or {};
			
			frame.text:SetTextColor( color.r or 1, color.g or 0.83, color.b or 0, color.a or 1 );
			
		end
		
		if options.border then
			
			local backdrop_color = options.border.color.backdrop;
			local border_color   = options.border.color.border;
			
			frame:SetBackdrop( options.border.backdrop );
			frame:SetBackdropColor( backdrop_color.r, backdrop_color.g, backdrop_color.b, backdrop_color.a );
			frame:SetBackdropBorderColor( border_color.r, border_color.g, border_color.b, border_color.a );
			
		else
			
			frame:SetBackdrop( nil );
			
		end
		
		if options.background then
			
			local backdrop_color = options.background.color.backdrop;
			local border_color   = options.background.color.border;
			
			frame:SetBackdrop( options.background.backdrop );
			frame:SetBackdropColor( backdrop_color.r, backdrop_color.g, backdrop_color.b, backdrop_color.a );
			frame:SetBackdropBorderColor( border_color.r, border_color.g, border_color.b, border_color.a );
			
		end

		frame.applyScale( options.scale or frame.scale or 1 );
	
	end	
end

-------------------------------------------------------------------------------

frame.applySkin = function( skin )
	
	-- we don't allow the skin developer to not include unit panels... if they
	-- don't specify them, we use the default
	
	local skin = skin.InfoPanelSelector or nUI_DefaultConfig.InfoPanelSelector;
	
	if not skin or not skin.options.enabled then
		
		frame.enabled = false;
		background:Hide();
		
	else
		
		local have_selection   = false;
		local rotation         = {};
		local buttonbag_states = nil;
		
		frame.enabled = true;
		background:Show();

		frame.applyOptions( skin.options );
		frame.applyAnchor( skin.anchor );

		-- force the availability of the minimap panel
		
		nUI_InfoPanels[nUI_INFOPANEL_MINIMAP].enabled = true;
		nUI_InfoPanels[nUI_INFOPANEL_MINIMAP].options.enabled = true;
		
		-- parse the list of available panels.
		
		for panel_name in pairs( nUI_InfoPanels ) do
	
			local panel_config = nUI_InfoPanels[panel_name];
			local panel_info   = nUI_InfoPanelSelector.Panels[panel_name];
			local plugin       = _G[panel_name];
			
			-- make sure the plugin exists
			
			if not plugin then
				
				DEFAULT_CHAT_FRAME:AddMessage( nUI_L["nUI: Cannot initialize the Info Panel plugin [ %s ] -- No global object by that name exists"]:format( panel_name ), 1, 0.5, 0.5 );
				
			-- if it the plugin is diabled, then make sure it's not longer visible
			-- or in the rotation
			
			elseif not panel_config.enabled 
			or not plugin.active
			then
				
				if panel_info then
						
					local pframe  = panel_info.frame;
					local panchor = panel_info.anchor;
					
					if panchor.enabled then
						if plugin.setEnabled then
							plugin.setEnabled( false );
						end
					end
	
					panchor.enabled = false;
					panchor:Hide();
					
					panel_info.enabled = false;
					
				end
				
			else

				if panel_name == nUI_Options.info_panel then
					have_selection = panel_name;
				end
				
				-- add this panel to the list of panels that support the buttonbag
				
				if not panel_config.full_size and nUI_InfoPanel_ButtonBag then
					
					if not buttonbag_states then
						buttonbag_states = panel_name;
					else
						buttonbag_states = buttonbag_states..","..panel_name;
					end
					
					nUI_InfoPanel_ButtonBag:SetAttribute( "showstates", buttonbag_states );
					
				end
				
				-- create the state button anchor and the content frame for the new panel

				local panchor;
				local pframe;
				
				if not panel_info then 
					
					panchor = CreateFrame( "Frame", panel_name.."Anchor", nUI_InfoPanelSelector, "SecureStateHeaderTemplate" )
					pframe  = CreateFrame( "Frame", panel_name.."Container", panchor, "SecureStateHeaderTemplate" );
					
					panchor.enabled = true;

					frame:SetAttribute( "addchild", panchor );
					panchor:SetAttribute( "showstates", panel_name );				

					panel_info =
					{
						panel_name = panel_name,
						plugin     = plugin,
						config     = panel_config,
						anchor     = panchor,
						frame      = pframe,
					};

					nUI_InfoPanelSelector.Panels[panel_name] = panel_info;				
					
				else

					panel_info.config = panel_config;
					panchor           = panel_info.anchor;
					pframe            = panel_info.frame;
					plugin            = panel_info.plugin;
				
					if not panchor.enabled then
						
						panchor.enabled = true;
						panchor:Show();
						
						if plugin.setEnabled then 
							plugin.setEnabled( true );
						end
					end				
				end

				panel_info.enabled = true;
				
				-- set up the tooltip and selector button labeling and callback notification to the 
				-- underlying info panel addon to let it know when it's been selected and deselected
				
				panchor.plugin = plugin;
				
				pframe:SetFrameStrata( frame:GetFrameStrata() );
				pframe:SetFrameLevel( frame:GetFrameLevel()+1 );
				
				panchor:SetScript( "OnShow",
					function()
						
						nUI_Options.info_panel = panel_name;
						nUI_InfoPanelSelector.text:SetText( panel_config.label );
						nUI_InfoPanelSelector.desc = panel_config.desc;
						
						if GameTooltip:IsOwned( nUI_InfoPanelSelector.button ) then
							GameTooltip:SetText( panel_config.desc or nUI_L["Click to change information panels"] );
						end
						
						if panchor.plugin.setSelected then 
							panchor.plugin.setSelected( true ); 
						else
							DEFAULT_CHAT_FRAME:AddMessage( nUI_L["nUI: cannot select the Info Panel plugin [ %s ] -- it does not have a setSelected() interface method"]:format( panel_name ), 1, 0.5, 0.5 );
						end
					end
				);
				
				panchor:SetScript( "OnHide",
					function()
						if panchor.plugin.setSelected then 
							panchor.plugin.setSelected( false );
						else
							DEFAULT_CHAT_FRAME:AddMessage( nUI_L["nUI: cannot select the Info Panel plugin [ %s ] -- it does not have a setSelected() interface method"]:format( panel_name ), 1, 0.5, 0.5 );
						end
					end
				);
				
				-- add the new panel to the list of panels in the rotation
				
				local item =
				{
					desc     = panel_info.config.desc,
					rotation = panel_info.config.rotation,
					name     = panel_name,
				};

				table.insert( rotation, item );
					
			end
		end
		
		-- create the rotation and select the correct panel
		
		local string state_string = nil;
		
		table.sort( rotation, SortPanelList );

		for item in pairs( rotation ) do
		
			if not state_string then 
				state_string = rotation[item].name;
			else
				state_string = state_string..","..rotation[item].name;
			end
		end

		nUI_InfoPanelSelector.button:SetAttribute( "newstate", state_string );
		
		-- lastly, let the info panel sizer deal with sizing and initializing the new frames

		nUI_InfoPanel.applyScale();
		
		-- if we have no selected unit panels (first time loaded) then default to
		-- the solo player unit panel, otherwise, select the last panel the user selected

		local selected   = have_selection or nUI_INFOPANEL_MINIMAP;
		local panel_info = nUI_InfoPanelSelector.Panels[selected];
		
		if not panel_info or not panel_info.enabled then
			selected   = nUI_INFOPANEL_MINIMAP;
			panel_info = nUI_InfoPanelSelector.Panels[selected];
		end
		
		if panel_info then
			
			nUI_InfoPanelSelector:SetAttribute( "state", selected );

			nUI_InfoPanelSelector.text:SetText( panel_info.config.label );
		
			nUI_InfoPanelSelector.desc = panel_info.config.desc;
		
			if panel_info.plugin.setSelected then
				panel_info.plugin.setSelected( true );
			end
		
			nUI_Options.info_panel = selected;
			
		end
	end
end

-------------------------------------------------------------------------------
-- chat frame event management

local info_background = CreateFrame( "Frame", "nUI_InfoPanel_Background", nUI_Dashboard.Anchor );
local info_frame      = CreateFrame( "Frame", "nUI_InfoPanel", info_background );
nUI.info_frame        = frame;
info_frame.texture    = frame:CreateTexture();

info_background:SetAllPoints( info_frame );
info_frame.texture:SetAllPoints( info_frame );

-------------------------------------------------------------------------------
-- adjust the size of the chat frame according the screen scale

info_frame.applyScale = function( scale )
	
	local options  = info_frame.options;
	local anchor   = scale and info_frame.anchor or nil;
	local scale    = scale or info_frame.scale or 1;

	info_frame.scale = scale;		
	
	if options then
			
		local width    = options.width  * scale * nUI.scale;
		local height   = options.height * scale * nUI.scale;
		
		if info_frame.width  ~= width 
		or info_frame.height ~= height
		then
			
			info_frame.width = width;
			info_frame.height = height;
			
			info_frame:SetWidth( width );
			info_frame:SetHeight( height );
			
		end

		-- size and intialize all of the information panels
		
		local inset   = options.inset * 2 * scale * nUI.scale;
		local pheight = height - inset;
		local pwidth1 = width - inset;
		local pwidth2 = pheight * 1.5;
		
		if info_frame.pheight ~= pheight
		or info_frame.pwidth1 ~= pwidth1
		or info_frame.pwdith2 ~= pwidth2
		then

			info_frame.pheight = pheight;
			info_frame.pwidth1 = pwidth1;
			info_frame.pwidth2 = pwidth2;
				
			for panel_name in pairs( nUI_InfoPanelSelector.Panels ) do
				
				local panel   = nUI_InfoPanelSelector.Panels[panel_name];
				local config  = panel.config;
				local pframe  = panel.frame;
				local panchor = panel.anchor;
				local plugin  = panel.plugin;
				
				if panchor.enabled then

					pframe:ClearAllPoints();
					pframe:SetPoint( "TOPLEFT", info_frame, "TOPLEFT", inset/2, -inset/2 );
					
					if panchor.pheight ~= pheight
					or panchor.pwidth1 ~= pwidth1
					or panchor.pwidth2 ~= pwidth2
					then
						
						panchor.pheight = pheight;
						panchor.pwidth1 = pwidth1;
						panchor.pwidth2 = pwidth2;
						
						pframe:SetHeight( pheight );
						pframe:SetWidth( config.full_size and pwidth1 or pwidth2 );

						-- if we haven't already, give the panel an opportunity to initialize itself
						
						if not panchor.initialized then
							
							panchor.initialized = true;
							
							if plugin.initPanel then
								plugin.initPanel( pframe, config.options );
							else
								DEFAULT_CHAT_FRAME:AddMessage( nUI_L["nUI: Cannot initialize the Info Panel plugin [ %s ] -- it does not have an initPanel() interface method"]:format( panel_name ), 1, 0.5, 0.5 );
							end
							
						end
						
						-- then notify the panel of the change in size (or initial size as the case may be)
						
						if plugin.sizeChanged then
							plugin.sizeChanged( scale * nUI.scale, pheight, config.full_size and pwidth1 or pwidth2 );
						end
					end
				end
			end
		end
		
		if anchor then info_frame.applyAnchor( anchor ); end
		
	end	
end

-------------------------------------------------------------------------------
-- anchor the chat frame

info_frame.applyAnchor = function( anchor )

	local anchor      = anchor or info_frame.anchor or {};
	local anchor_pt   = anchor.anchor_pt or "CENTER";
	local relative_to = anchor.relative_to or "nUI_Dashboard";
	local relative_pt = anchor.relative_pt or anchor_pt;
	local xOfs        = (anchor.xOfs or 0) * nUI.scale;
	local yOfs        = (anchor.yOfs or 0) * nUI.scale;	
	
	info_frame.anchor = anchor;
	
	if info_frame.anchor_pt   ~= anchor_pt
	or info_frame.relative_to ~= relative_to
	or info_frame.relative_pt ~= relative_pt
	or info_frame.xOfs        ~= xOfs
	or info_frame.yOfs        ~= yOfs
	then
		
		info_frame.anchor_pt   = anchor_pt;
		info_frame.relative_to = relative_to;
		info_frame.relative_pt = relative_pt;
		info_frame.xOfs        = xOfs;
		info_frame.yOfs        = yOfs;
		
		info_frame:ClearAllPoints();
		info_frame:SetPoint( anchor_pt, relative_to, relative_pt, xOfs, yOfs );
		
	end
end

-------------------------------------------------------------------------------
-- apply a set of configuration options to the chat frame

info_frame.applyOptions = function( options )

	info_frame.options = options;

	if not options or not options.enabled then
		
		info_frame.enabled = false;
		info_background:Hide();
		
	else
		
		info_frame.enabled = true;
		info_background:Show();
		
		info_background:SetFrameStrata( options.strata or nUI_Dashboard.Anchor:GetFrameStrata() );
		info_background:SetFrameLevel( options.level or nUI_Dashboard.Anchor:GetFrameLevel()+2 );
	
		if options.border then
			
			local backdrop_color = options.border.color.backdrop;
			local border_color   = options.border.color.border;
			
			info_frame:SetBackdrop( options.border.backdrop );
			info_frame:SetBackdropColor( backdrop_color.r, backdrop_color.g, backdrop_color.b, backdrop_color.a );
			info_frame:SetBackdropBorderColor( border_color.r, border_color.g, border_color.b, border_color.a );
			
		else
			
			info_frame:SetBackdrop( nil );
			
		end
		
		if options.background then
			
			local backdrop_color = options.background.color.backdrop;
			local border_color   = options.background.color.border;
			
			info_background:SetBackdrop( options.background.backdrop );
			info_background:SetBackdropColor( backdrop_color.r, backdrop_color.g, backdrop_color.b, backdrop_color.a );
			info_background:SetBackdropBorderColor( border_color.r, border_color.g, border_color.b, border_color.a );
			
		else
			
			info_background:SetBackdrop( nil );
			
		end
		
		info_frame.applyScale( options.scale or info_frame.scale or 1 );
		
	end	
end

-------------------------------------------------------------------------------

info_frame.applySkin = function( skin )
	
	-- we don't allow the skin developer to not include the info panels... if they
	-- don't specify them, we use the default
	
	local skin = skin.InfoPanel or nUI_DefaultConfig.InfoPanel;
	
	if not skin or not skin.options.enabled then
		
		info_frame.enabled = false;
		info_background:Hide();
		
	else
		
		info_frame.enabled = true;
		info_background:Show();

		info_frame.applyOptions( skin.options );
		info_frame.applyAnchor( skin.anchor );
		
	end
end

-------------------------------------------------------------------------------

local function onInfoPanelEvent()
	
	if event == "VARIABLES_LOADED" then

		nUI:registerSkinnedFrame( frame );
		nUI:registerScalableFrame( frame );
		
		nUI:registerSkinnedFrame( info_frame );
		nUI:registerScalableFrame( info_frame );
		
	end
end

nUI_InfoPanelSelector:SetScript( "OnEvent", onInfoPanelEvent );
nUI_InfoPanelSelector:RegisterEvent( "VARIABLES_LOADED" );
