﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

    nUI is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with nUI.  If not, see <http://www.gnu.org/licenses/>.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if not nUI_InfoPanels then nUI_InfoPanels = {}; end

local CreateFrame = CreateFrame;
local GetTime     = GetTime;

-------------------------------------------------------------------------------
-- default configuration for the Omen2 info panel

nUI_InfoPanels[nUI_INFOPANEL_OMEN2] =
{	
	enabled   = true,
	desc      = nUI_L[nUI_INFOPANEL_OMEN2],				-- player friendly name/description of the panel
	label     = nUI_L[nUI_INFOPANEL_OMEN2.."Label"],	-- label to use on the panel selection button face
	rotation  = nUI_INFOMODE_OMEN2,						-- index or position this panel appears on/in when clicking the selector button
	full_size = true;									-- this plugin requires the entire info panel port without the button bag
	
	options  =
	{
		enabled  = true,
	},
};

-------------------------------------------------------------------------------
-- master frame for the plugin

local plugin    = CreateFrame( "Frame", nUI_INFOPANEL_OMEN2, nUI_Dashboard.Anchor );
plugin.active   = true;

local function onOmenEvent()
	
	if event == "VARIABLES_LOADED" then
		
		if not IsAddOnLoaded( "Omen" ) then 
			LoadAddOn( "Omen" );
		end
		
		plugin.active = IsAddOnLoaded( "Omen" );

	end	
	
end

plugin:SetScript( "OnEvent", onOmenEvent );
plugin:RegisterEvent( "VARIABLES_LOADED" );

-------------------------------------------------------------------------------

plugin.initPanel = function( container, options )

	plugin.container = container;
	plugin.options   = options;

	if options and options.enabled then
			
		plugin.setEnabled( true );
		
	end
end

-------------------------------------------------------------------------------

plugin.sizeChanged = function( scale, height, width )
	
	local options  = plugin.options;
	
	plugin.scale = scale;

	nUI_Movers:lockFrame( OmenBarList, false, nil );
	nUI_Movers:lockFrame( OmenModuleButtons, false, nil );

	OmenBarList:SetWidth( width );
	
	if Omen.activeModule then Omen.activeModule:UpdateLayout(); end
	
	Omen:ResizeBars();
	
	nUI_Movers:lockFrame( OmenBarList, true, nil );
	nUI_Movers:lockFrame( OmenModuleButtons, true, nil );
			
end	

-------------------------------------------------------------------------------

plugin.setEnabled = function( enabled )

	if plugin.enabled ~= enabled then
		
		plugin.enabled = enabled;
		
		if not enabled then

			if plugin.saved_bar_parent then
			
				nUI_Movers:lockFrame( OmenBarList, false, nil );
				nUI_Movers:lockFrame( OmenModuleButtons, false, nil );
				
				OmenBarList:SetParent( plugin.saved_bar_parent );
				OmenBarList.Show = plugin.barShow;
				OmenBarList.Hide = plugin.barHide;
		
				OmenModuleButtons:SetScale( 1 );
				OmenModuleButtons:SetParent( plugin.buttons_parent );
				OmenModuleButtons.Show = plugin.buttonsShow;
				OmenModuleButtons.Hide = plugin.buttonHide;
				
				OmenModuleList.Config:SetParent( plugin.config_parent );
				
			end
			
		else

			-- Omen uses two windows... one to select mode and one to display the
			-- stats. Rather than manage them separately, we just link them to a 
			-- single parent frame and use that to manage them
			
			local frame  = plugin.container;
			local config = Omen.ModuleList.Config;

			if not plugin.saved_bar_parent then
				
				plugin.bar_parent = OmenBarList:GetParent();
				plugin.barShow    = OmenBarList.Show;
				plugin.barHide    = OmenBarList.Hide;
				
				plugin.buttons_parent = OmenModuleButtons:GetParent();
				plugin.buttonsShow    = OmenModuleButtons.Show;
				plugin.buttonsHide    = OmenModuleButtons.Hide;

				plugin.config_parent = config:GetParent();
				
			end
			
			OmenBarList:SetParent( frame );
			OmenBarList:Show();
			OmenBarList.Show = function() end;
			OmenBarList.Hide = function() end;
			
			OmenModuleButtons:SetParent( frame );
			OmenModuleButtons:Show();		
			OmenModuleButtons:SetScale( 0.5 );
			OmenModuleButtons.Show = function() end;
			OmenModuleButtons.Hide = function() end;
			
			-- lose the unused panels
			
			OmenTitle:Hide();
			OmenResizeGrip:Hide();
			
			-- locate the buttons frame
			
			OmenModuleButtons:ClearAllPoints();
			OmenModuleButtons:SetPoint( "BOTTOMLEFT", plugin.container, "BOTTOMLEFT", 0, 0 );
			OmenModuleButtons:SetPoint( "BOTTOMRIGHT", plugin.container, "BOTTOMRIGHT", 0, 0 );
			
			-- locate the bar frame
			
			OmenBarList:ClearAllPoints();
			OmenBarList:SetPoint( "TOPLEFT", plugin.container, "TOPLEFT", 0, 0 );
			OmenBarList:SetPoint( "TOPRIGHT", plugin.container, "TOPRIGHT", 0, 0 );
			OmenBarList:SetPoint( "BOTTOMLEFT", OmenModuleButtons, "TOPLEFT", 0, 0 );
			OmenBarList:SetPoint( "BOTTOMRIGHT", OmenModuleButtons, "TOPRIGHT", 0, 0 );			
			
			nUI_Movers:lockFrame( OmenBarList, true, nil );
			nUI_Movers:lockFrame( OmenModuleButtons, true, nil );
			
			-- Detatch the options button so we can keep it active even when the
			-- Omen panel is hidden
--[[				
			config:SetParent( anchor );
			config:SetScale( 0.42 );
			config:ClearAllPoints();
			config:SetPoint( "BOTTOM", nUI.info_frame.button, "BOTTOMRIGHT", 0, 0 )
			config:Show();
]]--				
			-- Set options to make Omen blend in with nUI visually
			
			local options = Omen.Options;

			options["Skin.Title.Hide"] = true;
			options["Skin.Modules.Hide"] = false;
			options["Lock"] = true;
			
			options["Skin.ModuleList.Background.Color.r"] = 0;
			options["Skin.ModuleList.Background.Color.g"] = 0;
			options["Skin.ModuleList.Background.Color.b"] = 0;
			options["Skin.ModuleList.Background.Color.a"] = 0;
						
			options["Skin.ModuleList.Border.Color.r"] = 0;
			options["Skin.ModuleList.Border.Color.g"] = 0;
			options["Skin.ModuleList.Border.Color.b"] = 0;
			options["Skin.ModuleList.Border.Color.a"] = 0;
			
			options["Skin.BarList.Background.Color.r"] = 0;
			options["Skin.BarList.Background.Color.g"] = 0;
			options["Skin.BarList.Background.Color.b"] = 0;
			options["Skin.BarList.Background.Color.a"] = 0;
						
			options["Skin.BarList.Border.Color.r"] = 0;
			options["Skin.BarList.Border.Color.g"] = 0;
			options["Skin.BarList.Border.Color.b"] = 0;
			options["Skin.BarList.Border.Color.a"] = 0;
			
			Omen:InjectFrameOptions( "ModuleList", Omen.configOptions.args.display.args.moduleList );
			Omen:InjectFrameOptions( "BarList", Omen.configOptions.args.display.args.barList );
					
		end				
	end			
end

-------------------------------------------------------------------------------

plugin.setSelected = function( selected )

	if selected ~= plugin.selected then

		plugin.selected = selected;
		
		if selected then
			
			
		else
			
			
		end
	end
end
