﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

    nUI is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with nUI.  If not, see <http://www.gnu.org/licenses/>.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if not nUI then nUI = {}; end
if not nUI_DefaultConfig then nUI_DefaultConfig = {}; end
if not nUI_Options then nUI_Options = {}; end

nUI_Options.bagbar = true;

-------------------------------------------------------------------------------
-- basic layout

nUI_DefaultConfig.BagBar =
{
	btn_size = 50,
	gap      = 2,
	anchor   = "BOTTOMRIGHT",
	xOfs     = 1260,
	yOfs     = 150,
};

-------------------------------------------------------------------------------
-- create the BagBar frame

nUI_BagBar = CreateFrame( "Frame", "nUI_BagBar", nUI_Dashboard.Anchor, "SecureStateHeaderTemplate" );

nUI_BagBar:SetBackdrop(
	{
		bgFile   = "Interface\\AddOns\\nUI\\Art\\nUI_BevelboxBg.blp", 
		edgeFile = "Interface\\AddOns\\nUI\\Art\\nUI_BevelboxBorder.blp", 
		tile     = true, 
		tileSize = 1, 
		edgeSize = 12, 
		insets   = {left = 0, right = 0, top = 0, bottom = 0},
	}
);

nUI_BagBar:SetBackdropColor( 0, 0, 0, 0.35 );

-------------------------------------------------------------------------------
-- button initialization

nUI_BagBar.Buttons = {};

nUI_BagBar.Buttons[1] = _G["KeyRingButton"];
nUI_BagBar.Buttons[2] = nUI_ButtonBagButton;
nUI_BagBar.Buttons[3] = _G["CharacterBag3Slot"];
nUI_BagBar.Buttons[4] = _G["CharacterBag2Slot"];
nUI_BagBar.Buttons[5] = _G["CharacterBag1Slot"];
nUI_BagBar.Buttons[6] = _G["CharacterBag0Slot"];
nUI_BagBar.Buttons[7] = _G["MainMenuBarBackpackButton"];

for i in pairs( nUI_BagBar.Buttons ) do
	
	button = nUI_BagBar.Buttons[i];
	
	button:SetParent( nUI_BagBar );

	button.nUI_CachedClearAllPoints = button.ClearAllPoints;
	button.nUI_CachedSetAllPoints   = button.SetAllPoints;
	button.nUI_CachedSetPoint       = button.SetPoint;

	button.ClearAllPoints = function() end;
	button.SetAllPoints   = function() end;
	button.SetPoint       = function() end;
	
end

-------------------------------------------------------------------------------
-- bag bar event management

local function onBagBarEvent()
	
	if event == "VARIABLES_LOADED" then
		
		nUI:patchConfig();
		nUI_BagBar:configBar();

		-- set up a slash command handler for dealing with setting the HUD's health race bar toggle
		
		local option = nUI_SlashCommands[nUI_SLASHCMD_BAGBAR];
		
		nUI_SlashCommands:setHandler( option.command,
			
			function( msg )
				
				if InCombatLockdown() then
					
					DEFAULT_CHAT_FRAME:AddMessage( nUI_L["nUI: You cannot change your bag bar's visibility while in combat. Please try again later"], 1, 0.83, 0 );
					
				else
						
					nUI_Options.bagbar = not nUI_Options.bagbar;
					
					DEFAULT_CHAT_FRAME:AddMessage( (option.message):format( nUI_Options.bagbar and nUI_L["|cFF00FF00ENABLED|r"] or nUI_L["|cFFFF0000DISABLED|r"] ), 1, 0.83, 0 );
					
					if nUI_Options.bagbar then nUI_BagBar:Show();
					else nUI_BagBar:Hide();
					end	
					
				end
			end
		);
		
	end
	
	nUI_BagBar:layoutFrame();

	if nUI_Options.bagbar then nUI_BagBar:Show();
	else nUI_BagBar:Hide();
	end
	
end

nUI_BagBar:SetScript( "OnEvent", onBagBarEvent );
nUI_BagBar:RegisterEvent( "VARIABLES_LOADED" );
nUI_BagBar:RegisterEvent( "DISPLAY_SIZE_CHANGED" );

-------------------------------------------------------------------------------
-- initialize the bag bar configuration

function nUI_BagBar:configBar( use_default )
	
	local config  = nUI_BagBarOptions or {};
	local default = nUI_DefaultConfig.BagBar;

	if use_default then
		
		config.btn_size = default.btn_size;
		config.gap      = default.gap;
		config.anchor   = default.anchor;
		config.xOfs     = default.xOfs;
		config.yOfs     = default.yOfs;
				
	else
			
		config.btn_size = tonumber( config.btn_size or default.btn_size );
		config.gap      = tonumber( config.gap or default.gap );
		config.anchor   = strupper( config.anchor or default.anchor );
		config.xOfs     = tonumber( config.xOfs or default.xOfs );
		config.yOfs     = tonumber( config.yOfs or default.yOfs );
		
	end
	
	nUI_BagBarOptions = config;
	
end

-------------------------------------------------------------------------------
-- apply the current layout configuration to the bag bar

function nUI_BagBar:layoutFrame()
				
	nUI:setScale();
			
	if nUI_BagBar.fCache then nUI_Movers:lockFrame( nUI_BagBar, false ); end
	
	local btn_size    = nUI_BagBarOptions.btn_size * nUI.scale;
	local btn_gap     = nUI_BagBarOptions.gap * nUI.scale;
	local width       = 0;
	local last_button;
	
	nUI_BagBar:SetFrameStrata( nUI_Dashboard:GetFrameStrata() );
	nUI_BagBar:SetFrameLevel( nUI_Dashboard:GetFrameLevel()+2 );
	nUI_BagBar:SetPoint( nUI_BagBarOptions.anchor, nUI_Dashboard, "CENTER", nUI_BagBarOptions.xOfs * nUI.scale, nUI_BagBarOptions.yOfs * nUI.scale );
			
	nUI_Movers:lockFrame( nUI_BagBar, true, nUI_L["Bag Bar"] );
	
	for i in pairs( nUI_BagBar.Buttons ) do
		
		local button = nUI_BagBar.Buttons[i];

		button:SetFrameStrata( nUI_BagBar:GetFrameStrata() );
		button:SetFrameLevel( nUI_BagBar:GetFrameLevel()+1 );
		button:SetScale( btn_size / button:GetHeight() );
		
		button:nUI_CachedClearAllPoints();
		
		if i == 1 then 
			button:nUI_CachedSetPoint( "TOPLEFT", nUI_BagBar, "TOPLEFT", btn_size * 0.05, -btn_size * 0.05 );
		else 
			button:nUI_CachedSetPoint( "TOPLEFT", last_button, "TOPRIGHT", btn_gap, 0 );
		end

		width = width + button:GetWidth() * button:GetScale() + (i > 1 and btn_gap or 0);

		last_button = button;
	end		
	
	nUI_BagBar:SetHeight( btn_size * 1.1 );
	nUI_BagBar:SetWidth( width + btn_size * 0.05 );
		
end
