﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

    nUI is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with nUI.  If not, see <http://www.gnu.org/licenses/>.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if not nUI_Data then nUI_Data = {}; end
if not nUI_Data.MoverAnchors then nUI_Data.MoverAnchors = {}; end

local MoverAnchors = nUI_Data.MoverAnchors;

-------------------------------------------------------------------------------
-- frame mover event management

nUI_Movers           = CreateFrame( "Frame", "nUI_MoverEvents", WorldFrame );
nUI_Movers.FrameList = {};

local function onMoversEvent()

	if event == "PLAYER_LOGOUT" then
		
		for mover_name in pairs( nUI_Data.MoverAnchors ) do
			
			if not nUI_Data.MoverAnchors[mover_name].user_placed then
				nUI_Data.MoverAnchors[mover_name] = nil;
			end
		end
		
	elseif event == "PLAYER_LOGIN" then
			
		nUI:setScale();

		-- initialize the slash command handler for selecting the mover state
		
		local option = nUI_SlashCommands[nUI_SLASHCMD_MOVERS];
		
		nUI_SlashCommands:setHandler( option.command,
		
			function()

				if not nUI_Movers.enabled then nUI_Movers.enabled = true;
				else nUI_Movers.enabled = false;
				end
			
				DEFAULT_CHAT_FRAME:AddMessage( (option.message):format(nUI_Movers.enabled and nUI_L["|cFF00FF00ENABLED|r"] or nUI_L["|cFFFF0000DISABLED|r"]), 1, 0.83, 0 );
				
				for i in pairs( nUI_Movers.FrameList ) do
					
					nUI_Movers:enableDrag( nUI_Movers.FrameList[i], nUI_Movers.enabled );
					
				end
			end
		);
		
		-- create a mover for the capture bars
		
		local frame = WorldStateCaptureBar1;
		local mover = nUI_Data.MoverAnchors["nUI_CaptureBarMover"];
		
		nUI_CaptureBarMover = CreateFrame( "Frame", "nUI_CaptureBarMover", UIParent );
		nUI_CaptureBarMover:SetWidth( 173 );
		nUI_CaptureBarMover:SetHeight( 26 );
		
		if not mover then
			nUI_CaptureBarMover:SetPoint( "TOPRIGHT", UIParent, "TOPRIGHT", -10, -20 );
		else
			for i in pairs( mover.Point ) do
				local point = mover.Point[i];
				nUI_CaptureBarMover:SetPoint( point.anchor, point.relative_to, point.relative_pt, point.xOfs, point.yOfs );
			end
		end
		
		nUI_CaptureBarMover:SetScript( "OnEvent", 
			function()	
				if event == "UPDATE_WORLD_STATES" then
					local last_frame;
					
					for i=1,NUM_EXTENDED_UI_FRAMES do
						local frame = _G["WorldStateCaptureBar"..i];				
						
						if not frame.fCache then nUI_Movers:lockFrame( frame, true, nil ); end					
						
						frame:fCache_ClearAllPoints();
						
						if i == 1 then
							frame:fCache_SetPoint( "CENTER", nUI_CaptureBarMover, "CENTER", 0, 0 );
						else
							frame:fCache_SetPoint( "TOP", last_frame, "BOTTOM", 0, 0 );
						end
						
						last_frame = frame;
					end
				end
			end
		);
	
		nUI_Movers:lockFrame( nUI_CaptureBarMover, true, nUI_L["Capture Bar"] );
		nUI_CaptureBarMover:RegisterEvent( "UPDATE_WORLD_STATES" );	
		
		-- standard Bliz frames we want to  move
		
		QuestWatchFrame:ClearAllPoints();
		QuestWatchFrame:SetPoint( "RIGHT", UIParent, "RIGHT", -5, 256 * nUI.scale );	
		nUI_Movers:lockFrame( QuestWatchFrame, true, nUI_L["Watched Quests"] );
	
		QuestTimerFrame:ClearAllPoints();
		QuestTimerFrame:SetPoint( "TOP", nUI_TopBars, "BOTTOM", 0, -5 );
		nUI_Movers:lockFrame( QuestTimerFrame, true, nUI_L["Quest Timer"] );
		
		DurabilityFrame:ClearAllPoints();
		DurabilityFrame:SetPoint( "TOP", QuestTimerFrame, "BOTTOM", 0, -5 );	
		nUI_Movers:lockFrame( DurabilityFrame, true, nUI_L["Equipment Durability"] );
	
		WorldStateAlwaysUpFrame:ClearAllPoints();
		WorldStateAlwaysUpFrame:SetPoint( "TOPLEFT", nUI_CaptureBarMover, "BOTTOMLEFT", 0, -10 );
		nUI_Movers:lockFrame( WorldStateAlwaysUpFrame, true, nUI_L["PvP Objectives"] );
	
		-- Bliz frames we want the player to be able to move any time
	
		LoadAddOn( "Blizzard_AuctionUI" );
		LoadAddOn( "Blizzard_CraftUI" );
		LoadAddOn( "Blizzard_GuildBankUI" );
		LoadAddOn( "Blizzard_InspectUI" );
		LoadAddOn( "Blizzard_TalentUI" );
		LoadAddOn( "Blizzard_TradeSkillUI" );
	
		if AuctionFrame then nUI_Movers:movableFrame( AuctionFrame ); end
		if CraftFrame then nUI_Movers:movableFrame( CraftFrame ); end
		if GuildBankFrame then nUI_Movers:movableFrame( GuildBankFrame ); end
		if InspectFrame then nUI_Movers:movableFrame( InspectFrame ); end
		if PlayerTalentFrame then nUI_Movers:movableFrame( PlayerTalentFrame ); end
		if TradeSkillFrame then nUI_Movers:movableFrame( TradeSkillFrame ); end
		
		nUI_Movers:movableFrame( ArenaFrame );
		nUI_Movers:movableFrame( BattlefieldFrame );
		nUI_Movers:movableFrame( ChannelFrame, FriendsFrame );
		nUI_Movers:movableFrame( ChatConfigFrame );
		nUI_Movers:movableFrame( FriendsFrame );
		nUI_Movers:movableFrame( GossipFrame );
		nUI_Movers:movableFrame( GuildRegistrarFrame );
		nUI_Movers:movableFrame( HonorFrame, CharacterFrame );
		nUI_Movers:movableFrame( LFGFrame, FriendsFrame ); -----------
		nUI_Movers:movableFrame( MailFrame );
		nUI_Movers:movableFrame( MerchantFrame );
		nUI_Movers:movableFrame( PaperDollFrame, CharacterFrame );
		nUI_Movers:movableFrame( PetitionFrame );
		nUI_Movers:movableFrame( PetStableFrame );
		nUI_Movers:movableFrame( PVPFrame, CharacterFrame );
		nUI_Movers:movableFrame( QuestFrame );
		nUI_Movers:movableFrame( QuestLogFrame );
		nUI_Movers:movableFrame( RaidFrame, FriendsFrame );
		nUI_Movers:movableFrame( ReputationFrame, CharacterFrame );
		nUI_Movers:movableFrame( SendMailFrame, MailFrame );
		nUI_Movers:movableFrame( SkillFrame, CharacterFrame );
		nUI_Movers:movableFrame( SpellBookFrame );
		nUI_Movers:movableFrame( TaxiFrame );
		nUI_Movers:movableFrame( TradeFrame );
	
	end
end

nUI_Movers:SetScript( "OnEvent", onMoversEvent );
nUI_Movers:RegisterEvent( "PLAYER_LOGIN" );
nUI_Movers:RegisterEvent( "PLAYER_LOGOUT" );

-------------------------------------------------------------------------------

function nUI_Movers:movableFrame( frame, parent )
	
	frame:EnableMouse( true );
	frame:SetMovable( true );
	frame:RegisterForDrag( "LeftButton" );
	
	frame:SetScript( "OnEnter", 
		function()
			if not InCombatLockdown() then
				GameTooltip:SetOwner( frame );
				GameTooltip:SetText( nUI_L["Left-click and drag to move this frame"] );
				GameTooltip:Show();
			end
		end
	);
	
	frame:SetScript( "OnLeave",
		function()
			GameTooltip:Hide();
		end
	);
	
	frame:SetScript( "OnDragStart",
		function()			
			if not InCombatLockdown() then
				frame.is_moving = true;
				if parent then parent:StartMoving() 
				else frame:StartMoving();
				end
			end
		end
	);
	
	frame:SetScript( "OnDragStop",
		function()
			if frame.is_moving then
				frame.is_moving = false;
				if parent then parent:StopMovingOrSizing();
				else frame:StopMovingOrSizing();
				end
			end
		end
	);
			
end

-------------------------------------------------------------------------------

function nUI_Movers:lockFrame( frame, mode, overlay )

	local new_mover = false;
	
	-- if we don't already have a frame cache for this frame, initialize it
	
	if not frame.fCache then	

		new_mover                   = true;		
		frame.fCache                = {};		
		frame.fCache_SetAllPoints   = frame.SetAllPoints;
		frame.fCache_SetPoint       = frame.SetPoint;
		frame.fCache_ClearAllPoints = frame.ClearAllPoints;

	end
	
	-- lock the frame to prevent anyone else from moving it
	
	if not frame.fCache.locked and mode then
		
		frame.fCache.locked  = true;
		frame.SetAllPoints   = function() end;
		frame.SetPoint       = function() end;
		frame.ClearAllPoints = function() end;
	
	-- make the frame moveable again
	
	elseif frame.fCache.locked and not mode then

		frame.fCache.locked  = false;
		frame.SetAllPoints   = frame.fCache_SetAllPoints;
		frame.SetPoint       = frame.fCache_SetPoint;
		frame.ClearAllPoints = frame.fCache_ClearAllPoints;
		
	end

	-- if this is a new mover, set up the overlay for it
	
	if new_mover then
		
		local frame_name = frame:GetName();
		local mover      = nUI_Data.MoverAnchors[frame_name];		

		-- if this frame has a visible overlay, then add it to the list of 
		-- movers we enable/disable on the "/nui movers" slash command

		if overlay then
			if not nUI_Movers.FrameList[frame_name] then 
				nUI_Movers.FrameList[frame_name] = frame; 
			end
		end
		
		-- record the default location for the frame
		
		frame.fCache.DefaultPoints = {};
		
		for i=1,frame:GetNumPoints() do
			
			local point = {};

			point.anchor, point.relative_to, point.relative_pt, point.xOfs, point.yOfs = frame:GetPoint( i );
			point.relative_to = point.relative_to and point.relative_to.GetName and point.relative_to:GetName() or point_relative_to;
			
			frame.fCache.DefaultPoints[i] = point;
			
		end
		
		-- create a default mover in the config if we don't have one yet
		
		if not mover or not mover.user_placed then
			
			mover = {};
			mover.Point = {};
			mover.user_placed = false;
			
			for i in pairs( frame.fCache.DefaultPoints ) do
				mover.Point[i] = frame.fCache.DefaultPoints[i];
			end
			
			nUI_Data.MoverAnchors[frame_name] = mover;
			
		end

		frame.fCache.label = overlay;	
		frame.fCache.drag  = true;
		
		-- create an overlay mover frame to show the user and/or for dragging the frame
	
		frame.fCache.overlay = CreateFrame( "Button", frame:GetName().."_MoverOverlay", frame:GetParent() );
		
		frame.fCache.overlay:SetFrameStrata( frame:GetFrameStrata() );
		frame.fCache.overlay:SetFrameLevel( frame:GetFrameLevel()+5 );
		
		frame.fCache.overlay:SetScale( frame:GetScale() );
		frame.fCache.overlay:SetWidth( max( frame:GetWidth(), 25 ) );
		frame.fCache.overlay:SetHeight( max( frame:GetHeight(), 25 ) );

		for i in pairs( mover.Point ) do
			local point = mover.Point[i];
			frame.fCache.overlay:SetPoint( point.anchor, point.relative_to, point.relative_pt, point.xOfs, point.yOfs );
		end
		
		frame.fCache.overlay:EnableMouse( true );
		frame.fCache.overlay:RegisterForDrag();
		frame.fCache.overlay:RegisterForClicks();
		frame.fCache.overlay:SetScript( "OnDragStart", function() nUI_Movers:dragFrame( frame, true ); end );
		frame.fCache.overlay:SetScript( "OnDragStop", function() nUI_Movers:dragFrame( frame, false ); end );
		frame.fCache.overlay:SetScript( "OnClick", function() nUI_Movers:resetFrame( frame ); end );
		frame.fCache.overlay:SetMovable( true );

		-- if we want the mover to be visible, creat a texture for it
		
		if overlay then
			
			frame.fCache.overlay:SetBackdrop(
				{
					bgFile   = "Interface\\AddOns\\nUI\\Art\\nUI_BevelboxBg.blp", 
					edgeFile = "Interface\\AddOns\\nUI\\Art\\nUI_BevelboxBorder.blp", 
					tile     = true, 
					tileSize = 1, 
					edgeSize = 10, 
					insets   = {left = 0, right = 0, top = 0, bottom = 0},
				}
			);
		
			frame.fCache.overlay:SetBackdropColor( 1, 0.75, 0.75, 1 );
			frame.fCache.overlay:SetBackdropBorderColor( 1, 0.75, 0.75, 1 );
			
			frame.fCache.overlay.texture = frame.fCache.overlay:CreateTexture();
			frame.fCache.overlay.texture:SetAllPoints( frame.fCache.overlay );
			frame.fCache.overlay.texture:SetTexture( 1, 0.5, 0.5, 0.5 );
		
		end

		-- lock the frame to the overlay
		
		frame:fCache_ClearAllPoints();
		
		for i in pairs( mover.Point ) do
			local point = mover.Point[i];
			frame:fCache_SetPoint( point.anchor, frame.fCache.overlay, point.anchor, 0, 0 );
		end
		
		-- disable any other movers that may be attached to the frame
		
		frame:RegisterForDrag();
		frame:SetScript( "OnDragStart", nil );
		frame:SetScript( "OnDragStop", nil );

		-- disable dragging
		
		self:enableDrag( frame, false );
	end	
end

-------------------------------------------------------------------------------

function nUI_Movers:enableDrag( frame, mode )

	if mode then

		if not frame.fCache.moving and not frame.fCache.drag then
			
			frame.fCache.drag = true;
			frame.fCache.overlay:SetWidth( max( frame:GetWidth(), 25 ) );
			frame.fCache.overlay:SetHeight( max( frame:GetHeight(), 25 ) );
			frame.fCache.overlay:SetScale( frame:GetScale() );
			frame.fCache.overlay:Show();
			frame.fCache.overlay:RegisterForDrag( "LeftButton" );
			frame.fCache.overlay:RegisterForClicks( "RightButtonUp" );
			
			frame.fCache.overlay:SetScript( "OnEnter", 
				function() 
					
					GameTooltip:SetOwner( frame.fCache.overlay ); 
					GameTooltip:SetText( nUI_L["Left click and drag to move <frame label>"]:format( frame.fCache.label ), 1, 0.83, 0 ); 
					
					if nUI_Data.MoverAnchors[frame:GetName()].user_placed then
						GameTooltip:AddLine( nUI_L["Right click to reset to the default location"], 1, 0.83, 0 );
					end
					
					GameTooltip:Show();
					
				end 
			);
			
			frame.fCache.overlay:SetScript( "OnLeave", function() GameTooltip:Hide(); end );
			
		end
			
	else
		
		if not frame.fCache.moving and frame.fCache.drag then
			
			frame.fCache.drag = false;
			frame.fCache.overlay:Hide();
			frame.fCache.overlay:RegisterForClicks();
			frame.fCache.overlay:RegisterForDrag();
			frame.fCache.overlay:SetScript( "OnEnter", function() end );
			frame.fCache.overlay:SetScript( "OnLeave", function() end );
		end		
	end
end

-------------------------------------------------------------------------------

function nUI_Movers:dragFrame( frame, mode )
	
	if mode and frame.fCache.drag and not frame.fCache.moving then
		
		frame.fCache.overlay:StartMoving();
		frame.fCache.moving = true;
		GameTooltip:Hide();
		
	elseif not mode and frame.fCache.drag and frame.fCache.moving then
		
		local mover   = nUI_Data.MoverAnchors[frame:GetName()];
		local overlay = frame.fCache.overlay;
		
		overlay:StopMovingOrSizing();
		frame.fCache.moving = false;

		mover.Point = {};
		mover.user_placed = true;
		
		for i=1,overlay:GetNumPoints() do
			
			local point = {};

			point.anchor, point.relative_to, point.relative_pt, point.xOfs, point.yOfs = overlay:GetPoint( i );
			point.relative_to = point.relative_to and point.relative_to:GetName() or point_relative_to;
			
			mover.Point[i] = point;
			
		end
	end
end

-------------------------------------------------------------------------------

function nUI_Movers:resetFrame( frame )
	
	local mover       = nUI_Data.MoverAnchors[frame:GetName()];
	local overlay     = frame.fCache.overlay;

	for i in pairs( frame.fCache.DefaultPoints ) do
		mover.Point[i] = frame.fCache.DefaultPoints[i];
	end

	mover.user_placed = false;
	
	-- lock the frame to the overlay
	
	frame.fCache.overlay:ClearAllPoints();
	
	for i in pairs( mover.Point ) do
		
		local point = mover.Point[i];						
		frame.fCache.overlay:SetPoint( point.anchor, point.relative_to, point.relative_pt, point.xOfs, point.yOfs );
		
	end
end
