﻿--[[

Copyright (C) 2004 by neuron
aagaande AT gmail DOT com

This program is free software; you can redistribute it and--or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

]]

local nQuestLog = nQuestLog

local REVISION = tonumber(("$Revision: 164 $"):match("%d+"))
if ( nQuestLog.revision < REVISION ) then
	nQuestLog.version = (nQuestLog.versionstring):format(REVISION)
	nQuestLog.revision = REVISION
	nQuestLog.date = ("$Date: 2007-12-16 16:45:41 +0000 (Sun, 16 Dec 2007) $"):match("%d%d%d%d%-%d%d%-%d%d")
end

--Load localization
local L = AceLibrary("AceLocale-2.2"):new("nQuestLog")

nQuestLog.mainMenu = { type = "group",
	name = nQuestLog.name,
	args = {
		show = { order = 10, type = "toggle",
			name = L["Minion visible"],
			desc = L["Note that minion will not show if you are not tracking any quests."],
			get = function() return nQuestLog.db.char.visible end,
			set = function(v)
				nQuestLog.db.char.visible = v
				nQuestLog:ToggleVisible(v)
			end },
		lock = { order = 20, type = "toggle",
			name = L["Minion locked"],
			desc = L["Minion must be locked for proper functionality!"],
			get = function() return nQuestLog.db.profile.minionLocked end,
			set = function(v) nQuestLog.db.profile.minionLocked = v end },
		expand = { order = 30, type = "execute",
			name = L["Expand/Collapse minion"], desc = L["expandCollapseDesc"],
			func = function() nQuestLog:ExpandCollapse() end },
		Quests = { order = 40, type = "group",
			name = L["Watched quests"], desc = L["Listing all quests"],
			cmdHidden = true,
			args = {} },
		Objectives = { order = 50, type = "group",
			name = L["Show/Hide objectives"], desc = L["Listing all watched quests"],
			cmdHidden = true,
			args = {} },
		mainSpacer = { order = 60, type = "header" },
		mainHeader = { order = 70, type = "header", name = L["Main settings"] },
		minion = { order = 80, type = "group",
			name = L["Minion"], desc = L["Minion"].." "..L["settings"],
			cmdHidden = true,
			args = {
				header = { order = 10, type = "group",
					name = L["Header"], desc = L["minionHeader"],
					args = {
						enabled = { order = 10, type = "toggle",
							name = L["Enabled"], desc = L["minionHeader"],
							get = function() return nQuestLog.db.profile.minionHeader end,
							set = function(v)
								nQuestLog.db.profile.minionHeader = v
								nQuestLog:Refresh()
							end },
						fontSize = { order = 20, type = "range",
							name = L["Font size"], desc = L["Change font size for minion header"],
							min = 6, max = 24, step = 1,
							disabled = function() return not nQuestLog.db.profile.minionHeader end,
							get = function() return nQuestLog.db.profile.minionHeaderFontSize end,
							set = function(v)
								nQuestLog.db.profile.minionHeaderFontSize = v
								nQuestLog:Refresh()
							end },
						text = { order = 30, type = "text",
							name = L["Title text"], desc = L["minionHeaderTitle"],
							usage = "<nQuestLog>",
							disabled = function() return not nQuestLog.db.profile.minionHeader end,
							get = function() return nQuestLog.db.profile.minionHeaderTitle end,
							set = function(v)
								nQuestLog.db.profile.minionHeaderText = v
								nQuestLog:Refresh()
							end },
						showDone = { order = 40, type = "toggle",
							name = L["Show completed quests"], desc = L["showQuestsDone"],
							disabled = function() return not nQuestLog.db.profile.minionHeader end,
							get = function() return nQuestLog.db.profile.minionHeaderQuestsDone end,
							set = function(v)
								nQuestLog.db.profile.minionHeaderQuestsDone = v
								nQuestLog:Refresh()
							end },
						showHidden = { order = 50, type = "toggle",
							name = L["Show hidden quests"], desc = L["showQuestsHidden"],
							disabled = function() return not nQuestLog.db.profile.minionHeader end,
							get = function() return nQuestLog.db.profile.minionHeaderQuestsHidden end,
							set = function(v)
								nQuestLog.db.profile.minionHeaderQuestsHidden = v
								nQuestLog:Refresh()
							end },
						showActive = { order = 60, type = "toggle",
							name = L["Show active quests"], desc = L["showQuestsActive"],
							disabled = function() return not nQuestLog.db.profile.minionHeader end,
							get = function() return nQuestLog.db.profile.minionHeaderQuestsActive end,
							set = function(v)
								nQuestLog.db.profile.minionHeaderQuestsActive = v
								nQuestLog:Refresh()
							end },
						showMax = { order = 70, type = "toggle",
							name = L["Show max quests"], desc = L["showQuestsMax"],
							disabled = function() return not nQuestLog.db.profile.minionHeader end,
							get = function() return nQuestLog.db.profile.minionHeaderQuestsMax end,
							set = function(v)
								nQuestLog.db.profile.minionHeaderQuestsMax = v
								nQuestLog:Refresh()
							end } } },
				anchor = { order = 20, type = "text",
					name = L["minionAnchor"], desc = L["minionAnchorDesc"],
					validate = { TOPLEFT = L["TOPLEFT"], TOPRIGHT = L["TOPRIGHT"],
						BOTTOMLEFT = L["BOTTOMLEFT"], BOTTOMRIGHT = L["BOTTOMRIGHT"] },
					get = function() return nQuestLog.db.profile.minionAnchor end,
					set = function(v)
						nQuestLog.db.profile.minionAnchor = v
						nQuestLog:SavePosition()
						nQuestLog:SetPosition()
					end },
				autoWidth = { order = 30, type = "toggle",
					name = L["minionAutoWidth"], desc = L["minionAutoWidthDesc"],
					get = function() return nQuestLog.db.profile.minionAutoWidth end,
					set = function(v)
						nQuestLog.db.profile.minionAutoWidth = v
						nQuestLog:Refresh()
					end },
				width = { order = 40, type = "range",
					name = L["Width"], desc = L["Set width of frame"],
					hidden = function() return nQuestLog.db.profile.minionAutoWidth end,
					min = 50, max = 500, step = 1,
					get = function() return nQuestLog.db.profile.minionWidth end,
					set = function(v)
						nQuestLog.db.profile.minionWidth = v
						nQuestLog:ToggleVisible(true)
					end },
				autoFade = { order = 50, type = "group",
					name = L["Auto fade"], desc = L["Auto fade"],
					args = {
						fadeIn = { order = 10, type = "range",
							name = L["minionFade"]:format(L["Fade-in"]),
							desc = L["minionFadeDesc"]:format(L["minionFadeIsOver"], L["increase"]),
							min = 0, max = 1, step = 0.01, isPercent = true,
							get = function() return nQuestLog.db.profile.minionFadeIn end,
							set = function(v) nQuestLog.db.profile.minionFadeIn = v end },
						fadeInTime = { order = 20, type = "range",
							name = L["minionFadeTime"]:format(L["Fade-in"]),
							desc = L["minionFadeTimeDesc"]:format(L["increase"], L["Fade-in"]),
							min = 0, max = 30, step = 0.1,
							get = function() return nQuestLog.db.profile.minionFadeInTime end,
							set = function(v) nQuestLog.db.profile.minionFadeInTime = v end },
						fadeOut = { order = 30, type = "range",
							name = L["minionFade"]:format(L["Fade-out"]),
							desc = L["minionFadeDesc"]:format(L["minionFadeLeaves"], L["decrease"]),
							min = 0, max = 1, step = 0.01, isPercent = true,
							get = function() return nQuestLog.db.profile.minionFadeOut end,
							set = function(v)
								nQuestLog.db.profile.minionFadeOut = v
								nQuestLogFrame:SetAlpha(v)
							end },
						fadeOutTime = { order = 40, type = "range",
							name = L["minionFadeTime"]:format(L["Fade-out"]),
							desc = L["minionFadeTimeDesc"]:format(L["decrease"], L["Fade-out"]),
							min = 0, max = 30, step = 0.1,
							get = function() return nQuestLog.db.profile.minionFadeOutTime end,
							set = function(v) nQuestLog.db.profile.minionFadeOutTime = v end },
						fadeOutDelay = { order = 50, type = "range",
							name = L["minionFadeDelay"]:format(L["Fade-out"]),
							desc = L["minionFadeDelayDesc"],
							min = 0, max = 120, step = 1,
							get = function() return nQuestLog.db.profile.minionFadeOutDelay end,
							set = function(v) nQuestLog.db.profile.minionFadeOutDelay = v end } } },
				fontOutline = { order = 60, type = "toggle",
					name = L["Font outline"], desc = L["Add outline to minion font"],
					get = function() return nQuestLog.db.profile.fontOutline end,
					set = function(v)
						nQuestLog.db.profile.fontOutline = v
						nQuestLog:Refresh()
					end } } },
		zone = { order = 90, type = "group",
			name = L["Zone"], desc = L["Zone"].." "..L["settings"],
			cmdHidden = true,
			args = {
				showEmpty = { order = 10, type = "toggle",
					name = L["Show empty zones"],
					desc = L["Show hidden zones where you are not tracking any quests"],
					get = function() return nQuestLog.db.profile.showEmptyZones end,
					set = function(v)
						nQuestLog.db.profile.showEmptyZones = v
						nQuestLog:RefreshTracker()
					end },
				showQuestVisCount = { order = 20, type = "toggle",
					name = L["Show visible/total quests for a zone"],
					desc = L["Shows <Zone> with X/X visible"],
					get = function() return nQuestLog.db.profile.showZoneVisibleStatus end,
					set = function(v)
						nQuestLog.db.profile.showZoneVisibleStatus = v
						nQuestLog:RefreshTracker()
					end },
				showLevel = { order = 30, type = "toggle",
					name = L["Show zone level"], desc = L["Show zone level"],
					get = function() return nQuestLog.db.profile.showZoneLevel end,
					set = function(v)
						nQuestLog.db.profile.showZoneLevel = v
						nQuestLog:RefreshTracker()
					end },
				fontSize = { order = 40, type = "range",
					name = L["Font size"], desc = L["Change font size for zone"],
					min = 6, max = 24, step = 1,
					get = function() return nQuestLog.db.profile.fontSizeZone end,
					set = function(v)
						nQuestLog.db.profile.fontSizeZone = v
						nQuestLog:RefreshTracker()
					end },
				padding = { order = 50, type = "range",
					name = L["Padding"], desc = L["Change padding between zones"],
					min = 0, max = 10, step = 1,
					get = function() return nQuestLog.db.profile.zonePadding end,
					set = function(v)
						nQuestLog.db.profile.zonePadding = v
						nQuestLog:RefreshTracker()
					end } } },
		quest = { order = 100, type = "group",
			name = L["Quest"], desc = L["Quest"].." "..L["settings"],
			cmdHidden = true,
			args = {
				showProgress = { order = 10, type = "toggle",
					name = L["Show quest progress"],
					desc = L["Show quest progress"].." ("..L["%s items total"]:format("1/7")..")",
					get = function() return nQuestLog.db.profile.showQuestProgress end,
					set = function(v)
						nQuestLog.db.profile.showQuestProgress = v
						nQuestLog:RefreshTracker()
					end },
				fontSize = { order = 20, type = "range",
					name = L["Font size"], desc = L["Change font size for quests"],
					min = 6, max = 24, step = 1,
					get = function() return nQuestLog.db.profile.fontSize end,
					set = function(v)
						nQuestLog.db.profile.fontSize = v
						nQuestLog:RefreshTracker()
					end },
				padding = { order = 30, type = "range",
					name = L["Padding"], desc = L["Change padding between quests"],
					min = 0, max = 10, step = 1,
					get = function() return nQuestLog.db.profile.questPadding end,
					set = function(v)
						nQuestLog.db.profile.questPadding = v
						nQuestLog:RefreshTracker()
					end },
				autoShowSpacer = { order = 40, type = "header" },
				autoShowHeader = { order = 50, type = "header", name = L["Auto show"] },
				trackNewQuests = { order = 60, type = "toggle",
					name = L["New quests"], desc = L["Auto show new quests in minion"],
					get = function() return nQuestLog.db.profile.trackNewQuests end,
					set = function(v) nQuestLog.db.profile.trackNewQuests = v end },
				trackWhenLooting = { order = 70, type = "toggle",
					name = L["When looting quest item"],
					desc = L["Auto show hidden quests when you loot a quest item for it"],
					get = function() return nQuestLog.db.profile.trackWhenLooting end,
					set = function(v) nQuestLog.db.profile.trackWhenLooting = v end } } },
		objs = { order = 110, type = "group", name = L["Quest objectives"],
			desc = L["Quest objectives"].." "..L["settings"],
			cmdHidden = true,
			args = {
				hide = { order = 10, type = "toggle",
					name = L["hideObjs"], desc = L["hideObjsDesc"],
					get = function() return nQuestLog.db.profile.hideAllObjectives end,
					set = function(v)
						nQuestLog.db.profile.hideAllObjectives = v
						nQuestLog:RefreshTracker()
					end },
				hideCompleted = { order = 20, type = "toggle",
					name = L["hideCompletedObjs"], desc = L["hideCompletedObjsDesc"],
					get = function() return nQuestLog.db.profile.hideCompletedObjectives end,
					set = function(v)
						nQuestLog.db.profile.hideCompletedObjectives = v
						nQuestLog:RefreshTracker()
					end },
				showDescNoObjs = { order = 30, type = "toggle",
					name = L["showDescNoObjs"], desc = L["showDescNoObjsDesc"],
					get = function() return nQuestLog.db.profile.showShortWhenNoObjectives end,
					set = function(v)
						nQuestLog.db.profile.showShortWhenNoObjectives = v
						nQuestLog:RefreshTracker()
					end } } },
		reset = { order = -110, type = "execute",
			name = L["Reset minion position"],
			desc = L["Resets the position of the minion to the center of the screen"],
			confirm = L["minionResetConfirm"],
			func = function() nQuestLog:ResetPosition() end },
		endSpacer = { order = -100, type = "header" } } }
