﻿--[[

Copyright (C) 2004 by neuron
aagaande AT gmail DOT com

This program is free software; you can redistribute it and--or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

]]

local nQuestLog = nQuestLog

local REVISION = tonumber(("$Revision: 148 $"):match("%d+"))
if ( nQuestLog.revision < REVISION ) then
	nQuestLog.version = (nQuestLog.versionstring):format(REVISION)
	nQuestLog.revision = REVISION
	nQuestLog.date = ("$Date: 2007-12-03 07:06:08 +0000 (Mon, 03 Dec 2007) $"):match("%d%d%d%d%-%d%d%-%d%d")
end

--Load localization
local L = AceLibrary("AceLocale-2.2"):new("nQuestLog")

function nQuestLog:LoadModules()
	--Sets generic settings for all modules
	for name, module in self:IterateModules() do
		module.db = self:AcquireDBNamespace(name)
		module.core = self
		module:OnModuleLoad()
		if ( module.db.profile.enabled ) then
			module:ToggleEnabled(true)
		end
	end
end

--menu argument is the menu to add all settings to
function nQuestLog:AddModuleSettings(menu)
--function nQuestLog:MakeSettingsMenu(menu)
	menu.args["ModuleSettingsSpacer"] = { order = 1000, type = "header" }
	menu.args["ModuleSettingsHeader"] = { order = 1001, type = "header", name = L["Module settings"] }
	for name, module in self:IterateModules() do
		local subMenu = { order = 1100, type = "toggle",
			name = module.menuName, desc = module.description,
			cmdHidden = true,
			get = function() return self:IsModuleEnabled(name) end,
			set = function(v) self:GetModule(name):ToggleEnabled(v) end }
		if ( module.GetMenu ) then
			subMenu = module:GetMenu(subMenu)
		end
		menu.args[name] = subMenu
	end
	return menu
end

function nQuestLog:IsModuleEnabled(name)
	if ( self:HasModule(name) ) then
		if ( self:GetModule(name):GetEnabled() ) then
			return true
		end
	end
	return false
end

------------------------------------------------------
--		ModulePrototypes							--
------------------------------------------------------

function nQuestLog.modulePrototype:GetEnabled()
	return self.db.profile.enabled
end

function nQuestLog.modulePrototype:ToggleEnabled(v)
	self.db.profile.enabled = v
	self.core:Refresh()
end

------------------------------------------------------
--		Functions to call often-used modules		--
------------------------------------------------------

function nQuestLog:Colorize(text, variable, range, zone, level)
	if ( self:IsModuleEnabled("Coloring") ) then
		return self:GetModule("Coloring"):Colorize(text, variable, range, zone, level)
	end
	return text
end

function nQuestLog:GetColor(variable)
	if ( self:IsModuleEnabled("Coloring") ) then
		return self:GetModule("Coloring"):GetColor(variable)
	end
	return { r = 255, g = 255, b = 255, a = 1 }
end

function nQuestLog:ShouldHighlight(title)
	if ( self:IsModuleEnabled("Highlight") ) then
		return self:GetModule("Highlight"):ShouldHighlight(title)
	end
end

function nQuestLog:ShouldHighlightZone(zone)
	if ( self:IsModuleEnabled("Highlight") ) then
		return self:GetModule("Highlight"):ShouldHighlightZone(zone)
	end
end

function nQuestLog:ShouldShowObjective(title, got, needed)
	--Hide completed objectives even if we override
	if ( self.db.profile.hideCompletedObjectives ) and ( got ) and ( got == needed ) then
		return false
	else
		local objShow = true
		--Hide objective if "Hide all objectives" is checked
		if ( self.db.profile.hideAllObjectives ) then
			objShow = false
		end
		--Show/hide manually watched/hidden objectives
		if ( self.db.char.watchedObjectives[title] ~= nil ) then
			objShow = self.db.char.watchedObjectives[title]
		end
		--If the SmartVisibility module is enabled
		if ( self:IsModuleEnabled("SmartVisibility") ) then
			--Show/hide objective based on SmartVisibility logic
			local objSmartShow = self:GetModule("SmartVisibility"):ShouldShowObjective(title)
			if ( objSmartShow ~= nil ) then
				objShow = objSmartShow
			end
		end
		return objShow
	end
end

function nQuestLog:ShowQuestToolTip(id)
	if ( self:IsModuleEnabled("Tooltips") ) then
		return self:GetModule("Tooltips"):ShowQuestToolTip(id)
	end
end

function nQuestLog:ShowUnlockedToolTip()
	if ( self:IsModuleEnabled("Tooltips") ) then
		return self:GetModule("Tooltips"):ShowUnlockedToolTip()
	end
end

function nQuestLog:ShowZoneToolTip(zone)
	if ( self:IsModuleEnabled("Tooltips") ) then
		return self:GetModule("Tooltips"):ShowZoneToolTip(zone)
	end
end
