﻿--[[

Copyright (C) 2004 by neuron
aagaande AT gmail DOT com

This program is free software; you can redistribute it and--or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

]]

--Declare nQuestLogFuBar libraries, then add to local namespace
nQuestLogFuBar = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceHook-2.1", "FuBarPlugin-2.0")
local nQuestLog, nQuestLogFuBar = nQuestLog, nQuestLogFuBar

local REVISION = tonumber(("$Revision: 180 $"):match("%d+"))
if ( nQuestLog.revision < REVISION ) then
	nQuestLog.version = (nQuestLog.versionstring):format(REVISION)
	nQuestLog.revision = REVISION
	nQuestLog.date = ("$Date: 2008-04-23 05:00:35 +0000 (Wed, 23 Apr 2008) $"):match("%d%d%d%d%-%d%d%-%d%d")
end
nQuestLogFuBar.name = nQuestLog.name
nQuestLogFuBar.version = nQuestLog.version
nQuestLogFuBar.revision = nQuestLog.revision
nQuestLogFuBar.date = nQuestLog.date

--Load libraries
local Crayon = LibStub("LibCrayon-3.0")
local Quixote = AceLibrary("Quixote-1.0")
local Tablet = AceLibrary("Tablet-2.0")
local Waterfall = AceLibrary:HasInstance("Waterfall-1.0") and AceLibrary("Waterfall-1.0")

--Load localization
local L = AceLibrary("AceLocale-2.2"):new("nQuestLog")

local RED = "|cFFFF0000"
local GREEN = "|cFF00FF00"
local WHITE = "|cFFFFFFFF"
local ENDCOLOR = "|r"
local NEWLINE = "\n"

--Define nQuestLog FuBar options
nQuestLogFuBar.blizzardTooltip = false
nQuestLogFuBar.cannotDetachTooltip = true
nQuestLogFuBar.defaultMinimapPosition = 250
nQuestLogFuBar.defaultPosition = "LEFT"
nQuestLogFuBar.hasIcon = "Interface\\Addons\\nQuestLog\\images\\icon"
nQuestLogFuBar.hideMenuTitle = false
nQuestLogFuBar.hideWithoutStandby = true
nQuestLogFuBar.independentProfile = true
nQuestLogFuBar.OnMenuRequest = nQuestLog.mainMenu
nQuestLogFuBar.overrideMenu = true

function nQuestLogFuBar:OnInitialize()
	self.db = nQuestLog:AcquireDBNamespace("fubar")

	nQuestLog.mainMenu.args.fubar = { order = -120, type = "group", name = L["FuBarPlugin options"],
		desc = L["FuBarPlugin options desc"],
		cmdHidden = true,
		args = {
			textOptsHeader = { order = 10, type = "header", name = L["Text options"], hidden = "IsMinimapAttached" },
			showQuestsDone = { order = 20, type = "toggle",
				name = L["Show completed quests"], desc = L["showQuestsDone"],
				hidden = "IsMinimapAttached",
				get = function() return nQuestLog.db.profile.showFuQuestsDone end,
				set = function(v)
					nQuestLog.db.profile.showFuQuestsDone = v
					self:UpdateText()
				end },
			showQuestsHidden = { order = 30, type = "toggle",
				name = L["Show hidden quests"], desc = L["showQuestsHidden"],
				hidden = "IsMinimapAttached",
				get = function() return nQuestLog.db.profile.showFuQuestsHidden end,
				set = function(v)
					nQuestLog.db.profile.showFuQuestsHidden = v
					self:UpdateText()
				end },
			showQuestsActive = { order = 40, type = "toggle",
				name = L["Show active quests"], desc = L["showQuestsActive"],
				hidden = "IsMinimapAttached",
				get = function() return nQuestLog.db.profile.showFuQuestsActive end,
				set = function(v)
					nQuestLog.db.profile.showFuQuestsActive = v
					self:UpdateText()
				end },
			showQuestsMax = { order = 50, type = "toggle",
				name = L["Show max quests"], desc = L["showQuestsMax"],
				hidden = "IsMinimapAttached",
				get = function() return nQuestLog.db.profile.showFuQuestsMax end,
				set = function(v)
					nQuestLog.db.profile.showFuQuestsMax = v
					self:UpdateText()
				end },
			tipOptsSpacer = { order = 60, type = "header", hidden = "IsMinimapAttached" },
			tipOptsHeader = { order = 70, type = "header", name = L["Tooltip options"] },
			showTipQuestsDone = { order = 80, type = "toggle",
				name = L["Show completed quests"], desc = L["showQuestsDone"],
				get = function() return nQuestLog.db.profile.showFuTipQuestsDone end,
				set = function(v)
					nQuestLog.db.profile.showFuTipQuestsDone = v
					self:UpdateTooltip()
				end },
			showTipQuestsHidden = { order = 90, type = "toggle",
				name = L["Show hidden quests"], desc = L["showQuestsHidden"],
				get = function() return nQuestLog.db.profile.showFuTipQuestsHidden end,
				set = function(v)
					nQuestLog.db.profile.showFuTipQuestsHidden = v
					self:UpdateTooltip()
				end },
			showTipQuestsActive = { order = 100, type = "toggle",
				name = L["Show active quests"], desc = L["showQuestsActive"],
				get = function() return nQuestLog.db.profile.showFuTipQuestsActive end,
				set = function(v)
					nQuestLog.db.profile.showFuTipQuestsActive = v
					self:UpdateTooltip()
				end },
			showTipMinionStatus = { order = 110, type = "toggle",
				name = L["Show minion status"], desc = L["showFuMinionStatus"],
				get = function() return nQuestLog.db.profile.showFuTipMinionStatus end,
				set = function(v)
					nQuestLog.db.profile.showFuTipMinionStatus = v
					self:UpdateTooltip()
				end },
			showTipHint = { order = 120, type = "toggle",
				name = L["Show hint"], desc = L["showFuHint"],
				get = function() return nQuestLog.db.profile.showFuTipHint end,
				set = function(v)
					nQuestLog.db.profile.showFuTipHint = v
					self:UpdateTooltip()
				end },
			standardOptsHeader = { order = -1000, type = "header", name = L["Standard options"] } } }
	
	AceLibrary("AceConsole-2.0"):InjectAceOptionsTable(self, nQuestLog.mainMenu.args.fubar)
	
	nQuestLog.mainMenu.args.hidePlugin = {
		order = nQuestLog.mainMenu.args.fubar.args.hide.order,
		type = "toggle",
		cmdName = nQuestLog.mainMenu.args.fubar.args.hide.cmdName,
		guiName = nQuestLog.mainMenu.args.fubar.args.hide.guiName,
		desc = nQuestLog.mainMenu.args.fubar.args.hide.desc,
		hidden = nQuestLog.mainMenu.args.fubar.args.hide.hidden,
		guiHidden = true,
		wfHidden = true,
		handler = nQuestLog.mainMenu.args.fubar.args.hide.handler,
		get = nQuestLog.mainMenu.args.fubar.args.hide.get,
		set = nQuestLog.mainMenu.args.fubar.args.hide.set
	}
end

function nQuestLogFuBar:OnEnable()
	self:Hook(self, "OpenMenu",
		function(object, ...)
			nQuestLog:RefreshMenu()
			return self.hooks[object]["OpenMenu"](object, ...)
		end
	)
end

function nQuestLogFuBar:OnClick(button)
	if ( IsAltKeyDown() ) then
		nQuestLog:ExpandCollapse()
	elseif ( IsControlKeyDown() ) then
		if ( nQuestLog.Waterfall ) then
			Waterfall:Open(nQuestLog.Waterfall)
		else
			self:Print(L["waterfallError"])
		end
	elseif ( IsShiftKeyDown() ) then
		nQuestLog.db.profile.minionLocked = not nQuestLog.db.profile.minionLocked
	else
		if ( nQuestLogFrame:IsVisible() ) then
			nQuestLog:ToggleVisible(false)
		else
			nQuestLog:ToggleVisible(true)
		end
	end
end

function nQuestLogFuBar:OnTextUpdate()
	local color, text = nil, ""
	local qMax = MAX_QUESTS
	local qTotal, qDone = Quixote:GetNumQuests()
	
	if ( nQuestLog.db.profile.showFuQuestsDone ) then
		color = Crayon:GetThresholdHexColor(qDone / qTotal)
		text = text..Crayon:Colorize(color, qDone)
	end
	if ( nQuestLog.db.profile.showFuQuestsHidden ) then
		if ( text ~= "" ) then
			text = text.."/"
		end
		local qHidden = 0
		for _, qTitle in Quixote:IterateQuests() do
			if ( not nQuestLog.db.char.watchedQuests[qTitle] ) then
				qHidden = qHidden + 1
			end
		end
		color = Crayon:GetThresholdHexColor((qTotal - qHidden) / qTotal)
		text = text..Crayon:Colorize(color, qHidden)
	end
	if ( nQuestLog.db.profile.showFuQuestsActive ) then
		if ( text ~= "" ) then
			text = text.."/"
		end
		color = Crayon:GetThresholdHexColor((qMax - qTotal) / qMax)
		text = text..Crayon:Colorize(color, qTotal)
	end
	if ( nQuestLog.db.profile.showFuQuestsMax ) then
		if ( text ~= "" ) then
			text = text.."/"
		end
		text = text..qMax
	end
	
	self:SetText(text)
end

function nQuestLogFuBar:OnTooltipUpdate()
	local cat = Tablet:AddCategory("columns", 2)
	
	local qMax = MAX_QUESTS
	local qTotal, qDone = Quixote:GetNumQuests()
	
	if ( nQuestLog.db.profile.showFuTipQuestsDone )
	or ( nQuestLog.db.profile.showFuTipQuestsHidden )
	or ( nQuestLog.db.profile.showFuTipQuestsActive ) then
		cat:AddLine("text", " ")
		cat:AddLine("text", WHITE..L["Quest status"])
		local color
		if ( nQuestLog.db.profile.showFuTipQuestsDone ) then
			color = Crayon:GetThresholdHexColor(qDone / qTotal)
			cat:AddLine("text", L["Completed"], "text2", Crayon:Colorize(color, qDone.."/"..qTotal))
		end
		if ( nQuestLog.db.profile.showFuTipQuestsHidden ) then
			local qHidden = 0
			for _, qTitle in Quixote:IterateQuests() do
				if ( not nQuestLog.db.char.watchedQuests[qTitle] ) then
					qHidden = qHidden + 1
				end
			end
			color = Crayon:GetThresholdHexColor((qTotal - qHidden) / qTotal)
			cat:AddLine("text", L["Hidden"], "text2", Crayon:Colorize(color, qHidden.."/"..qTotal))
		end
		if ( nQuestLog.db.profile.showFuTipQuestsActive ) then
			color = Crayon:GetThresholdHexColor((qMax - qTotal) / qMax)
			cat:AddLine("text", L["Active"], "text2", Crayon:Colorize(color, qTotal.."/"..qMax))
		end
	end
	
	local hint = ""
	if ( nQuestLog.db.profile.showFuTipMinionStatus ) then
		cat:AddLine("text", " ")
		local status = L["Visible"]
		if ( nQuestLog.db.profile.minionLocked ) then
			status = status..", "..L["Locked"]
		else
			status = status..", "..RED..L["Unlocked"]..ENDCOLOR
			hint = hint.." "..RED..L["Minion must be locked for proper functionality!"]..ENDCOLOR..NEWLINE
		end
		if ( not nQuestLogFrame:IsVisible() ) then
			status = "          "..L["Hidden"]
			if ( nQuestLog.db.char.visible ) then
				status = L["Hidden"].." ("..L["no quests to track"]..")"
			end
			hint = ""
		end
		cat:AddLine("text", WHITE..L["Minion status"], "text2", GREEN..status)
	end
	
	if ( nQuestLog.db.profile.showFuTipHint ) then
		local clickColor = "|cffeda55f"
		hint = hint..NEWLINE..format(L["%s to show/hide."], clickColor..L["Click"]..ENDCOLOR)
				   ..NEWLINE..format(L["%s to expand/collapse."], clickColor..L["Alt-Click"]..ENDCOLOR)
				   ..NEWLINE..format(L["%s to lock/unlock."], clickColor..L["Shift-Click"]..ENDCOLOR)
				   ..NEWLINE..format(L["%s to configure."], clickColor..L["Ctrl-Click"]..ENDCOLOR)
				   ..NEWLINE..format(L["%s for options."], clickColor..L["Right-Click"]..ENDCOLOR)
		Tablet:SetHint(hint)
	end
end
