﻿--[[

Copyright (C) 2004 by neuron
aagaande AT gmail DOT com

This program is free software; you can redistribute it and--or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

]]

local nQuestLog = nQuestLog

local REVISION = tonumber(("$Revision: 180 $"):match("%d+"))
if ( nQuestLog.revision < REVISION ) then
	nQuestLog.version = (nQuestLog.versionstring):format(REVISION)
	nQuestLog.revision = REVISION
	nQuestLog.date = ("$Date: 2008-04-23 05:00:35 +0000 (Wed, 23 Apr 2008) $"):match("%d%d%d%d%-%d%d%-%d%d")
end

--Load libraries
local Quixote = AceLibrary("Quixote-1.0")
local Tourist = LibStub("LibTourist-3.0")

--Load localization
local L = AceLibrary("AceLocale-2.2"):new("nQuestLog")

function nQuestLog:RGBPercToHex(r, g, b)
	r = r <= 1 and r >= 0 and r or 1
	g = g <= 1 and g >= 0 and g or 1
	b = b <= 1 and b >= 0 and b or 1
	return "|cFF"..("%02x%02x%02x"):format(r*255, g*255, b*255)
end

function nQuestLog:Round(x, digits)
	local mult = tonumber("1"..strrep("0", digits))
	return (ceil(x*mult - 0.5) / mult)
end

function nQuestLog:FormatQuestInfo(level, tag, title, color)
	local questInfo = ""
	if ( level ) then
		questInfo = questInfo.."["..level
		if ( tag ) then
			questInfo = questInfo..tag
		end
		questInfo = questInfo.."] "
	end
	if ( title ) then
		questInfo = questInfo..title
	end
	if ( color ) then
		questInfo = color..questInfo.."|r"
	end
	return questInfo
end

function nQuestLog:FormatZoneByFaction(zone, x, y)
	local r, g, b = Tourist:GetFactionColor(zone)
	local zoneColor = self:RGBPercToHex(r, g, b)
	if ( x ) and ( y ) then
		zone = zone.." ["..x..", "..y.."]"
	end
	return zoneColor..zone.."|r"
end

function nQuestLog:Format_QuestZone(zone)
	local level = ""
	local low, high = Tourist:GetLevel(zone)
	if ( self.db.profile.showZoneLevel ) and ( low > 0 ) and ( high > 0 ) then
		level = self:Colorize(" ["..low.."-"..high.."]", "zoneLevel", nil, zone)
	end
	zone = self:Colorize(zone, "zoneHeader", nil, zone)
	return zone..level
end

function nQuestLog:Format_QuestTitle(title, level, tag, got, needed, complete)
	local newtitle = "["..level..tag.."]"..title
	--Color quest name
	local newtitle = self:Colorize("["..level..tag.."] "..title, "questHeader", nil, nil, level)	
	--Color quest progress
	local progress = ""
	if ( complete == -1 ) then
		--Quest failed
		progress = self:Colorize(L[" (failed)"], "questFailed")
	elseif ( complete == 1 ) then
		--Quest completed
		progress = self:Colorize(L[" (done)"], "questDone")
	else
		if ( needed == 0 ) then
			progress = self:Colorize(L[" (goto)"], "questGoto")
		elseif ( self.db.profile.showQuestProgress ) then
			progress = self:Colorize("  "..got.."/"..needed, "questProgress", got / needed)
		end
	end
	return newtitle..progress
end

--Large function to format quest objectives
function nQuestLog:Format_QuestObjectives(title, objectives, objective, id, force)
	local newobjectives = ""
	local totalGot, totalNeeded = 0, 0
	--Function to format a specific quest objective
	local function Format_QuestObjective(desc, got, needed)
		local desc = self:Colorize(desc, "objectiveHeader", got / needed)
		local progress = self:Colorize(got.."/"..needed, "objectiveProgress", got / needed)
		return "\n - "..desc.."  "..progress
	end
	--Loop through quest objectives and add them all
	if ( objectives > 0 ) then
		for i=1, objectives do
			local desc, type, got, needed, done = Quixote:GetQuestStatusById(id, i)
			if ( type == "reputation" ) then
				needed = 1
				got = 0
				if ( done ) then
					got = 1
				end
			end
			totalGot = totalGot + got
			totalNeeded = totalNeeded + needed
			if ( force ) or ( self:ShouldShowObjective(title, got, needed) ) then
				newobjectives = newobjectives..Format_QuestObjective(desc, got, needed)
			end
		end
	else
		if ( not force ) and ( self:ShouldShowObjective(title) ) then
			newobjectives = "\n - "..self:Colorize(objective, "objectiveText")
			self.dontResize = true --Prevent minion width auto-resize from occurring for this text
		end
	end
	return newobjectives, totalGot, totalNeeded
end
