﻿--[[

Copyright (C) 2004 by neuron
aagaande AT gmail DOT com

This program is free software; you can redistribute it and--or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

]]

--Declare nQuestLog libraries, then add to local namespace
nQuestLog = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "AceEvent-2.0", "AceHook-2.1", "AceModuleCore-2.0")
local nQuestLog = nQuestLog

nQuestLog.name = "nQuestLog"
nQuestLog.revision = tonumber(("$Revision: 164 $"):match("%d+"))
nQuestLog.versionstring = "1.0 |cffff8888r%d|r"
nQuestLog.version = (nQuestLog.versionstring):format(nQuestLog.revision)
nQuestLog.date = ("$Date: 2007-12-16 16:45:41 +0000 (Sun, 16 Dec 2007) $"):match("%d%d%d%d%-%d%d%-%d%d")
nQuestLog.hasIcon = "Interface\\Addons\\nQuestLog\\images\\icon"

--Load libraries
local Dewdrop = AceLibrary("Dewdrop-2.0")
local Quixote = AceLibrary("Quixote-1.0")
local Waterfall = AceLibrary:HasInstance("Waterfall-1.0") and AceLibrary("Waterfall-1.0")

--Load localization
local L = AceLibrary("AceLocale-2.2"):new("nQuestLog")

--Declare replacement for getglobal calls
local _G = getfenv(0)

--Declare constants for bindings
BINDING_HEADER_NQUESTLOG = "nQuestLog"
BINDING_NAME_NQUESTLOG_TOGGLE = L["Show/Hide minion"]
BINDING_NAME_NQUESTLOG_LOCK = L["Lock/Unlock minion"]
BINDING_NAME_NQUESTLOG_EXPANDCOLLAPSE = L["Expand/Collapse minion"]

------------------------------------------------------
--		Loading and unloading						--
------------------------------------------------------

function nQuestLog:OnInitialize()
	nQuestLog:RegisterDB("nQuestLogDB")
	nQuestLog:RegisterDefaults("profile", {
		minionBottom = -1, minionLeft = -1, minionRight = -1, minionTop = -1,
		minionHeader = false, minionHeaderFontSize = 16, minionHeaderTitle = "nQuestLog",
		minionHeaderQuestsDone = true, minionHeaderQuestsHidden = false,
		minionHeaderQuestsActive = true, minionHeaderQuestsMax = true,
		minionAnchor = "TOPRIGHT", minionAutoWidth = true, minionWidth = 250, fontOutline = true,
		minionFadeIn = 1, minionFadeInTime = 0.5, minionFadeOut = 1, minionFadeOutTime = 0.5, minionFadeOutDelay = 0,
		showEmptyZones = true, showZoneVisibleStatus = false, showZoneLevel = true, fontSizeZone = 14, zonePadding = 0,
		showQuestProgress = true, fontSize = 13, questPadding = 0, trackNewQuests = true, trackWhenLooting = true,
		hideAllObjectives = true, hideCompletedObjectives = true, showShortWhenNoObjectives = true,
		showFuQuestsDone = true, showFuQuestsHidden = false, showFuQuestsActive = true, showFuQuestsMax = true,
		showFuTipQuestsDone = true, showFuTipQuestsHidden = true, showFuTipQuestsActive = true,
		showFuTipMinionStatus = true, showFuTipHint = true })
	nQuestLog:RegisterDefaults("char", {
		visible = true, watchedQuests = {}, watchedObjectives = {}, hiddenZones = {} })
	if ( Waterfall ) then
		self.Waterfall = "nQuestLogWaterfall"
		Waterfall:Register(self.Waterfall, "title", self.name, "aceOptions", self.mainMenu)
	end
	nQuestLog:RegisterChatCommand({"/nquestlog", "/nquest", "/nql"}, self.mainMenu)
end

function nQuestLog:OnEnable()
	--TODO, clean this up, we should support OnDisable as well.
	self:CreateFrames()
	
	self.refreshHold = true

	if ( self.db.profile.minionBottom == -1 ) or ( self.db.profile.minionLeft == -1 )
	or ( self.db.profile.minionRight == -1 ) or ( self.db.profile.minionTop == -1 ) then
		self:ResetPosition()
	end
	
	--Register Quixote Events:
	self:RegisterEvent("Quixote_Quest_Gained", "OnQuest_Gained")
	self:RegisterEvent("Quixote_Quest_Lost", "OnQuest_Lost")
	self:RegisterEvent("Quixote_Leaderboard_Update", "OnQuest_Leaderboard_Update")
	self:RegisterEvent("Quixote_Update", "Refresh")
	self:RegisterEvent("Quixote_Ready", "OnQuestLog_Ready", true)	
	
	--Used for checking if we should refresh:
	self:RegisterEvent("ZONE_CHANGED", "OnRefreshCheck")
	self:RegisterEvent("ZONE_CHANGED_INDOORS", "OnRefreshCheck")
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "OnRefreshCheck")
	
	--Initiate modules
	self:LoadModules()
	self:AddModuleSettings(self.mainMenu)
	
	self.isFading = ""
	self:Fade()
	
	if ( self.Waterfall ) then
		self.mainMenu.args.config = { order = -130, type = "execute",
			name = L["Configure"],
			desc = L["Open configuration frame"],
			wfHidden = true,
			func = function()
				Waterfall:Open(self.Waterfall)
				Dewdrop:Close()
			end }
	end
end

--Triggers when profile is switched, reset, or copied
function nQuestLog:OnProfileEnable()
	if ( self.db.profile.minionBottom == -1 ) or ( self.db.profile.minionLeft == -1 )
	or ( self.db.profile.minionRight == -1 ) or ( self.db.profile.minionTop == -1 ) then
		self:ResetPosition()
	else
		self:SetPosition()
		--Unlock the minion if it's in the center of the screen
		if ( nQuestLogFrame:GetCenter() == UIParent:GetCenter() ) then
			self.db.profile.minionLocked = false
		end
	end
	nQuestLogFrame:SetAlpha(1)
	self:RefreshTracker()
end

function nQuestLog:OnDisable()
--	self:ToggleVisible(false)
end

------------------------------------------------------
--		Frame creation and visibility				--
------------------------------------------------------

function nQuestLog:CreateFrames()
	if ( self.framesCreated ) then return end
	
	for iButton=1, MAX_QUESTS * 2, 1 do
		local f = CreateFrame("Frame", "nQuestLogButton"..iButton, nQuestLogFrameQuestInfo, "QuestInfoTemplate")
		if ( iButton == 1 ) then
			f:SetPoint("TOPLEFT", nQuestLogFrameQuestInfo, "TOPLEFT", 6, -5)
			f:SetPoint("TOPRIGHT", nQuestLogFrameQuestInfo, "TOPRIGHT", -6, -5)
		else
			f:SetPoint("TOPLEFT", _G["nQuestLogButton"..iButton - 1], "BOTTOMLEFT")
			f:SetPoint("TOPRIGHT", _G["nQuestLogButton"..iButton - 1], "BOTTOMRIGHT")
		end
		f:Show()
	end
	
	self.framesCreated = true
end

function nQuestLog:ToggleVisible(open)
	local showMinion
	if ( open ~= nil ) then
		showMinion = open
	else
		showMinion = not nQuestLogFrame:IsVisible()
	end
	self.db.char.visible = showMinion
	if ( showMinion ) then
		nQuestLogFrame:SetWidth(self.db.profile.minionWidth)
		self:SetPosition()
		self:RefreshTracker()
	else
		--Close Details and Comments frames if they are open, using the escape detector as a shortcut
		if ( nQuestLogEscapeDetector ) then
			nQuestLogEscapeDetector:Hide()
		end
		nQuestLogFrame:Hide()
	end
end

------------------------------------------------------
--		Minion positioning							--
------------------------------------------------------

function nQuestLog:ResetPosition()
	nQuestLogFrame:ClearAllPoints()
	nQuestLogFrame:SetPoint("CENTER")
	self:SavePosition()
	self:SetPosition()
	self.db.profile.minionLocked = false
end

function nQuestLog:SetPosition()
	nQuestLogFrame:ClearAllPoints()
	if ( self.db.profile.minionAnchor == "TOPLEFT" ) then
		nQuestLogFrame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", self.db.profile.minionLeft, self.db.profile.minionTop)
	elseif ( self.db.profile.minionAnchor == "TOPRIGHT" ) then
		nQuestLogFrame:SetPoint("TOPRIGHT", UIParent, "BOTTOMLEFT", self.db.profile.minionRight, self.db.profile.minionTop)
	elseif ( self.db.profile.minionAnchor == "BOTTOMLEFT" ) then
		nQuestLogFrame:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT", self.db.profile.minionLeft, self.db.profile.minionBottom)
	elseif ( self.db.profile.minionAnchor == "BOTTOMRIGHT" ) then
		nQuestLogFrame:SetPoint("BOTTOMRIGHT", UIParent, "BOTTOMLEFT", self.db.profile.minionRight, self.db.profile.minionBottom)
	end
end

function nQuestLog:SavePosition()
	self.db.profile.minionBottom = nQuestLogFrame:GetBottom()
	self.db.profile.minionLeft = nQuestLogFrame:GetLeft()
	self.db.profile.minionRight = nQuestLogFrame:GetRight()
	self.db.profile.minionTop = nQuestLogFrame:GetTop()
end

------------------------------------------------------
--		Refresh functions							--
------------------------------------------------------

--Add "Watched quests" and "Show/Hide objectives" sections to main menu
function nQuestLog:RefreshMenu()
	local lastPrintedZone = {}
	local menuOrder = 10
	
	self.mainMenu.args.Quests.args = {}
	
	local strTrackingDefault = L["Hide completed"]
	if ( self.db.profile.hideAllObjectives ) then
		strTrackingDefault = L["Hidden"]
	elseif ( not self.db.profile.hideCompletedObjectives ) then
		strTrackingDefault = L["Shown"]
	end
	if ( self.db.profile.smartQuestTracking ) then
		strTrackingDefault = L["Smart"]
	end
	
	self.mainMenu.args.Objectives.args = {
		headerTop = { order = 1, type = "header", name = L["Default : "]..strTrackingDefault },
		reset = { order = 2, type = "execute",
			name = L["Reset manually watched objectives"],
			desc = L["Reset manually watched objectives"],
			func = function()
				self.db.char.watchedObjectives = {}
				nQuestLog:Refresh()
			end } }
	
	local function AddToMenu(data, strTitle, strFancyTitle, strZone, strDescription)
		local strMenuName = data.Menu
		if ( lastPrintedZone[strMenuName] ~= strZone ) then
			self.mainMenu.args[strMenuName].args[strZone] = {
				order = menuOrder, type = "toggle",
				name = self:Format_QuestZone(strZone),
				desc = L["Zone"].." "..strZone,
				get = function()
					if ( self.db.char.hiddenZones[strZone] ) then
						return false
					end
					return true
				end,
				set = function(v)
					if ( not v ) then
						self.db.char.hiddenZones[strZone] = true
					else
						self.db.char.hiddenZones[strZone] = nil
					end
					self:Refresh()
				end }
			lastPrintedZone[strMenuName] = strZone
			menuOrder = menuOrder + 1
		end
		
		self.mainMenu.args[strMenuName].args[strTitle] = {
			order = menuOrder, type = "toggle",
			name = strFancyTitle, desc = strDescription,
			get = data.get, set = data.set }
	end
	
	--Scan all quests
	for _, tmp_Zone in Quixote:IterZones() do
		for _, iQuestId in Quixote:QuestsByZone(tmp_Zone) do
			local strTitle, iLevel, strTag, _, iComplete, iObjectives, strZone = Quixote:GetQuestById(iQuestId)
			local _, strDescription = Quixote:GetQuestText(iQuestId)
			
			--Scan the objectives to get numbers of quest items we want:
			local iTotalGot, iTotalNeeded = 0, 0
			for i=1, iObjectives do
				local _, strType, iGot, iNeeded, isDone = Quixote:GetQuestStatusById(iQuestId, i)
				if ( strType == "reputation" ) then
					iNeeded = 1
					iGot = 0
					if ( isDone ) then
						iGot = 1
					end
				end
				iTotalGot = iTotalGot + iGot
				iTotalNeeded = iTotalNeeded + iNeeded
			end
			
			--Then the quest:
			local strFancyTitle = self:Format_QuestTitle(strTitle, iLevel, strTag, iTotalGot, iTotalNeeded, iComplete)
			AddToMenu({
				Menu = "Quests",
				get = function()
					if ( self.db.char.watchedQuests[strTitle] ) then
						return true
					end
					return false
				end,
				set = function(v)
					if ( v ) then
						self.db.char.watchedQuests[strTitle] = true
					else
						self.db.char.watchedQuests[strTitle] = nil
					end
					nQuestLog:Refresh()
				end }, strTitle, strFancyTitle, strZone, strDescription)
			
			if ( self.db.char.watchedQuests[strTitle] ) then
				AddToMenu({
					Menu = "Objectives",
					get = function()
						return nQuestLog:ShouldShowObjective(strTitle, iTotalGot, iTotalNeeded)
					end,
					set = function(v)
						if ( v ) then
							self.db.char.watchedObjectives[strTitle] = true
						else
							self.db.char.watchedObjectives[strTitle] = false
							if ( self:IsModuleEnabled("SmartVisibility") ) then
								self:GetModule("SmartVisibility"):OnQuest_Lost(strTitle)
							end
						end
						nQuestLog:Refresh()
					end }, strTitle, strFancyTitle, strZone, strDescription)
			end
			
			menuOrder = menuOrder + 1
		end
	end
end

--Refreshes all tracker stuff
function nQuestLog:RefreshTracker()
	local function RefreshBackdrop()
		nQuestLogFrame:SetBackdrop({
			bgFile = "Interface/Tooltips/UI-Tooltip-Background",
			edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
				tile = true, 
				tileSize = 16,
				edgeSize = 16,
			insets = { left = 2, right = 2, top = 2, bottom = 2} })
		local cBorder = self:GetColor("trackerBorderColor")
		local cBG = self:GetColor("trackerBackgroundColor")
		nQuestLogFrame:SetBackdropBorderColor(cBorder.r / 255, cBorder.g / 255, cBorder.b / 255, cBorder.a)
		nQuestLogFrame:SetBackdropColor(cBG.r / 255, cBG.g / 255, cBG.b / 255, cBG.a)
	end
	
	RefreshBackdrop()
	self:Refresh()
end

function nQuestLog:Refresh()
	self.refresh = nil
	if ( not self.db.char.visible ) or ( self.refreshHold ) then
		return
	end
	
	--Local variables
	local iFrameHeight = 0
	local strLastPrintedZone = ""
	local iQuestNumber = 1 --Temporary, used to get frame data.
	local bLastFrameQuest = false --This is used for padding, can be 1
	local newWidth = 0 --This is only used if the minion width auto-resize option is selected
	local strTitle, iLevel, strTag, strObjective, iComplete, iObjectives, strZone
	
	local function HideButtons()
		--Hide all QuestInfo we're not showing:
		for i=iQuestNumber, MAX_QUESTS * 2, 1 do
			local frame = _G["nQuestLogButton"..i]
			frame:Hide()
		end
	end
	
	--Set font name and flags to use for all minion text
	local fontFlags = ""
	if ( self.db.profile.fontOutline ) then
		fontFlags = "OUTLINE"
	end
	local fontName = GameFontNormal:GetFont()
	local fontSize = self.db.profile.fontSizeZone
	
	--Get width of zone "+ " and "- " text (whichever is larger) to use as an X offset later
	nQuestLogButton1Toggle:SetFont(fontName, fontSize, fontFlags)
	nQuestLogButton1Toggle:SetText("+ ")
	local toggleWidth = nQuestLogButton1Toggle:GetStringWidth()
	nQuestLogButton1Toggle:SetText("- ")
	if ( nQuestLogButton1Toggle:GetStringWidth() > toggleWidth ) then
		toggleWidth = nQuestLogButton1Toggle:GetStringWidth()
	end
	nQuestLogButton1Toggle:SetText("")
	
	if ( self.db.profile.minionHeader ) then
		nQuestLogFrameHeaderText:SetPoint("TOPLEFT", "nQuestLogFrame", "TOPLEFT", toggleWidth + 5, -5)
		nQuestLogFrameHeaderText:SetFont(fontName, self.db.profile.minionHeaderFontSize, fontFlags)
		
		--local color = nil
		local qMax, minionText = MAX_QUESTS, ""
		local qTotal, qDone = Quixote:GetNumQuests()
		
		if ( self.db.profile.minionHeaderTitle ~= "" ) then
			minionText = minionText..self.db.profile.minionHeaderTitle.." "
		end
		if ( self.db.profile.minionHeaderQuestsDone ) then
			--color = Crayon:GetThresholdHexColor(qDone / qTotal)
			--minionText = minionText..Crayon:Colorize(color, qDone)
			minionText = minionText..qDone
		end
		if ( self.db.profile.minionHeaderQuestsHidden ) then
			if ( minionText ~= "" ) then
				minionText = minionText.."/"
			end
			local qHidden = 0
			for _, qTitle in Quixote:IterateQuests() do
				if ( not self.db.char.watchedQuests[qTitle] ) then
					qHidden = qHidden + 1
				end
			end
			--color = Crayon:GetThresholdHexColor((qTotal - qHidden) / qTotal)
			--minionText = minionText..Crayon:Colorize(color, qHidden)
			minionText = minionText..qHidden
		end
		if ( self.db.profile.minionHeaderQuestsActive ) then
			if ( minionText ~= "" ) then
				minionText = minionText.."/"
			end
			--color = Crayon:GetThresholdHexColor((qMax - qTotal) / qMax)
			--minionText = minionText..Crayon:Colorize(color, qTotal)
			minionText = minionText..qTotal
		end
		if ( self.db.profile.minionHeaderQuestsMax ) then
			if ( minionText ~= "" ) then
				minionText = minionText.."/"
			end
			minionText = minionText..qMax
		end
		
		nQuestLogFrameHeaderText:SetText(minionText)
		nQuestLogFrameHeader:SetHeight(nQuestLogFrameHeaderText:GetStringHeight() + 2 + self.db.profile.zonePadding)
		
		local tempWidth = nQuestLogFrameHeaderText:GetStringWidth()
		if ( tempWidth > newWidth ) then
			newWidth = tempWidth
		end
	else
		nQuestLogFrameHeaderText:SetText("")
		nQuestLogFrameHeader:SetHeight(1)
	end
	
	local function SetFrameText(strText, iQuestId, strZone)
		--Shows + sets text on a new frame
		local frame = _G["nQuestLogButton"..iQuestNumber]
		local frameText = _G["nQuestLogButton"..iQuestNumber.."Text"]
		local frameToggle = _G["nQuestLogButton"..iQuestNumber.."Toggle"]
		
		--Font size
		local fontSize = self.db.profile.fontSize
		if ( iQuestId == nil ) then
			fontSize = self.db.profile.fontSizeZone
		end
		frameText:SetFont(fontName, fontSize, fontFlags)
		frameToggle:SetFont(fontName, fontSize, fontFlags)
		
		if ( iQuestId == nil ) then
			frameToggle:SetWidth(toggleWidth)
			if ( self.db.char.hiddenZones[strZone] ) then
				frameToggle:SetText("+")
			else
				frameToggle:SetText("-")
			end
			
			--Calculate how many quests are visible/not visible for this zone.
			local iAllQuests = 0
			local iVisibleQuests = 0
			for _, iQuestId in Quixote:QuestsByZone(strZone) do
				local strQuestTitle = Quixote:GetQuestById(iQuestId)
				iAllQuests = iAllQuests + 1
				if ( self.db.char.watchedQuests[strQuestTitle] ) then
					iVisibleQuests = iVisibleQuests + 1
				end
			end
			
			if ( self.db.profile.showZoneVisibleStatus ) then
				if ( self.db.char.hiddenZones[strZone] ) then
					strText = strText.." ("..iAllQuests..L[" hidden)"]
				else
					strText = strText.." ("..iVisibleQuests.."/"..iAllQuests..L[" visible)"]
				end
			elseif( iVisibleQuests < iAllQuests ) and ( not self.db.char.hiddenZones[strZone] ) then
				strText = strText.." *"
			end
			
			frameText:SetText(strText)
			
			local tempWidth = frameText:GetStringWidth()
			if ( tempWidth > newWidth ) then
				newWidth = tempWidth
			end
		else
			for text in strText:gmatch("[^\n]+") do
				frameText:SetText(text)
				local tempWidth = frameText:GetStringWidth()
				if ( tempWidth > newWidth ) then
					newWidth = tempWidth
				end
				--"dontResize" is set in function nQuestLog:Format_QuestObjectives if the quest has no objectives
				--If "dontResize" is true, this means that we are showing the quest description under the quest title
				--We don't want the description to be a factor in the resize, since its text should wrap
				if ( self.dontResize ) then
					self.dontResize = nil
					--Break out of the loop, since we don't want to use the description for resizing
					break
				end
			end
			
			frameText:SetText(strText)
			frameToggle:SetText("")
		end
		
		--Padding
		if ( iQuestNumber > 1 ) then
			local parent = _G["nQuestLogButton"..iQuestNumber - 1]
			
			local padding = self.db.profile.questPadding
			if ( iQuestId ~= nil ) then
				if ( bLastFrameQuest ) then
					padding = self.db.profile.questPadding
				else
					padding = 0
				end
				bLastFrameQuest = true
			else
				padding = self.db.profile.zonePadding
				bLastFrameQuest = false
			end
			
			frame:SetPoint("TOPLEFT", parent, "BOTTOMLEFT", 0, -padding)
			iFrameHeight = iFrameHeight + padding
		end
		
		--Adjust frame text up 1px for better highlighting position
		frameText:SetPoint("TOPLEFT", frame, "TOPLEFT", toggleWidth, 1)
		--Adjust for borders, plus 2px to ensure that text wraps properly
		frameText:SetWidth(nQuestLogFrame:GetWidth() - 12 - toggleWidth)
		frame:SetHeight(frameText:GetHeight())
		iFrameHeight = iFrameHeight + frame:GetHeight()
		
		frame:Show()
		if (( not iQuestId ) and ( self:ShouldHighlightZone(strZone) ))
		or (( iQuestId ) and ( self:ShouldHighlight(strTitle) )) then
			local color = self:GetColor("questHighlight")
			frame:SetBackdropColor(color.r / 255, color.g / 255, color.b / 255, color.a)
		else
			frame:SetBackdropColor(0, 0, 0, 0)
		end
		frame.strZone = strZone
		frame.iQuestId = iQuestId
		iQuestNumber = iQuestNumber + 1
	end --function SetFrameText(...)
	
	local function TrackQuest(iQuestId)
		local qObjs, iGot, iNeeded = self:Format_QuestObjectives(strTitle, iObjectives, strObjective, iQuestId)
		local title = self:Format_QuestTitle(strTitle, iLevel, strTag, iGot, iNeeded, iComplete)
		SetFrameText(title..qObjs, iQuestId, strZone)
	end
	
	--Scan all quests
	for _, tmp_Zone in Quixote:IterZones() do
		if ( self.db.char.hiddenZones[tmp_Zone] ) then
			--Zone for this quest is hidden
			if ( self.db.profile.showEmptyZones ) then
				SetFrameText(self:Format_QuestZone(tmp_Zone), nil, tmp_Zone)
			else
				--Zone is hidden and we should not show empty zones, lets see if we have any quests tracked here.
				for _, iQuestId in Quixote:QuestsByZone(tmp_Zone) do
					strTitle = Quixote:GetQuestById(iQuestId)
					if ( self.db.char.watchedQuests[strTitle] ) then
						--Yes we do, lets show the zone
						SetFrameText(self:Format_QuestZone(tmp_Zone), nil, tmp_Zone)
						break
					end
				end
			end
		else
			--Zone for this quest is not hidden
			SetFrameText(self:Format_QuestZone(tmp_Zone), nil, tmp_Zone)
			for _, iQuestId in Quixote:QuestsByZone(tmp_Zone) do
				--TODO, clear up the variables we dont use and remove them.
				strTitle, iLevel, strTag, iGroup, iComplete, iObjectives, strZone = Quixote:GetQuestById(iQuestId)
				strObjective = Quixote:GetQuestText(iQuestId)
				if ( self.db.char.watchedQuests[strTitle] ) then
					--OK, we found a quest, lets add it.
					TrackQuest(iQuestId)
				end
			end
		end --if ( self.db.char.hiddenZones[tmp_Zone] )
	end --for ... in Quixote:IterZones()
	
	--Hide all QuestInfo we're not showing:
	HideButtons()
	
	nQuestLogFrame:SetHeight(nQuestLogFrameHeader:GetHeight() + iFrameHeight + 11)
	
	if ( iFrameHeight == 0 ) then
		nQuestLogFrame:Hide()
	else
		nQuestLogFrame:Show()
		self:SavePosition()
		newWidth = newWidth + toggleWidth + 15
		if ( self.db.profile.minionAutoWidth ) and ( newWidth ~= self.db.profile.minionWidth ) then
			self.db.profile.minionWidth = newWidth
			nQuestLogFrame:SetWidth(newWidth)
			self:Refresh()
		end
	end
end
