﻿local L = AceLibrary("AceLocale-2.2"):new("Tooltips")

L:RegisterTranslations("enUS", function() return {
	["Tooltips"] = true,
	["Description"] = "Deals with the different tooltips and adding info to mob/item tooltips",
	["Enabled"] = true,
	
	--Tooltip anchor
	tooltipAnchor = "Tooltip Anchor",
	tooltipAnchorDesc = "Sets the tooltip when mousing over the minion's anchor",
	["DEFAULT"] = true,
	["TOPRIGHT"] = true,
	["RIGHT"] = true,
	["BOTTOMRIGHT"] = true,
	["TOPLEFT"] = true,
	["LEFT"] = true,
	["BOTTOMLEFT"] = true,
	
	--Item tooltip
	itemToolTip = "Item tooltips",
	itemToolTipDesc = "Add related quests to item tooltips.",
	
	--Mob tooltip
	mobToolTip = "Mob tooltips",
	mobToolTipDesc = "Add related quests/objectives to mob tooltips",
	mobToolTipTrigger = "Add to tooltip on...",
	mobToolTipTriggerDesc = "Sets the event(s) for adding quest data to mob tooltips.",
	mobToolTipTriggerBoth = "Mob and unit frame mouseover",
	mobToolTipTriggerMob = "Mob mouseover only",
	disableInRaidInstance = "Disable while raiding",
	disableInRaidInstanceDesc = "Disables mob tooltip processing while inside a raid instance.  Prevents wasting CPU cycles when they are badly needed during raids.",
	useMobMap = "Use MobMap",
	useMobMapDesc = "Match quest objective items/objects to mobs using MobMap drop data",
	MobMapDropRateFilter = "Set drop rate threshold",
	MobMapDropRateFilterDesc = "Filters MobMap drop table and removes drops below the specified percent threshold.  This helps to remove invalid mob loot and avoid false positives in tooltips.",
	addMobMapDropRates = "Display drop rates",
	addMobMapDropRatesDesc = "Display MobMap drop rates in mob tooltips",
	addKillsNeeded = "Display kills remaining",
	addKillsNeededDesc = "Display an estimate of how many kills are needed based on MobMap drop rates",
	killsNeeded = "Kills needed",
	
	trimToolTip = "Trim tooltip info",
	trimToolTipDesc = "Trim quest/objective titles to XX characters before displaying in mob and item tooltips.  Set to 0 to disable.",
	
	--Minion unlocked
	["MinionUnlocked"] = "Minion is unlocked",
	["PlaceMinion"] = "Place minion and lock it.\nYou can lock it by right clicking on the FuBar/minimap icon.",
	
	--Zone tooltips
	["ZoneHidden"] = "Zone hidden",
	["TrackedQuests"] = "Shown quests",
	["HiddenQuests"] = "Hidden quests",
	["ZoneTips"] = "Hint : Right click to show/hide quests\n          Alt + rightclick to show all zones",
	
	--Quest tooltips
	["Total"] = true,
	["QuestTips"] = "Hint : Alt click to show/hide objectives",
} end)
