﻿--[[

Copyright (C) 2004 by neuron
aagaande AT gmail DOT com

This program is free software; you can redistribute it and--or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

]]

local nQuestLog = nQuestLog

local REVISION = tonumber(("$Revision: 162 $"):match("%d+"))
if ( nQuestLog.revision < REVISION ) then
	nQuestLog.version = (nQuestLog.versionstring):format(REVISION)
	nQuestLog.revision = REVISION
	nQuestLog.date = ("$Date: 2007-12-16 00:12:12 +0000 (Sun, 16 Dec 2007) $"):match("%d%d%d%d%-%d%d%-%d%d")
end

local moduleName = "SmartVisibility"
local SmartVisibility = nQuestLog:NewModule(moduleName, "AceConsole-2.0", "AceEvent-2.0", "AceHook-2.1" )

--Load libraries
local Quixote = AceLibrary("Quixote-1.0")

--Load localization
local L = AceLibrary("AceLocale-2.2"):new("SmartVisibility")

function SmartVisibility:OnModuleLoad()
	self.menuName = L["SmartVisibility"]
	self.description = L["Description"]
	if (not self.defaultsRegistered) then
		self.core:RegisterDefaults(moduleName, "profile", { enabled = true,
			zoneAutoCollapse = true, zoneAutoExpand = true, questHideDone = false,
			objShowZone = "default", objShowActive = 30, objShowNew = false })
		self.defaultsRegistered = true
	end
end

function SmartVisibility:ToggleEnabled(v)
	self.questTimes = {} --stores last update to quest
	self.db.profile.enabled = v
	if ( v ) then
		self:RegisterEvent("Quixote_Quest_Complete", "OnQuest_Complete")
		self:RegisterEvent("Quixote_Quest_Gained", "OnQuest_Gained")
		self:RegisterEvent("Quixote_Quest_Lost", "OnQuest_Lost")
		self:RegisterEvent("Quixote_Leaderboard_Update", "OnQuest_Leaderboard_Update")
		
		self:RegisterEvent("ZONE_CHANGED", "OnZoneChange")
		self:RegisterEvent("ZONE_CHANGED_INDOORS", "OnZoneChange")
		self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "OnZoneChange")
		self:RegisterEvent("Quixote_Ready", "OnZoneChange", true)
	else
		self:UnregisterEvent("Quixote_Quest_Complete")
		self:UnregisterEvent("Quixote_Quest_Gained")
		self:UnregisterEvent("Quixote_Quest_Lost")
		self:UnregisterEvent("Quixote_Leaderboard_Update")
		
		self:UnregisterEvent("ZONE_CHANGED")
		self:UnregisterEvent("ZONE_CHANGED_INDOORS")
		self:UnregisterEvent("ZONE_CHANGED_NEW_AREA")
	end
	self.core:Refresh()
end

function SmartVisibility:GetMenu(oldMenu)
	local menu = { order = oldMenu.order, type = "group",
		name = self.menuName, desc = self.description,
		cmdHidden = true,
		args = { toggleEnabled = oldMenu,
			zoneSpacer = { order = oldMenu.order + 1, type = "header" },
			zoneHeader = { order = oldMenu.order + 2, type = "header", name = L["Zone"] },
			zoneAutoCollapse = { order = oldMenu.order + 3, type = "toggle",
				name = L["zoneAutoCollapse"], desc = L["zoneAutoCollapseDesc"],
				get = function() return self.db.profile.zoneAutoCollapse end,
				set = function(v)
					self.db.profile.zoneAutoCollapse = v
					self:OnZoneChange()
				end },
			zoneAutoExpand = { order = oldMenu.order + 4, type = "toggle",
				name = L["zoneAutoExpand"], desc = L["zoneAutoExpandDesc"],
				get = function() return self.db.profile.zoneAutoExpand end,
				set = function(v)
					self.db.profile.zoneAutoExpand = v
					self:OnZoneChange()
				end },
			questSpacer = { order = oldMenu.order + 5, type = "header" },
			questHeader = { order = oldMenu.order + 6, type = "header", name = L["Quests"] },
			questHideDone = { order = oldMenu.order + 7, type = "toggle",
				name = L["questHideDone"], desc = L["questHideDoneDesc"],
				get = function() return self.db.profile.questHideDone end,
				set = function(v) self.db.profile.questHideDone = v end },
			objSpacer = { order = oldMenu.order + 8, type = "header" },
			objHeader = { order = oldMenu.order + 9, type = "header", name = L["Objectives"] },
			objShowZone = { order = oldMenu.order + 10, type = "text",
				name = L["objShowZone"], desc = L["objShowZoneDesc"],
				validate = { disabled = "("..L["option disabled"]..")", always = L["Always"], default = L["By default"] },
				get = function() return self.db.profile.objShowZone end,
				set = function(v)
					self.db.profile.objShowZone = v
					self.core:Refresh()
				end },
			objShowActive = { order = oldMenu.order + 11, type = "range",
				name = L["objShowActive"], desc = L["objShowActiveDesc"],
				min = 0, max = 120, step = 1,
				get = function() return self.db.profile.objShowActive end,
				set = function(v)
					self.db.profile.objShowActive = v
					self.core:Refresh()
				end },
			objShowNew = { order = oldMenu.order + 12, type = "toggle",
				name = "- "..L["objShowNew"], desc = L["objShowNewDesc"],
				get = function() return self.db.profile.objShowNew end,
				set = function(v)
					self.db.profile.objShowNew = v
					self.core:Refresh()
				end } } }
	return menu
end

function SmartVisibility:OnZoneChange()
	local zone, subZone = GetRealZoneText(), GetSubZoneText()
	if ( self.zone ~= zone ) or ( self.subZone ~= subZone ) then
		self.zone = zone
		self.subZone = subZone
		for _, z in Quixote:IterZones() do
			--Auto-collapse minion zones not matching the current zone or subzone
			if ( self.db.profile.zoneAutoCollapse ) and ( z ~= zone ) and ( z ~= subZone ) then
				self.core.db.char.hiddenZones[z] = true
			--Auto-expand minion zones matching either the current zone or subzone
			elseif ( self.db.profile.zoneAutoExpand ) and (( z == zone ) or ( z == subZone )) then
				self.core.db.char.hiddenZones[z] = nil
			end
		end
		self.core:Refresh()
	end
end

function SmartVisibility:ShouldShowObjective(title)
	if ( self.db.profile.objShowZone ~= "disabled" ) then
		if ( self.db.profile.objShowZone == "always" )
		or (( self.db.profile.objShowZone == "default" ) and ( self.core.db.char.watchedObjectives[title] == nil )) then
			local zone = select(7, Quixote:GetQuestByName(title))
			if ( zone == self.zone ) or ( zone == self.subZone ) then
				return true
			end
		end
	end
	if ( self.db.profile.objShowActive > 0 ) then
		local minTime = GetTime() - ( self.db.profile.objShowActive * 60 )
		if ( self.questTimes[title] ) and ( self.questTimes[title] > minTime ) then
			return true
		end
	end
end

function SmartVisibility:OnQuest_Complete(title)
	if ( self.db.profile.questHideDone ) then
		self.core.db.char.watchedQuests[title] = nil
	end
end

function SmartVisibility:OnQuest_Gained(title)
	if ( self.db.profile.objShowNew ) then
		self.questTimes[title] = GetTime()
	end
end

function SmartVisibility:OnQuest_Lost(title)
	self.questTimes[title] = nil
end

function SmartVisibility:OnQuest_Leaderboard_Update(title)
	self.questTimes[title] = GetTime()
end
