﻿--[[

Copyright (C) 2004 by neuron
aagaande AT gmail DOT com

This program is free software; you can redistribute it and--or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

]]

--TODO:  Is this better than Cartographer?  Tourist:GetYardDistance(zone1, x1, y1, zone2, x2, y2)

local nQuestLog = nQuestLog

local REVISION = tonumber(("$Revision: 146 $"):match("%d+"))
if ( nQuestLog.revision < REVISION ) then
	nQuestLog.version = (nQuestLog.versionstring):format(REVISION)
	nQuestLog.revision = REVISION
	nQuestLog.date = ("$Date: 2007-12-01 23:32:41 +0000 (Sat, 01 Dec 2007) $"):match("%d%d%d%d%-%d%d%-%d%d")
end

local moduleName = "QuestGivers"
local QuestGiver = nQuestLog:NewModule(moduleName, "AceEvent-2.0", "AceHook-2.1")

--Load libraries
local Quixote = AceLibrary("Quixote-1.0")

--Load localization
local L = AceLibrary("AceLocale-2.2"):new("QuestGivers")

function QuestGiver:OnModuleLoad()
	self.menuName = L["QuestGivers"]
	self.description = L["Description"]
	self.core:RegisterDefaults(moduleName, "char", { questgivers = {} })
	self.core:RegisterDefaults(moduleName, "profile", { enabled = true })
end

function QuestGiver:ToggleEnabled(v)
	self.db.profile.enabled = v
	if ( v ) then
		local function Cleanup()
			for name in pairs(self.db.char.questgivers) do
				if ( not Quixote:GetQuest(name) ) then
					self.db.char.questgivers[name] = nil
				end
			end
		end
		self:RegisterEvent("Quixote_Ready", Cleanup, true)
		self:Hook("AcceptQuest", true)
	else
		self:Unhook("AcceptQuest", true)
	end
end

function QuestGiver:GetMenu(oldMenu)
	local menu = { order = oldMenu.order, type = "group",
		name = self.menuName, desc = self.description,
		cmdHidden = true,
		args = { toggleEnabled = oldMenu } }
	return menu
end

function QuestGiver:AcceptQuest()
	if ( UnitName("npc") ) or ( UnitIsPlayer("npc") ) then
		local x, y = GetPlayerMapPosition("player")
		self.db.char.questgivers[GetTitleText()] = {
			npcName = UnitName('npc'),
			location = { zone = GetZoneText(), x = x, y = y } }
	end
	return self.hooks["AcceptQuest"]()
end

--API:
function QuestGiver:GetQuestGiver(name)
	if ( not self.db.char.questgivers[name] ) then
		return
	end
	local npcName = self.db.char.questgivers[name].npcName
	local location = self.db.char.questgivers[name].location
	local distance = nil
	if ( Cartographer ) then
		--Distance can be nil, depends on Cartographer availability
		distance = Cartographer:GetDistanceToPoint(location.x, location.y, location.zone)
		distance = Cartographer:GetDistanceToPoint(location.x, location.y)
	end
	return npcName, location, distance
end

--Function returns localized string of questgiver info, and distance (for hilighting and such)
function QuestGiver:Format_QuestGiver(name, location, distance)
	if ( location == nil ) then
		name, location, distance = self:GetQuestGiver(name)
	end
	if ( name == nil ) then
		return
	end
	if ( distance ) then
		return L["%s in %s (%d,%d) (%d yd)"]:format(name, location.zone, floor(location.x*100), floor(location.y*100), distance), distance
	end
	return L["%s in %s (%d,%d)"]:format(name, location.zone, floor(location.x*100), floor(location.y*100)), distance
end
