﻿local L = AceLibrary("AceLocale-2.2"):new("Notifications")

L:RegisterTranslations("enUS", function() return {
	Notifications = true,
	Description = "Quest progress notifications",
	
	["%s notifications"] = true, --%s = "Text" OR "Sound"
	["Text"] = true,
	["Sound"] = true,
	
	testOutput = "Test output",
	testOutputDesc = "Generate a fake notification for testing purposes.",
	fakeQuest = "Hey, you just completed a fake quest!",
	
	questDone = "Quest complete", --also used in notifications
	questDoneDesc = "Notify when a quest is completed.",
	
	objDone = "Objective complete", --also used in notifications
	objDoneDesc = "Notify when an objective is completed.",
	objDoneSoundDesc = "Notify when an objective is completed but at least one incomplete objective remains.",
	objProgress = "Objective progress",
	objProgressDesc = "Notify when progess is made on an objective.",
	objProgressHidden = "Only when quest is hidden",
	objProgressHiddenDesc = "Notify on objective progress only when the quest is hidden.",
	objQuestName = "Add quest names",
	objQuestNameDesc = "Display quest names in objective notifications.",
	hideBlizz = "Hide Blizzard objective notifications",
	hideBlizzDesc = "Hide the default Blizzard quest objective notifications displayed near the top of the screen.",
	
	multiToggle = "Hint:  Select more than one option for automatic randomization of the options selected.",
	["%s \"Job's done!\""] = true,
	["%s \"More work?\""] = true,
	["%s \"Ready to work!\""] = true,
	["%s \"Something need doing?\""] = true,
	["%s \"Work complete!\""] = true,
	["Flag captured"] = true,
	["Peasant"] = true,
	["Peon"] = true,
	["Ready check"] = true,
	
	blizzProgressPattern = "^.+: ?%d+/%d+$", -- pattern to suppress Blizzard objective progress messages
} end)
