﻿--[[

Copyright (C) 2004 by neuron
aagaande AT gmail DOT com

This program is free software; you can redistribute it and--or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

]]

local nQuestLog = nQuestLog

local REVISION = tonumber(("$Revision: 194 $"):match("%d+"))
if ( nQuestLog.revision < REVISION ) then
	nQuestLog.version = (nQuestLog.versionstring):format(REVISION)
	nQuestLog.revision = REVISION
	nQuestLog.date = ("$Date: 2008-10-16 21:10:59 +0000 (Thu, 16 Oct 2008) $"):match("%d%d%d%d%-%d%d%-%d%d")
end

local moduleName = "Notifications"
local Notification = nQuestLog:NewModule(moduleName, "AceConsole-2.0", "AceEvent-2.0", "AceHook-2.1")

--Load libraries
local Quixote = AceLibrary("Quixote-1.0")

--Load localization
local L = AceLibrary("AceLocale-2.2"):new("Notifications")

function Notification:OnModuleLoad()
	self.menuName = L["Notifications"]
	self.description = L["Description"]
	if ( not self.defaultsRegistered ) then
		self.core:RegisterDefaults(moduleName, "profile", { enabled = true,
			notifyFinishedQuest = true, notifyFinishedObjective = true, notifyLootedQuestItem = true,
			notifyLootedHiddenQuestItemOnly = false, objAddQuestName = false, hideBlizz = true,
			sink20OutputSink = "UIErrorsFrame", questDoneSound = 0, objDoneSound = 0 })
		self.defaultsRegistered = true
	end
end

function Notification:ToggleEnabled(v)
	self.db.profile.enabled = v
	if ( v ) then
		self:Hook("UIErrorsFrame_OnEvent", true)
		self:RegisterEvent("Quixote_Leaderboard_Update", "OnQuest_Objective_Update")
		self:RegisterEvent("Quixote_Quest_Complete", "OnQuest_Complete")
	else
		self:Unhook("UIErrorsFrame_OnEvent", true)
		self:UnregisterEvent("Quixote_Leaderboard_Update", "OnQuest_Objective_Update")
		self:UnregisterEvent("Quixote_Quest_Complete", "OnQuest_Complete")
	end
end

function Notification:GetMenu(oldMenu)
	local menu = { order = oldMenu.order, type = "group",
		name = self.menuName, desc = self.description,
		cmdHidden = true,
		args = {
			toggleEnabled = oldMenu,
			spacer1 = { order = 1300, type = "header" },
			text = { order = 1301, type = "group",
				name = L["Text"], desc = L["%s notifications"]:format(L["Text"]),
				args = {
					questDone = { order = 10, type = "toggle",
						name = L["questDone"], desc = L["questDoneDesc"],
						get = function() return self.db.profile.notifyFinishedQuest end,
						set = function(v) self.db.profile.notifyFinishedQuest = v end },
					objDone = { order = 20, type = "toggle",
						name = L["objDone"], desc = L["objDoneDesc"],
						get = function() return self.db.profile.notifyFinishedObjective end,
						set = function(v) self.db.profile.notifyFinishedObjective = v end },
					objProgress = { order = 30, type = "toggle",
						name = L["objProgress"], desc = L["objProgressDesc"],
						disabled = function() return self.db.profile.notifyLootedHiddenQuestItemOnly end,
						get = function() return self.db.profile.notifyLootedQuestItem end,
						set = function(v) self.db.profile.notifyLootedQuestItem = v end },
					objProgressHidden = { order = 40, type = "toggle",
						name = " - "..L["objProgressHidden"], desc = L["objProgressHiddenDesc"],
						disabled = function() return not self.db.profile.notifyLootedQuestItem end,
						get = function() return self.db.profile.notifyLootedHiddenQuestItemOnly end,
						set = function(v) self.db.profile.notifyLootedHiddenQuestItemOnly = v end },
					objQuestName = { order = 50, type = "toggle",
						name = L["objQuestName"], desc = L["objQuestNameDesc"],
						get = function() return self.db.profile.objAddQuestName end,
						set = function(v) self.db.profile.objAddQuestName = v end },
					spacer1 = { order = 60, type = "header" },
					testOutput = { order = 80, type = "execute",
						name = L["testOutput"], desc = L["testOutputDesc"],
						func = function() self:NotifyText(L["fakeQuest"]) end },
					hideBlizz = { order = 90, type = "toggle",
						name = L["hideBlizz"], desc = L["hideBlizzDesc"],
						get = function() return self.db.profile.hideBlizz end,
						set = function(v) self.db.profile.hideBlizz = v end } } },
			sound = { order = 1302, type = "group",
				name = L["Sound"], desc = L["%s notifications"]:format(L["Sound"]),
				args = {
					questDone = { order = 10, type = "group",
						name = L["questDone"], desc = L["questDoneDesc"].."\n\n"..L["multiToggle"],
						args = {} },
					objDone = { order = 20, type = "group",
						name = L["objDone"], desc = L["objDoneSoundDesc"].."\n\n"..L["multiToggle"],
						args = {} } } } } }
	
	--Add SinkLib options menu
	LibStub("LibSink-2.0"):Embed(self)
	menu.args.text.args.output = self:GetSinkAce2OptionsDataTable(self).output
	self:SetSinkStorage(self.db.profile)
	
	--Set SinkLib menu order
	menu.args.text.args.output.order = 70
	
	do
		local function isSoundActive(v, i, x)
			while ( v > 0 ) and ( x >= i ) do
				if ( v >= 2^x ) then
					if ( x == i ) then
						return true
					end
					v = v - 2^x
				end
				x = x - 1
			end
			return false
		end
		local function setSound(v, i, setting, path)
			if ( v ) then
				self.db.profile[setting] = self.db.profile[setting] + 2^i
				PlaySoundFile(path)
			else
				self.db.profile[setting] = self.db.profile[setting] - 2^i
			end
		end
		
		--"i" is used to determine which sounds are active and should never be changed.
		--"i" has nothing to do with menu order; the position of each row in the table determines its order in the menu.
		--This allows for menu reordering without affecting the options chosen by the user.
		local questDoneSounds = {
			{ i = 0, name = L["%s \"Job's done!\""]:format(L["Peasant"]), path = "Interface\\Addons\\nQuestLog\\sounds\\PeasantBuildingComplete1.mp3" },
			{ i = 1, name = L["%s \"Work complete!\""]:format(L["Peon"]), path = "Sound\\Creature\\Peon\\PeonBuildingComplete1.wav" },
			{ i = 2, name = L["Flag captured"], path = "Sound\\Interface\\PVPFlagCapturedmono.wav" },
			{ i = 3, name = L["Ready check"], path = "Sound\\Interface\\ReadyCheck.wav" } }
		local objDoneSounds = {
			{ i = 0, name = L["%s \"Ready to work!\""]:format(L["Peasant"]), path = "Sound\\Creature\\Peasant\\PeasantReady1.wav" },
			{ i = 1, name = L["%s \"More work?\""]:format(L["Peasant"]), path = "Sound\\Creature\\Peasant\\PeasantWhat3.wav" },
			{ i = 2, name = L["%s \"Ready to work!\""]:format(L["Peon"]), path = "Sound\\Creature\\Peon\\PeonReady1.wav" },
			{ i = 3, name = L["%s \"Something need doing?\""]:format(L["Peon"]), path = "Sound\\Creature\\Peon\\PeonWhat4.wav" },
			{ i = 4, name = L["Flag captured"], path = "Sound\\Interface\\PVPFlagCapturedmono.wav" },
			{ i = 5, name = L["Ready check"], path = "Sound\\Interface\\ReadyCheck.wav" } }
		
		for i,v in ipairs(questDoneSounds) do
			menu.args.sound.args.questDone.args[i] = { order = i, type = "toggle",
				name = v.name, desc = L["multiToggle"], path = v.path,
				get = function() return isSoundActive(self.db.profile.questDoneSound, v.i, #(questDoneSounds)-1) end,
				set = function(s) setSound(s, v.i, "questDoneSound", v.path) end }
		end
		for i,v in ipairs(objDoneSounds) do
			menu.args.sound.args.objDone.args[i] = { order = i, type = "toggle",
				name = v.name, desc = L["multiToggle"], path = v.path,
				get = function() return isSoundActive(self.db.profile.objDoneSound, v.i, #(objDoneSounds)-1) end,
				set = function(s) setSound(s, v.i, "objDoneSound", v.path) end }
		end
	end
	
	return menu
end

function Notification:NotifyText(text)
	local color = self.core:GetColor("notificationColor")
	--Send output to SinkLib
	self:Pour(text, color.r / 255, color.g / 255, color.b / 255)
end

--soundType must be "obj" or "quest"
function Notification:NotifySound(soundType)
	local args = self.core.mainMenu.args["Notifications"].args.sound.args[soundType.."Done"].args
	local x, v, sounds = #(args), self.db.profile[soundType.."DoneSound"], {}
	while ( v > 0 ) do
		if ( v >= 2^x ) then
			tinsert(sounds, x)
			v = v - 2^x
		end
		x = x - 1
	end
	PlaySoundFile(args[sounds[math.random(1, #(sounds))] + 1].path)
end

--Copied from FuBar_QuestsFu
function Notification:UIErrorsFrame_OnEvent(frame, event, message, ...)
	--If the option is enabled, then suppress Blizzard objective progress messages
	if ( self.db.profile.hideBlizz ) and ( event == "UI_INFO_MESSAGE" ) and ( message:match(L["blizzProgressPattern"]) ) then
		return
	end
	return self.hooks.UIErrorsFrame_OnEvent(frame, event, message, ...)
end

function Notification:OnQuest_Objective_Update(title, id, _, desc, _, got, needed)
	if ( self.db.profile.objAddQuestName ) then
		desc = "("..title..") "..desc
	end
	--If objective is complete and notifications should be displayed for completed objectives
	if ( got == needed ) then
		local objs, objsDone = Quixote:GetNumQuestObjectives(id)
		if ( self.db.profile.notifyFinishedObjective ) then
			--If quest isn't complete or if quest completion notifications aren't enabled
			if not (( self.db.profile.notifyFinishedQuest ) and ( objs == objsDone )) then
				self:NotifyText(L["objDone"]..":  "..desc)
			end
		end
		if ( self.db.profile.objDoneSound > 0 ) and ( objs ~= objsDone ) then
			self:NotifySound("obj")
		end
	--If there is objective progress and notifications should be displayed for objective progress
	elseif ( got > 0 ) and ( self.db.profile.notifyLootedQuestItem ) then
		local zone = select(7, Quixote:GetQuestByName(title))
		--If notifications are not restricted to hidden quests only, send a notification
		--Or, if they are, check if the quest or zone is hidden and send notification if it is
		if ( not self.db.profile.notifyLootedHiddenQuestItemOnly ) or (( self.db.profile.notifyLootedHiddenQuestItemOnly )
		and (( not self.core.db.char.watchedQuests[title] ) or ( self.core.db.char.hiddenZones[zone] ))) then
			self:NotifyText(desc.." "..got.."/"..needed)
		end
	end
end

function Notification:OnQuest_Complete(title)
	--If quest completion notifications are enabled
	if ( self.db.profile.notifyFinishedQuest ) then
		self:NotifyText(L["questDone"]..":  "..title)
	end
	if ( self.db.profile.questDoneSound > 0 ) then
		self:NotifySound("quest")
	end
end
