﻿--[[

Copyright (C) 2004 by neuron
aagaande AT gmail DOT com

This program is free software; you can redistribute it and--or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

]]

local nQuestLog = nQuestLog

local REVISION = tonumber(("$Revision: 144 $"):match("%d+"))
if ( nQuestLog.revision < REVISION ) then
	nQuestLog.version = (nQuestLog.versionstring):format(REVISION)
	nQuestLog.revision = REVISION
	nQuestLog.date = ("$Date: 2007-11-28 06:03:46 +0000 (Wed, 28 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d")
end

local moduleName = "Highlight"
local Highlight = nQuestLog:NewModule(moduleName,"AceEvent-2.0","AceHook-2.1", "AceConsole-2.0")

--Load libraries
local Quixote = AceLibrary("Quixote-1.0")

--Load localization
local L = AceLibrary("AceLocale-2.2"):new("Highlight")

function Highlight:OnModuleLoad()
	self.menuName = L["Highlight"]
	self.description = L["Description"]
	if (not self.defaultsRegistered) then
		self.core:RegisterDefaults(moduleName, "profile", { enabled = true })
		self.defaultsRegistered = true
	end
end

function Highlight:ToggleEnabled(v)
	self.db.profile.enabled = v
	if ( v ) then
		self:RegisterEvent("ZONE_CHANGED", "OnZoneChange")
		self:RegisterEvent("ZONE_CHANGED_INDOORS", "OnZoneChange")
		self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "OnZoneChange")
		self:RegisterEvent("Quixote_Quest_Gained", "OnQuest_Gained")
		self:RegisterEvent("Quixote_Ready", "OnQuestLog_Ready",true)
		self:OnZoneChange(true)
	else
		self:UnregisterEvent("ZONE_CHANGED", "OnZoneChange")
		self:UnregisterEvent("ZONE_CHANGED_INDOORS", "OnZoneChange")
		self:UnregisterEvent("ZONE_CHANGED_NEW_AREA", "OnZoneChange")
		self:UnregisterEvent("Quixote_Quest_Gained", "OnQuest_Gained")
		self.highlightList = {}
	end
	self.core:Refresh()
end

function Highlight:GetMenu(oldMenu)
	local menu = { order = oldMenu.order, type = "group",
		name = self.menuName, desc = self.description,
		cmdHidden = true,
		args = { toggleEnabled = oldMenu } }
	return menu
end

function Highlight:OnQuestLog_Ready()
	if ( self.db.profile.enabled ) then
		self:OnZoneChange(true)
	end
end

function Highlight:OnQuest_Gained()
	self:OnZoneChange(true)
end

function Highlight:OnZoneChange(quick)
	self.highlightList = {}
	local zoneText = strlower(GetZoneText())
	local subzoneText = strlower(GetSubZoneText())

	for _, id in Quixote:QuestsByLevel() do
		local title, _, _, _, _, _, zone = Quixote:GetQuestById(id)
		local objective, description = Quixote:GetQuestText(id)
		objective, description = strlower(objective), strlower(description)
		
		if ( subzoneText ~= "" ) and (( strfind(objective, subzoneText, 1, true) ) or ( strfind(description, subzoneText, 1, true) )) then
			--Check for zone text in short quest objective description
			self.highlightList[title] = true
		elseif ( zoneText ~= "" ) and ( strlower(zone) ~= zoneText )
		and (( strfind(objective, zoneText, 1, true) ) or ( strfind(description, zoneText, 1, true) )) then
			--Now check the quest description against the main zone, maybe we got out of zone quests.
			self.highlightList[title] = true
		end
	end
	
	if ( not quick ) then
		self.core.refresh = true
	end
end

function Highlight:ShouldHighlightZone(zone)
	--Check if zone is folded
	if ( not self.core.db.char.hiddenZones[zone] ) then
		return false
	end

	--Zone is folded, lets see if any quests are highlighted
	for _, id in Quixote:QuestsByZone(zone) do
		local title = Quixote:GetQuestById(id)
		if ( self.highlightList[title] ) then
			return true
		end
	end
	return false
end

function Highlight:ShouldHighlight(title)
	return self.highlightList[title]
end
