﻿--[[

Copyright (C) 2004 by neuron
aagaande AT gmail DOT com

This program is free software; you can redistribute it and--or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

]]

local nQuestLog = nQuestLog

local REVISION = tonumber(("$Revision: 180 $"):match("%d+"))
if ( nQuestLog.revision < REVISION ) then
	nQuestLog.version = (nQuestLog.versionstring):format(REVISION)
	nQuestLog.revision = REVISION
	nQuestLog.date = ("$Date: 2008-04-23 05:00:35 +0000 (Wed, 23 Apr 2008) $"):match("%d%d%d%d%-%d%d%-%d%d")
end

local moduleName = "DetailsFrame"
local DetailsFrame = nQuestLog:NewModule(moduleName, "AceEvent-2.0")

--Load libraries
local Abacus = LibStub("LibAbacus-3.0")
local Crayon = LibStub("LibCrayon-3.0")
local Quixote = AceLibrary("Quixote-1.0")
local Tablet = AceLibrary("Tablet-2.0")

--Load localization
local L = AceLibrary("AceLocale-2.2"):new(moduleName)

local nQLescapeDetector

function DetailsFrame:OnModuleLoad()
	self.menuName = L[moduleName]
	self.description = L["Description"]
	
	if ( not self.defaultsRegistered ) then
		self.core:RegisterDefaults(moduleName, 'profile', { enabled = true,
			color = { title = true, level = true },
			detail_data = { fontSizePercent = 0.85, detached = true },
			minWidth = 350, maxHeight = 500 })
		self.defaultsRegistered = true
	end
end

function DetailsFrame:ToggleEnabled(v)
	self.db.profile.enabled = v
	if (v) then
		self:RegisterEvent("Quixote_Quest_Lost", "OnQuest_Lost")
		self:RegisterEvent("Quixote_Leaderboard_Update", "OnQuest_Leaderboard_Update")
	else
		self:UnregisterEvent("Quixote_Quest_Lost", "OnQuest_Lost")
		self:UnregisterEvent("Quixote_Leaderboard_Update", "OnQuest_Leaderboard_Update")
	end
end

function DetailsFrame:GetMenu(oldMenu)
	local menu = { order = oldMenu.order, type = 'group',
		name = self.menuName, desc = self.description,
		cmdHidden = true,
		args = {
			toggleEnabled = oldMenu,
			minWidth = { order = oldMenu.order + 1, type = 'range',
				name = L["Minimum width"],
				desc = L["Set the minimum width of the Details frame"],
				min = 250, max = 500, step = 1,
				get = function() return self.db.profile.minWidth end,
				set = function(v)
					self.db.profile.minWidth = v
					if ( Tablet:IsRegistered("nQuestLog_Detail") ) then
						Tablet:Close("nQuestLog_Detail")
						Tablet:Unregister("nQuestLog_Detail")
					end
					self:UpdateQuestDetail()
				end },
			maxHeight = { order = oldMenu.order + 2, type = 'range',
				name = L["Maximum height"],
				desc = L["Set the maximum height of the Details frame"],
				min = 200, max = 800, step = 1,
				get = function() return self.db.profile.maxHeight end,
				set = function(v)
					self.db.profile.maxHeight = v
					if ( Tablet:IsRegistered("nQuestLog_Detail") ) then
						Tablet:Close("nQuestLog_Detail")
						Tablet:Unregister("nQuestLog_Detail")
					end
					self:UpdateQuestDetail()
				end
			} } }
	return menu
end

function DetailsFrame:OnQuest_Lost(name,id)
	if ( self.questid == id ) then
		self.questid = nil
		self:UpdateQuestDetail()
	end
end

function DetailsFrame:OnQuest_Leaderboard_Update(name,id)
	if ( self.questid == id ) then
		self:UpdateQuestDetail()
	end
end

function DetailsFrame:ShowLog(questid)
	if ( self.questid ~= questid ) then
		self.questid = questid
	else
		self.questid = nil
		if ( nQLescapeDetector ) then
			nQLescapeDetector:Hide()
		end
	end
	self:UpdateQuestDetail()
end

function DetailsFrame:UpdateQuestDetail()
	if ( Tablet:IsRegistered("nQuestLog_Detail") ) then
		--Disable the lock every time the tablet is shown
		--I'd rather remove the "Lock" option from the Tablet Dewdrop menu, but that doesn't appear to be possible at this time without modification of Tablet-2.0
		if ( Tablet:IsLocked("nQuestLog_Detail") ) then
			Tablet:ToggleLocked("nQuestLog_Detail")
		end
		if ( self.questid ) then
			nQLescapeDetector:Show()
		end
		--Refresh the Details pane
		Tablet:Refresh("nQuestLog_Detail")
		return
	end
	
	--Add function pointers to core functions used in this module
	local function addWayPoint(...) nQuestLog:AddWayPoint(...) end
	local function itemClick(...) nQuestLog:ItemClick(...) end
	local function itemHover(...) nQuestLog:ItemHover(...) end
	local function formatQuestInfo(...) return nQuestLog:FormatQuestInfo(...) end
	local function RGBPercToHex(...) return nQuestLog:RGBPercToHex(...) end
	local function round(...) return nQuestLog:Round(...) end
	
	local function getZoneID(zoneName)
		local continentNames, key, val = { GetMapContinents() }
		for ckey, cval in pairs(continentNames) do
			local zoneNames = { GetMapZones(ckey) }
			for zkey, zval in pairs(zoneNames) do
				if ( zval == zoneName ) then
					return ckey, zkey
				end
			end
		end
	end
	
	local function hideQuestDetail()
		self.questid = nil
		if ( nQLescapeDetector ) then
			nQLescapeDetector:Hide()
		end
		self:UpdateQuestDetail()
	end
	
	local showingDescription = true
	local function toggleDescription()
		showingDescription = not showingDescription
		Tablet:Refresh("nQuestLog_Detail")
	end
	
	local function abandonQuestPopup(questid)
		local startingQuestLogSelection = GetQuestLogSelection()
		SelectQuestLogEntry(questid)
		SetAbandonQuest()
		local items = GetAbandonQuestItems()
		if ( items ) then
			StaticPopup_Hide("ABANDON_QUEST")
			StaticPopup_Show("ABANDON_QUEST_WITH_ITEMS", GetAbandonQuestName(), items)
		else
			StaticPopup_Hide("ABANDON_QUEST_WITH_ITEMS")
			StaticPopup_Show("ABANDON_QUEST", GetAbandonQuestName())
		end
		SelectQuestLogEntry(startingQuestLogSelection)
	end
	
	local directions = L["bunch-of-directions"]
	local function colorizeQuestText(text, ...)
		--this syntax is parsing of korean
		--group 0:all, 1: objective, 2: questgivers, 3:description,....
		--by woodin 2007.2.9 (Korean Parsing fix)
		if ( GetLocale() == "koKR" ) then
			local parseFormats = {
				{ group = 1, patt = "(%d+)([^%s%|])", repl = "|cff00ff00%1|r%2" }, --Match numbers
				{ group = 1, patt = "([은|는|을|를|아|한|의]+) ([^%s]+) ([^%s]+)(에게)", repl = "%1 |cffffffff%2 %3|r%4" }, --Match quest finisher
				{ group = 1, patt = "([은|는|을|를|아|한|의]+) ([^%s]+)(에게)", repl = "%1 |cffffffff%2|r%3" }, --Match quest finisher
				{ group = 1, patt = "([에서|이]+) ([^%s]+) ([^%s]+)(를 )", repl = "%1 |cffffffff%2 %3|r%4" }, --Match quest finisher
				{ group = 1, patt = "([에서|이]+) ([^%s]+)(를 )", repl = "%1 |cffffffff%2|r%3" }, --Match quest finisher
				{ group = 1, patt = "([의|는]+) ([^%s]+) ([^%s]+)(가 )", repl = "%1 |cffffffff%2 %3|r%4" }, --Match quest finisher
				{ group = 1, patt = "([의|는]+) ([^%s]+)(가 )", repl = "%1 |cffffffff%2|r%3" }, --Match quest finisher
				{ group = 1, patt = "([의|는]+) ([^%s]+) ([^%s]+)(이 )", repl = "%1 |cffffffff%2 %3|r%4" }, --Match quest finisher
				{ group = 1, patt = "([의|는]+) ([^%s]+)(이 )", repl = "%1 |cffffffff%2|r%3" }, --Match quest finisher
				{ group = 1, patt = "([의|는]+) ([^%s]+) ([^%s]+)(와 )", repl = "%1 |cffffffff%2 %3|r%4" }, --Match quest finisher
				{ group = 1, patt = "([의|는]+) ([^%s]+)(와 )", repl = "%1 |cffffffff%2|r%3" }, --Match Quest finisher
				{ group = 1, patt = "([의]+) ([^%s]+) ([^%s]+)(에 있는 )", repl = "%1 |cffffffff%2 %3|r%4" }, --Match Quest finisher
				{ group = 1, patt = "([의]+) ([^%s]+)(에 있는 )", repl = "%1 |cffffffff%2|r%3" } } --Match Quest finisher
			for k in ipairs(parseFormats) do
				text = text:gsub(parseFormats[k].patt, parseFormats[k].repl)
			end
		elseif ( GetLocale() == "zhCN" ) then
			for i=1, select('#', ...) do
				local val = select(i, ...)
				if ( val ) then
					text = text:gsub(val, "|cffffffff%1|r")
				end
			end
			text = text:gsub("([^%a%d%|])(%d+)([^%a%d%|])", "%1|cff00ff00%2|r%3") --Match numbers
			text = text:gsub("([^%a%d%|])(%d+)([^%a%d%|])", "%1|cff00ff00%2|r%3") --Match numbers again
		else
			--This is copied in approach from MonkeyQuestLog, note.
			for i=1, select('#', ...) do
				local val = select(i, ...)
				if ( val ) then
					local val2 = val:gsub("([^%s])", "|cffffffff%1|r") --color each word so it doesn't mess up later
					text = text:gsub(val, val2)
				end
			end
			text = text:gsub("([^%a%d%|])(%d+)([^%a%d%|])", "%1|cff00ff00%2|r%3") --Match numbers
			text = text:gsub("([^%a%d%|])(%d+)([^%a%d%|])", "%1|cff00ff00%2|r%3") --Match numbers again
			text = text:gsub("([%w,]+) (%u[%w'%-]+ %u[%w'%-]+)", "%1 |cffffffff%2|r") --Match uppercase words.
			text = text:gsub("([%w,]+) (%u[%w'%-]+)", "%1 |cffffffff%2|r") --Run it twice or it'll skip words (TODO: figure out a better pattern to avoid this, if possible)
		end -- if ( GetLocale() == "koKR" )
		if ( GetLocale() == "zhCN" ) then
			text = text:gsub("东西", "STRING_TO_FIX_WRONG_DIR")
			for _, direction in ipairs(directions) do
				text = text:gsub(direction, "%1|cffffffff%2|r%3") --Match direction
			end
			text = text:gsub("STRING_TO_FIX_WRONG_DIR", "东西")
		else
			for _, direction in ipairs(directions) do
				text = text:gsub(direction, "%1|cffffffff%2|r%3") --Match direction
			end
		end -- if ( GetLocale() == "zhCN" )
		return text
	end --local function colorizeQuestText(text, ...)
	
	nQLescapeDetector = CreateFrame('Frame', "nQuestLogEscapeDetector")
	nQLescapeDetector:SetScript('OnHide', hideQuestDetail)
	tinsert(UISpecialFrames, nQLescapeDetector:GetName())
	
	Tablet:Register("nQuestLog_Detail", 'detachedData', self.db.profile.detail_data, 'cantAttach', true,
		'dontHook', true, 'hideWhenEmpty', true, 'showTitleWhenDetached', false, 'strata', "HIGH",
		'minWidth', self.db.profile.minWidth, 'maxHeight', self.db.profile.maxHeight, 'children',
		function()
			Tablet:SetTitle("Detail")
			if ( self.questid ) then
				local startingQuestLogSelection = GetQuestLogSelection()
				SelectQuestLogEntry(self.questid)
				
				local title, level, tag, suggestedGroup, complete, nObjectives, zone, id = Quixote:GetQuest(self.questid)
				local objective, description = Quixote:GetQuestText(self.questid)
				
				--Title and objective:
				if ( not self.db.profile.color.title ) then
					title = Crayon:White(title)
				end
				if ( not self.db.profile.color.level ) then
					level = Crayon:White(questLevel)
				end
				local color
				local colorTable = GetDifficultyColor(level)
				if ( colorTable ) then
					color = nQuestLog:RGBPercToHex(colorTable.r or 1, colorTable.g or 1, colorTable.b or 1)
				end
				
				--Modified for nQuestLog
				local giverName, giverLocation, giverDistance,giverZone 
				if ( nQuestLog:IsModuleEnabled("QuestGivers") ) then
					giverName,giverLocation,giverDistance = nQuestLog:GetModule("QuestGivers"):GetQuestGiver(title)
					if ( giverLocation ) then
						giverZone = giverLocation.zone
					end
				end
				
				local cat = Tablet:AddCategory('columns', 1, 'text', formatQuestInfo(level, tag, title, color),
					'size', Tablet:GetHeaderFontSize() + 1, 'justify', "CENTER", 'func', hideQuestDetail)
				if ( complete ) then
					cat:AddLine('text', complete, 'textR', (complete == L["(failed)"]) and 1 or 0, 'textG', (complete == L["(done)"]) and 1 or 0, 'textB', 0, 'justify', "CENTER")
				end
				if ( suggestedGroup ) and ( suggestedGroup > 0 ) then
					cat:AddLine('text', (QUEST_SUGGESTED_GROUP_NUM):format(suggestedGroup), 'justify', "CENTER")
				end
				cat:AddLine('text', colorizeQuestText(objective, giverName, giverZone), 'wrap', true)
				
				--Leaderboard:
				if ( nObjectives > 0 ) then
					cat = Tablet:AddCategory('columns', 2)
					for i=1, nObjectives do
						self:AddLeaderboardToCategory(cat, self.questid, i, Tablet:GetNormalFontSize(), 0)
					end
				end
				
				--Given by? - Modified for nQuestLog
				if ( giverName ) then
					local questgivertext = ""
					local c, z = getZoneID(giverLocation.zone)
					local x, y = giverLocation.x*100, giverLocation.y*100
					
					cat = Tablet:AddCategory('columns', 2, 'text', L["Given by"])
					if ( Cartographer_Waypoints ) or (TomTom) or (MobMapDotParentFrame) then
						cat:AddLine('text', "|cFF66FF66["..giverName.."]|r\n"..giverLocation.zone.." ["..round(x,1)..", "..round(y,1).."]",
							'func', function () addWayPoint(x, y, title, level, giverName, c, z, giverLocation.zone) end, 'indentation', 14, 'wrap', true)
					else
						questgivertext = nQuestLog:GetModule("QuestGivers"):Format_QuestGiver(giverName, giverLocation, giverDistance)
						if (questgivertext) then
							cat:AddLine('text', questgivertext, 'indentation', 2, 'wrap', true)
						end
						if (giverDistance and not self.refreshEvent) then
							--We have distance, so we need to schedule a refresh
							self.refreshEvent = "nQuestLog-DetailsFrame-"..random()
							self:ScheduleRepeatingEvent(self.refreshEvent, self.UpdateQuestDetail, 1, self)
						end
					end
				end --if ( giverName )
				
				--Requires money?
				if ( GetQuestLogRequiredMoney() > 0 ) then
					cat = Tablet:AddCategory('columns', 2, 'text', L["Required money: "]..Abacus:FormatMoneyFull(GetQuestLogRequiredMoney()), 'showWithoutChildren', true)
				end
				
				--Description:
				cat = Tablet:AddCategory('columns', 1, 'text', L["Description"], 'func', toggleDescription, 'showWithoutChildren', true,
					'checked', true, 'hasCheck', true, 'checkIcon', (not showingDescription) and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up")
				if ( showingDescription ) then
					cat:AddLine('text', colorizeQuestText(description, giverName, giverZone), 'wrap', true)
				end
				
				--Rewards:
				cat = Tablet:AddCategory('columns', 2, 'text', L["Rewards"])
				local numChoices = GetNumQuestLogChoices(self.questid) --The ones you choose from
				local numRewards = GetNumQuestLogRewards(self.questid) --The ones you always get
				local rewardMoney = GetQuestLogRewardMoney(self.questid) --Moolah!
				local rewardSpellTexture, rewardSpellName = GetQuestLogRewardSpell() --Sometimes there's a spell
				
				if ( numChoices > 0 ) or ( numRewards > 0 ) or ( rewardMoney > 0 ) then
					if ( numChoices > 0 ) then
						cat:AddLine('text', L["Choose from:"], 'indentation', 2)
						for i=1, numChoices, 1 do
							local name, texture, numItems, quality = GetQuestLogChoiceInfo(i)
							local color = ""
							if ( quality ) then
								color = select(4, GetItemQualityColor(quality))
							end
							cat:AddLine('text', color.."["..(name or L["<not yet cached>"]).."]"..((numItems > 1) and (" x"..numItems) or ""),
								'checked', true, 'hasCheck', true, 'checkIcon', texture, 'indentation', 4,
								'func', itemClick, 'arg1', GetQuestLogItemLink("choice", i),
								'onEnterFunc', itemHover, 'onEnterArg1', GetQuestLogItemLink("choice", i),
								'onLeaveFunc', GameTooltip.Hide, 'onLeaveArg1', GameTooltip)
						end
					end
					if ( numRewards > 0 ) then
						cat:AddLine('text', L["Always receive:"], 'indentation', 2)
						for i=1, numRewards, 1 do
							local name, texture, numItems, quality = GetQuestLogRewardInfo(i)
							local color = ""
							if ( quality ) then
								color = select(4, GetItemQualityColor(quality))
							end
							cat:AddLine('text', color.."["..(name or L["<not yet cached>"]).."]"..((numItems > 1) and (" x"..numItems) or ""),
								'checked', true, 'hasCheck', true, 'checkIcon', texture, 'indentation', 4,
								'func', itemClick, 'arg1', GetQuestLogItemLink("reward", i),
								'onEnterFunc', itemHover, 'onEnterArg1', GetQuestLogItemLink("reward", i),
								'onLeaveFunc', GameTooltip.Hide, 'onLeaveArg1', GameTooltip)
						end
					end
					if ( rewardSpellTexture ) then
						cat:AddLine('text', L["Spell:"], 'indentation', 2)
						cat:AddLine('text', rewardSpellName, 'indentation', 4,
							'checked', true, 'hasCheck', true, 'checkIcon', rewardSpellTexture)
					end
					if ( rewardMoney > 0 ) then
						cat:AddLine('text', L["Money: "]..Abacus:FormatMoneyFull(rewardMoney, true), 'indentation', 2)
					end
				else
					cat:AddLine('text', L["Nothing."], 'indentation', 2)
				end --if ( numChoices > 0 ) or ( numRewards > 0 ) or ( rewardMoney > 0 )
				
				cat = Tablet:AddCategory('columns', 1, 'text', L["Options"])
				--Shareable:
				if ( GetQuestLogPushable() ) then
					cat:AddLine('text', L["- Share"], 'func', "ShareQuest", 'arg1', self, 'arg2', self.questid, 'textR', 0, 'textG', 1, 'textB', 0)
				end
				cat:AddLine('text', L["- Abandon"], 'func', abandonQuestPopup, 'arg1', self.questid, 'textR', 1, 'textG', 0, 'textB', 0.1)
				cat:AddLine('text', L["[ Close ]"], 'func', hideQuestDetail, 'textR', 1, 'textG', 0.5, 'textB', 0.2, 'justify', "CENTER")
				
				SelectQuestLogEntry(startingQuestLogSelection)
			end --if ( self.questid )
		end) --Tablet:Register
	Tablet:Open("nQuestLog_Detail")
end

function DetailsFrame:AddLeaderboardToCategory(cat, questid, i)
	local title, level = Quixote:GetQuest(questid)
	local description, qtype, numGot, numNeeded, done = Quixote:GetQuestStatusById(questid, i)
	local r, g, b
	local DC = GetDifficultyColor(level)
	
	local function MobmapQuestObj(questobj)
		if ( MobMapDotParentFrame ) and ( MobMap_ParseQuestObjective ) then
			MobMap_ParseQuestObjective(questobj)
		end
	end
	
	if ( numGot == nil ) then
		self:Print("The author of nQuestLog would very much like to know if you see this message.  Email the rest of this line to him at aagaande AT gmail DOT com.", Quixote:GetQuestStatusById(questid, i))
	end
	r, g, b = Crayon:GetThresholdColor((qtype == "reputation" and Quixote:GetReactionLevel(numGot) or numGot) / (qtype == "reputation" and Quixote:GetReactionLevel(numNeeded) or numNeeded))
	
	local party = ""
	for i=1, GetNumPartyMembers(), 1 do
		local unit = "party"..i
		local n = Quixote:GetPartyQuestStatus(unit, title, description)
		if ( n ) and ( type(n) == "number" ) then
			if ( n == numNeeded ) then
				n = "d"
			end
			local englishClass = select(2, UnitClass(unit))
			local classColor = RAID_CLASS_COLORS[englishClass]
			local classHexColor = ("%02x%02x%02x"):format(classColor.r*255, classColor.g*255, classColor.b*255)
			party = ("%s|c00%s%s:%s|r "):format(party, classHexColor, strsub(UnitName(unit), 1, 3), n)
		end
	end
	
	cat:AddLine('text', description, 'text2', party..(done and L["(done)"] or ("%s/%s"):format(numGot, numNeeded)).."  ",
		'textR', r or ((DC and DC.r) or 1), 'textG', g or ((DC and DC.g) or 1), 'textB', b or ((DC and DC.b) or 1),
		'text2R', r or ((DC and DC.r) or 1), 'text2G', g or ((DC and DC.g) or 1), 'text2B', b or ((DC and DC.b) or 1),
		'func', MobmapQuestObj, 'arg1', description, 'arg2', questid, 'indentation', 13)
end

function DetailsFrame:ShareQuest(questid)
	--Share the quest with nearby party members.
	local wasSelected = GetQuestLogSelection()
	SelectQuestLogEntry(questid)
	if ( GetQuestLogPushable() ) and ( GetNumPartyMembers() > 0 ) then
		QuestLogPushQuest()
	end
	SelectQuestLogEntry(questid)
end
