﻿--[[

Copyright (C) 2004 by neuron
aagaande AT gmail DOT com

This program is free software; you can redistribute it and--or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

]]

local nQuestLog = nQuestLog

local REVISION = tonumber(("$Revision: 181 $"):match("%d+"))
if ( nQuestLog.revision < REVISION ) then
	nQuestLog.version = (nQuestLog.versionstring):format(REVISION)
	nQuestLog.revision = REVISION
	nQuestLog.date = ("$Date: 2008-04-23 06:58:13 +0000 (Wed, 23 Apr 2008) $"):match("%d%d%d%d%-%d%d%-%d%d")
end

local moduleName = "BlizzardFrames"
local BlizzardFrames = nQuestLog:NewModule(moduleName, "AceEvent-2.0", "AceHook-2.1")

--Load libraries
local Quixote = AceLibrary("Quixote-1.0")

--Load localization
local L = AceLibrary("AceLocale-2.2"):new("BlizzardFrames")

--Declare replacement for getglobal calls
local _G = getfenv(0)

function BlizzardFrames:OnModuleLoad()
	self.menuName = L["BlizzardFrames"]
	self.description = L["Description"]
	if ( not self.defaultsRegistered ) then
		self.core:RegisterDefaults(moduleName, "profile", { enabled = true, hideTracker = true,
			addLogQuestLevels = true, addLogQuestGivers = false, logMove = true, logScale = 1,
			addDialogQuestLevels = true, greyIncompleteQuestIcons = true })
		self.defaultsRegistered = true
	end
end

function BlizzardFrames:ToggleEnabled(v)
	self.db.profile.enabled = v
	if ( v ) then
		self:SecureHook("QuestLog_OnShow")
		self:SecureHook("QuestLog_SetSelection")
		self:SecureHook("QuestLog_Update")
		self:SecureHook("QuestWatch_Update")
		self:RegisterEvent("GOSSIP_SHOW", "OnGossipShow")
		self:RegisterEvent("QUEST_GREETING", "OnQuestGreeting")
		self:RegisterEvent("Quixote_Update", "QuestLog_Update")
		self:QuestLog_SetScale(self.db.profile.logScale)
		self:QuestLog_ToggleMoveable(self.db.profile.logMove)
	else
		self:Unhook("QuestLog_OnShow")
		self:Unhook("QuestLog_SetSelection")
		self:Unhook("QuestLog_Update")
		self:Unhook("QuestWatch_Update")
		self:UnregisterEvent("GOSSIP_SHOW", "OnGossipShow")
		self:UnregisterEvent("QUEST_GREETING", "OnQuestGreeting")
		self:UnregisterEvent("Quixote_Update", "QuestLog_Update")
		self:QuestLog_SetScale()
		self:QuestLog_ToggleMoveable()
	end
end

function BlizzardFrames:GetMenu(oldMenu)
	local menu = { order = oldMenu.order, type = "group",
		name = self.menuName, desc = self.description,
		cmdHidden = true,
		args = {
			toggleEnabled = oldMenu,
			hideTracker = { order = oldMenu.order + 1, type = "toggle",
				name = L["hideTracker"], desc = L["hideTrackerDesc"],
				get = function() return self.db.profile.hideTracker end,
				set = function(v)
					self.db.profile.hideTracker = v
					QuestWatch_Update()
				end },
			logSpacer = { order = oldMenu.order + 2, type = "header" },
			logHeader = { order = oldMenu.order + 3, type = "header", name = L["Quest log"] },
			addLogQuestLevels = { order = oldMenu.order + 4, type  = "toggle",
				name = L["Add quest levels"], desc = L["addLogQuestLevels"],
				get = function() return self.db.profile.addLogQuestLevels end,
				set = function(v)
					self.db.profile.addLogQuestLevels = v
					QuestLog_Update()
				end },
			addLogQuestGivers = { order = oldMenu.order + 5, type = "toggle",
				name = L["Add quest givers"], desc = L["addLogQuestGivers"],
				get = function() return self.db.profile.addLogQuestGivers end,
				set = function(v)
					self.db.profile.addLogQuestGivers = v
					QuestLog_SetSelection(GetQuestLogSelection())
				end },
			logMove = { order = oldMenu.order + 6, type = "toggle",
				name = L["logMove"], desc = L["logMoveDesc"],
				get = function() return self.db.profile.logMove end,
				set = function(v)
					self.db.profile.logMove = v
					self:QuestLog_ToggleMoveable(v)
				end },
			logScale = { order = oldMenu.order + 7, type = "range",
				name = L["logScale"], desc = L["logScaleDesc"],
				min = 0.5, max = 1.5, step = 0.01, isPercent = true,
				get = function() return self.db.profile.logScale end,
				set = function(v)
					self.db.profile.logScale = v
					self:QuestLog_SetScale(v)
				end },
			dialogSpacer = { order = oldMenu.order + 8, type = "header" },
			dialogHeader = { order = oldMenu.order + 9, type = "header", name = L["Dialog"] },
			addDialogQuestLevels = { order = oldMenu.order + 10, type  = "toggle",
				name = L["Add quest levels"], desc = L["addDialogQuestLevels"],
				get = function() return self.db.profile.addDialogQuestLevels end,
				set = function(v)
					self.db.profile.addDialogQuestLevels = v
					if ( QuestFrameGreetingPanel:IsVisible() ) then
						if ( v ) then
							self:OnQuestGreeting()
						else
							QuestFrameGreetingPanel_OnShow()
						end
					elseif ( GossipFrame:IsVisible() ) then
						if ( v ) then
							self:OnGossipShow()
						else
							GossipFrameUpdate()
						end
					end
				end },
			greyIncompleteQuestIcons = { order = oldMenu.order + 11, type = "toggle",
				name = L["Grey incomplete quest icons"], desc = L["greyIncompleteQuestIcons"],
				get = function() return self.db.profile.greyIncompleteQuestIcons end,
				set = function(v)
					self.db.profile.greyIncompleteQuestIcons = v
					if ( not v ) then
						local texture
						for i=1, MAX_NUM_QUESTS, 1 do
							texture = _G["GossipTitleButton"..i.."GossipIcon"]
							texture:SetDesaturated(false)
							texture = _G["QuestTitleButton"..i.."QuestIcon"]
							texture:SetDesaturated(false)
						end
					end
					if ( QuestFrameGreetingPanel:IsVisible() ) then
						self:OnQuestGreeting()
					elseif ( GossipFrame:IsVisible() ) then
						self:OnGossipShow()
					end
				end } } }
	return menu
end

--Copied from FuBar_QuestsFu
function BlizzardFrames:OnGossipShow()
	local function gossip_loop(buttonIndex, do_texture, ...)
		local numQuests = select("#", ...)
		for i=2, numQuests, 3 do
			if ( self.db.profile.addDialogQuestLevels ) then
				local button = _G["GossipTitleButton"..buttonIndex]
				button:SetText(format("[%d] %s", select(i, ...), button:GetText()))
			end
			if ( self.db.profile.greyIncompleteQuestIcons ) and ( do_texture ) then
				local texture = _G["GossipTitleButton"..buttonIndex.."GossipIcon"]
				local qDone = select(5, Quixote:GetQuestByName(select(i-1, ...)))
				if ( qDone == 1 ) then
					texture:SetDesaturated(false)
				else
					texture:SetDesaturated(true)
				end
			end
			buttonIndex = buttonIndex + 1
		end
		return buttonIndex + 1
	end
	if ( self.db.profile.addDialogQuestLevels ) or ( self.db.profile.greyIncompleteQuestIcons ) then
		local buttonIndex = 1
		if ( GetGossipAvailableQuests() ) then
			buttonIndex = gossip_loop(buttonIndex, false, GetGossipAvailableQuests())
		end
		if ( GetGossipActiveQuests() ) then
			buttonIndex = gossip_loop(buttonIndex, true, GetGossipActiveQuests())
		end
	end
end

--Mostly copied from FuBar_QuestsFu
function BlizzardFrames:OnQuestGreeting()
	if ( self.db.profile.addDialogQuestLevels ) or ( self.db.profile.greyIncompleteQuestIcons ) then
		local numactive, numavailable = GetNumActiveQuests(), GetNumAvailableQuests()
		local title, level, button
		local o, GetTitle, GetLevel = 0, GetActiveTitle, GetActiveLevel
		for i=1, (numactive + numavailable) do
			if ( i == numactive + 1 ) then
				o, GetTitle, GetLevel = numactive, GetAvailableTitle, GetAvailableLevel
			end
			title = GetTitle(i-o)
			if ( self.db.profile.addDialogQuestLevels ) then
				level = GetLevel(i-o)
				button = _G["QuestTitleButton"..i]
				button:SetText(format("[%d] %s", level, title))
			end
			if ( self.db.profile.greyIncompleteQuestIcons ) then
				local texture = _G["QuestTitleButton"..i.."QuestIcon"]
				if ( i > numactive) then
					texture:SetDesaturated(false)
				else
					local qDone = select(5, Quixote:GetQuestByName(title))
					if ( qDone ) then
						texture:SetDesaturated(false)
					else
						texture:SetDesaturated(true)
					end
				end
			end
		end
	end
end

function BlizzardFrames:QuestLog_OnShow()
	if ( self.db.profile.logMove ) and ( self.db.profile.logX ) and ( self.db.profile.logY ) then
		QuestLogFrame:ClearAllPoints()
		QuestLogFrame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", self.db.profile.logX, self.db.profile.logY)
	end
end

function BlizzardFrames:QuestLog_SetScale(v)
	if ( v ) then
		QuestLogFrame:SetScale(v)
	else
		QuestLogFrame:SetScale(1)
	end
end

function BlizzardFrames:QuestLog_SetSelection(id)
	--Only process if the quest log is visible and the option is checked to add quest givers
	if ( QuestLogFrame:IsVisible() ) and ( self.db.profile.addLogQuestGivers ) then
		local qName = Quixote:GetQuestById(id)
		if ( qName ) and ( nQuestLog:IsModuleEnabled("QuestGivers") ) then
			local qgName, qgLoc, qgDist = nQuestLog:GetModule("QuestGivers"):GetQuestGiver(qName)
			local qObjText = QuestLogObjectivesText:GetText()
			local qgText = ""
			if ( qgName ) then
				qgText = L["Given by"]..":  "..qgName
				if ( qgLoc ) then
					qgText = qgText.."\n"..L["Location"]..":  "..qgLoc.zone..
						" ["..floor(qgLoc.x*100)..", "..floor(qgLoc.y*100).."]"
					if ( qgDist ) then
						qgText = qgText.." ("..floor(qgDist).." "..L["yd"]..")"
					end
				end
				qgText = qgText.."\n\n"
			end
			if qObjText ~= nil then
			QuestLogObjectivesText:SetText(qgText..qObjText)
			else
				QuestLogObjectivesText:SetText(qgText)
			end
		end
	end
end

function BlizzardFrames:QuestLog_ToggleMoveable(v)
	if ( v ) then
		QuestLogFrame:RegisterForDrag("LeftButton")
		QuestLogFrame:SetScript("OnDragStart", function() QuestLogFrame:StartMoving() end)
		QuestLogFrame:SetScript("OnDragStop",
			function()
				QuestLogFrame:StopMovingOrSizing()
				self.db.profile.logX = QuestLogFrame:GetLeft()
				self.db.profile.logY = QuestLogFrame:GetTop()
			end)
		QuestLogFrame:SetClampedToScreen(true)
	else
		QuestLogFrame:RegisterForDrag()
		QuestLogFrame:SetScript("OnDragStart", nil)
		QuestLogFrame:SetScript("OnDragStop", nil)
		QuestLogFrame:SetClampedToScreen(false)
	end
	if ( QuestLogFrame:IsVisible() ) then
		HideUIPanel(QuestLogFrame)
		ShowUIPanel(QuestLogFrame)
	end
end

--Copied from FuBar_QuestsFu
function BlizzardFrames:QuestLog_Update()
	--Only process if the quest log is visible and the option is checked to add quest levels
	if ( QuestLogFrame:IsVisible() ) and ( self.db.profile.addLogQuestLevels ) then
		for i=1, QUESTS_DISPLAYED, 1 do
			local titleLine = _G["QuestLogTitle"..i]
			if ( titleLine ) and ( titleLine:GetText() ) then
				local title, level, tag = Quixote:GetQuest(titleLine:GetText():trim())
				if ( title ) then
					titleLine:SetText("["..level..tag.."] "..title)
					local check = _G["QuestLogTitle"..i.."Check"]
					if ( check:IsVisible() ) then
						check:SetPoint("LEFT", titleLine, "LEFT", QuestLogDummyText:GetWidth() + 24, 0)
					end
				end
			end
		end
	end
end

function BlizzardFrames:QuestWatch_Update()
	if ( self.db.profile.hideTracker ) then
		QuestWatchFrame:Hide()
	end
end
