--[[-----------------------------------------------------------------

    Neal's MainBar v 3.1

    Copyright (c) 2008, Anton I. (Neal aka Neavx @ Alleria-EU)
    All rights reserved.

--]]-----------------------------------------------------------------

RANGE_INDICATOR = "R"

local nMainbar = CreateFrame("Frame")
local _G = getfenv(0)
local i, TEXTUREPATH

    --========[ config ]========--

local SHORT_BAR = true          -- a short blizzbar? false = no, true = yes

local SCALE = 0.875
local SHAPESCALE = 1            -- scale the shapeshift/stancebar     
local POSSESSSCALE = 1          -- scale the possesbarframe
local PETSCALE = 0.75              -- scale the petbar
local STRATA = "LOW"

local COUNT_FONTSIZE = 15
local HOTKEY_FONTSIZE = 12   
local MACRONAMES_FONTSIZE = 12

local GLOSS = true              -- a gloss texture?

local SHOW_KEYBINDS = true     -- show keybinds? false = hide, true = show
local SHOW_MACRONAMES = true   -- show macroname? false = hide, true = show

if (GLOSS == true) then TEXTUREPATH = "Interface\\AddOns\\nMainbar\\overlay_gloss" else TEXTUREPATH = "Interface\\AddOns\\nMainbar\\overlay" end
local FLASHTEXTURE = "Interface\\AddOns\\nMainbar\\highlight"
local CHECKEDTEXTURE = "Interface\\AddOns\\nMainbar\\checked"
local PUSHEDTEXTURE = "Interface\\AddOns\\nMainbar\\pushed"

    --========[ frame and texture stuff ]========--
    
local nMainbar_Textures = {    
    ["stuff_to_hide"] = {  
        MainMenuBarTexture2,
        MainMenuBarTexture3,
        MainMenuBarPageNumber,
        MainMenuBarPerformanceBarFrame,
        ActionBarUpButton,
        ActionBarDownButton,
        TalentMicroButton,
        CharacterMicroButton,
        SpellbookMicroButton,
        QuestLogMicroButton,
        SocialsMicroButton,
        MainMenuMicroButton,
        HelpMicroButton,
        LFGMicroButton,
        KeyRingButton,
        CharacterBag0Slot,
        CharacterBag1Slot,
        CharacterBag2Slot,
        CharacterBag3Slot,
        MainMenuMaxLevelBar2,
        MainMenuMaxLevelBar3,
        MainMenuXPBarTexture2,
        MainMenuXPBarTexture3,
        MainMenuBarBackpackButton,
    },
    ["no_texture"] = {
        ReputationWatchBarTexture2,
        ReputationWatchBarTexture3,
        ReputationXPBarTexture2,
        ReputationXPBarTexture3,
        SlidingActionBarTexture0,
        SlidingActionBarTexture1,
        ShapeshiftBarLeft,
        ShapeshiftBarMiddle,
        ShapeshiftBarRight,
        PossessBarLeft,
        PossessBarRight,
    },
    ["short_frames"] = {
        MainMenuBar,
        MainMenuBarMaxLevelBar,
        MainMenuBarMaxLevelBar,
        MainMenuExpBar,
        ReputationWatchStatusBar,
        ReputationWatchBar,
    },
    ["frame_scale"] = {
        MainMenuBar,
        MultiBarBottomLeft,
        MultiBarBottomRight,
        MultiBarRight,
        MultiBarLeft,
    },
    ["frame_strata"] = {
        MultiBarBottomLeft,          
        MultiBarBottomRight,
        MainMenuBar,
    },
}
    
-- ------------------------------------------------------------------------------
-- do not dublicate or copy the part below,
-- without the permisson of the author!                           
-- Copyright (c) 2008, Anton I. (Neal aka Neavx @ Alleria-EU)
-- All rights reserved.
-- ------------------------------------------------------------------------------
        
    --========[ petbar ]========--

for i = 1, NUM_PET_ACTION_SLOTS, 1 do
    local button = _G["PetActionButton"..i]
    button:SetHighlightTexture(PUSHEDTEXTURE)    
    button:SetPushedTexture(PUSHEDTEXTURE)
    button:SetCheckedTexture(CHECKEDTEXTURE) 
    
    local icon = _G["PetActionButton"..i.."Icon"]
    icon:SetTexCoord(0.055, 0.945, 0.055, 0.945)
    icon:SetPoint("TOPLEFT", button, "TOPLEFT", 1, -1)
    icon:SetPoint("BOTTOMRIGHT", button, "BOTTOMRIGHT", -1, 1)
    
    local flash = _G["PetActionButton"..i.."Flash"]
    flash:SetTexture(FLASHTEXTURE)
        
    local normal2 = _G["PetActionButton"..i.."NormalTexture2"]
    normal2:Hide()
    
    local name = _G["PetActionButton"..i.."Name"]
    name:Hide()

    local texture = button:CreateTexture(nil,"Overlay")
    texture:SetVertexColor(0.7, 0.6, 0.6)
    texture:SetTexture(TEXTUREPATH)
    texture:SetPoint("TOPRIGHT", button, "TOPRIGHT", 4, 4)  
    texture:SetPoint("BOTTOMLEFT", button, "BOTTOMLEFT", -4, -4)
end

    --========[ possessbar ]========--

for i = 1, NUM_POSSESS_SLOTS, 1 do
    local button = _G["PossessButton"..i]
    button:SetHighlightTexture(PUSHEDTEXTURE)    
    button:SetPushedTexture(PUSHEDTEXTURE)
    button:SetCheckedTexture(CHECKEDTEXTURE) 
    
    local icon = _G["PossessButton"..i.."Icon"]
    icon:SetTexCoord(0.055, 0.945, 0.055, 0.945)
    icon:SetPoint("TOPLEFT", button, "TOPLEFT", 1, -1)
    icon:SetPoint("BOTTOMRIGHT", button, "BOTTOMRIGHT", -1, 1)   

    local flash = _G["PossessButton"..i.."Flash"]
    flash:SetTexture(FLASHTEXTURE)
    
    local cooldown = _G["PossessButton"..i.."Cooldown"]
    
    local border = _G["PossessButton"..i.."Border"]    
    border:Hide()
    
    local normal = _G["PossessButton"..i.."NormalTexture"]
    normal:SetWidth(0.01)     -- hide the little border! 
    normal:SetHeight(0.01)    -- there is no other way to do this :(
  
    local texture = button:CreateTexture(nil, "BORDER")
    texture:SetVertexColor(0.7, 0.6, 0.6)
    texture:SetTexture(TEXTUREPATH)
    texture:SetPoint("TOPRIGHT", button, "TOPRIGHT", 4, 4)  
    texture:SetPoint("BOTTOMLEFT", button, "BOTTOMLEFT", -4, -4)
end

    --========[ shapeshiftbar ]========--

for i = 1, NUM_SHAPESHIFT_SLOTS, 1 do
    local button = _G["ShapeshiftButton"..i]
    button:SetHighlightTexture(PUSHEDTEXTURE)    
    button:SetPushedTexture(PUSHEDTEXTURE)
    button:SetCheckedTexture(CHECKEDTEXTURE)     
    
    local normal = _G["ShapeshiftButton"..i.."NormalTexture"]
    normal:SetTexture(TEXTUREPATH)
    normal:SetVertexColor(0.7, 0.6, 0.6)
    normal:SetTexCoord(0.055, 0.945, 0.055, 0.945)
    normal:SetPoint("TOPRIGHT", button, "TOPRIGHT", 2, 2)  
    normal:SetPoint("BOTTOMLEFT", button, "BOTTOMLEFT", -2, -2)    
    
    local icon = _G["ShapeshiftButton"..i.."Icon"]
    icon:SetTexCoord(0.06, 0.94, 0.06, 0.94)
    icon:SetPoint("TOPRIGHT", button, "TOPRIGHT", 1, 1)
    icon:SetPoint("BOTTOMLEFT", button, "BOTTOMLEFT", -1, -1)    
    
    local flash = _G["ShapeshiftButton"..i.."Flash"]
    flash:SetTexture(FLASHTEXTURE)    
    
    local macroname = _G["ShapeshiftButton"..i.."Name"]
    macroname:Hide()
    
    local cooldown = _G["ShapeshiftButton"..i.."Cooldown"]  -- dont need this atm
end 

    --========[ all other buttons ]========--

nMainbar:SetScript("OnEvent", function()
    if (event == "PLAYER_LOGIN") then
        for i = 1, 12 do
            skin("ActionButton", i) 
            skin("BonusActionButton", i)
            skin("MultiBarBottomRightButton", i)
            skin("MultiBarBottomLeftButton", i)
            skin("MultiBarLeftButton", i)
            skin("MultiBarRightButton", i)
        end
    end
end)
      
function skin(name, i)
    local button = _G[name..i]
    button:SetHighlightTexture(PUSHEDTEXTURE)    
    button:SetPushedTexture(PUSHEDTEXTURE)
    button:SetCheckedTexture(CHECKEDTEXTURE)
    
    local border = _G[name..i.."Border"]
    border:Hide()
    
    local icon = _G[name..i.."Icon"]
    icon:SetTexCoord(0.055, 0.945, 0.055, 0.945)

    local count = _G[name..i.."Count"]
    count:SetFont((count:GetFont()), COUNT_FONTSIZE, "OUTLINE")
    count:SetPoint("BOTTOMRIGHT", button, "BOTTOMRIGHT", -1, 2)
    
    local normal = _G[name..i.."NormalTexture"]
    normal:SetWidth(0.01)     -- hide the little border! 
    normal:SetHeight(0.01)    -- there is no other way to do this :(    
    
    local hotkey = _G[name..i.."HotKey"]
    hotkey:SetFont((hotkey:GetFont()), HOTKEY_FONTSIZE, "OUTLINE")
    if (SHOW_KEYBINDS == false) then 
        hotkey:Hide() 
    end    
    
    local macroname = _G[name..i.."Name"]
    macroname:SetFont((macroname:GetFont()), MACRONAMES_FONTSIZE, "OUTLINE")
    if (SHOW_MACRONAMES == false) then 
        macroname:Hide() 
    end    
    
    local cooldown = _G[name..i.."Cooldown"]   -- we don't need this atm

    local texture = button:CreateTexture(nil, "BORDER")
    texture:SetVertexColor(0.7, 0.6, 0.6)
    texture:SetPoint("TOPLEFT", button, "TOPLEFT", -3.5, 3.5)
    texture:SetPoint("BOTTOMRIGHT", button, "BOTTOMRIGHT", 3.5, -3.5)   
    texture:SetTexture(TEXTUREPATH)
    
    local backdrop = CreateFrame("Frame")
    backdrop:SetParent(button)
    backdrop:SetFrameStrata("BACKGROUND")
    backdrop:SetBackdrop({bgFile = "Interface\\AddOns\\nMainbar\\backdrop"})
    backdrop:SetAllPoints(button)
end
nMainbar:RegisterEvent("PLAYER_LOGIN")
    
    -- ----------------------------
    -- end of the skinning part...
    -- ----------------------------

    --========[ some settings ]========--

    ShapeshiftBarFrame:SetScale(SHAPESCALE)
    PossessBarFrame:SetScale(POSSESSSCALE)
    PetActionBarFrame:SetScale(PETSCALE)

    UIPARENT_MANAGED_FRAME_POSITIONS["MultiBarRight"] = nil   -- important or we can't move the bar!
    MultiBarRight:ClearAllPoints()
    MultiBarRight:SetPoint("RIGHT", -9, 0)

    for _, frame in pairs(nMainbar_Textures["frame_strata"]) do
        frame:SetFrameStrata(STRATA)
        frame:SetFrameLevel(3)
    end

    for _, frame in pairs(nMainbar_Textures["frame_scale"]) do
        frame:SetScale(SCALE)
    end

    --========[ a short mainbar! ]========--
    
if (SHORT_BAR == true) then
    MainMenuBarTexture0:SetPoint("BOTTOM", MainMenuBarArtFrame, "BOTTOM", -128, 0)
    MainMenuBarTexture1:SetPoint("BOTTOM", MainMenuBarArtFrame, "BOTTOM", 128, 0)

    MainMenuMaxLevelBar0:SetPoint("BOTTOM", MainMenuBarMaxLevelBar, "TOP", -128, 0)

    MainMenuXPBarTexture0:SetPoint("BOTTOM", MainMenuExpBar, "BOTTOM", -128, 3)
    MainMenuXPBarTexture1:SetPoint("BOTTOM", MainMenuExpBar, "BOTTOM", 128, 3)

    MainMenuBarLeftEndCap:SetPoint("BOTTOM", MainMenuBarArtFrame, "BOTTOM", -290, 0)
    MainMenuBarRightEndCap:SetPoint("BOTTOM", MainMenuBarArtFrame, "BOTTOM", 287, 0)

    for _, frame in pairs(nMainbar_Textures["stuff_to_hide"]) do
        frame:Hide()
        frame.Show = function() end
    end

    for _, frame in pairs(nMainbar_Textures["no_texture"]) do
        frame:SetTexture("")
    end

    for _, frame in pairs(nMainbar_Textures["short_frames"]) do
        frame:SetWidth(512)
    end
end