-- myMainBar v1.9 --


--------------------------------------------------------------------------------------------------
-- Global variables
--------------------------------------------------------------------------------------------------

BINDING_HEADER_MYMAINBAR = "myMainBar";


--------------------------------------------------------------------------------------------------
-- Overriden functions
--------------------------------------------------------------------------------------------------

-- Copy the original MainMenuBar_UpdateKeyRing function
myMainMenuBar_UpdateKeyRing = MainMenuBar_UpdateKeyRing;

-- Override MainMenuBar_UpdateKeyRing to display the keyring only on the standard bar
function MainMenuBar_UpdateKeyRing()

	-- Check if the small Main Bar is displayed
	if (myMainBarFrame:IsVisible()) then
		KeyRingButton:Hide();
	else
		myMainMenuBar_UpdateKeyRing();
	end

end


--------------------------------------------------------------------------------------------------
-- Event functions
--------------------------------------------------------------------------------------------------

-- OnLoad Event
function myMainBarFrame_OnLoad(self)

	-- Register the events that need to be watched
	self:RegisterEvent("ADDON_LOADED");
	self:RegisterEvent("ACTIONBAR_PAGE_CHANGED");

end

-- OnEvent Event
function myMainBarFrame_OnEvent(self, event, ...)

	if (event == "ADDON_LOADED") then
		local addon = select(1, ...);
		if (addon == "myMainBar") then
			-- Initialize the addon
			myMainBarFrame_Initialize();
		end
		return;
	end
	
	if (event == "ACTIONBAR_PAGE_CHANGED") then
		-- Update the bar page number on the small Main Bar
		myMainMenuBarPageNumber:SetText(MainMenuBarPageNumber:GetText());
		return;
	end

end


--------------------------------------------------------------------------------------------------
-- Initialize functions
--------------------------------------------------------------------------------------------------

-- Initialize the addon
function myMainBarFrame_Initialize()

	-- Adjust the action buttons
	ActionButton1:SetPoint("BOTTOMLEFT", "MainMenuBarArtFrame", "BOTTOMLEFT", 8, 3);
	BonusActionButton1:SetPoint("BOTTOMLEFT", "BonusActionBarFrame", "BOTTOMLEFT", 4, 3);
	
	-- Update the bar page number on the small Main Bar
	myMainMenuBarPageNumber:SetText(MainMenuBarPageNumber:GetText());
	
	-- Display the small Main Bar
	myMainBarFrame_Toggle();

end


--------------------------------------------------------------------------------------------------
-- Display functions
--------------------------------------------------------------------------------------------------

-- Toggle the Main Bar
function myMainBarFrame_Toggle()

	-- Check if the small Main Bar is displayed
	if (myMainBarFrame:IsVisible()) then
		MainMenuBar:SetWidth(1024);
		MainMenuExpBar:SetWidth(1024);
		MainMenuXPBarTexture0:SetPoint("BOTTOM", "MainMenuExpBar", "BOTTOM", -384, 3);
		MainMenuXPBarTexture1:SetPoint("BOTTOM", "MainMenuExpBar", "BOTTOM", -128, 3);
		MainMenuXPBarTexture2:SetPoint("BOTTOM", "MainMenuExpBar", "BOTTOM", 128, 3);
		MainMenuXPBarTexture3:Show();
		MainMenuBarMaxLevelBar:SetWidth(1024);
		MainMenuMaxLevelBar0:SetPoint("BOTTOM", "MainMenuBarMaxLevelBar", "TOP", -384, 0);
		MainMenuMaxLevelBar3:Show();
		ReputationWatchStatusBar:SetWidth(1024);
		ReputationWatchBarTexture3:SetTexture("Interface\\PaperDollInfoFrame\\UI-ReputationWatchBar");
		ReputationXPBarTexture3:SetTexture("Interface\\MainMenuBar\\UI-MainMenuBar-Dwarf");
		MainMenuBarTexture0:SetPoint("BOTTOM", "MainMenuBarArtFrame", "BOTTOM", -384, 0);
		MainMenuBarTexture1:SetPoint("BOTTOM", "MainMenuBarArtFrame", "BOTTOM", -128, 0);
		MainMenuBarTexture2:Show();
		MainMenuBarTexture3:Show();
		MainMenuBarRightEndCap:Show();
		myMainBarFrame:Hide();
		MainMenuBarLeftEndCap:SetPoint("BOTTOM", "MainMenuBarArtFrame", "BOTTOM", -544, 0);
		MainMenuBarPageNumber:Show();
		MainMenuBarPerformanceBarFrame:Show();
		MultiBarBottomLeft:SetPoint("BOTTOMLEFT", "ActionButton1", "TOPLEFT", 0, 18);
		MainMenuMicroButton:Show();
		HelpMicroButton:Show();
		MainMenuBar_UpdateKeyRing();
		MainMenuBarBackpackButton:Show();
		CharacterBag0Slot:Show();
		CharacterBag1Slot:Show();
		CharacterBag2Slot:Show();
		CharacterBag3Slot:Show();
	else
		MainMenuBar:SetWidth(768);
		MainMenuExpBar:SetWidth(768);
		MainMenuXPBarTexture0:SetPoint("BOTTOM", "MainMenuExpBar", "BOTTOM", -256, 3);
		MainMenuXPBarTexture1:SetPoint("BOTTOM", "MainMenuExpBar", "BOTTOM", -0, 3);
		MainMenuXPBarTexture2:SetPoint("BOTTOM", "MainMenuExpBar", "BOTTOM", 256, 3);
		MainMenuXPBarTexture3:Hide();
		MainMenuBarMaxLevelBar:SetWidth(768);
		MainMenuMaxLevelBar0:SetPoint("BOTTOM", "MainMenuBarMaxLevelBar", "TOP", -256, 0);
		MainMenuMaxLevelBar3:Hide();
		ReputationWatchStatusBar:SetWidth(768);
		ReputationWatchBarTexture3:SetTexture("");
		ReputationXPBarTexture3:SetTexture("");
		MainMenuBarTexture0:SetPoint("BOTTOM", "MainMenuBarArtFrame", "BOTTOM", -256, 0);
		MainMenuBarTexture1:SetPoint("BOTTOM", "MainMenuBarArtFrame", "BOTTOM", 0, 0);
		MainMenuBarTexture2:Hide();
		MainMenuBarTexture3:Hide();
		myMainBarFrame:Show();
		MainMenuBarLeftEndCap:SetPoint("BOTTOM", "MainMenuBarArtFrame", "BOTTOM", -416, 0);
		MainMenuBarRightEndCap:Hide();
		MainMenuBarPageNumber:Hide();
		MainMenuBarPerformanceBarFrame:Hide();
		MultiBarBottomLeft:SetPoint("BOTTOMLEFT", "ActionButton1", "TOPLEFT", -128, 18);
		MainMenuMicroButton:Hide();
		HelpMicroButton:Hide();
		MainMenuBar_UpdateKeyRing();
		MainMenuBarBackpackButton:Hide();
		CharacterBag0Slot:Hide();
		CharacterBag1Slot:Hide();
		CharacterBag2Slot:Hide();
		CharacterBag3Slot:Hide();
	end

end
