-- myClock v1.9 --


--------------------------------------------------------------------------------------------------
-- Local variables
--------------------------------------------------------------------------------------------------

local MYCLOCK_LOCK;


--------------------------------------------------------------------------------------------------
-- Event functions
--------------------------------------------------------------------------------------------------

-- OnLoad event
function myClockFrame_OnLoad(self)

	-- Register the events that need to be watched
	this:RegisterEvent("ADDON_LOADED");

end

-- OnEvent event
function myClockFrame_OnEvent(self, event, ...)

	-- Check the current event
	if (event == "ADDON_LOADED") then
		local addon = select(1, ...);
		if (addon == "myClock") then
			-- Initialize the addon
			myClockFrame_Initialize();
		end
		return;
	end

end

-- OnUpdate event
function myClockFrame_OnUpdate(elapsed)

	-- Check if an update is needed
	if ( this.updateTimer <= elapsed ) then
		this.updateTimer = FRAMERATE_FREQUENCY;
		-- Get the server time
		local hour, minute = GetGameTime();
		-- Apply the offset option
		hour = hour + myClockOptions.offset;
		-- Apply the half hour offsets option
		if (myClockOptions.halfhourOffsets) then
			minute = minute + 30;
		end
		-- Check the minutes
		if (minute >= 60) then
			minute = minute - 60;
			hour = hour + 1;
		end
		-- Check the hours
		if (hour >= 24) then
			hour = hour - 24;
		elseif (hour < 0) then
			hour = hour + 24;
		end
		-- Check the time format option
		if (myClockOptions.timeFormat == 24) then
			myClockFrameText:SetText(format(TEXT(TIME_TWENTYFOURHOURS), hour, minute));
		else
			local pm = 0;
			if (hour >= 12) then
				pm = 1;
			end
			if (hour > 12) then
				hour = hour - 12;
			end
			if (hour == 0) then
				hour = 12;
			end
			if (pm == 0) then
				myClockFrameText:SetText(string.gsub(string.sub(format(TEXT(TIME_TWELVEHOURAM), hour, minute),1,5)," ","").." AM");
			else
				myClockFrameText:SetText(string.gsub(string.sub(format(TEXT(TIME_TWELVEHOURPM), hour, minute),1,5)," ","").." PM");
			end
		end
	else
		this.updateTimer = this.updateTimer - elapsed;
	end

end

-- OnMouseDown event
function myClockFrame_OnMouseDown(self, button, down)

	-- Check the button used
	if (not self.isLocked and arg1 == "LeftButton") then
		self:StartMoving();
		self.isMoving = true;
	end

end;

-- OnMouseUp event
function myClockFrame_OnMouseUp(self, button, down)

	-- Check the button used
	if (button == "LeftButton") then
		if (self.isMoving) then
			self:StopMovingOrSizing();
			self.isMoving = false;
		end
    elseif (button == "RightButton") then
		ToggleDropDownMenu(1, nil, myClockFrameDropDownMenu, "cursor");
	end

end;


--------------------------------------------------------------------------------------------------
-- Initialize functions
--------------------------------------------------------------------------------------------------

-- Initialize the addon
function myClockFrame_Initialize()

	-- Toggle the clock frame lock
	myClockFrame_ToggleLock();
	
	-- Initialize the dropdown menu
	UIDropDownMenu_Initialize(myClockFrameDropDownMenu, myClockFrameDropDownMenu_Initialize, "MENU");
	
	-- Initialize the options frame
	myClockOptionsFrame_Initialize();
	
	-- Update the display
	myClockFrame_Update();

end

-- Initialize the dropdown menu
function myClockFrameDropDownMenu_Initialize()

	local info;
	
	info = {};
	info.text = "myClock";
	info.isTitle = 1;
	info.notCheckable = 1;
	UIDropDownMenu_AddButton(info);
	
	info = {};
	info.text = MYCLOCK_LOCK;
	info.func = myClockFrame_ToggleLock;
	info.notCheckable = 1;
	UIDropDownMenu_AddButton(info);
	
	info = {};
	info.text = MYCLOCK_OPTIONS;
	info.func = myClockOptionsFrame_Toggle;
	info.notCheckable = 1;
	UIDropDownMenu_AddButton(info);
	
	info = {};
	info.text = CANCEL;
	info.func = CloseDropDownMenus;
	info.notCheckable = 1;
	UIDropDownMenu_AddButton(info);

end


--------------------------------------------------------------------------------------------------
-- Display functions
--------------------------------------------------------------------------------------------------

-- Update the display
function myClockFrame_Update()

	-- Check the show day/night option
	if (myClockOptions.showDayNight) then
		GameTimeFrame:Show();
	else
		GameTimeFrame:Hide();
	end
	
	-- Reset the update timer
	myClockFrame.updateTimer = 0;

end

-- Toggle the clock frame lock
function myClockFrame_ToggleLock()

	-- Check the clock frame lock
	if (myClockFrame.isLocked) then
		myClockFrame.isLocked = nil;
		MYCLOCK_LOCK = MYCLOCK_LOCK_POSITION;
	else
		myClockFrame.isLocked = 1;
		MYCLOCK_LOCK = MYCLOCK_UNLOCK_POSITION;
	end

end
