-- myClock v1.9 --


--------------------------------------------------------------------------------------------------
-- Localized global variables
--------------------------------------------------------------------------------------------------

MYCLOCK_HELP = {
	"Usage\n=====\n\nTo setup the clock, right click on it.\n\nThe default options are:\n\n     - Half-hour Offsets = No\n     - Offset = 0 Hour\n     - Show Day/Night Button = No\n     - Time Format = 12 Hours"
};
MYCLOCK_LOCK_POSITION = "Lock Position";
MYCLOCK_UNLOCK_POSITION = "Unlock Position";
MYCLOCK_OPTIONS = "Options";
MYCLOCK_OPTIONS_TITLE = "myClock Options";
MYCLOCK_OPTIONS_SHOW_DAYNIGHT = "Show Day/Night Button";
MYCLOCK_OPTIONS_HALFHOUR_OFFSETS = "Half-hour Offsets";
MYCLOCK_OPTIONS_OFFSET = "Offset";
MYCLOCK_OPTIONS_HOURS = " Hours";
MYCLOCK_OPTIONS_TIME_FORMAT = "Time Format";
MYCLOCK_DEFAULT_TIME_FORMAT = 12;

-- Get the client language
local clientLanguage = GetLocale();

-- Check the client language
if (clientLanguage == "deDE") then
	MYCLOCK_HELP = {
		"Benutzung\n========\n\nUm die Uhr einzustellen, rechtsklicken Sie auf sie.\n\nDie Standardoptionen sind:\n\n     - Halbstunde Zeitunterschiede = Nein\n     - Zeitunterschied = 0 Stunde\n     - Tag/Nacht Knopf anzeigen = Nein\n     - Zeitformat = 24 Stunden"
	};
	MYCLOCK_LOCK_POSITION = "Position fixieren";
	MYCLOCK_UNLOCK_POSITION = "Position freigeben";
	MYCLOCK_OPTIONS = "Optionen";
	MYCLOCK_OPTIONS_TITLE = "myClock Optionen";
	MYCLOCK_OPTIONS_SHOW_DAYNIGHT = "Tag/Nacht Knopf anzeigen";
	MYCLOCK_OPTIONS_HALFHOUR_OFFSETS = "Halbstunde Zeitunterschiede";
	MYCLOCK_OPTIONS_OFFSET = "Zeitunterschied";
	MYCLOCK_OPTIONS_HOURS = " Stunden";
	MYCLOCK_OPTIONS_TIME_FORMAT = "Zeitformat";
	MYCLOCK_DEFAULT_TIME_FORMAT = 24;
elseif (clientLanguage == "esES" ) then
	MYCLOCK_HELP = {
		"Usar\n=====\n\nLas opciones por defecto son:\n\n     - Decalaje de media hora = No\n     - Decalaje = 0 Hora\n     - Mostrar boton día/noche = No\n     - Formato de la hora = 12 Horas"
	};
	MYCLOCK_LOCK_POSITION = "Bloquear posición";
	MYCLOCK_UNLOCK_POSITION = "Liberar posición";
	MYCLOCK_OPTIONS = "Opciones";
	MYCLOCK_OPTIONS_TITLE = "Opciones myClock";
	MYCLOCK_OPTIONS_SHOW_DAYNIGHT = "Mostrar boton día/noche";
	MYCLOCK_OPTIONS_HALFHOUR_OFFSETS = "Decalaje de media hora";
	MYCLOCK_OPTIONS_OFFSET = "Decalaje";
	MYCLOCK_OPTIONS_HOURS = " Horas";
	MYCLOCK_OPTIONS_TIME_FORMAT = "Formato de la hora";
	MYCLOCK_DEFAULT_TIME_FORMAT = 12;
elseif (clientLanguage == "frFR") then
	MYCLOCK_HELP = {
		"Utilisation\n========\n\nPour configurer l'horloge, cliquez dessus avec le bouton droit de la souris.\n\nLes options par défaut sont:\n\n     - Décalages d'une-demie heure = Non\n     - Décalage = 0 Heure\n     - Afficher le bouton Jour/Nuit = Non\n     - Affichage de l'heure = 24 Heures"
	};
	MYCLOCK_LOCK_POSITION = "Verrouiller la position";
	MYCLOCK_UNLOCK_POSITION = "Déverrouiller la position";
	MYCLOCK_OPTIONS = "Options";
	MYCLOCK_OPTIONS_TITLE = "myClock Options";
	MYCLOCK_OPTIONS_SHOW_DAYNIGHT = "Afficher le bouton Jour/Nuit";
	MYCLOCK_OPTIONS_HALFHOUR_OFFSETS = "Décalages d'une demie-heure";
	MYCLOCK_OPTIONS_OFFSET = "Décalage";
	MYCLOCK_OPTIONS_HOURS = " Heures";
	MYCLOCK_OPTIONS_TIME_FORMAT = "Affichage de l'heure";
	MYCLOCK_DEFAULT_TIME_FORMAT = 24;
end
