if IsAddOnLoaded("Nurfed_ActionBars") then
	local FrameList = {
		action = { "Nurfed_ActionButton", 120 },
		pet = { "Nurfed_petbar", 10 },
		shapeshift = { "Nurfed_stancebar", 10 },
	}

	local FrameId = {
		action = function (name, id)
			local b = getglobal (name)
			if b and b:IsVisible () then
				return b:GetID()
			end
		end,
		shapeshift = function (name, id)
			local b = getglobal (name)
			if b and b:IsVisible () then
				if GetNumShapeshiftForms () >= id then
					return id
				end
			end
		end,
		pet = function (name, id)
			if PetHasActionBar() then
				local b = getglobal (name)
				if b and b:IsVisible () then
					local name, _, _, isToken = GetPetActionInfo(id)
					if name and not isToken then
						return id
					end
				end
			end
		end,
	}

	local function Nurfed_Buttons_UpdateCountList(add)
		for type, frames in pairs(FrameList) do
			for i = 1, frames[2] do
				local name = frames[1]..i
				local id = FrameId[type] (name, i)
				local frame = getglobal(name.."Count")
				if id and frame then
					add(frame, type, id)
				end
			end
		end
	end

	ltc:RegisterPlugin(Nurfed_Buttons_UpdateCountList)
end
