--The List of frames to check against.
local FrameList = {
	action = {
		{ "ActionButton", 12 },
		{ "BonusActionButton", 12 },
		{ "MultiBarBottomLeftButton", 12 },
		{ "MultiBarBottomRightButton", 12 },
		{ "MultiBarRightButton", 12 },
		{ "MultiBarLeftButton", 12 },
	},
	shapeshift = {
		{ "ShapeshiftButton", 10 },
	},
	pet = {
		{ "PetActionButton", 10 },
	},
}

local FrameId = {
	action = function (name, id)
		local b = getglobal (name)
		if b and b:IsVisible () then
			return ActionButton_GetPagedID (b)
		end
	end,
	shapeshift = function (name, id) 
		local b = getglobal (name)
		if b and b:IsVisible () then
			if GetNumShapeshiftForms () >= id then
				return id
			end
		end
	end,
	pet = function (name, id)
		local b = getglobal (name)
		if b and b:IsVisible () then
			if PetHasActionBar() then
				local name, _, _, isToken = GetPetActionInfo(id)
				if name and not isToken then
					return id
				end
			end
		end
	end,
}

local function Default_Buttons_UpdateCountList(add)
	for type, l in pairs(FrameList) do
		for _, frames in ipairs(l) do
			for i = 1, frames[2] do
				local name = frames[1]..i
				local id = FrameId[type] (name, i)
				local frame = getglobal(name.."Count")
				if id and frame then
					add(frame, type, id)
				end
			end
		end
	end
end

--Make lern2count aware of this plugin
ltc:RegisterPlugin(Default_Buttons_UpdateCountList)
