if IsAddOnLoaded("Bongos") then
	
	local FrameList = {
		action = { "BActionButton", 120 },
		pet = { "BPetActionButton", 10 },
		shapeshift = { "BClassBarButton", 10 },
	}

	local FrameId = {
		action = function (name, id)
			local b = getglobal (name)
			if b and b:IsVisible () then
--				return BActionButton:GetPagedID(b:GetID())
				return b:GetPagedID()
			end
		end,
		shapeshift = function (name, id) 
			local b = getglobal (name)
			if b and b:IsVisible () then
				if GetNumShapeshiftForms () >= id then
					return id
				end
			end
		end,
		pet = function (name, id)
			if PetHasActionBar() then
				local b = getglobal (name)
				if b and b:IsVisible () then
					local name, _, _, isToken = GetPetActionInfo(id)
					if name and not isToken then
						return id
					end
				end
			end
		end,
	}
	
	local function Bongos_AddCount(name)
		local button = getglobal(name)
		if not button then return end
		local count = button:CreateFontString(name.."Count", "ARTWORK")
		count:SetFontObject(NumberFontNormal)
		count:SetPoint("BOTTOMRIGHT", button, "BOTTOMRIGHT", -2, -2)
		count:SetJustifyH("RIGHT")
		return count
	end

	local function Bongos_Buttons_UpdateCountList(add)
		for type, frames in pairs(FrameList) do
			for i = 1, frames[2] do
				local name = frames[1]..i
				local id = FrameId[type] (name, i)
				local frame = getglobal(name.."Count")
				if not frame and type == "pet" or type == "shapeshift" then
					frame = Bongos_AddCount(name)
				end
				if id and frame then
					add(frame, type, id)
				end
			end
		end
	end
	
	ltc:RegisterPlugin(Bongos_Buttons_UpdateCountList)
end
