if not IsAddOnLoaded("Bongos_AB") then return end

local Bongos = LibStub('AceAddon-3.0'):GetAddon('Bongos3')
local ActionButton = Bongos:GetModule('ActionBar').Button

local FrameList = {
	action = { "Bongos3ActionButton", 120 },
	shapeshift = { "BongosClassButton", 10 },
}

local FrameId = {
	action = function (name, id)
		local b = getglobal (name)
		if b and b:IsVisible () then
			return b:GetPagedID()
		end
	end,
	shapeshift = function (name, id)
		local b = getglobal (name)
		if b and b:IsVisible () then
			if GetNumShapeshiftForms () >= id then
				return id
			end
		end
	end,
}

local function Bongos3_Buttons_UpdateCountList(add)
	for type, frames in pairs(FrameList) do
		for i = 1, frames[2] do
			local name = frames[1]..i
			local id = FrameId[type] (name, i)
			local frame = getglobal(name.."Count")
			if id and frame then
				add(frame, type, id)
			end
		end
	end
end

ltc:RegisterPlugin(Bongos3_Buttons_UpdateCountList)

