--------------------------
--		Initialization     --
--------------------------

kGo = LibStub("AceAddon-3.0"):NewAddon("kGo", "AceEvent-3.0", "AceConsole-3.0")

setglobal("BINDING_HEADER_KGO", "kGo - IMPORTANT: Only set the first keybind - Display kGo Window. ")

local options, moduleOptions = nil, {}
kGo.options ={
	type = "group",
	name = "kGo",
	args = {
		scale = {
			order = 1,
			type = "range",
			name = "Scale",
			get = function() return kGo.db.profile.scale end,
			set = function(info, value) 
						kGo.db.profile.scale = value 
						kGo.frame:SetScale(value) 
					end,
			min = 0.5, max = 2.0, step = 0.05			
		},
		keybindShowFrame = {
			order = 2, 
			type = "keybinding",
			name = "Show Frame Keybinding",
			get = function() return GetBindingKey("Display kGo Window") end,
			set = function(info, value) 
						SetBinding(value, "Display kGo Window") 
						SaveBindings(2) -- save for character
					end,
		},
		
	},
	plugins = {
	
	},
}

function kGo:OnInitialize()
	local defaults = {
		profile = {
			scale = 1.0,
			
			-- positioning
			point = "CENTER",
			relPoint = "CENTER",
			offsetX = 0,
			offsetY = 0,
						
		},
		char = {
			display = "Grid",
		}
	}
	
	self.db = LibStub("AceDB-3.0"):New("kGoDB", defaults)
	
	-- options
	LibStub("AceConfig-3.0"):RegisterOptionsTable("kGo", self.options)
	self:RegisterChatCommand("kgo", "ChatCommand")
	self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("kGo", "kGo")
end

function kGo:OnEnable()
	-- create main frame
	if not self.frame then
		self:CreateMainFrame()
	end
end

function kGo:OnDisable()

end
-------------------
--		Options    --
-------------------

function kGo:ChatCommand(input)
	if not input or input:trim() == "" then
		LibStub("AceConfigDialog-3.0"):Open("kGo")
	else
		LibStub("AceConfigCmd-3.0").HandleCommand(kGo, "kgo", input)
	end
end
-------------------------------
--		Main Frame Creation    --
-------------------------------

function kGo:CreateMainFrame()
	self.frame = CreateFrame("Frame", "kGoFrame", UIParent)
	
	local f = self.frame
	
	-- aesthetics 
	f:SetWidth(330)
	f:SetHeight(200)
	f:SetScale(self.db.profile.scale)
	
	f:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
		tile = true, tileSize = 0, edgeSize = 16,
		insets = {left = 4, right = 4, top = 4, bottom = 4}
	})
	
	self.frame:SetBackdropColor(0, 0.2, 0.65, 1)
	
	-- behaviour
	f:SetPoint(self.db.profile.point, UIParent, self.db.profile.relPoint, self.db.profile.offsetX, self.db.profile.offsetY)
	
	f:EnableMouse(true)
	--f:EnableKeyboard(true)
	f:SetMovable(true)
	f:RegisterForDrag("LeftButton")
	
	f:SetScript("OnDragStart", function() this:StartMoving() end)
	f:SetScript("OnDragStop", function() this:StopMovingOrSizing() self:SaveFramePosition() end)
	
	f:SetFrameStrata("DIALOG")
	
	f:Hide()
end

function kGo:SaveFramePosition()
		local point, _, relPoint, x, y = self.frame:GetPoint()
		self.db.profile.point = point
		self.db.profile.relPoint = relPoint
		self.db.profile.offsetX = x
		self.db.profile.offsetY = y
end

--------------------------------
--		Main Frame Manipulation  --
--------------------------------

function kGo:ShowkGoFrame()
	if InCombatLockdown() then
		return
	end
	self.frame:Show()
end

