--[[
This module is the intial inception of the addon. 

A 2 (or sometimes 3) button panel which is more compact than the grid layout which is used.
This module will be developed later because its still cool.

- Sole



function kGo:CreateMainFrame()
	kGo.frame = CreateFrame("Frame", "kGoFrame", UIParent)
	
	local f = kGo.frame
	
	-- aesthetics 
	f:SetWidth(330)
	f:SetHeight(200)
	f:SetScale(self.db.profile.scale)
	
	f:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
		tile = true, tileSize = 0, edgeSize = 16,
		insets = {left = 4, right = 4, top = 4, bottom = 4}
	})
	
	self.frame:SetBackdropColor(0, 0.2, 0.65, 1)
	
	-- behaviour
	f:SetPoint("TOPLEFT", UIParent, self.db.profile.relPoint, self.db.profile.offsetX, self.db.profile.offsetY)
	
	f:EnableMouse(true)
	f:EnableKeyboard(true)
	f:SetMovable(true)
	f:RegisterForDrag("LeftButton")
	
	f:SetScript("OnDragStart", function() this:StartMoving() end)
	f:SetScript("OnDragStop", function() this:StopMovingOrSizing() self:SaveFramePosition() end)
	f:SetScript("OnKeyUp", function(frame, arg1) self:OnKeyUp(arg1) end)
	
	f:SetFrameStrata("DIALOG")
	
	f:Hide()
end
------------------------
--		Button Creation  --
------------------------

function kGo:CreateButtons()
	self.frame.button1 = CreateFrame("Frame", "kGoButton1", kGoFrame)
	self.frame.button2 = CreateFrame("Frame", "kGoButton2", kGoFrame)
	
	for i=1, 2 do
		local b = self.frame["button"..i]
		b:SetHeight(150)
		b:SetWidth(140)
		b:SetScale(self.db.profile.scale)
		
		b:SetBackdrop({
			bgFile = "Interface/Tooltips/UI-Tooltip-Background",
			edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
			tile = true, tileSize = 0, edgeSize = 8,
			insets = {left = 2, right = 2, top = 2, bottom = 2}
		})
		
		b:SetBackdropColor(0,0,0,0.5)
		
		b.texture = b:CreateTexture("kGoButtonTexture"..i, "OVERLAY")
		b.texture:SetPoint("TOP", b, "TOP", 0, -10)
		b.texture:SetTexture("Interface\\Icons\\INV_Misc_Rune_01")
		b.texture:SetHeight(110*self.db.profile.scale)
		b.texture:SetWidth(115*self.db.profile.scale)
		
		b.highlight = b:CreateTexture("kGoButtonHighlight"..i, "HIGHLIGHT")
		b.highlight:SetPoint("TOP", b, "TOP", 0, -10)
		b.highlight:SetTexture(1, 1, 1, 0.5)
		b.highlight:SetHeight(110*self.db.profile.scale)
		b.highlight:SetWidth(115*self.db.profile.scale)
		
		b:EnableMouse(true)
	end
	
	self.frame.button1:SetPoint("TOPLEFT", "kGoFrame", "TOPLEFT", 20, -20)	
	self.frame.button2:SetPoint("TOPRIGHT", "kGoFrame", "TOPRIGHT", -20, -20)
end
]]