﻿
-- Version & Date
local MAJOR_VERSION = "2.0"
local MINOR_VERSION = tonumber((string.gsub("$Revision: 56789 $", "^.-(%d+).-$", "%1")))

-- Libs
gfxToggle = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "AceConsole-2.0", "AceDebug-2.0", "FuBarPlugin-2.0")
local L = AceLibrary("AceLocale-2.2"):new("gfxToggle")

local metro = AceLibrary("Metrognome-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")

-- Keybinding
BINDING_HEADER_GFX		= L["gfxToggle2"]
BINDING_NAME_GFX_TOGGLE	= L["Toggle graphics"]
BINDING_NAME_GFX_AUTO	= L["Auto-Mode"]

-- About
local gfxToggle = gfxToggle
gfxToggle.title = "gfxToggle2"
gfxToggle.version = MAJOR_VERSION .. "." .. MINOR_VERSION
gfxToggle.date = string.gsub("$Date: 2007-12-10 15:14:50 +0000 (Mon, 10 Dec 2007) $", "^.-(%d%d%d%d%-%d%d%-%d%d).-$", "%1")
gfxToggle.clickableTooltip = true
gfxToggle.hasText = true
gfxToggle.hasIcon = true
gfxToggle.printFrame = DEFAULT_CHAT_FRAME
gfxToggle.debugFrame = DEFAULT_CHAT_FRAME

-- Initializing
function gfxToggle:OnInitialize()
	self:RegisterStuff()
	self:CreateOptions()

	self:RegisterChatCommand({ "/gfxt", "/gfxtoggle" }, self.Options)
	self.OnMenuRequest = self.Options

	self:MainInit()
end

-- Enable / Disable Options
function gfxToggle:OnEnable()
	self:SetDebugging(false)
	self:AutoReg()
end

function gfxToggle:OnDisable()
	self:UnregMetro()
	metro:Unregister("gfxTUpdate")
end

-- Create Options
function gfxToggle:CreateOptions()
	self.Options = {
		desc = L["gfxToggle2 Options"],
		type = "group",
		args = {
			save = {
				guiHidden = true,
				name = L["Save"],
				desc = L["Saves your custom settings."],
				usage = L["Change settings in WoW Graphic-Options (World Appearance, Shaders and Misc). After that click on the Ok-Button and save settings."],
				type = "text",
				get = false,
				set = function(v) self:Save(v) end,
				validate = {"low", "med", "high"},
			},
			spacer = { type = "header", order = 80 },
			guisave = {
				cmdHidden = true,
				name = L["Save"], order = 250,
				desc = L["Change settings in WoW Graphic-Options (World Appearance, Shaders and Misc). After that click on the Ok-Button and save settings."],
				type = "group",
				args = {
					low = {
						name = L["Low"], order = 1,
						type = "execute",
						desc = L["Saves settings for: "]..L["|cff00ff00Low|r"],
						func = function(v) self:Save("low") end,
					},
					med = {
						name = L["Medium"], order = 2,
						type = "execute",
						desc = L["Saves settings for: "]..L["|cffffff00Medium|r"],
						func = function(v) self:Save("med") end,
					},
					high = {
						name = L["High"], order = 3,
						type = "execute",
						desc = L["Saves settings for: "]..L["|cffff0000High|r"],
						func = function(v) self:Save("high") end,
					},
				},
			},
			auto = {
				name = L["Auto"], order = 600,
				desc = L["Checks your zone database and toggles the saved settings automatically."],
				type = "toggle",
				get = function() return self.data.optionsDB.Auto end,
				set = function(v) self.data.optionsDB.Auto = v self:Auto() end,
			},
			medium = {
				name = L["Medium"], order = 1000,
				desc = string.format(L["Does allow the use of the settings: %s."], L["|cffffff00Medium|r"]),
				type = "toggle",
				get = function() return self.data.optionsDB.UseMedium end,
				set = function(v) self.data.optionsDB.UseMedium = v end,
			},
			toggle = {
				guiHidden = true,
				name = L["Toggle"], order = 500,
				desc = string.format(L["Toggles between %s, %s (if turned on by '/gfxt medium') and %s."],
					L["|cff00ff00Low|r"], L["|cffffff00Medium|r"], L["|cffff0000High|r"]),
				type = "execute",
				func = "Toggle",
			},
			shorttext = {
				cmdHidden = true,
				name = L["Short Text"], order = 1300,
				desc = L["Toggles text display"],
				type = "toggle",
				get = function() return self.data.optionsDB.ShortText end,
				set = function(v) self.data.optionsDB.ShortText = v self:Update() end,
			},
			addl = {
				guiHidden = true,
				name = L["Add "]..L["|cff00ff00Low|r"],
				desc = L["Adds zone for setting: "]..L["|cff00ff00Low|r"],
				usage = '<'..L["this"]..'> '..L["Adds the current zone. "]..'<'..L["name"]..'> '..L["Adds the specified zone."],
				type = "text",
				get = false,
				set = function(i) self:Add(i, "low") end,
			},
			addm = {
				guiHidden = true,
				name = L["Add "]..L["|cffffff00Medium|r"],
				desc = L["Adds zone for setting: "]..L["|cffffff00Medium|r"],
				usage = '<'..L["this"]..'> '..L["Adds the current zone. "]..'<'..L["name"]..'> '..L["Adds the specified zone."],
				type = "text",
				get = false,
				set = function(i) self:Add(i, "med") end,
			},
			guiadd = {
				cmdHidden = true,
				type = "group",
				name = L["Add "]..L["zone"], order = 50,
				desc = L["Adds the specified zone."],
				args = {
					gaddl = {
						name = L["Low"], order = 1,
						desc = L["Adds zone for setting: "]..L["|cff00ff00Low|r"],
						usage = '<'..L["name"]..'> '..L["Adds the specified zone."],
						type = "text",
						error = '<'..L["name"]..'> '..L["Adds the specified zone."],
						get = false,
						set = function(v) self:Add(v, "low") end,
						validate = function(v) return v ~= "" and string.gsub(v, " ", "") ~= "" end,
					},
					gaddm = {
						name = L["Medium"], order = 2,
						desc = L["Adds zone for setting: "]..L["|cffffff00Medium|r"],
						usage = '<'..L["name"]..'> '..L["Adds the specified zone."],
						type = "text",
						get = false,
						set = function(v) self:Add(v, "med") end,
						validate = function(v) return v ~= "" and string.gsub(v, " ", "") ~= "" end,
					},
				},
			},
			del = {
				guiHidden = true,
				name = L["Delete "]..L["zone"],
				desc = L["Deletes a zone from database."],
				usage = '<'..L["this"]..'> '..L["Deletes current zone."]..' <'..L["name"]..'> '
					..L["Deletes specified zone."]..' <'..L["All"]..'> '..L["Deletes all zones."],
				type = "text",
				get = false,
				set = function(i) self:Del(i) end,
			},
			guidel = {
				cmdHidden = true,
				name = L["Delete "]..L["zone"], order = 60,
				desc = L["Deletes a zone from database."],
				type = "group",
				args = {
					allzones = {
						name = L["All"], order = 3,
						desc = L["Deletes all zones."],
						type = "execute",
						func = function() StaticPopup_Show("GFXTOGGLE_ZONES_RESET") end,
					},
				},
			},
			spacer2 = { type = "header", order = 350 },
			list = {
				guiHidden = true,
				name = L["List"], order = 400,
				desc = L["Lists all saved zones."],
				type = "execute",
				func = "List",
			},
			reset = {
				name = L["Reset"], order = 2000,
				desc = L["Resets all settings to their defaults."],
				type = "execute",
				func = function() StaticPopup_Show("GFXTOGGLE_OPTIONS_RESET") end,
			},
			mute = {
				name = L["Mute"], order = 800,
				desc = L["Toggles screen messages."],
				type = "toggle",
				get = function() return self.data.optionsDB.Mute end,
				set = function(v) self.data.optionsDB.Mute = v end,
			},
			m2faster = {
				name = L["M2Faster"], order = 900,
				desc = L["Toggle Blizzard's M2Faster-Function to improve performance in crowded areas. Default is: |cff00ff00On|r"],
				type = "toggle",
				get = function() return self.data.optionsDB.M2Faster end,
				set = function(v)
					self.data.optionsDB.M2Faster = v
					if self.data.optionsDB.M2Faster then SetCVar("M2Faster", 1)	else SetCVar("M2Faster", 0)	end
				end,
			},
			restartGX = {
				name = L["RestartGx"], order = 1100,
				desc = L["Allows re-initializing of the graphics driver (needed for VSync)."],
				usage = L["To switch VSync, Tripplebuffer and Smooth Mouse the game has to restart the graphics. "..
					"While it does the restart, it'll switch to the desktop and back to game after a duration of 1-2 seconds. "..
					"By using this command you allow switching these settings. Default is: |cffff5050Off|r."],
				type = "toggle",
				get = function() return self.data.optionsDB.gxRestart end,
				set = function(v) self.data.optionsDB.gxRestart = v end,
			},
			delay = {
				name = L["Delay"], order = 700,
				desc = L["Sets a delay for the Auto-Mode. (Default: [|cfff5f5305|r] seconds)"],
				type = "range",
				get = function() return self.data.optionsDB.Delay end,
				set = function(v)
					self.data.optionsDB.Delay = v
					self.delay = v
					metro:ChangeRate("gfxTLow", self.delay, "gfxTMed", self.delay, "gfxTHigh", self.delay, "gfxTZone", self.delay)
				end,
				min = 1, max = 60, step = 0.5,
			},
		},
	}
end

-- MinimapFix
function gfxToggle:MinimapFix()
	if simpleMinimap then
--~		Minimap:SetMaskTexture(simpleMinimap:GetModule("skins").skins[simpleMinimap:GetModule("skins").db.profile.skin]["mask"])
		simpleMinimap:UpdateScreen()
	elseif Squeenix then
		Minimap:SetMaskTexture("Interface\\AddOns\\Squeenix\\Mask.blp")
	else
		Minimap:SetMaskTexture("textures\\MinimapMask")
	end
end

-- Register Stuff
function gfxToggle:RegisterStuff()
	self:RegisterDB("gfxToggleDB")
	self:RegisterDefaults('profile', {
		zonesDB = {},
		optionsDB = {
			Delay = 5,
			M2Faster = true,
			Version = self.version,
		}
	} )

	self.data = self.db.profile
	self.data.optionsDB.Version = self.version
end

-- MainInit
function gfxToggle:MainInit()
	self:Options_Reset_Dialog()
	self:Zones_Reset_Dialog()

	if self:IsM2Faster() then SetCVar("M2Faster", 1) else SetCVar("M2Faster", 0) end

	self.delay = self.data.optionsDB.Delay

	if self.data.optionsDB.Low then
		self.lo = true
	elseif self.data.optionsDB.Med then
		self.me = true
	elseif self.data.optionsDB.High then
		self.hi = true
	end

	if ApplyToForehead then
		self:Print(L["Attention! Don't touch the RestartGx toggle if you're running WoW on a linux box. It might crash your client!"])
	end

	self:GetDB()
end

-- Create Static dialog for Reset Settings
function gfxToggle:Options_Reset_Dialog()
	StaticPopupDialogs["GFXTOGGLE_OPTIONS_RESET"] = {
		text = string.format(L["Are you sure you want to reset all your %s for %s"], L["settings"], self.title),
		button1 = TEXT(ACCEPT),
		button2 = TEXT(CANCEL),
		OnAccept = function() self:Reset()	end,
		showAlert = 1,
		timeout = 0,
		exclusive = 1,
		whileDead = 1,
		interruptCinematic = 1
	}
end

function gfxToggle:Zones_Reset_Dialog()
	StaticPopupDialogs["GFXTOGGLE_ZONES_RESET"] = {
		text = string.format(L["Are you sure you want to reset all your %s for %s"], L["zones"], self.title),
		button1 = TEXT(ACCEPT),
		button2 = TEXT(CANCEL),
		OnAccept = function() self:Del("all") end,
		showAlert = 1,
		timeout = 0,
		exclusive = 1,
		whileDead = 1,
		interruptCinematic = 1
	}
end

-- Register misc Stuff
function gfxToggle:RegisterMetro()
	metro:Register("gfxTLow", self.LoadLo, self.delay, self)
	metro:Register("gfxTMed", self.LoadMed, self.delay, self)
	metro:Register("gfxTHigh", self.LoadHi, self.delay, self)
	metro:Register("gfxTZone", self.ZoneChange, self.delay, self)
end

function gfxToggle:UnregMetro()
	metro:Unregister("gfxTLow", "gfxTMed", "gfxTHigh", "gfxTZone")
end

function gfxToggle:AutoReg()
	if self:IsAuto() then
		self:RegisterMetro()
		self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "ZoneChange")
		metro:Start("gfxTZone")
	end
end

-- Auto-Switch --
function gfxToggle:AutoKey()
	self.data.optionsDB.Auto = not self.data.optionsDB.Auto

	if not self:IsMute() then
		if self.data.optionsDB.Auto then
			self:CustomPrint(1,1,1, UIErrorsFrame, nil, " ", L["Auto-Mode is set to: %s"], L["|cff00ff00On|r"])
		else
			self:CustomPrint(1,1,1, UIErrorsFrame, nil, " ", L["Auto-Mode is set to: %s"], L["|cffff5050Off|r"])
		end
	end

	self:Auto()
end

function gfxToggle:Auto()
	self:Update()
	self:UnregisterAllEvents()
	self:UnregMetro()
	self:AutoReg()
end

-- Reset
function gfxToggle:Reset()
	self.data.optionsDB = {}
	self:Print(L["All settings have been reset to their defaults."])
	self:Update()
end

-- On ZoneChange
function gfxToggle:ZoneChange()
	local mem, tim, count, rate = metro:Profile("gfxTZone")
	self:Debug("Mem: %s KiB | Time: %s s| Count: %s | Rate: %s", mem or "", tim or "", count or "", rate or "")
	if metro:Status("gfxTZone") then metro:Stop("gfxTZone") end
	self.cnt = (self.cnt or 0) + 1
	self:Debug("ZoneChange has been called %s time(s).",self.cnt)
	local gzt = GetZoneText()
	if gzt == "" or nil then	metro:Start("gfxTZone") return end
	self:GetDB()

	for k,v in pairs(self.tmpDB) do
		if strlower(k) == strlower(gzt) and v == "L" then
			self.zoneName = gzt
			if self:IsLow() then return end
			metro:Start("gfxTLow")
			return
		end
	end

	for k,v in pairs(self.tmpDB) do
		if strlower(k) == strlower(gzt) and v == "M" then
			self.zoneName = gzt
			if self:IsMed() then return end
			if self:Med() then
				metro:Start("gfxTMed")
			else
				metro:Start("gfxTLow")
				return
			end
		end
	end

	if gzt ~= (self.zoneName or "" or nil) then
		if self:IsHigh() then return end
		metro:Start("gfxTHigh") return
	end
end

-- Checks for Mute, Auto, Low, High, Vsync, M2Faster
function gfxToggle:IsMute()
	return self.data.optionsDB.Mute
end

function gfxToggle:IsAuto()
	self.auto = self.data.optionsDB.Auto
	return self.auto
end

function gfxToggle:Med()
	return self.data.optionsDB.UseMedium
end

function gfxToggle:IsInfoLow()
	return self.data.optionsDB.infoLow
end

function gfxToggle:IsInfoMed()
	return self.data.optionsDB.infoMed
end

function gfxToggle:IsInfoHigh()
	return self.data.optionsDB.infoHi
end

function gfxToggle:IsLow()
	return self.data.optionsDB.Low
end

function gfxToggle:IsMed()
	return self.data.optionsDB.Med
end

function gfxToggle:IsHigh()
	return self.data.optionsDB.High
end

function gfxToggle:IsVsync()
	return self.data.optionsDB.gxRestart
end

function gfxToggle:IsM2Faster()
	return self.data.optionsDB.M2Faster
end

function gfxToggle:SetLow()
	self.data.optionsDB.Low = true
	self.data.optionsDB.Med = nil
	self.data.optionsDB.High = nil
	self.lo = true
	self.me = false
	self.hi = false
end

function gfxToggle:SetMed()
	self.data.optionsDB.Med = true
	self.data.optionsDB.Low = nil
	self.data.optionsDB.High = nil
	self.lo = false
	self.me = true
	self.hi = false
end

function gfxToggle:SetHigh()
	self.data.optionsDB.High = true
	self.data.optionsDB.Med = nil
	self.data.optionsDB.Low = nil
	self.lo = false
	self.me = false
	self.hi = true
end

-- Get Zones and capitalize the first letters
function gfxToggle:GetDB()
	self.tmpDB = {}

	for k,v in pairs(self.data.zonesDB) do
		self.tmpDB[self:Capitalize(k,2)] = v
	end

	return self.tmpDB
end

function gfxToggle:Count()
	local c for k,v in pairs(self.tmpDB) do c = (c or 0) + 1 end return c
end

function gfxToggle:Add(i,w)
	self:GetDB()
	local z

	if i == "this" then z = strlower(GetZoneText()) else z = strlower(i) end

	for k, v in pairs(self.tmpDB) do
		if strlower(k) == z then self:Print(L["Chat_Exists"]) return end
	end

	if w == "low" then
		self.data.zonesDB[z] = "L"
	elseif w == "med" then
		self.data.zonesDB[z] = "M"
		if not self:Med() then self:Print(L["Chat_MedAdd"]) end
	end

	self:Print("'"..self:Capitalize(z, 2)..L["Chat_Added"])
	self:GetDB()

	if z == strlower(GetZoneText()) then
		if w == "low" then self:LoadLo() elseif w == "med" then self:LoadMed() end
	end

	self:Update()
end

-- Delete Zone --
function gfxToggle:Del(i)
	self:GetDB()

	if strlower(i) == "all" then
		self.data.zonesDB = {}
		self:Print(L["Chat_DelAll"])
		self:GetDB()
		return
	end

	local z, f
	if i == "this" then	z = strlower(GetZoneText())	else z = strlower(i) end
	for v in pairs(self.tmpDB) do if strlower(v) == z then f = strlower(v) end end
	if not f then self:Print(L["Chat_NotThere"]) return end
	self:Print("'"..self:Capitalize(z,2)..L["Chat_Deleted"])
	self.data.zonesDB[f] = nil
	self:GetDB()
	if z == strlower(GetZoneText()) then self:LoadHi() end
	self:Update()
end

-- List all Zones --
function gfxToggle:List()
	self:GetDB()
	local p,c = function() self:Print(" ") end
	self.dbLow, self.dbMed = {}, {}

	if next(self.tmpDB) ~= nil then
		for k,v in pairs(self.tmpDB) do
			if v == "L" then tinsert(self.dbLow,k) elseif v == "M" then tinsert(self.dbMed,k) end
		end

		c = self:Count()

		if c ~= (c and 0) then
			if next(self.dbLow) ~= nil then
				table.sort(self.dbLow)
				p() self:Print("|cff00ff00%s|r", L["Zones: Low"])
				for k, v in ipairs(self.dbLow) do self:Print(v) end
			end

			if next(self.dbMed) ~= nil then
				table.sort(self.dbMed)
				p() self:Print("|cffffff00%s|r", L["Zones: Medium"])
				for k, v in ipairs(self.dbMed) do self:Print(v) end
			end

			p()
			if c == 1 then self:Print(c..L["Chat_FoundOne"]) else self:Print(c ..L["Chat_Found"]) end
		end
	else
		print(L["Chat_NoEntry"])
	end
end

-- Toggle manually
function gfxToggle:Toggle()
	if self:Med() then
		if self:IsLow() then self:LoadMed() return end
		if self:IsMed() then self:LoadHi() return end
		if self:IsHigh() then self:LoadLo() return end
	else
		if self:IsLow() then self:LoadHi() else self:LoadLo() return end
	end
end

-- LoadDefLo
function gfxToggle:DefLo()
	SetBaseMip(0)
	SetWorldDetail(0)
	SetFarclip(177)
	SetCVar("lod", 1)
	SetCVar("ffxGlow", 0)
	SetCVar("ffxDeath", 0)
	SetCVar("M2UseShaders", 0)
	SetCVar("spellEffectLevel", 0)
	SetCVar("weatherDensity", 0)
	SetCVar("groundEffectDist", 70)
	SetCVar("groundEffectDensity", 16)
	SetCVar("shadowLOD", 0)

	if not self:IsMute() then
		self:CustomPrint(1,1,1, UIErrorsFrame, nil, " ", L["|cff00ff00Low|r"], L["(default) \nUse '/gfxt save' to save custom settings."])
	end

	self:SetLow()
	metro:Stop("gfxTLow")
end

-- LoadDefMed
function gfxToggle:DefMed()
	SetBaseMip(1)
	SetWorldDetail(1)
	SetFarclip(350)
	SetCVar("lod", 1)
	SetCVar("ffxGlow", 1)
	SetCVar("ffxDeath", 1)
	SetCVar("M2UseShaders", 1)
	SetCVar("spellEffectLevel", 1)
	SetCVar("weatherDensity", 1)
	SetCVar("groundEffectDist", 110)
	SetCVar("groundEffectDensity", 40)
	SetCVar("shadowLOD", 1)

	if not self:IsMute() then
		self:CustomPrint(1,1,1, UIErrorsFrame, nil, " ", L["|cffffff00Medium|r"], L["(default) \nUse '/gfxt save' to save custom settings."])
	end

	self:SetMed()
	metro:Stop("gfxTMed")
end

-- LoadDefHi
function gfxToggle:DefHi()
	SetBaseMip(1)
	SetWorldDetail(2)
	SetFarclip(777)
	SetCVar("lod", 0)
	SetCVar("ffxGlow", 1)
	SetCVar("ffxDeath", 1)
	SetCVar("M2UseShaders", 1)
	SetCVar("spellEffectLevel", 2)
	SetCVar("weatherDensity", 3)
	SetCVar("groundEffectDist", 140)
	SetCVar("groundEffectDensity", 64)
	SetCVar("shadowLOD", 1)

	if not self:IsMute() then
		self:CustomPrint(1,1,1, UIErrorsFrame, nil, " ", L["|cffff0000High|r"], L["(default) \nUse '/gfxt save' to save custom settings."])
	end

	self:SetHigh()
	metro:Stop("gfxTHigh")
end

-- BaseLoad
function gfxToggle:BaseLoad(d)
	local db = self.db.profile.optionsDB[d]

	SetBaseMip(db.BMip or GetBaseMip())
	SetWorldDetail(db.World or GetWorldDetail())
	SetFarclip(db.Far or GetFarclip())

	SetCVar("lod", db.LD or GetCVar("lod"))
	SetCVar("ffxGlow", db.GL or GetCVar("ffxGlow"))
	SetCVar("ffxDeath", db.DT or GetCVar("ffxDeath"))
	SetCVar("M2UseShaders", db.M2 or GetCVar("M2UseShaders"))
	SetCVar("spellEffectLevel", db.SE or GetCVar("spellEffectLevel"))
	SetCVar("weatherDensity", db.WE or GetCVar("weatherDensity"))
	SetCVar("groundEffectDist", db.GR or GetCVar("groundEffectDist"))
	SetCVar("groundEffectDensity", db.GD or GetCVar("groundEffectDensity"))
	SetCVar("shadowLOD", db.SL or GetCVar("shadowLOD"))

	if self.data.optionsDB.M2Faster then SetCVar("M2Faster", 1) else SetCVar("M2Faster", 0) end

	if self:IsVsync() then
		SetCVar("gxVSync", db.VS or GetCVar("gxVSync"))
		SetCVar("gxTripleBuffer", db.TB or GetCVar("gxTripleBuffer"))
		SetCVar("gxFixLag", db.FL or GetCVar("gxFixLag"))
		RestartGx()
	end
end

-- LoadLo
function gfxToggle:LoadLo()
	if self:IsInfoLow() then
		self:BaseLoad("infoLow")
		if not self:IsMute() then self:CustomPrint(1,1,1, UIErrorsFrame, nil, " ", "%s %s", L["GFX set to:"], L["|cff00ff00Low|r"]) end
		self:SetLow()
	else
		self:DefLo()
	end

	self:MinimapFix()
	metro:Stop("gfxTLow")
	self:Update()
end

-- LoadMed
function gfxToggle:LoadMed()
	if self:IsInfoMed() then
		self:BaseLoad("infoMed")
		if not self:IsMute() then self:CustomPrint(1,1,1, UIErrorsFrame, nil, " ", "%s %s", L["GFX set to:"], L["|cffffff00Medium|r"]) end
		self:SetMed()
	else
		self:DefMed()
	end

	self:MinimapFix()
	metro:Stop("gfxTMed")
	self:Update()
end

-- LoadHi --
function gfxToggle:LoadHi()
	if self:IsInfoHigh() then
		self:BaseLoad("infoHi")
		if not self:IsMute() then self:CustomPrint(1,1,1, UIErrorsFrame, nil, " ", "%s %s", L["GFX set to:"], L["|cffff0000High|r"]) end
		self:SetHigh()
	else
		self:DefHi()
	end

	self:MinimapFix()
	metro:Stop("gfxTHigh")
	self:Update()
end

-- Save Settings Lo/Hi --
function gfxToggle:Save(v)
	local db = {
		BMip	= GetBaseMip(),
		World	= GetWorldDetail(),
		Far		= GetFarclip(),
		LD		= GetCVar("lod"),
		GL		= GetCVar("ffxGlow"),
		DT		= GetCVar("ffxDeath"),
		M2		= GetCVar("M2UseShaders"),
		VS		= GetCVar("gxVSync"),
		TB		= GetCVar("gxTripleBuffer"),
		FL		= GetCVar("gxFixLag"),
		SE		= GetCVar("spellEffectLevel"),
		WE		= GetCVar("weatherDensity"),
		GR		= GetCVar("groundEffectDist"),
		GD		= GetCVar("groundEffectDensity"),
		SL		= GetCVar("shadowLOD"),
	}

	if strlower(v) == "low" then self.data.optionsDB.infoLow = db end
	if strlower(v) == "med" then self.data.optionsDB.infoMed = db end
	if strlower(v) == "high" then self.data.optionsDB.infoHi = db end

	if not self:IsMute() then
		if strlower(v) == "low" then
			self:Print("%s %s", L["Saved settings for: "], L["|cff00ff00Low|r"])
		elseif strlower(v) == "med" then
			self:Print("%s %s", L["Saved settings for: "], L["|cffffff00Medium|r"])
		elseif strlower(v) == "high" then
			self:Print("%s %s", L["Saved settings for: "], L["|cffff0000High|r"] )
		end
	else
		return
	end

	self:Update()
end

-- FuBar code start!
-- FuBar click on text
function gfxToggle:OnClick()
	if IsShiftKeyDown() then self:AutoKey() else self:Toggle() end
end

function gfxToggle:UpdateData()
	self.short = self.data.optionsDB.ShortText

	if self.lo then
		self.value = "l"
	elseif self.me then
		self.value = "m"
	elseif self.hi then
		self.value = "h"
	end

	if self.short then
		if self:IsAuto() then self.auto = L["- A"] else self.auto = L[" - M"] end
	elseif self:IsAuto() then
		self.auto = L["- Auto"] else self.auto = " - " .. L["Manual"]
	end
end

-- Text update
function gfxToggle:UpdateText()
	local t = {}

	if self.value == "l" then
		if self.short then
			tinsert(t, L["|cff00ff00L|r"])
		else
			tinsert(t, L["|cff00ff00Low|r"])
		end
	elseif self.value == "m" then
		if self.short then
			tinsert(t, L["|cffffff00M|r"])
		else
			tinsert(t, L["|cffffff00Medium|r"])
		end
	elseif self.value == "h" then
		if self.short then
			tinsert(t, L["|cffff0000H|r"])
		else
			tinsert(t, L["|cffff0000High|r"])
		end
	else
		if self.short then
			tinsert(t, L["|cffffffffN|r"])
		else
			tinsert(t, L["|cffffffffNormal|r"])
		end
	end

	tinsert(t, string.format("|cffffffff%s|r", self.auto))
	self:SetText(table.concat(t, " "))
end

-- Show tooltip
function gfxToggle:OnTooltipUpdate()
	local z, fl, fm = GetZoneText()
	local dbl, dbm = {}, {}
	local settings, r,g,b, cat

	if next(self.tmpDB) ~= nil then
		for k, v in pairs(self.tmpDB) do
			if strlower(k) == strlower(z) then
				if v == "L" then fl = true
				elseif v == "M" then fm = true end
			end

			if v == "L" then tinsert(dbl, k)
			else tinsert(dbm, k) end
		end

		if fl then
			settings = L["Low"]
			r,g,b = 0,1,0
		elseif fm then
			settings = L["Medium"]
			r,g,b = 1,1,0
		else
			settings = L["High"]
			r,g,b = 1,0,0
		end
	end

	cat = tablet:AddCategory(
		'text', L["Toggle graphics"],
		'columns', 1
	)

	cat:AddLine(
		'text', L["Low"],
		'textR', 0,
		'textG', 1,
		'textB', 0,
		'func', function() self:LoadLo() end
	)

	cat:AddLine(
		'text', L["Medium"],
		'textR', 1,
		'textG', 1,
		'textB', 0,
		'func', function() self:LoadMed() end
	)

	cat:AddLine(
		'text', L["High"],
		'textR', 1,
		'textG', 0,
		'textB', 0,
		'func', function() self:LoadHi() end
	)

	cat = tablet:AddCategory(
		'text', L["Current zone:"],
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0
	)

	cat:AddLine(
		'text', z,
		'text2', settings,
		'text2R', r,
		'text2G', g,
		'text2B', b,
		'func', function()
			if IsShiftKeyDown() then
				self:Add("this", "med")
			else
				self:Add("this", "low")
			end
		end
	)

	if next(dbl) ~= nil then
		table.sort(dbl)

		cat = tablet:AddCategory(
			'text', L["Zones: "]..L["|cff00ff00Low|r"],
			'child_textR',1,
			'child_textG',1,
			'child_textB',0
		)

		for k, v in ipairs(dbl) do
			cat:AddLine(
				'text', v,
				'func', 'Del',
				'arg1', self,
				'arg2', v
			)
		end
	end

	if next(dbm) ~= nil then
		table.sort(dbm)

		cat = tablet:AddCategory(
			'text',L["Zones: "]..L["|cffffff00Medium|r"],
			'child_textR',1,
			'child_textG',1,
			'child_textB',0
		)

		for k, v in ipairs(dbm) do
			cat:AddLine(
				'text', v,
				'func', 'Del',
				'arg1', self,
				'arg2', v
			)
		end
	end

--~	tablet:SetHint(L["Left mousebutton for low/(medium)/high. Shift + left mousebutton for auto/manual."])
	tablet:SetHint(L["Left-click on current zone adds zone to 'Low', Shift + left-click adds zone to 'Medium'. " ..
		"Left-click on 'Low' or 'Medium' zone deletes it."])
end
-- FuBar code end

-- The Util Functions
function gfxToggle:Capitalize(s, l)
	for w in string.gmatch(s,"%S+") do
		if(strlen(w)>(l or 1)) then	s=gsub(s,w,strupper(strsub(w,1,1))..strsub(w,2)) end
	end

	return s
end
