------------------------------------------------------
-- Levelator.lua
------------------------------------------------------

function FLV_OnEvent(self, inEvent)
	if (inEvent == "GOSSIP_SHOW") then
		FLV_ButtonIndex = 1;
		FLV_UpdateGossipQuests(GetGossipAvailableQuests());
		if (GetNumGossipAvailableQuests() > 0) then
			FLV_ButtonIndex = FLV_ButtonIndex + 1;
		end
		FLV_UpdateGossipQuests(GetGossipActiveQuests());
	elseif (inEvent == "QUEST_GREETING") then
		for i = 1, GetNumActiveQuests() do
			local level = GetActiveLevel(i);
			local title = GetActiveTitle(i);
			local button = getglobal("QuestTitleButton"..i);
			button:SetFormattedText('[%d] %s', level, title);
			if ( IsActiveQuestTrivial(i) ) then
				button:SetTextColor(unpack(MATERIAL_TEXT_COLOR_TABLE.Default));
			else
				button:SetTextColor(0, 0, 0);
			end
		end
		for i = 1, GetNumAvailableQuests() do
			local level = GetAvailableLevel(i);
			local title = GetAvailableTitle(i);
			local button = getglobal("QuestTitleButton"..i + (GetNumActiveQuests() or 0));
			button:SetFormattedText('[%d] %s', level, title);
			if ( IsAvailableQuestTrivial(i) ) then
				button:SetTextColor(unpack(MATERIAL_TEXT_COLOR_TABLE.Default));
			else
				button:SetTextColor(0, 0, 0);
			end
		end
	end
end

function FLV_UpdateGossipQuests(...)
	for i = 1, select("#", ...), 3 do
		local button = getglobal("GossipTitleButton"..FLV_ButtonIndex);
		button:SetFormattedText('[%d] %s', select(i+1, ...), select(i, ...));
		if ( select(i+2, ...) ) then
			button:SetTextColor(unpack(MATERIAL_TEXT_COLOR_TABLE.Default));
		else
			button:SetTextColor(0, 0, 0);
		end
		GossipResize(button);
		FLV_ButtonIndex = FLV_ButtonIndex + 1;
	end
end

function FLV_GetQuestPrefix(level, tag, numPlayers)
	if (tag and numPlayers > 0) then
		return "["..level..string.sub(tag, 1, 1)..numPlayers.."]";
	elseif (tag) then
		return "["..level..string.sub(tag, 1, 1).."]";
	else
		return "["..level.."] ";
	end	
end

function FLV_GetQuestLogTitle(questIndex)
	local title, level, tag, numPlayers, isHeader, isCollapsed, isComplete = FLV_Orig_GetQuestLogTitle(questIndex);
	if (title and not isHeader) then
		title = FLV_GetQuestPrefix(level, tag, numPlayers) .. title;
	end
	return title, level, tag, numPlayers, isHeader, isCollapsed, isComplete;
end

function FLV_GetQuestLink(index)
	local link = FLV_Orig_GetQuestLink(index);
	local title, level, tag, numPlayers, isHeader, isCollapsed, isComplete = FLV_Orig_GetQuestLogTitle(index);
	return FLV_GetQuestPrefix(level, tag, numPlayers) .. link;
end

function FLV_GameTooltip_SetHyperlink(tooltip, link)
	tooltip:Orig_SetHyperlink(link);
	local _, _, questLevel = string.find(link, "quest:%d+:(%d+)");
	if (questLevel) then
		local leftText = getglobal(tooltip:GetName().."TextLeft1");
		leftText:SetText(format("[%d] %s", questLevel, leftText:GetText()));
	end
end

FLV_EventFrame = CreateFrame("Frame", nil, nil);
FLV_EventFrame:SetScript("OnEvent", FLV_OnEvent);
FLV_EventFrame:RegisterEvent("GOSSIP_SHOW");
FLV_EventFrame:RegisterEvent("QUEST_GREETING");

FLV_Orig_GetQuestLogTitle = GetQuestLogTitle;
GetQuestLogTitle = FLV_GetQuestLogTitle;

FLV_Orig_GetQuestLink = GetQuestLink;
GetQuestLink = FLV_GetQuestLink;

GameTooltip.Orig_SetHyperlink = GameTooltip.SetHyperlink;
GameTooltip.SetHyperlink = FLV_GameTooltip_SetHyperlink;
ItemRefTooltip.Orig_SetHyperlink = ItemRefTooltip.SetHyperlink;
ItemRefTooltip.SetHyperlink = FLV_GameTooltip_SetHyperlink;

