------------------------------------------------------
-- Gemologist.lua
------------------------------------------------------

-- Configuration
FGO_Config = { };
FGO_Config_Default = { };
FGO_Config_Default.Tooltip = true;
FGO_Config_Default.Prospect = false;
FGO_Config_Default.AutoLoot = true;

function FGO_ContainerFrameItemButton_OnClick(button)
	if ( button == "LeftButton" and not FGO_IsDisenchanting ) then
		local bagID = this:GetParent():GetID();
		local slotID = this:GetID();
	
		FGO_ClickedItem = GetContainerItemLink(bagID, slotID);
	end
end

function FGO_PaperDollItemSlotButton_OnClick(button)	
	if ( button == "LeftButton" and not FGO_IsDisenchanting ) then
		FGO_ClickedItem = GetInventoryItemLink("player", this:GetID());
	end
end

function FGO_HookTooltip(frame)
	if (frame:GetScript("OnTooltipSetItem")) then
		frame:HookScript("OnTooltipSetItem", FGO_OnTooltipSetItem);
	else
		frame:SetScript("OnTooltipSetItem", FGO_OnTooltipSetItem);
	end
end

function FGO_OnTooltipSetItem()
	local name, link = this:GetItem();
	if not link then return false; end
	local _, _, itemID  = string.find(link, "item:(%d+)");
	itemID = tonumber(itemID);
	
	local itemInfo = FGO_ItemInfo[itemID];
	if ( FGO_Config.Tooltip and itemInfo) then
		local color = GFW_FONT_COLOR;
		local localizedSources = {};
		for _, source in ipairs(itemInfo) do
			table.insert(localizedSources, getglobal(source));
		end
		if (#localizedSources == 0) then
			GFWUtils.DebugLog(link.." listed but missing sources.");
			return false;
		elseif (#localizedSources == 1) then
			this:AddLine(string.format(FGO_FOUND_ONLY_IN_FORMAT, localizedSources[1]), color.r, color.g, color.b);
			return true;
		else
			this:AddLine(FGO_FOUND_IN_HEADER, color.r, color.g, color.b);
			this:AddLine(table.concat(localizedSources, ", "), color.r, color.g, color.b);
			return true;
		end
	end
	
	local prospects = FGO_ProspectInfo[itemID];
	if (FGO_Config.Prospect and prospects) then
		local color = GFW_FONT_COLOR;
		local localizedNames = {};
		for _, gemID in ipairs(prospects) do
			if (FGO_UncommonGemNames[gemID]) then
				local _, _, _, colorCode = GetItemQualityColor(2);
				table.insert(localizedNames, colorCode..FGO_UncommonGemNames[gemID]..FONT_COLOR_CODE_CLOSE);
			elseif (FGO_RareGemNames[gemID]) then
				local _, _, _, colorCode = GetItemQualityColor(3);
				table.insert(localizedNames, colorCode..FGO_RareGemNames[gemID]..FONT_COLOR_CODE_CLOSE);
			end
		end
		if (#localizedNames == 0) then
			GFWUtils.DebugLog(link.." listed but missing gem names.");
			return false;
		else
			this:AddLine(FGO_PROSPECTING_HEADER, color.r, color.g, color.b);
			for i = 1, #localizedNames, 3 do 
				local maxVal = math.min(i + 2, #localizedNames);
				this:AddDoubleLine(" ", table.concat(localizedNames, ", ", i, maxVal), color.r, color.g, color.b, color.r, color.g, color.b);
			end
			return true;
		end
	end
end

function FGO_OnLoad()

	-- Register Slash Commands
	SLASH_GFW_GEMOLOGIST1 = "/gemologist";
	SLASH_GFW_GEMOLOGIST2 = "/gems";
	SlashCmdList["GFW_GEMOLOGIST"] = function(msg)
		FGO_ChatCommandHandler(msg);
	end
	
	FGO_HookTooltip(GameTooltip);
	FGO_HookTooltip(ItemRefTooltip);

	hooksecurefunc("ContainerFrameItemButton_OnClick", FGO_ContainerFrameItemButton_OnClick);
	hooksecurefunc("PaperDollItemSlotButton_OnClick", FGO_PaperDollItemSlotButton_OnClick);

	FGO_EventFrame = CreateFrame("Frame", nil, nil);
	FGO_EventFrame:SetScript("OnEvent", FGO_OnEvent);
	FGO_EventFrame:RegisterEvent("ADDON_LOADED");
	FGO_EventFrame:RegisterEvent("LOOT_OPENED");
	FGO_EventFrame:RegisterEvent("UNIT_SPELLCAST_START");
	FGO_EventFrame:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED");
end

local LootOpenedTime = 0;
local MIN_TRY_AGAIN_TIME = 1;

function FGO_OnEvent(self, event, arg1)
	if (event == "ADDON_LOADED" and arg1 == "GFW_Gemologist") then
		FGO_EventFrame:UnregisterEvent("ADDON_LOADED");
		setmetatable(FGO_Config, {__index = function(t,key) return FGO_Config_Default[key] end });
	elseif (event == "LOOT_OPENED") then
		if (GetTime() - LootOpenedTime < MIN_TRY_AGAIN_TIME) then
			return; -- UIParent likes to get lost in infinite recursion...
		end
		LootOpenedTime = GetTime();

		if (FGO_IsProspecting and LootFrame:IsVisible()) then
			for slot = 1, GetNumLootItems() do
				if (LootSlotIsCoin(slot)) then
					return; -- coins don't come from prospecting.
				end
			end
			if (FGO_Config.AutoLoot) then
				CloseLoot(); -- closing the loot window, if it's from prospecting, automatically loots the items.
			end
		end
		FGO_ClickedItem = nil;	
		FGO_IsProspecting = nil;
	elseif (event == "UNIT_SPELLCAST_START" and arg1 == "player") then
		local spell, rank, displayName, icon, startTime, endTime = UnitCastingInfo("player");
		if (FGO_ClickedItem and icon == "Interface\\Icons\\INV_Misc_Gem_BloodGem_01") then
			local _, _, _, numSpells = GetSpellTabInfo(1);
			-- only check the first tab of spellbook; same icon for Prospecting may be on other spells,
			-- but is likely not on any other General spells.
			for spellIndex = 1, numSpells do
				local texture = GetSpellTexture(spellIndex, BOOKTYPE_SPELL);
				local spellName, spellRank = GetSpellName(spellIndex, BOOKTYPE_SPELL);
				if (texture == icon and spellName == spell and spellRank == rank) then
					if (FGO_Config.AutoLoot) then
						GFWUtils.Print(string.format(FGO_PROSPECTING_STATUS, FGO_ClickedItem));
					end
					FGO_IsProspecting = true;
				end
			end
		end
	elseif (event == "UNIT_SPELLCAST_INTERRUPTED" and arg1 == "player") then
		FGO_ClickedItem = nil;	
		FGO_IsProspecting = nil;
	end
end

function FGO_ChatCommandHandler(msg)

	-- Print Help
	if ( msg == "help" ) or ( msg == "" ) then
		local version = GetAddOnMetadata("GFW_Gemologist", "Version");
		GFWUtils.Print("Fizzwidget Gemologist "..version..":");
		GFWUtils.Print("/gemologist (or /gems)");
		GFWUtils.Print("- "..GFWUtils.Hilite("help").." - "..FGO_HELP_HELP);
		GFWUtils.Print("- "..GFWUtils.Hilite("status").." - "..FGO_HELP_STATUS);
		GFWUtils.Print("- "..GFWUtils.Hilite("gem on").." | "..GFWUtils.Hilite("off").." - "..FGO_HELP_GEM);
		GFWUtils.Print("- "..GFWUtils.Hilite("ore on").." | "..GFWUtils.Hilite("off").." - "..FGO_HELP_ORE);
		GFWUtils.Print("- "..GFWUtils.Hilite("autoloot on").." | "..GFWUtils.Hilite("off").." - "..FGO_HELP_AUTOLOOT);
		GFWUtils.Print("- "..GFWUtils.Hilite("[item link]").." - "..FGO_HELP_LINK);
		return;
	end
	
	if (msg == "version") then
		local version = GetAddOnMetadata("GFW_Gemologist", "Version");
		GFWUtils.Print("Fizzwidget Gemologist "..version);
		return;
	end
	
	if (msg == "gem on") then
		FGO_Config.Tooltip = true;
		GFWUtils.Print(FGO_STATUS_GEM_ON);
		return;
	end
	if (msg == "gem off") then
		FGO_Config.Tooltip = false;
		GFWUtils.Print(FGO_STATUS_GEM_OFF);
		return;
	end
	if (msg == "ore on") then
		FGO_Config.Prospect = true;
		GFWUtils.Print(FGO_STATUS_ORE_ON);
		return;
	end
	if (msg == "ore off") then
		FGO_Config.Prospect = false;
		GFWUtils.Print(FGO_STATUS_ORE_OFF);
		return;
	end
	if (msg == "autoloot on") then
		FGO_Config.AutoLoot = true;
		GFWUtils.Print(FGO_STATUS_AUTOLOOT_ON);
		return;
	end
	if (msg == "autoloot off") then
		FGO_Config.AutoLoot = false;
		GFWUtils.Print(FGO_STATUS_AUTOLOOT_OFF);
		return;
	end
	
	if ( msg == "status" ) then
		GFWUtils.Print(FGO_Config.Tooltip and FGO_STATUS_GEM_ON or FGO_STATUS_GEM_OFF);
		GFWUtils.Print(FGO_Config.Prospect and FGO_STATUS_ORE_ON or FGO_STATUS_ORE_OFF);
		GFWUtils.Print(FGO_Config.AutoLoot and FGO_STATUS_AUTOLOOT_ON or FGO_STATUS_AUTOLOOT_OFF);
		return;
	end
	
	local _, _, cmd, itemLink = string.find(msg, "(%w+) (.+)");
	for itemID in string.gmatch(msg, "item:(%d+)") do
		itemID = tonumber(itemID);
		_, itemLink = GetItemInfo(itemID);
		
		local itemInfo = FGO_ItemInfo[itemID];
		if (itemInfo) then
			local localizedSources = {};
			for _, source in ipairs(itemInfo) do
				table.insert(localizedSources, getglobal(source));
			end
			if (#localizedSources == 0) then
				GFWUtils.DebugLog(itemLink.." is listed but missing sources.");
				return false;
			elseif (#localizedSources == 1) then
				GFWUtils.Print(string.format(FGO_LINK_FOUND_ONLY_IN_FORMAT, itemLink, localizedSources[1]));
				return true;
			else
				GFWUtils.Print(string.format(FGO_LINK_FOUND_IN_HEADER_FORMAT, itemLink));
				GFWUtils.Print(table.concat(localizedSources, ", "));
				return true;
			end
		end
		
		local prospects = FGO_ProspectInfo[itemID];
		if (prospects) then
			local localizedNames = {};
			for _, gemID in ipairs(prospects) do
				local _, gemLink = GetItemInfo(gemID);
				if (gemLink) then
					table.insert(localizedNames, gemLink);
				elseif (FGO_UncommonGemNames[gemID]) then
					local _, _, _, colorCode = GetItemQualityColor(2);
					table.insert(localizedNames, colorCode..FGO_UncommonGemNames[gemID]..FONT_COLOR_CODE_CLOSE);
				elseif (FGO_RareGemNames[gemID]) then
					local _, _, _, colorCode = GetItemQualityColor(3);
					table.insert(localizedNames, colorCode..FGO_RareGemNames[gemID]..FONT_COLOR_CODE_CLOSE);
				end
			end
			if (#localizedNames == 0) then
				GFWUtils.DebugLog(link.." listed but missing gem names.");
				return false;
			else
				GFWUtils.Print(FGO_PROSPECTING_HEADER);
				GFWUtils.Print(table.concat(localizedNames, ", "));
				return true;
			end
		end

		GFWUtils.Print("Nothing known about "..itemLink..".");
		return;
	end
	
	-- if we made it down here, there were args we didn't understand... time to remind the user what to do.
	FGO_ChatCommandHandler("help");

end

------------------------------------------------------
-- Runtime loading
------------------------------------------------------

FGO_OnLoad();